/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.expressions;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.tree.api.Element;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.ValueList;

public class FunctionElement
implements Element,
Expression {
    private String name;
    private ValueList arguments;

    public FunctionElement(String name, Expression argument) {
        this.name = name;
        this.arguments = new ValueList();
        this.arguments.add(argument);
    }

    public FunctionElement(String name) {
        this.name = name;
        this.arguments = new ValueList();
    }

    public boolean add(Expression argument) {
        return this.arguments.add(argument);
    }

    public String getName() {
        return this.name;
    }

    public ValueList getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.name + this.arguments;
    }

    @Override
    public Object calculate(JtwigContext context) throws CalculateException {
        try {
            return context.function(this.getName()).execute(this.arguments(context));
        }
        catch (FunctionException e) {
            throw new CalculateException(e);
        }
        catch (FunctionNotFoundException e) {
            throw new CalculateException(e);
        }
    }

    private Object[] arguments(JtwigContext context) throws CalculateException {
        return this.arguments.calculate(context).toArray();
    }
}

