/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.content;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.api.Content;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.structural.Block;
import com.lyncode.jtwig.util.BooleanOperations;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IfExpression
implements Content {
    private Expression conditionalExpression;
    private Content content;
    private ElseExpression elseExpression = null;
    private List<ElseIfExpression> elseIfExpressions = new ArrayList<ElseIfExpression>();

    public IfExpression(Expression conditionalExpression) {
        this.conditionalExpression = conditionalExpression;
    }

    public boolean setElseExpression(ElseExpression elseExpression) {
        this.elseExpression = elseExpression;
        return true;
    }

    public boolean addElseIf(ElseIfExpression expression) {
        this.elseIfExpressions.add(expression);
        return true;
    }

    public boolean setContent(Content content) {
        this.content = content;
        return true;
    }

    @Override
    public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
        try {
            if (BooleanOperations.isTrue(this.conditionalExpression.calculate(context))) {
                return this.content.render(outputStream, context);
            }
            for (ElseIfExpression exp : this.elseIfExpressions) {
                if (!exp.render(outputStream, context)) continue;
                return true;
            }
            if (this.elseExpression != null) {
                return this.elseExpression.render(outputStream, context);
            }
            return true;
        }
        catch (CalculateException e) {
            throw new RenderException(e);
        }
    }

    @Override
    public IfExpression compile(JtwigResource resource) throws CompileException {
        this.content = this.content.compile(resource);
        for (int i = 0; i < this.elseIfExpressions.size(); ++i) {
            this.elseIfExpressions.set(i, this.elseIfExpressions.get(i).compile(resource));
        }
        if (this.elseExpression != null) {
            this.elseExpression = this.elseExpression.compile(resource);
        }
        return this;
    }

    @Override
    public boolean replace(Block expression) throws CompileException {
        boolean replaced = this.content.replace(expression);
        for (int i = 0; i < this.elseIfExpressions.size(); ++i) {
            replaced = replaced || this.elseIfExpressions.get(i).replace(expression);
        }
        if (this.elseExpression != null) {
            replaced = replaced || this.elseExpression.replace(expression);
        }
        return replaced;
    }

    public static class ElseExpression
    implements Content {
        private Content content;

        public ElseExpression(Content content) {
            this.content = content;
        }

        @Override
        public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
            this.content.render(outputStream, context);
            return true;
        }

        @Override
        public ElseExpression compile(JtwigResource resource) throws CompileException {
            this.content = this.content.compile(resource);
            return this;
        }

        @Override
        public boolean replace(Block expression) throws CompileException {
            return this.content.replace(expression);
        }
    }

    public static class ElseIfExpression
    implements Content {
        private Expression condition;
        private Content content;

        public ElseIfExpression(Expression condition) {
            this.condition = condition;
        }

        public boolean setContent(Content abstractContent) {
            this.content = abstractContent;
            return true;
        }

        public Content getContent() {
            return this.content;
        }

        @Override
        public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
            try {
                if (BooleanOperations.isTrue(this.condition.calculate(context))) {
                    return this.content.render(outputStream, context);
                }
                return false;
            }
            catch (CalculateException e) {
                throw new RenderException(e);
            }
        }

        @Override
        public ElseIfExpression compile(JtwigResource resource) throws CompileException {
            this.content = this.content.compile(resource);
            return this;
        }

        @Override
        public boolean replace(Block expression) throws CompileException {
            return this.content.replace(expression);
        }
    }
}

