/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.parser.error;

import com.lyncode.jtwig.parser.JtwigKeyword;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.support.MatcherPath;

public class ErrorExplainer {
    public String explain(InvalidInputError error) {
        ErrorInfo known = this.findKnownError(error.getFailedMatchers());
        if (known == null) {
            return "Unknown Error";
        }
        switch (known.getKnownError()) {
            case Keyword: {
                return "Expecting one of keywords (" + StringUtils.join((Object[])JtwigKeyword.keywords(), (String)", ") + ")";
            }
            case SpecificKeyword: {
                return this.specificKeyword(known.getChild().element.matcher.getLabel());
            }
        }
        throw new RuntimeException("Expecting explanation");
    }

    private String specificKeyword(String keyword) {
        return "Expecting " + keyword + " keyword";
    }

    private ErrorInfo findKnownError(List<MatcherPath> failedMatchers) {
        for (MatcherPath matcherPath : failedMatchers) {
            ErrorInfo knownError = this.findKnownError(matcherPath, matcherPath);
            if (knownError == null) continue;
            return knownError;
        }
        return null;
    }

    private ErrorInfo findKnownError(MatcherPath root, MatcherPath matcherPath) {
        try {
            KnownError knownError = KnownError.valueOf(matcherPath.element.matcher.getLabel());
            return new ErrorInfo(knownError, root, matcherPath);
        }
        catch (IllegalArgumentException e) {
            if (matcherPath.parent != null) {
                return this.findKnownError(root, matcherPath.parent);
            }
            return null;
        }
    }

    private static enum KnownError {
        Keyword,
        SpecificKeyword;

    }

    private static class ErrorInfo {
        private KnownError knownError;
        private MatcherPath rootMatcherPath;
        private MatcherPath foundMatcherPath;

        private ErrorInfo(KnownError knownError, MatcherPath rootMatcherPath, MatcherPath foundMatcherPath) {
            this.knownError = knownError;
            this.rootMatcherPath = rootMatcherPath;
            this.foundMatcherPath = foundMatcherPath;
        }

        public KnownError getKnownError() {
            return this.knownError;
        }

        public MatcherPath getRootMatcherPath() {
            return this.rootMatcherPath;
        }

        public boolean hasChild() {
            return this.rootMatcherPath != this.foundMatcherPath;
        }

        public MatcherPath getChild() {
            if (!this.hasChild()) {
                return null;
            }
            MatcherPath current = this.rootMatcherPath;
            while (this.getParent(current) != this.foundMatcherPath) {
                current = this.getParent(current);
            }
            return current;
        }

        private MatcherPath getParent(MatcherPath current) {
            return current.parent;
        }

        public MatcherPath getFoundMatcherPath() {
            return this.foundMatcherPath;
        }
    }
}

