/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.expressions;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.Operator;
import com.lyncode.jtwig.tree.expressions.ValueList;
import com.lyncode.jtwig.tree.helper.StrictBinaryOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OperationBinary
implements Expression {
    private ValueList operands = new ValueList();
    private List<Operator> operators = new ArrayList<Operator>();

    public OperationBinary(Expression operand) {
        this.operands.add(operand);
    }

    public ValueList getOperands() {
        return this.operands;
    }

    public List<Operator> getOperators() {
        return this.operators;
    }

    public boolean addOperator(Operator operator) {
        this.operators.add(operator);
        return true;
    }

    public boolean add(Expression operand) {
        this.operands.add(operand);
        return true;
    }

    public String toString() {
        ArrayList<String> results = new ArrayList<String>();
        if (!this.operands.isEmpty()) {
            results.add(this.getDescription(0));
            for (int i = 1; i < this.operands.size(); ++i) {
                results.add(this.operators.get(i - 1).toString());
                results.add(this.getDescription(i));
            }
        } else {
            return "Binary operation without operands";
        }
        return StringUtils.join(results, (String)" ");
    }

    private String getDescription(int index) {
        Expression element = this.operands.get(index);
        if (element instanceof OperationBinary) {
            return "(" + element.toString() + ")";
        }
        return element.toString();
    }

    @Override
    public Object calculate(JtwigContext context) throws CalculateException {
        return StrictBinaryOperation.create(this).calculate(context);
    }
}

