/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.resource;

import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.resource.JtwigResource;
import java.io.File;
import java.io.InputStream;

public class ClasspathJtwigResource
implements JtwigResource {
    private String resource;

    public ClasspathJtwigResource(String resource) {
        this.resource = resource.startsWith(File.separator) ? resource.substring(1) : resource;
    }

    @Override
    public InputStream retrieve() throws ResourceException {
        return this.getClass().getClassLoader().getResourceAsStream(this.resource);
    }

    @Override
    public JtwigResource resolve(String relativePath) throws ResourceException {
        File relativeFile = new File(new File(this.resource).getParent(), relativePath);
        return new ClasspathJtwigResource(relativeFile.getPath());
    }
}

