/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.cron.GrocTimeSpecification;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.ArrayList;
import java.util.List;

public class CronXml {
    private List<Entry> entries = new ArrayList<Entry>();

    public Entry addNewEntry() {
        this.validateLastEntry();
        Entry entry = new Entry();
        this.entries.add(entry);
        return entry;
    }

    public void addEntry(Entry entry) {
        this.validateLastEntry();
        this.entries.add(entry);
        this.validateLastEntry();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void validateLastEntry() {
        if (this.entries.size() == 0) {
            return;
        }
        Entry last = this.entries.get(this.entries.size() - 1);
        if (last.getUrl() == null) {
            throw new AppEngineConfigException("no URL for cronentry");
        }
        if (last.getSchedule() == null) {
            throw new AppEngineConfigException("no schedule for cronentry " + last.getUrl());
        }
        try {
            GrocTimeSpecification parsedSchedule = GrocTimeSpecification.create(last.schedule);
        }
        catch (IllegalArgumentException iae) {
            throw new AppEngineConfigException("schedule " + last.schedule + " failed to parse", iae.getCause());
        }
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder("cron:\n");
        for (Entry ent : this.entries) {
            builder.append("- description: '" + ent.getDescription().replace("'", "''") + "'\n");
            builder.append("  url: " + ent.getUrl() + "\n");
            builder.append("  schedule: " + ent.getSchedule() + "\n");
            builder.append("  timezone: " + ent.getTimezone() + "\n");
            String target = ent.getTarget();
            if (target == null) continue;
            builder.append("  target: " + target + "\n");
        }
        return builder.toString();
    }

    public static class Entry {
        private static final String TZ_GMT = "UTC";
        String url = null;
        String desc = "";
        String tz = "UTC";
        String schedule = null;
        String target = null;

        public void setDescription(String description) {
            this.desc = description.replaceAll("\n", " ");
        }

        public void setUrl(String url) {
            this.url = url.replaceAll("\n", " ");
        }

        public void setSchedule(String schedule) {
            this.schedule = schedule = schedule.replaceAll("\n", " ");
        }

        public void setTimezone(String timezone) {
            this.tz = timezone.replaceAll("\n", " ");
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public String getTimezone() {
            return this.tz;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

