/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.plugins;

import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.plugins.SDKRuntimePlugin;
import com.google.apphosting.utils.config.AppYaml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class SDKPluginManager {
    private static final Map<String, SDKRuntimePlugin> runtimeToPluginMap = new HashMap<String, SDKRuntimePlugin>(10);

    public static SDKRuntimePlugin findRuntimePlugin(File applicationDirectory) {
        return SDKPluginManager.findRuntimePlugin(SDKPluginManager.extractRuntimeString(applicationDirectory));
    }

    public static synchronized SDKRuntimePlugin findRuntimePlugin(String runtime) {
        if (null == runtime) {
            return null;
        }
        SDKRuntimePlugin plugin = runtimeToPluginMap.get(runtime);
        if (plugin != null) {
            return plugin;
        }
        PluginLoader cl = new PluginLoader(SdkInfo.getSdkRoot());
        for (SDKRuntimePlugin pl : ServiceLoader.load(SDKRuntimePlugin.class, cl)) {
            if (!pl.shouldHandle(runtime)) continue;
            runtimeToPluginMap.put(runtime, pl);
            return pl;
        }
        return null;
    }

    public static synchronized void setRuntimePlugin(String runtime, SDKRuntimePlugin plugin) {
        if (!plugin.shouldHandle(runtime)) {
            throw new IllegalArgumentException("shouldHandleRuntime(" + runtime + ") return false on the given plugin.");
        }
        runtimeToPluginMap.put(runtime, plugin);
    }

    private static String extractRuntimeString(File applicationDirectory) {
        AppYaml appYaml;
        File appYamlFile = new File(applicationDirectory, "app.yaml");
        if (!appYamlFile.exists()) {
            return null;
        }
        try {
            appYaml = AppYaml.parse(new FileReader(appYamlFile));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return appYaml.getRuntime();
    }

    private static class PluginLoader
    extends URLClassLoader {
        public PluginLoader(File sdkRoot) {
            super(PluginLoader.getJarUrls(sdkRoot), SDKPluginManager.class.getClassLoader());
        }

        private static URL[] getJarUrls(File sdkRoot) {
            File libDir = new File(sdkRoot, "lib");
            File pluginDir = new File(libDir, "plugins");
            if (!pluginDir.isDirectory()) {
                return new URL[0];
            }
            ArrayList<URL> list = new ArrayList<URL>(10);
            for (File file : pluginDir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                try {
                    list.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            URL[] urls = new URL[list.size()];
            list.toArray(urls);
            return urls;
        }
    }
}

