/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.LocalVersionFactory;
import com.google.appengine.tools.info.RemoteVersionFactory;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheckResults;
import com.google.appengine.tools.info.Version;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UpdateCheck {
    private static final Logger logger = Logger.getLogger(UpdateCheck.class.getName());
    private static final long MAX_NAG_FREQUENCY = 604800L;
    private static final String OPT_OUT_FILE = ".appcfg_no_nag";
    private final String server;
    private final File appDirectory;
    private final Preferences prefs;
    private final boolean secure;

    public UpdateCheck(String server) {
        this(server, null, false);
    }

    public UpdateCheck(String server, File appDirectory, boolean secure) {
        this.server = server;
        this.appDirectory = appDirectory;
        this.secure = secure;
        this.prefs = Preferences.userNodeForPackage(UpdateCheck.class);
    }

    public boolean allowedToCheckForUpdates() {
        File optOutFile = new File(System.getProperty("user.home"), OPT_OUT_FILE);
        return !optOutFile.exists();
    }

    public UpdateCheckResults checkForUpdates() {
        Version localVersion = this.getLocalVersion();
        logger.fine("Local Version: " + localVersion);
        Version remoteVersion = new RemoteVersionFactory(localVersion, this.server, this.secure).getVersion();
        logger.fine("Remote Version: " + remoteVersion);
        return new UpdateCheckResults(localVersion, remoteVersion);
    }

    Version getLocalVersion() {
        File[] libFiles;
        File libDir;
        if (this.appDirectory != null && (libDir = new File(new File(this.appDirectory, "WEB-INF"), "lib")).exists() && (libFiles = libDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String lowercasePath = file.getPath().toLowerCase();
                return lowercasePath.endsWith(".jar") || lowercasePath.endsWith(".zip");
            }
        })) != null) {
            return new LocalVersionFactory(Arrays.asList(libFiles)).getVersion();
        }
        return SdkInfo.getLocalVersion();
    }

    public boolean maybePrintNagScreen(PrintStream out) {
        if (this.doNagScreen(out)) {
            this.prefs.putLong("lastNagTime", System.currentTimeMillis());
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                logger.log(Level.WARNING, "Could not update last nag time:", ex);
            }
            return true;
        }
        return false;
    }

    private boolean canNagUser() {
        try {
            this.prefs.sync();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, "Could not sync last nag time:", ex);
        }
        long lastNagTime = this.prefs.getLong("lastNagTime", 0L);
        return System.currentTimeMillis() - lastNagTime > 604800L;
    }

    private boolean doNagScreen(PrintStream out) {
        UpdateCheckResults results = this.checkForUpdates();
        if (!this.canNagUser()) {
            return false;
        }
        if (results.isLocalApiVersionNoLongerSupported()) {
            this.printNagMessage("The API version in this SDK is no longer supported on the server!", out, results);
            return true;
        }
        if (results.isNewerReleaseAvailable()) {
            if (results.isNewerApiVersionAvailable()) {
                this.printNagMessage("You are using a deprecated API version.  Please upgrade.", out, results);
                return true;
            }
            this.printNagMessage("There is a new version of the SDK available.", out, results);
            return true;
        }
        return false;
    }

    private void printNagMessage(String message, PrintStream out, UpdateCheckResults results) {
        out.println("********************************************************");
        out.println(message);
        out.println("-----------");
        out.println("Latest SDK:");
        out.println(results.getRemoteVersion());
        out.println("-----------");
        out.println("Your SDK:");
        out.println(results.getLocalVersion());
        out.println("-----------");
        out.println("Please visit http://code.google.com/appengine for the latest SDK.");
        out.println("********************************************************");
    }

    static boolean validateVersion(String version, PrintStream out) {
        String[] versions;
        if (version != null && (versions = version.split("\\.")).length >= 2 && versions[0].equals("1")) {
            try {
                int minor = Integer.parseInt(versions[1]);
                if (minor < 6) {
                    out.println("********************************************************");
                    out.println("Warning: Future versions of the Dev App Server will require Java 1.6 or later. Please upgrade your JRE.");
                    out.println("********************************************************");
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean checkJavaVersion(PrintStream out) {
        return UpdateCheck.validateVersion(System.getProperty("java.specification.version"), out);
    }
}

