/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.appengine.repackaged.org.joda.time.JodaTimePermission;
import com.google.appengine.repackaged.org.joda.time.LocalDateTime;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.chrono.BaseChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatterBuilder;
import com.google.appengine.repackaged.org.joda.time.format.FormatUtils;
import com.google.appengine.repackaged.org.joda.time.tz.DefaultNameProvider;
import com.google.appengine.repackaged.org.joda.time.tz.FixedDateTimeZone;
import com.google.appengine.repackaged.org.joda.time.tz.NameProvider;
import com.google.appengine.repackaged.org.joda.time.tz.Provider;
import com.google.appengine.repackaged.org.joda.time.tz.UTCProvider;
import com.google.appengine.repackaged.org.joda.time.tz.ZoneInfoProvider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public abstract class DateTimeZone
implements Serializable {
    private static final long serialVersionUID = 5546345482340108586L;
    public static final DateTimeZone UTC = new FixedDateTimeZone("UTC", "UTC", 0, 0);
    private static Provider cProvider;
    private static NameProvider cNameProvider;
    private static Set cAvailableIDs;
    private static DateTimeZone cDefault;
    private static DateTimeFormatter cOffsetFormatter;
    private static Map iFixedOffsetCache;
    private static Map cZoneIdConversion;
    private final String iID;

    public static DateTimeZone getDefault() {
        return cDefault;
    }

    public static void setDefault(DateTimeZone dateTimeZone) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        cDefault = dateTimeZone;
    }

    public static DateTimeZone forID(String string) {
        if (string == null) {
            return DateTimeZone.getDefault();
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = cProvider.getZone(string);
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            int n = DateTimeZone.parseOffset(string);
            if ((long)n == 0L) {
                return UTC;
            }
            string = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(string, n);
        }
        throw new IllegalArgumentException("The datetime zone id is not recognised: " + string);
    }

    public static DateTimeZone forOffsetHours(int n) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(n, 0);
    }

    public static DateTimeZone forOffsetHoursMinutes(int n, int n2) throws IllegalArgumentException {
        if (n == 0 && n2 == 0) {
            return UTC;
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + n2);
        }
        int n3 = 0;
        try {
            int n4 = FieldUtils.safeMultiply(n, 60);
            n2 = n4 < 0 ? FieldUtils.safeAdd(n4, -n2) : FieldUtils.safeAdd(n4, n2);
            n3 = FieldUtils.safeMultiply(n2, 60000);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return DateTimeZone.forOffsetMillis(n3);
    }

    public static DateTimeZone forOffsetMillis(int n) {
        String string = DateTimeZone.printOffset(n);
        return DateTimeZone.fixedOffsetZone(string, n);
    }

    public static DateTimeZone forTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return DateTimeZone.getDefault();
        }
        String string = timeZone.getID();
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = null;
        String string2 = DateTimeZone.getConvertedId(string);
        if (string2 != null) {
            dateTimeZone = cProvider.getZone(string2);
        }
        if (dateTimeZone == null) {
            dateTimeZone = cProvider.getZone(string);
        }
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string2 == null && ((string2 = timeZone.getDisplayName()).startsWith("GMT+") || string2.startsWith("GMT-"))) {
            int n = DateTimeZone.parseOffset(string2 = string2.substring(3));
            if ((long)n == 0L) {
                return UTC;
            }
            string2 = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(string2, n);
        }
        throw new IllegalArgumentException("The datetime zone id is not recognised: " + string);
    }

    private static synchronized DateTimeZone fixedOffsetZone(String string, int n) {
        DateTimeZone dateTimeZone;
        Reference reference;
        if (n == 0) {
            return UTC;
        }
        if (iFixedOffsetCache == null) {
            iFixedOffsetCache = new HashMap();
        }
        if ((reference = (Reference)iFixedOffsetCache.get(string)) != null && (dateTimeZone = (DateTimeZone)reference.get()) != null) {
            return dateTimeZone;
        }
        dateTimeZone = new FixedDateTimeZone(string, null, n, n);
        iFixedOffsetCache.put(string, new SoftReference<DateTimeZone>(dateTimeZone));
        return dateTimeZone;
    }

    public static Set getAvailableIDs() {
        return cAvailableIDs;
    }

    public static Provider getProvider() {
        return cProvider;
    }

    public static void setProvider(Provider provider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        DateTimeZone.setProvider0(provider);
    }

    private static void setProvider0(Provider provider) {
        Set set;
        if (provider == null) {
            provider = DateTimeZone.getDefaultProvider();
        }
        if ((set = provider.getAvailableIDs()) == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        cProvider = provider;
        cAvailableIDs = set;
    }

    private static Provider getDefaultProvider() {
        Provider provider = null;
        try {
            String string = System.getProperty("com.google.appengine.repackaged.org.joda.time.DateTimeZone.Provider");
            if (string != null) {
                try {
                    provider = (Provider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    thread.getThreadGroup().uncaughtException(thread, exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (provider == null) {
            try {
                provider = new ZoneInfoProvider("com/google/appengine/repackaged/org/joda/time/tz/data");
            }
            catch (Exception exception) {
                Thread thread = Thread.currentThread();
                thread.getThreadGroup().uncaughtException(thread, exception);
            }
        }
        if (provider == null) {
            provider = new UTCProvider();
        }
        return provider;
    }

    public static NameProvider getNameProvider() {
        return cNameProvider;
    }

    public static void setNameProvider(NameProvider nameProvider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        DateTimeZone.setNameProvider0(nameProvider);
    }

    private static void setNameProvider0(NameProvider nameProvider) {
        if (nameProvider == null) {
            nameProvider = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider = nameProvider;
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider = null;
        try {
            String string = System.getProperty("com.google.appengine.repackaged.org.joda.time.DateTimeZone.NameProvider");
            if (string != null) {
                try {
                    nameProvider = (NameProvider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    thread.getThreadGroup().uncaughtException(thread, exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    private static synchronized String getConvertedId(String string) {
        HashMap<String, String> hashMap = cZoneIdConversion;
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("GMT", "UTC");
            hashMap.put("MIT", "Pacific/Apia");
            hashMap.put("HST", "Pacific/Honolulu");
            hashMap.put("AST", "America/Anchorage");
            hashMap.put("PST", "America/Los_Angeles");
            hashMap.put("MST", "America/Denver");
            hashMap.put("PNT", "America/Phoenix");
            hashMap.put("CST", "America/Chicago");
            hashMap.put("EST", "America/New_York");
            hashMap.put("IET", "America/Indianapolis");
            hashMap.put("PRT", "America/Puerto_Rico");
            hashMap.put("CNT", "America/St_Johns");
            hashMap.put("AGT", "America/Buenos_Aires");
            hashMap.put("BET", "America/Sao_Paulo");
            hashMap.put("WET", "Europe/London");
            hashMap.put("ECT", "Europe/Paris");
            hashMap.put("ART", "Africa/Cairo");
            hashMap.put("CAT", "Africa/Harare");
            hashMap.put("EET", "Europe/Bucharest");
            hashMap.put("EAT", "Africa/Addis_Ababa");
            hashMap.put("MET", "Asia/Tehran");
            hashMap.put("NET", "Asia/Yerevan");
            hashMap.put("PLT", "Asia/Karachi");
            hashMap.put("IST", "Asia/Calcutta");
            hashMap.put("BST", "Asia/Dhaka");
            hashMap.put("VST", "Asia/Saigon");
            hashMap.put("CTT", "Asia/Shanghai");
            hashMap.put("JST", "Asia/Tokyo");
            hashMap.put("ACT", "Australia/Darwin");
            hashMap.put("AET", "Australia/Sydney");
            hashMap.put("SST", "Pacific/Guadalcanal");
            hashMap.put("NST", "Pacific/Auckland");
            cZoneIdConversion = hashMap;
        }
        return (String)hashMap.get(string);
    }

    private static int parseOffset(String string) {
        BaseChronology baseChronology = cDefault != null ? ISOChronology.getInstanceUTC() : new BaseChronology(){

            public DateTimeZone getZone() {
                return null;
            }

            public Chronology withUTC() {
                return this;
            }

            public Chronology withZone(DateTimeZone dateTimeZone) {
                return this;
            }

            public String toString() {
                return this.getClass().getName();
            }
        };
        return -((int)DateTimeZone.offsetFormatter().withChronology(baseChronology).parseMillis(string));
    }

    private static String printOffset(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n = -n;
        }
        int n2 = n / 3600000;
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        int n3 = (n -= n2 * 3600000) / 60000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
        if ((n -= n3 * 60000) == 0) {
            return stringBuffer.toString();
        }
        int n4 = n / 1000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n4, 2);
        if ((n -= n4 * 1000) == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        FormatUtils.appendPaddedInteger(stringBuffer, n, 3);
        return stringBuffer.toString();
    }

    private static synchronized DateTimeFormatter offsetFormatter() {
        if (cOffsetFormatter == null) {
            cOffsetFormatter = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter();
        }
        return cOffsetFormatter;
    }

    protected DateTimeZone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = string;
    }

    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long l) {
        return this.getShortName(l, null);
    }

    public String getShortName(long l, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l)) == null) {
            return this.iID;
        }
        String string2 = cNameProvider.getShortName(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(l));
    }

    public final String getName(long l) {
        return this.getName(l, null);
    }

    public String getName(long l, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l)) == null) {
            return this.iID;
        }
        String string2 = cNameProvider.getName(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(l));
    }

    public abstract int getOffset(long var1);

    public final int getOffset(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(readableInstant.getMillis());
    }

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long l) {
        return this.getOffset(l) == this.getStandardOffset(l);
    }

    public int getOffsetFromLocal(long l) {
        long l2;
        long l3;
        int n;
        int n2 = this.getOffset(l);
        if (n2 != (n = this.getOffset(l - (long)n2)) && n2 - n < 0 && (l3 = this.nextTransition(l - (long)n2)) != (l2 = this.nextTransition(l - (long)n))) {
            return n2;
        }
        return n;
    }

    public long convertUTCToLocal(long l) {
        int n = this.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l2;
    }

    public long convertLocalToUTC(long l, boolean bl) {
        long l2;
        long l3;
        int n;
        int n2 = this.getOffset(l);
        if (n2 != (n = this.getOffset(l - (long)n2)) && (bl || n2 < 0) && (l3 = this.nextTransition(l - (long)n2)) != (l2 = this.nextTransition(l - (long)n))) {
            if (bl) {
                throw new IllegalArgumentException("Illegal instant due to time zone offset transition: " + DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print(new Instant(l)) + " (" + this.getID() + ")");
            }
            n = n2;
        }
        if ((l ^ (l3 = l - (long)n)) < 0L && (l ^ (long)n) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return l3;
    }

    public long getMillisKeepLocal(DateTimeZone dateTimeZone, long l) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this) {
            return l;
        }
        long l2 = l + (long)this.getOffset(l);
        return l2 - (long)dateTimeZone.getOffsetFromLocal(l2);
    }

    public boolean isLocalDateTimeGap(LocalDateTime localDateTime) {
        if (this.isFixed()) {
            return false;
        }
        try {
            localDateTime.toDateTime(this);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public String toString() {
        return this.getID();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    static {
        DateTimeZone.setProvider0(null);
        DateTimeZone.setNameProvider0(null);
        try {
            try {
                cDefault = DateTimeZone.forID(System.getProperty("user.timezone"));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (cDefault == null) {
                cDefault = DateTimeZone.forTimeZone(TimeZone.getDefault());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (cDefault == null) {
            cDefault = UTC;
        }
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        Stub(String string) {
            this.iID = string;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeUTF(this.iID);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            this.iID = objectInputStream.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return DateTimeZone.forID(this.iID);
        }
    }
}

