/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.storm.FormLocation;
import clojure.storm.FormObject;
import clojure.storm.FormRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracer {
    private static IFn traceFnCallFn = null;
    private static IFn traceFnReturnFn = null;
    private static IFn traceExprFn = null;
    private static IFn traceBindFn = null;
    private static IFn handleExceptionFn = null;
    private static Keyword TRACE_FN_CALL_FN_KEY = Keyword.intern(null, "trace-fn-call-fn-key");
    private static Keyword TRACE_FN_RETURN_FN_KEY = Keyword.intern(null, "trace-fn-return-fn-key");
    private static Keyword TRACE_EXPR_FN_KEY = Keyword.intern(null, "trace-expr-fn-key");
    private static Keyword TRACE_BIND_FN_KEY = Keyword.intern(null, "trace-bind-fn-key");
    private static Keyword HANDLE_EXCEPTION_FN_KEY = Keyword.intern(null, "handle-exception-fn-key");
    private static AtomicBoolean traceEnable = new AtomicBoolean(false);
    private static ConcurrentHashMap<IPersistentVector, IPersistentVector> coordCache = new ConcurrentHashMap();

    public static void handleThreadException(Thread thread2, Throwable ex) {
        if (handleExceptionFn != null) {
            handleExceptionFn.invoke(thread2, ex);
        }
    }

    public static void traceFnCall(IPersistentVector fnArgs, String fnNs, String fnName, int formId) {
        if (traceFnCallFn != null && traceEnable.get()) {
            traceFnCallFn.invoke(null, fnNs, fnName, fnArgs, formId);
        }
    }

    public static void traceExpr(Object val2, Integer[] coord, int formId) {
        if (traceExprFn != null && traceEnable.get()) {
            IPersistentVector c = Tracer.internCoord(coord);
            traceExprFn.invoke(null, val2, c, formId);
        }
    }

    public static void traceFnReturn(Object retVal, Integer[] coord, int formId) {
        if (traceFnReturnFn != null && traceEnable.get()) {
            IPersistentVector c = Tracer.internCoord(coord);
            traceFnReturnFn.invoke(null, retVal, c, formId);
        }
    }

    public static void traceBind(Object val2, Integer[] coord, String symName) {
        if (traceBindFn != null && traceEnable.get()) {
            IPersistentVector c = Tracer.internCoord(coord);
            traceBindFn.invoke(null, c, symName, val2);
        }
    }

    public static void registerFormLocation(int formId, int line, String ns2, String sourceFile) {
        FormRegistry.registerForm(formId, new FormLocation(formId, sourceFile, ns2, line));
    }

    public static void registerFormObject(int formId, String nsName, Object form) {
        FormRegistry.registerForm(formId, new FormObject(formId, nsName, form));
    }

    public static void setTraceFnsCallbacks(IPersistentMap callbacks) {
        traceFnCallFn = (IFn)callbacks.valAt(TRACE_FN_CALL_FN_KEY);
        traceFnReturnFn = (IFn)callbacks.valAt(TRACE_FN_RETURN_FN_KEY);
        traceExprFn = (IFn)callbacks.valAt(TRACE_EXPR_FN_KEY);
        traceBindFn = (IFn)callbacks.valAt(TRACE_BIND_FN_KEY);
        handleExceptionFn = (IFn)callbacks.valAt(HANDLE_EXCEPTION_FN_KEY);
    }

    private static IPersistentVector internCoord(Integer ... coord) {
        PersistentVector k = PersistentVector.adopt(coord);
        if (coordCache.containsKey(k)) {
            return coordCache.get(k);
        }
        coordCache.put(k, k);
        return k;
    }

    public static boolean getTraceEnable() {
        return traceEnable.get();
    }

    public static void disableThreadsTracing() {
        traceEnable.set(false);
        System.out.println("Storm tracing disable.");
    }

    public static void enableThreadsTracing() {
        if (traceEnable.get()) {
            System.out.println("Storm tracing is already enable.");
        } else {
            traceEnable.set(true);
            System.out.println("Storm tracing enable.");
        }
    }

    static {
        String traceEnableProp = System.getProperty("clojure.storm.traceEnable");
        if (traceEnableProp != null && traceEnableProp.equals("true")) {
            Tracer.enableThreadsTracing();
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e2) -> Tracer.handleThreadException(t, e2));
    }
}

