/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.LispReader;
import clojure.lang.Namespace;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import clojure.storm.IForm;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FormLocation
implements IForm {
    public int formId;
    public String sourceFile;
    public int line;
    public String formNamespace;
    private static Keyword READ_COND_KEY = Keyword.intern(null, "read-cond");
    private static Keyword ALLOW_KEY = Keyword.intern(null, "allow");

    public FormLocation(int formId, String sourceFile, String ns2, int line) {
        this.sourceFile = sourceFile;
        this.line = line;
        this.formId = formId;
        this.formNamespace = ns2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getForm() {
        try {
            Namespace ns2 = Namespace.find(Symbol.intern(this.formNamespace));
            Var.pushThreadBindings(RT.map(RT.CURRENT_NS, ns2));
            IPersistentMap opts = RT.map(READ_COND_KEY, ALLOW_KEY);
            InputStream strm = RT.baseLoader().getResourceAsStream(this.sourceFile);
            if (strm != null) {
                LineNumberingPushbackReader rdr = new LineNumberingPushbackReader(new InputStreamReader(strm));
                for (int l = 0; l < this.line - 1; ++l) {
                    rdr.readLine();
                }
                Object form = LispReader.read(rdr, opts);
                rdr.close();
                Object object = form;
                return object;
            }
        }
        catch (IOException ioe) {
            System.out.println("ERROR : can't read form. File " + this.sourceFile + " line : " + this.line);
            Object var2_4 = null;
            return var2_4;
        }
        finally {
            Var.popThreadBindings();
        }
        return null;
    }

    @Override
    public Integer getId() {
        return this.formId;
    }

    @Override
    public String getNs() {
        return this.formNamespace;
    }

    public Keyword getDefKind() {
        return null;
    }
}

