package codex.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.joda.time.DateTime;

import java.util.UUID;


public class UUIDSerde extends Serializer<UUID> {

    public static final Registration REGISTRATION = new ComparableRegistration(UUID.class, new UUIDSerde(), 3334);
    @Override
    public void write(Kryo kryo, Output output, UUID uuid) {
        output.writeLong(uuid.getMostSignificantBits());
        output.writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    public UUID read(Kryo kryo, Input input, Class type) {
          return new UUID(input.readLong(), input.readLong());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

}
