/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IRecord;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LispReader;
import clojure.lang.Namespace;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeSet;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.storm.Emitter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static Object mergeMeta(Object x, IPersistentMap m) {
        if (x instanceof IObj && RT.count(m) > 0) {
            IMapEntry me;
            IObj o = (IObj)x;
            IPersistentMap retMeta = PersistentHashMap.EMPTY;
            IPersistentMap oMeta = RT.meta(o);
            if (oMeta != null) {
                for (Object meo : oMeta) {
                    me = (IMapEntry)meo;
                    retMeta = retMeta.assoc(me.key(), me.val());
                }
            }
            for (Object meo : m) {
                me = (IMapEntry)meo;
                retMeta = retMeta.assoc(me.key(), me.val());
            }
            return o.withMeta(retMeta);
        }
        return x;
    }

    public static Symbol maybeGetTraceSymbol(Symbol sym, ISeq form) {
        if (sym.getNamespace() != null && sym.getNamespace().equals("clojure.core") && sym.getName().equals("addMethod") && RT.second(form) instanceof Symbol) {
            Symbol nameSym = (Symbol)RT.second(form);
            String currentNsName = ((Namespace)RT.CURRENT_NS.deref()).getName().getName();
            return Symbol.create(nameSym.getNamespace() != null ? nameSym.getNamespace() : currentNsName, nameSym.getName());
        }
        return null;
    }

    public static IPersistentVector coordOf(Object form) {
        IPersistentVector coord = (IPersistentVector)RT.get(RT.meta(form), LispReader.COORD_KEY);
        if (coord == null && form != null && form instanceof ISeq && ((ISeq)form).count() > 0) {
            coord = (IPersistentVector)RT.get(RT.meta(((ISeq)form).first()), LispReader.COORD_KEY);
        }
        return coord;
    }

    public static Object addCoordMeta(Object o, IPersistentVector coord) {
        Associative meta = RT.meta(o);
        if (coord != null && o instanceof IObj) {
            meta = RT.assoc(meta, LispReader.COORD_KEY, coord);
            return ((IObj)o).withMeta((IPersistentMap)meta);
        }
        return o;
    }

    public static long clojureFormSourceHash(String s) {
        long M = 0xFFFFFFFBL;
        String cleanS = s.replaceAll("#[/.a-zA-Z0-9_-]+", "").replaceAll("\\^:[a-zA-Z0-9_-]+", "").replaceAll("\\^\\{.+?\\}", "").replaceAll(";.+\n", "").replaceAll("[ \t\n]+", "");
        long sum = 0L;
        long mul = 1L;
        for (int i = 0; i < cleanS.length(); ++i) {
            char cval = cleanS.charAt(i);
            mul = i % 4 == 0 ? 1L : mul * 256L;
            sum += (long)cval * mul;
        }
        return sum % M;
    }

    public static String objCoord(String kind, Object form) {
        long hash2 = form == null ? 0L : Utils.clojureFormSourceHash(form.toString());
        return kind + hash2;
    }

    private static IPersistentCollection mapIndexed(IFn f, IPersistentCollection coll) {
        ArrayList<Object> objs = new ArrayList<Object>();
        int i = 0;
        Iterator iter = RT.iter(coll);
        while (iter.hasNext()) {
            Object o = iter.next();
            Object mappedO = f.invoke(i, o);
            objs.add(mappedO);
            ++i;
        }
        if (coll instanceof PersistentVector) {
            return PersistentVector.create(objs);
        }
        if (coll instanceof PersistentHashSet) {
            return PersistentHashSet.create(objs);
        }
        return PersistentList.create(objs);
    }

    private static Object walkCodeForm(final IPersistentVector coord, final IFn f, Object form) {
        AFn walkCollection = new AFn(){

            @Override
            public Object invoke(Object forms) {
                return Utils.mapIndexed(new AFn(){

                    @Override
                    public Object invoke(Object idx, Object frm) {
                        return Utils.walkCodeForm((IPersistentVector)RT.conj(coord, idx), f, frm);
                    }
                }, (IPersistentCollection)forms);
            }
        };
        AFn walkSet = new AFn(){

            @Override
            public Object invoke(Object forms) {
                return (IPersistentSet)Utils.mapIndexed(new AFn(){

                    @Override
                    public Object invoke(Object idx, Object frm) {
                        return Utils.walkCodeForm((IPersistentVector)RT.conj(coord, Utils.objCoord("K", frm)), f, frm);
                    }
                }, (IPersistentSet)forms);
            }
        };
        AFn walkMap = new AFn(){

            @Override
            public Object invoke(Object m) {
                ArrayList<Object> kvs = new ArrayList<Object>();
                Iterator iter = RT.iter(m);
                while (iter.hasNext()) {
                    IMapEntry e2 = (IMapEntry)iter.next();
                    Object kfrm = e2.key();
                    Object vfrm = e2.val();
                    kvs.add(Utils.walkCodeForm((IPersistentVector)RT.conj(coord, Utils.objCoord("K", kfrm)), f, kfrm));
                    kvs.add(Utils.walkCodeForm((IPersistentVector)RT.conj(coord, Utils.objCoord("V", kfrm)), f, vfrm));
                }
                Object[] r = kvs.toArray();
                return RT.map(r);
            }
        };
        Object result = null;
        result = form instanceof IPersistentMap && !(form instanceof IRecord) ? walkMap.invoke(form) : (form instanceof IPersistentSet && !(form instanceof PersistentTreeSet) ? walkSet.invoke(form) : (form instanceof IPersistentCollection && !(form instanceof IRecord) && !(form instanceof IMapEntry) ? walkCollection.invoke(form) : form));
        return f.invoke(coord, Utils.mergeMeta(result, RT.meta(form)));
    }

    public static Object tagFormRecursively(Object form) {
        return Utils.walkCodeForm(PersistentVector.EMPTY, new AFn(){

            @Override
            public Object invoke(Object coord, Object frm) {
                if (frm instanceof ISeq && RT.count(frm) > 0 || frm instanceof Symbol) {
                    return Utils.addCoordMeta(frm, (IPersistentVector)coord);
                }
                return frm;
            }
        }, form);
    }

    public static Object tagStormCoord(Object form) {
        boolean dontTag;
        boolean bl = dontTag = form != null && RT.meta(form) != null && RT.get(RT.meta(form), Keyword.intern("clojure.storm", "dont-tag")) != null;
        if (((Boolean)Emitter.INSTRUMENTATION_ENABLE.deref()).booleanValue() && !dontTag) {
            try {
                Object tagged = Utils.tagFormRecursively(form);
                return tagged;
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                return form;
            }
        }
        return form;
    }

    public static Object stripStormMeta(Object form) {
        return Utils.walkCodeForm(PersistentVector.EMPTY, new AFn(){

            @Override
            public Object invoke(Object coord, Object frm) {
                if (frm instanceof ISeq || frm instanceof Symbol) {
                    IObj mfrm = (IObj)frm;
                    IPersistentMap frmMeta = RT.meta(mfrm);
                    return mfrm.withMeta((IPersistentMap)RT.dissoc(frmMeta, LispReader.COORD_KEY));
                }
                return frm;
            }
        }, form);
    }

    public static int toInt(Object n) {
        if (n == null) {
            return 0;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        if (n instanceof Long) {
            return ((Long)n).intValue();
        }
        return 0;
    }

    private static void collectFiles(File dir2, List<File> collectedFiles) {
        File[] files = dir2.listFiles();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    Utils.collectFiles(file2, collectedFiles);
                    continue;
                }
                collectedFiles.add(file2);
            }
        }
    }

    public static Set<String> getSrcDirRootNamespaces(File dir2) {
        HashSet<String> namespaces = new HashSet<String>();
        ArrayList<File> allDirFiles = new ArrayList<File>();
        Pattern pattern = Pattern.compile(".+?" + dir2.getName() + "/(.+?)/.*");
        Utils.collectFiles(dir2, allDirFiles);
        for (File f : allDirFiles) {
            Matcher matcher;
            if (!f.getName().endsWith(".clj") && !f.getName().endsWith(".cljc") || !(matcher = pattern.matcher(f.getAbsolutePath())).find() || matcher.groupCount() < 1) continue;
            String rootDir = matcher.group(1);
            namespaces.add(Compiler.demunge(rootDir));
        }
        return namespaces;
    }

    public static Set<String> classpathSrcDirstRootNamespaces() {
        String classpath = System.getProperty("java.class.path");
        String cpSeparator = System.getProperty("path.separator");
        String[] cpEntries = classpath.split(cpSeparator);
        HashSet<String> rootNamespaces = new HashSet<String>();
        for (String cpEntry : cpEntries) {
            File f = new File(cpEntry);
            if (!f.isDirectory()) continue;
            rootNamespaces.addAll(Utils.getSrcDirRootNamespaces(f));
        }
        return rootNamespaces;
    }

    public static boolean isAnnoyingLeinNreplForm(Object form) {
        Symbol firstSymb;
        ISeq frm;
        return form instanceof ISeq && RT.first(frm = (ISeq)form) instanceof Symbol && ((firstSymb = (Symbol)RT.first(frm)).toString().equals("clojure.core/let") || firstSymb.toString().equals("do")) && form.toString().contains("nrepl.server/start-server");
    }
}

