/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.storm.FormLocation;
import clojure.storm.FormObject;
import clojure.storm.FormRegistry;

public class Tracer {
    private static IFn traceFnCallFn = null;
    private static IFn traceFnReturnFn = null;
    private static IFn traceFnUnwindFn = null;
    private static IFn traceExprFn = null;
    private static IFn traceBindFn = null;
    private static Keyword TRACE_FN_CALL_FN_KEY = Keyword.intern(null, "trace-fn-call-fn-key");
    private static Keyword TRACE_FN_RETURN_FN_KEY = Keyword.intern(null, "trace-fn-return-fn-key");
    private static Keyword TRACE_EXPR_FN_KEY = Keyword.intern(null, "trace-expr-fn-key");
    private static Keyword TRACE_BIND_FN_KEY = Keyword.intern(null, "trace-bind-fn-key");
    private static Keyword TRACE_FN_CALL_FN = Keyword.intern(null, "trace-fn-call-fn");
    private static Keyword TRACE_FN_RETURN_FN = Keyword.intern(null, "trace-fn-return-fn");
    private static Keyword TRACE_FN_UNWIND_FN = Keyword.intern(null, "trace-fn-unwind-fn");
    private static Keyword TRACE_EXPR_FN = Keyword.intern(null, "trace-expr-fn");
    private static Keyword TRACE_BIND_FN = Keyword.intern(null, "trace-bind-fn");

    public static void traceFnCall(Object[] fnArgs, String fnNs, String fnName, int formId) {
        if (traceFnCallFn != null) {
            traceFnCallFn.invoke(null, fnNs, fnName, fnArgs, formId);
        }
    }

    public static void traceExpr(Object val2, String coord, int formId) {
        if (traceExprFn != null) {
            traceExprFn.invoke(null, val2, coord, formId);
        }
    }

    public static void traceFnReturn(Object retVal, String coord, int formId) {
        if (traceFnReturnFn != null) {
            traceFnReturnFn.invoke(null, retVal, coord, formId);
        }
    }

    public static void traceFnUnwind(Object throwable, String coord, int formId) {
        if (traceFnUnwindFn != null) {
            traceFnUnwindFn.invoke(null, throwable, coord, formId);
        }
    }

    public static void traceBind(Object val2, String coord, String symName) {
        if (traceBindFn != null) {
            traceBindFn.invoke(null, coord, symName, val2);
        }
    }

    public static void registerFormLocation(int formId, int line, String ns2, String sourceFile) {
        FormRegistry.registerForm(formId, new FormLocation(formId, sourceFile, ns2, line));
    }

    public static void registerFormObject(int formId, String nsName, String sourceFile, int line, Object form) {
        FormRegistry.registerForm(formId, new FormObject(formId, nsName, sourceFile, line, form));
    }

    public static void setTraceFnsCallbacks(IPersistentMap callbacks) {
        if (callbacks.valAt(TRACE_FN_CALL_FN_KEY) != null) {
            traceFnCallFn = (IFn)callbacks.valAt(TRACE_FN_CALL_FN_KEY);
        }
        if (callbacks.valAt(TRACE_FN_RETURN_FN_KEY) != null) {
            traceFnReturnFn = (IFn)callbacks.valAt(TRACE_FN_RETURN_FN_KEY);
        }
        if (callbacks.valAt(TRACE_EXPR_FN_KEY) != null) {
            traceExprFn = (IFn)callbacks.valAt(TRACE_EXPR_FN_KEY);
        }
        if (callbacks.valAt(TRACE_BIND_FN_KEY) != null) {
            traceBindFn = (IFn)callbacks.valAt(TRACE_BIND_FN_KEY);
        }
        if (callbacks.valAt(TRACE_FN_CALL_FN) != null) {
            traceFnCallFn = (IFn)callbacks.valAt(TRACE_FN_CALL_FN);
        }
        if (callbacks.valAt(TRACE_FN_RETURN_FN) != null) {
            traceFnReturnFn = (IFn)callbacks.valAt(TRACE_FN_RETURN_FN);
        }
        if (callbacks.valAt(TRACE_FN_UNWIND_FN) != null) {
            traceFnUnwindFn = (IFn)callbacks.valAt(TRACE_FN_UNWIND_FN);
        }
        if (callbacks.valAt(TRACE_EXPR_FN) != null) {
            traceExprFn = (IFn)callbacks.valAt(TRACE_EXPR_FN);
        }
        if (callbacks.valAt(TRACE_BIND_FN) != null) {
            traceBindFn = (IFn)callbacks.valAt(TRACE_BIND_FN);
        }
    }
}

