/*
 * Decompiled with CFR 0.152.
 */
package redis.reply;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import redis.RedisProtocol;
import redis.reply.Reply;

public class BulkReply
implements Reply<byte[]> {
    public static final char MARKER = '$';
    private final byte[] bytes;

    public BulkReply(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte[] data() {
        return this.bytes;
    }

    public String asAsciiString() {
        if (this.bytes == null) {
            return null;
        }
        return new String(this.bytes, Charsets.US_ASCII);
    }

    public String asUTF8String() {
        if (this.bytes == null) {
            return null;
        }
        return new String(this.bytes, Charsets.UTF_8);
    }

    public String asString(Charset charset) {
        if (this.bytes == null) {
            return null;
        }
        return new String(this.bytes, charset);
    }

    @Override
    public void write(OutputStream os) throws IOException {
        os.write(36);
        os.write(RedisProtocol.toBytes(this.bytes.length));
        os.write(CRLF);
        os.write(this.bytes);
        os.write(CRLF);
    }
}

