/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import java.io.File;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;

public class AGRepository
implements AGAbstractRepository,
Closeable {
    private final AGCatalog catalog;
    private final String repositoryID;
    private final String catalogPrefixedRepositoryID;
    private final String repositoryURL;
    private final AGValueFactory vf;
    private File dataDir;

    public AGRepository(AGCatalog catalog, String repositoryID) {
        this.catalog = catalog;
        this.repositoryID = repositoryID;
        this.catalogPrefixedRepositoryID = catalog.getCatalogPrefixedRepositoryID(repositoryID);
        this.repositoryURL = catalog.getRepositoryURL(repositoryID);
        this.vf = new AGValueFactory(this);
    }

    @Override
    public AGCatalog getCatalog() {
        return this.catalog;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public String getCatalogPrefixedRepositoryID() {
        return this.catalogPrefixedRepositoryID;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    @Override
    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getCatalog().getHTTPClient();
    }

    public void initialize() throws RepositoryException {
    }

    @Override
    public AGRepositoryConnection getConnection() throws RepositoryException {
        AGHttpRepoClient repoclient = new AGHttpRepoClient(this, this.getCatalog().getHTTPClient(), this.repositoryURL, null);
        return new AGRepositoryConnection(this, repoclient);
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public boolean isWritable() throws RepositoryException {
        String url = this.getCatalog().getRepositoriesURL();
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        Value writable = null;
        try {
            while (null == writable && tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value uri = bindingSet.getValue("uri");
                if (!uri.stringValue().equals(this.getRepositoryURL())) continue;
                writable = bindingSet.getValue("writable");
            }
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                tqresult.close();
            }
            catch (QueryEvaluationException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (null == writable) {
            throw new IllegalStateException("Repository not found in catalog's list of repositories: " + this.getRepositoryURL());
        }
        boolean result = Boolean.parseBoolean(writable.stringValue());
        return result;
    }

    @Override
    public String getSpec() {
        String cname = this.getCatalog().getCatalogName();
        String name = this.getRepositoryID();
        if (cname == null) {
            return "<" + name + ">";
        }
        return "<" + cname + ":" + name + ">";
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void shutDown() throws RepositoryException {
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }
}

