/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGErrorInfo;
import com.franz.agraph.http.AGErrorType;
import com.franz.agraph.http.AGHttpException;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.AGResponseHandler;
import com.franz.util.Closeable;
import com.franz.util.Util;
import info.aduna.net.http.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHTTPClient
implements Closeable {
    private final String serverURL;
    private final HttpClient httpClient;
    private AuthScope authScope;
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MultiThreadedHttpConnectionManager mManager = null;

    public AGHTTPClient(String serverURL) {
        this(serverURL, null);
    }

    public AGHTTPClient(String serverURL, HttpConnectionManager manager) {
        this.serverURL = serverURL;
        if (manager == null) {
            this.mManager = new MultiThreadedHttpConnectionManager();
            manager = this.mManager;
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            params.setDefaultMaxConnectionsPerHost(20);
            manager.setParams(params);
        }
        this.httpClient = new HttpClient(manager);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(String url, Header[] headers, NameValuePair[] params, RequestEntity requestEntity, AGResponseHandler handler) throws HttpException, IOException, RepositoryException, RDFParseException {
        PostMethod post = new PostMethod(url);
        this.setDoAuthentication((HttpMethod)post);
        for (Header header : headers) {
            post.addRequestHeader(header);
        }
        post.addRequestHeader("Accept-encoding", "gzip");
        post.setQueryString(params);
        if (requestEntity != null) {
            post.setRequestEntity(requestEntity);
        }
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)post);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse((HttpMethod)post);
                }
            } else {
                if (httpCode == 401) {
                    throw new UnauthorizedException();
                }
                if (!HttpClientUtil.is2xx((int)httpCode)) {
                    AGErrorInfo errInfo = this.getErrorInfo((HttpMethod)post);
                    if (errInfo.getErrorType() == AGErrorType.MALFORMED_DATA) {
                        throw new RDFParseException(errInfo.getErrorMessage());
                    }
                    if (errInfo.getErrorType() == AGErrorType.UNSUPPORTED_FILE_FORMAT) {
                        throw new UnsupportedRDFormatException(errInfo.getErrorMessage());
                    }
                    throw new RepositoryException("POST failed " + url + ":" + errInfo + " (" + httpCode + ")");
                }
            }
        }
        finally {
            this.releaseConnection((HttpMethod)post);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws IOException, RepositoryException, AGHttpException {
        GetMethod get = new GetMethod(url);
        this.setDoAuthentication((HttpMethod)get);
        for (Header header : headers) {
            get.addRequestHeader(header);
        }
        get.addRequestHeader("Accept-encoding", "gzip");
        get.setQueryString(params);
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)get);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse((HttpMethod)get);
                }
            } else {
                if (httpCode == 401) {
                    throw new UnauthorizedException();
                }
                if (!HttpClientUtil.is2xx((int)httpCode)) {
                    AGErrorInfo errInfo = this.getErrorInfo((HttpMethod)get);
                    throw new AGHttpException(errInfo);
                }
            }
        }
        finally {
            this.releaseConnection((HttpMethod)get);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String url, Header[] headers, NameValuePair[] params) throws HttpException, IOException, RepositoryException {
        DeleteMethod delete = new DeleteMethod(url);
        this.setDoAuthentication((HttpMethod)delete);
        for (Header header : headers) {
            delete.addRequestHeader(header);
        }
        delete.setQueryString(params);
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)delete);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!HttpClientUtil.is2xx((int)httpCode)) {
                AGErrorInfo errInfo = this.getErrorInfo((HttpMethod)delete);
                throw new RepositoryException("DELETE failed " + url + ":" + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String url, Header[] headers, NameValuePair[] params, RequestEntity requestEntity) throws IOException, AGHttpException, UnauthorizedException {
        PutMethod put = new PutMethod(url);
        this.setDoAuthentication((HttpMethod)put);
        for (Header header : headers) {
            put.addRequestHeader(header);
        }
        put.setQueryString(params);
        if (requestEntity != null) {
            put.setRequestEntity(requestEntity);
        }
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)put);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!HttpClientUtil.is2xx((int)httpCode)) {
                AGErrorInfo errInfo = this.getErrorInfo((HttpMethod)put);
                throw new AGHttpException(errInfo);
            }
        }
        finally {
            this.releaseConnection((HttpMethod)put);
        }
    }

    protected AGErrorInfo getErrorInfo(HttpMethod method) {
        AGErrorInfo errorInfo;
        try {
            AGResponseHandler handler = new AGResponseHandler("");
            handler.handleResponse(method);
            errorInfo = AGErrorInfo.parse(handler.getString());
            this.logger.warn("Server reports problem: {}", (Object)errorInfo.getErrorMessage());
        }
        catch (Exception e) {
            this.logger.warn("Unable to retrieve error info from server");
            errorInfo = new AGErrorInfo("Unable to retrieve error info from server");
        }
        return errorInfo;
    }

    public void setUsernameAndPassword(String username, String password) {
        if (username != null && password != null) {
            this.logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)this.serverURL);
            try {
                URL server = new URL(this.serverURL);
                this.authScope = new AuthScope(server.getHost(), -1);
                this.httpClient.getState().setCredentials(this.authScope, (Credentials)new UsernamePasswordCredentials(username, password));
                this.httpClient.getParams().setAuthenticationPreemptive(true);
            }
            catch (MalformedURLException e) {
                this.logger.warn("Unable to set username and password for malformed URL {}", (Object)this.serverURL);
            }
        } else {
            this.authScope = null;
            this.httpClient.getState().clearCredentials();
            this.httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    protected final void setDoAuthentication(HttpMethod method) {
        if (this.authScope != null && this.httpClient.getState().getCredentials(this.authScope) != null) {
            method.setDoAuthentication(true);
        } else {
            method.setDoAuthentication(false);
        }
        method.addRequestHeader(new Header("Connection", "keep-alive"));
    }

    protected final void releaseConnection(HttpMethod method) {
        try {
            InputStream responseStream = method.getResponseBodyAsStream();
            if (responseStream != null) {
                while (responseStream.read() >= 0) {
                }
            }
            method.releaseConnection();
        }
        catch (IOException e) {
            this.logger.warn("I/O error upon releasing connection", (Throwable)e);
        }
    }

    public void putRepository(String repositoryURL) throws IOException, RepositoryException, UnauthorizedException, AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("override", "false")};
        this.put(repositoryURL, headers, params, null);
    }

    public void deleteRepository(String repositoryURL) throws IOException, RepositoryException, UnauthorizedException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(repositoryURL, headers, params);
    }

    public TupleQueryResult getTupleQueryResult(String url) throws RepositoryException {
        Header[] headers = new Header[]{new Header("Accept", TupleQueryResultFormat.SPARQL.getDefaultMIMEType())};
        NameValuePair[] params = new NameValuePair[]{};
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.initialize();
        TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
        AGResponseHandler handler = new AGResponseHandler((Repository)repo, (TupleQueryResultHandler)builder);
        try {
            this.get(url, headers, params, handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return builder.getQueryResult();
    }

    public String[] getBlankNodes(String repositoryURL, int amount) throws IOException, RepositoryException, UnauthorizedException {
        String url = AGProtocol.getBlankNodesURL(repositoryURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("amount", Integer.toString(amount))};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.post(url, headers, data, null, handler);
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        return handler.getString().split("\n");
    }

    public String openSession(String spec, boolean autocommit) throws RepositoryException {
        String url = AGProtocol.getSessionURL(this.serverURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("store", spec), new NameValuePair("autoCommit", Boolean.toString(autocommit)), new NameValuePair("lifetime", Long.toString(3600L))};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.post(url, headers, data, null, handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            // empty catch block
        }
        return handler.getString();
    }

    @Override
    public void close() {
        Util.close(this.mManager);
    }
}

