/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.flipkart.iris.bufferqueue.BufferQueueEntry;
import com.flipkart.iris.bufferqueue.mmapped.MappedHeader;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.validation.constraints.NotNull;

class MappedEntries {
    private final ByteBuffer entriesBuffer;
    public final int maxEntryLength;
    public final long capacity;

    MappedEntries(ByteBuffer entriesBuffer, MappedHeader mappedHeader) {
        this.entriesBuffer = entriesBuffer;
        this.maxEntryLength = BufferQueueEntry.calculateEntryLength(mappedHeader.maxDataLength());
        this.capacity = entriesBuffer.limit() / this.maxEntryLength;
    }

    public void format() {
        long numMessages = this.capacity;
        int i = 0;
        while ((long)i < numMessages) {
            this.makeEntry(i).set(new byte[0]);
            ++i;
        }
    }

    @VisibleForTesting
    ByteBuffer getMessageBuffer(long index) {
        int maxMessageLength = this.maxEntryLength;
        long offset = index % this.capacity * (long)this.maxEntryLength;
        ByteBuffer msgBuf = this.entriesBuffer.duplicate();
        msgBuf.position((int)offset);
        msgBuf = msgBuf.slice();
        msgBuf.limit(maxMessageLength);
        return msgBuf;
    }

    @NotNull
    @VisibleForTesting
    BufferQueueEntry makeEntry(long cursor) {
        return new BufferQueueEntry(this.getMessageBuffer(cursor), cursor);
    }

    @NotNull
    @VisibleForTesting
    BufferQueueEntry getEntry(long cursor) {
        return new BufferQueueEntry(this.getMessageBuffer(cursor));
    }
}

