/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.flipkart.iris.bufferqueue.BufferQueue;
import com.flipkart.iris.bufferqueue.BufferQueueEntry;
import com.flipkart.iris.bufferqueue.mmapped.MappedEntries;
import com.flipkart.iris.bufferqueue.mmapped.MappedHeader;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedBufferQueue
implements BufferQueue {
    public static final int MAX_MAX_DATA_LENGTH = 0x100000;
    public static final long SYNC_INTERVAL = 1000L;
    private final Integer maxDataLength;
    private final AtomicLong readCursor = new AtomicLong(1L);
    private final AtomicLong writeCursor = new AtomicLong(1L);
    private final File file;
    private final ByteBuffer fileBuffer;
    private final FileChannel fileChannel;
    private final MappedHeader mappedHeader;
    private final MappedEntries mappedEntries;
    private final HeaderSyncThread headerSyncThread;

    static long fileSize(int maxDataLength, long numMessages) {
        return 4096L + (long)BufferQueueEntry.calculateEntryLength(maxDataLength) * numMessages;
    }

    MappedBufferQueue(File file, ByteBuffer fileBuffer) throws FileNotFoundException, IOException {
        fileBuffer = fileBuffer.duplicate();
        this.file = file;
        this.fileBuffer = fileBuffer;
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        this.fileChannel = raf.getChannel();
        this.mappedHeader = MappedBufferQueue.getHeaderBuffer(fileBuffer);
        this.mappedEntries = MappedBufferQueue.getEntriesBuffer(fileBuffer, this.mappedHeader);
        this.maxDataLength = this.mappedHeader.maxDataLength();
        this.readCursor.set(this.mappedHeader.readCursor());
        this.writeCursor.set(this.mappedHeader.writeCursor());
        this.headerSyncThread = new HeaderSyncThread(1000L);
        this.headerSyncThread.start();
    }

    private static MappedHeader getHeaderBuffer(ByteBuffer fileBuffer) {
        ByteBuffer headerBuffer = fileBuffer.duplicate();
        headerBuffer.limit(4096);
        headerBuffer.rewind();
        return new MappedHeader(headerBuffer);
    }

    private static MappedEntries getEntriesBuffer(ByteBuffer fileBuffer, MappedHeader mappedHeader) {
        fileBuffer.position(4096);
        ByteBuffer entriesBuffer = fileBuffer.slice();
        entriesBuffer.rewind();
        return new MappedEntries(entriesBuffer, mappedHeader);
    }

    static void format(ByteBuffer fileBuffer, int maxDataLength) {
        Preconditions.checkArgument((maxDataLength < 0x100000 ? 1 : 0) != 0, (String)"maxDataLength must be <= %s", (Object[])new Object[]{0x100000});
        MappedHeader headerBuffer = MappedBufferQueue.getHeaderBuffer(fileBuffer);
        headerBuffer.format(maxDataLength);
        MappedEntries entriesBuffer = MappedBufferQueue.getEntriesBuffer(fileBuffer, headerBuffer);
        entriesBuffer.format();
    }

    @Override
    public int maxDataLength() {
        return this.maxDataLength;
    }

    @Override
    public Optional<BufferQueueEntry> next() {
        if (this.writeCursor.get() - this.readCursor.get() >= this.capacity()) {
            this.forwardReadCursor();
            if (this.writeCursor.get() - this.readCursor.get() >= this.capacity()) {
                return Optional.absent();
            }
        }
        long n = this.writeCursor.getAndIncrement();
        return Optional.of((Object)this.mappedEntries.makeEntry(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(byte[] data) throws BufferOverflowException {
        Optional<BufferQueueEntry> entry = this.next();
        if (!entry.isPresent()) {
            return false;
        }
        try {
            ((BufferQueueEntry)entry.get()).set(data);
        }
        finally {
            ((BufferQueueEntry)entry.get()).markPublished();
        }
        return true;
    }

    public long forwardReadCursor() {
        BufferQueueEntry entry;
        long readCursorVal;
        while ((readCursorVal = this.readCursor.get()) < this.writeCursor.get() && (readCursorVal <= 0L || (entry = this.mappedEntries.getEntry(readCursorVal)).isPublished() && entry.isConsumed())) {
            this.readCursor.compareAndSet(readCursorVal, readCursorVal + 1L);
        }
        return readCursorVal;
    }

    @Override
    public Optional<BufferQueueEntry> consume() {
        BufferQueueEntry entry;
        long readCursorVal = this.forwardReadCursor();
        if (readCursorVal < this.writeCursor.get() && (entry = this.mappedEntries.getEntry(readCursorVal)).isPublished()) {
            return Optional.of((Object)entry);
        }
        return Optional.absent();
    }

    @Override
    public List<BufferQueueEntry> consume(int n) {
        BufferQueueEntry entry;
        ArrayList bufferQueueEntries = Lists.newArrayList();
        long readCursorVal = this.forwardReadCursor();
        int i = 0;
        while ((long)i < Math.min((long)n, this.writeCursor.get() - readCursorVal) && (entry = this.mappedEntries.getEntry(readCursorVal + (long)i)).isPublished()) {
            bufferQueueEntries.add(entry);
            ++i;
        }
        return bufferQueueEntries;
    }

    @Override
    public long capacity() {
        return this.mappedEntries.capacity;
    }

    @Override
    public long size() {
        return this.writeCursor.get() - this.readCursor.get();
    }

    @Override
    public boolean isFull() {
        return this.size() == this.capacity();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    private class HeaderSyncThread
    extends Thread {
        private final long waitMillies;
        private volatile boolean isEnabled = true;

        private HeaderSyncThread(long waitMillies) {
            this.waitMillies = waitMillies;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                MappedHeader mappedHeader = MappedBufferQueue.this.mappedHeader;
                synchronized (mappedHeader) {
                    if (this.isEnabled) {
                        try {
                            FileLock lock = MappedBufferQueue.this.fileChannel.lock();
                            try {
                                long currentWriteCursor = MappedBufferQueue.this.writeCursor.get();
                                long persistedWriteCursor = MappedBufferQueue.this.mappedHeader.writeCursor(currentWriteCursor);
                                MappedBufferQueue.this.writeCursor.compareAndSet(currentWriteCursor, persistedWriteCursor);
                                long currentReadCursor = MappedBufferQueue.this.readCursor.get();
                                long persistedReadCursor = MappedBufferQueue.this.mappedHeader.readCursor(currentReadCursor);
                                MappedBufferQueue.this.readCursor.compareAndSet(currentReadCursor, persistedReadCursor);
                            }
                            finally {
                                lock.release();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        MappedBufferQueue.this.mappedHeader.wait(this.waitMillies);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }

        public void disable() {
            this.isEnabled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enable() {
            this.isEnabled = true;
            HeaderSyncThread headerSyncThread = this;
            synchronized (headerSyncThread) {
                this.notifyAll();
            }
        }
    }
}

