/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BufferQueueEntry {
    private static final HashFunction checksum = Hashing.crc32();
    private static final int CHECKSUM_BYTES = checksum.bits() / 8;
    @VisibleForTesting
    static final int OFFSET_CURSOR = 0;
    @VisibleForTesting
    static final int OFFSET_LENGTH = 64;
    @VisibleForTesting
    static final int OFFSET_CHECKSUM = 96;
    @VisibleForTesting
    static final int OFFSET_DATA = 96 + CHECKSUM_BYTES;
    private static final long CURSOR_UNPUBLISHED = 0L;
    private static final long CURSOR_CONSUMED = -1L;
    private final ByteBuffer buf;
    @VisibleForTesting
    long cursor;

    public BufferQueueEntry(ByteBuffer buf, long cursor) {
        this.buf = buf;
        this.cursor = cursor;
        buf.putLong(0, 0L);
    }

    public BufferQueueEntry(ByteBuffer buf) {
        this.buf = buf;
        this.cursor = buf.getLong(0);
        if (this.cursor <= 0L) {
            throw new IllegalArgumentException("The given buffer entry does not represent a \"published, but not yet consumed\" entry");
        }
    }

    public void set(byte[] data) throws BufferOverflowException {
        if (this.isPublished()) {
            throw new IllegalStateException("The given buffer entry has already been marked as published and cannot be written to");
        }
        if (BufferQueueEntry.calculateEntryLength(data.length) > this.buf.limit()) {
            throw new BufferOverflowException();
        }
        this.buf.putInt(64, data.length);
        this.buf.position(96);
        this.buf.put(checksum.hashBytes(data).asBytes());
        this.buf.position(OFFSET_DATA);
        this.buf.put(data);
        this.buf.flip();
    }

    public void markPublished() {
        this.writeCursor(this.cursor);
    }

    public boolean isPublished() {
        return this.readCursor() != 0L;
    }

    public int dataLength() {
        if (!this.isPublished()) {
            return -1;
        }
        return this.buf.getInt(64);
    }

    public int maxDataLength() {
        return this.buf.capacity() - OFFSET_DATA;
    }

    public byte[] get() {
        if (this.isConsumed()) {
            throw new IllegalStateException("The buffer queue entry has already been marked as consumed, so cannot be read from");
        }
        int length = this.dataLength();
        if (!this.isPublished() || length > this.maxDataLength() || length <= 0) {
            return new byte[0];
        }
        byte[] checksumBytes = new byte[CHECKSUM_BYTES];
        this.buf.position(96);
        this.buf.get(checksumBytes);
        byte[] data = new byte[length];
        this.buf.position(OFFSET_DATA);
        this.buf.get(data);
        if (!Arrays.equals(checksum.hashBytes(data).asBytes(), checksumBytes)) {
            return new byte[0];
        }
        return data;
    }

    public void markConsumed() {
        this.writeCursor(-1L);
    }

    public boolean isConsumed() {
        return this.readCursor() == -1L;
    }

    @VisibleForTesting
    long readCursor() {
        return this.buf.getLong(0);
    }

    @VisibleForTesting
    void writeCursor(long cursor) {
        this.buf.putLong(0, cursor);
    }

    public static int calculateEntryLength(int messageDataLength) {
        return OFFSET_DATA + messageDataLength;
    }
}

