(ns open-stack-wrapper.mock)
(def endpoints-mock
  {:access {:token
            {:issued_at "2014-01-28T14:09:06.955707", :expires "2014-01-29T14:09:06Z",
             :id "MIIOzgYJKoZIhvcNAQcCoIIOvzCCDrsCAQExCTAHBgUrDgMCGjCCDSQGCSqGSIb3DQEHAaCCDRUEgg0ReyJhY2Nlc3MiOiB7InRva2VuIjogeyJpc3N1ZWRfYXQiOiAiMjAxNC0wMS0yOFQxNDowOTowNi45NTU3MDciLCAiZXhwaXJlcyI6ICIyMDE0LTAxLTI5VDE0OjA5OjA2WiIsICJpZCI6ICJwbGFjZWhvbGRlciIsICJ0ZW5hbnQiOiB7ImRlc2NyaXB0aW9uIjogIkF1dG8gY3JlYXRlZCBhY2NvdW50IiwgImVuYWJsZWQiOiB0cnVlLCAiaWQiOiAiZGEwNWEzMGRmZjc3NDZiOWEyMDAyN2E2OGNmZTYwNzYiLCAibmFtZSI6ICJmYWNlYm9vazE0Mjg0Njc4NTAifX0sICJzZXJ2aWNlQ2F0YWxvZyI6IFt7ImVuZHBvaW50cyI6IFt7ImFkbWluVVJMIjogImh0dHA6Ly8xMC4xMDAuMC4yMjI6ODc3NC92Mi9kYTA1YTMwZGZmNzc0NmI5YTIwMDI3YTY4Y2ZlNjA3NiIsICJyZWdpb24iOiAiUmVnaW9uT25lIiwgImludGVybmFsVVJMIjogImh0dHA6Ly8xMC4xMDAuMC4yMjI6ODc3NC92Mi9kYTA1YTMwZGZmNzc0NmI5YTIwMDI3YTY4Y2ZlNjA3NiIsICJpZCI6ICI4NGRiZjBkNWVkOWE0OTg0OGVmNjdlNDlmNjMxNjE3ZiIsICJwdWJsaWNVUkwiOiAiaHR0cDovLzguMjEuMjguMjIyOjg3NzQvdjIvZGEwNWEzMGRmZjc3NDZiOWEyMDAyN2E2OGNmZTYwNzYifV0sICJlbmRwb2ludHNfbGlua3MiOiBbXSwgInR5cGUiOiAiY29tcHV0ZSIsICJuYW1lIjogIm5vdmEifSwgeyJlbmRwb2ludHMiOiBbeyJhZG1pblVSTCI6ICJodHRwOi8vMTAuMTAwLjAuNDo5Njk2LyIsICJyZWdpb24iOiAiUmVnaW9uT25lIiwgImludGVybmFsVVJMIjogImh0dHA6Ly8xMC4xMDAuMC40Ojk2OTYvIiwgImlkIjogIjFiNDI3Zjg0Y2VlMDQzMjE5NWQ3MTAxYjI1OTUxYTU2IiwgInB1YmxpY1VSTCI6ICJodHRwOi8vOC4yMS4yOC40Ojk2OTYvIn1dLCAiZW5kcG9pbnRzX2xpbmtzIjogW10sICJ0eXBlIjogIm5ldHdvcmsiLCAibmFtZSI6ICJuZXV0cm9uIn0sIHsiZW5kcG9pbnRzIjogW3siYWRtaW5VUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo4MDgwIiwgInJlZ2lvbiI6ICJSZWdpb25PbmUiLCAiaW50ZXJuYWxVUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo4MDgwIiwgImlkIjogIjA1ODdhYmQxNWNhYTQ1MDI5MGNhZThiYjExZjU0M2JiIiwgInB1YmxpY1VSTCI6ICJodHRwOi8vOC4yMS4yOC4yMjI6ODA4MCJ9XSwgImVuZHBvaW50c19saW5rcyI6IFtdLCAidHlwZSI6ICJzMyIsICJuYW1lIjogInN3aWZ0X3MzIn0sIHsiZW5kcG9pbnRzIjogW3siYWRtaW5VUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo5MjkyIiwgInJlZ2lvbiI6ICJSZWdpb25PbmUiLCAiaW50ZXJuYWxVUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo5MjkyIiwgImlkIjogIjA5NmEyMGU3MmE4MjRjNjZiOTU5NWYyMjY0YTI5MDFiIiwgInB1YmxpY1VSTCI6ICJodHRwOi8vOC4yMS4yOC4yMjI6OTI5MiJ9XSwgImVuZHBvaW50c19saW5rcyI6IFtdLCAidHlwZSI6ICJpbWFnZSIsICJuYW1lIjogImdsYW5jZSJ9LCB7ImVuZHBvaW50cyI6IFt7ImFkbWluVVJMIjogImh0dHA6Ly8xMC4xMDAuMC4yMjI6ODc3NyIsICJyZWdpb24iOiAiUmVnaW9uT25lIiwgImludGVybmFsVVJMIjogImh0dHA6Ly8xMC4xMDAuMC4yMjI6ODc3NyIsICJpZCI6ICIwMmI4ODE2YThmZGQ0M2UxYWRlYzdhMmY4NTAwZjAyZiIsICJwdWJsaWNVUkwiOiAiaHR0cDovLzguMjEuMjguMjIyOjg3NzcifV0sICJlbmRwb2ludHNfbGlua3MiOiBbXSwgInR5cGUiOiAibWV0ZXJpbmciLCAibmFtZSI6ICJjZWlsb21ldGVyIn0sIHsiZW5kcG9pbnRzIjogW3siYWRtaW5VUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo4Nzc2L3YxL2RhMDVhMzBkZmY3NzQ2YjlhMjAwMjdhNjhjZmU2MDc2IiwgInJlZ2lvbiI6ICJSZWdpb25PbmUiLCAiaW50ZXJuYWxVUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo4Nzc2L3YxL2RhMDVhMzBkZmY3NzQ2YjlhMjAwMjdhNjhjZmU2MDc2IiwgImlkIjogIjJjZjZhNDM5OTMyMTRjODNhNTA1NjBjYzkwMDkyYTQ1IiwgInB1YmxpY1VSTCI6ICJodHRwOi8vOC4yMS4yOC4yMjI6ODc3Ni92MS9kYTA1YTMwZGZmNzc0NmI5YTIwMDI3YTY4Y2ZlNjA3NiJ9XSwgImVuZHBvaW50c19saW5rcyI6IFtdLCAidHlwZSI6ICJ2b2x1bWUiLCAibmFtZSI6ICJjaW5kZXIifSwgeyJlbmRwb2ludHMiOiBbeyJhZG1pblVSTCI6ICJodHRwOi8vMTAuMTAwLjAuMjIyOjg3NzMvc2VydmljZXMvQWRtaW4iLCAicmVnaW9uIjogIlJlZ2lvbk9uZSIsICJpbnRlcm5hbFVSTCI6ICJodHRwOi8vMTAuMTAwLjAuMjIyOjg3NzMvc2VydmljZXMvQ2xvdWQiLCAiaWQiOiAiMGFhMjJhZTAxNGRlNDc0ZmFkOTE0ZTMzNDdiYTc2ZWEiLCAicHVibGljVVJMIjogImh0dHA6Ly84LjIxLjI4LjIyMjo4NzczL3NlcnZpY2VzL0Nsb3VkIn1dLCAiZW5kcG9pbnRzX2xpbmtzIjogW10sICJ0eXBlIjogImVjMiIsICJuYW1lIjogIm5vdmFfZWMyIn0sIHsiZW5kcG9pbnRzIjogW3siYWRtaW5VUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo4MDgwLyIsICJyZWdpb24iOiAiUmVnaW9uT25lIiwgImludGVybmFsVVJMIjogImh0dHA6Ly8xMC4xMDAuMC4yMjI6ODA4MC92MS9BVVRIX2RhMDVhMzBkZmY3NzQ2YjlhMjAwMjdhNjhjZmU2MDc2IiwgImlkIjogIjFiNmMwMDNmMWExNjRmMzJhNTUxZmUwNzVhYTUzN2JmIiwgInB1YmxpY1VSTCI6ICJodHRwOi8vOC4yMS4yOC4yMjI6ODA4MC92MS9BVVRIX2RhMDVhMzBkZmY3NzQ2YjlhMjAwMjdhNjhjZmU2MDc2In1dLCAiZW5kcG9pbnRzX2xpbmtzIjogW10sICJ0eXBlIjogIm9iamVjdC1zdG9yZSIsICJuYW1lIjogInN3aWZ0In0sIHsiZW5kcG9pbnRzIjogW3siYWRtaW5VUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjozNTM1Ny92Mi4wIiwgInJlZ2lvbiI6ICJSZWdpb25PbmUiLCAiaW50ZXJuYWxVUkwiOiAiaHR0cDovLzEwLjEwMC4wLjIyMjo1MDAwL3YyLjAiLCAiaWQiOiAiMDhlMTg0ZTQyZTc2NDU0Y2FlNWYzYWZlODk4NGRiMWQiLCAicHVibGljVVJMIjogImh0dHA6Ly84LjIxLjI4LjIyMjo1MDAwL3YyLjAifV0sICJlbmRwb2ludHNfbGlua3MiOiBbXSwgInR5cGUiOiAiaWRlbnRpdHkiLCAibmFtZSI6ICJrZXlzdG9uZSJ9XSwgInVzZXIiOiB7InVzZXJuYW1lIjogImZhY2Vib29rMTQyODQ2Nzg1MCIsICJyb2xlc19saW5rcyI6IFtdLCAiaWQiOiAiMmVhZWRhYzBkY2MwNDM1Y2JmZWM2OWRjYmQzMzkxYjQiLCAicm9sZXMiOiBbeyJuYW1lIjogIl9tZW1iZXJfIn0sIHsibmFtZSI6ICJNZW1iZXIifV0sICJuYW1lIjogImZhY2Vib29rMTQyODQ2Nzg1MCJ9LCAibWV0YWRhdGEiOiB7ImlzX2FkbWluIjogMCwgInJvbGVzIjogWyI5ZmUyZmY5ZWU0Mzg0YjE4OTRhOTA4NzhkM2U5MmJhYiIsICI1OWVhYjYwMzgyOTA0MmFkYjlhZjkzZDNmZDM1MGUxYyJdfX19MYIBgTCCAX0CAQEwXDBXMQswCQYDVQQGEwJVUzEOMAwGA1UECAwFVW5zZXQxDjAMBgNVBAcMBVVuc2V0MQ4wDAYDVQQKDAVVbnNldDEYMBYGA1UEAwwPd3d3LmV4YW1wbGUuY29tAgEBMAcGBSsOAwIaMA0GCSqGSIb3DQEBAQUABIIBADXKtQxq4SmeoRnRMk0Z+DqvFyijpAnpNua8V8bIdnKymfcxIk6CUdriD9h2aS1F0NUz3BuunP4e9CCpYsnj7Awxt4r9L1BjYc27nStQmTtNNoQGhnxw4cLzop-WclffhQpR1dev+kYaEP7mHX7qcfzpEnRo97kpmEkhAShxb5+JiozbeBUlic7q++N-LtOTPLHutBsg0X1XqnrBUBfKED8JVlkjmKv-6fTQEE4bE-vnY+MvBbl4hR4DEetPLVvTsJho2EYl47a+KpI5Ipb0EKoRcy5K72lDk6eYilIf7YQVO0OIQbNAU572TSu2ACMU0oU0z1yTjzN-9bwHTnDYkRI=", :tenant {:description "Auto created account", :enabled true, :id "da05a30dff7746b9a20027a68cfe6076", :name "facebook1428467850"}},
            :serviceCatalog [{:endpoints [{:adminURL "http://10.100.0.222:8774/v2/da05a30dff7746b9a20027a68cfe6076", :region "RegionOne", :internalURL "http://10.100.0.222:8774/v2/da05a30dff7746b9a20027a68cfe6076", :id "84dbf0d5ed9a49848ef67e49f631617f", :publicURL "http://8.21.28.222:8774/v2/da05a30dff7746b9a20027a68cfe6076"}], :endpoints_links [], :type "compute", :name "nova"} {:endpoints [{:adminURL "http://10.100.0.4:9696/", :region "RegionOne", :internalURL "http://10.100.0.4:9696/", :id "1b427f84cee0432195d7101b25951a56", :publicURL "http://8.21.28.4:9696/"}], :endpoints_links [], :type "network", :name "neutron"} {:endpoints [{:adminURL "http://10.100.0.222:8080", :region "RegionOne", :internalURL "http://10.100.0.222:8080", :id "0587abd15caa450290cae8bb11f543bb", :publicURL "http://8.21.28.222:8080"}], :endpoints_links [], :type "s3", :name "swift_s3"} {:endpoints [{:adminURL "http://10.100.0.222:9292", :region "RegionOne", :internalURL "http://10.100.0.222:9292", :id "096a20e72a824c66b9595f2264a2901b", :publicURL "http://8.21.28.222:9292"}], :endpoints_links [], :type "image", :name "glance"} {:endpoints [{:adminURL "http://10.100.0.222:8777", :region "RegionOne", :internalURL "http://10.100.0.222:8777", :id "02b8816a8fdd43e1adec7a2f8500f02f", :publicURL "http://8.21.28.222:8777"}], :endpoints_links [], :type "metering", :name "ceilometer"} {:endpoints [{:adminURL "http://10.100.0.222:8776/v1/da05a30dff7746b9a20027a68cfe6076", :region "RegionOne", :internalURL "http://10.100.0.222:8776/v1/da05a30dff7746b9a20027a68cfe6076", :id "2cf6a43993214c83a50560cc90092a45", :publicURL "http://8.21.28.222:8776/v1/da05a30dff7746b9a20027a68cfe6076"}], :endpoints_links [], :type "volume", :name "cinder"} {:endpoints [{:adminURL "http://10.100.0.222:8773/services/Admin", :region "RegionOne", :internalURL "http://10.100.0.222:8773/services/Cloud", :id "0aa22ae014de474fad914e3347ba76ea", :publicURL "http://8.21.28.222:8773/services/Cloud"}], :endpoints_links [], :type "ec2", :name "nova_ec2"} {:endpoints [{:adminURL "http://10.100.0.222:8080/", :region "RegionOne", :internalURL "http://10.100.0.222:8080/v1/AUTH_da05a30dff7746b9a20027a68cfe6076", :id "1b6c003f1a164f32a551fe075aa537bf", :publicURL "http://8.21.28.222:8080/v1/AUTH_da05a30dff7746b9a20027a68cfe6076"}], :endpoints_links [], :type "object-store", :name "swift"} {:endpoints [{:adminURL "http://10.100.0.222:35357/v2.0", :region "RegionOne", :internalURL "http://10.100.0.222:5000/v2.0", :id "08e184e42e76454cae5f3afe8984db1d", :publicURL "http://8.21.28.222:5000/v2.0"}], :endpoints_links [], :type "identity", :name "keystone"}], :user {:username "facebook1428467850", :roles_links [], :id "2eaedac0dcc0435cbfec69dcbd3391b4", :roles [{:name "_member_"} {:name "Member"}], :name "facebook1428467850"}, :metadata {:is_admin 0, :roles ["9fe2ff9ee4384b1894a90878d3e92bab" "59eab603829042adb9af93d3fd350e1c"]}}})

(def token-mock
  {:access {:token {:issued_at "2014-01-28T18:28:50.514221", :expires "2014-01-29T18:28:50Z", :id "MIIDCwYJKoZIhvcNAQcCoIIC-DCCAvgCAQExCTAHBgUrDgMCGjCCAWEGCSqGSIb3DQEHAaCCAVIEggFOeyJhY2Nlc3MiOiB7InRva2VuIjogeyJpc3N1ZWRfYXQiOiAiMjAxNC0wMS0yOFQxODoyODo1MC41MTQyMjEiLCAiZXhwaXJlcyI6ICIyMDE0LTAxLTI5VDE4OjI4OjUwWiIsICJpZCI6ICJwbGFjZWhvbGRlciJ9LCAic2VydmljZUNhdGFsb2ciOiBbXSwgInVzZXIiOiB7InVzZXJuYW1lIjogImZhY2Vib29rMTQyODQ2Nzg1MCIsICJyb2xlc19saW5rcyI6IFtdLCAiaWQiOiAiMmVhZWRhYzBkY2MwNDM1Y2JmZWM2OWRjYmQzMzkxYjQiLCAicm9sZXMiOiBbXSwgIm5hbWUiOiAiZmFjZWJvb2sxNDI4NDY3ODUwIn0sICJtZXRhZGF0YSI6IHsiaXNfYWRtaW4iOiAwLCAicm9sZXMiOiBbXX19fTGCAYEwggF9AgEBMFwwVzELMAkGA1UEBhMCVVMxDjAMBgNVBAgMBVVuc2V0MQ4wDAYDVQQHDAVVbnNldDEOMAwGA1UECgwFVW5zZXQxGDAWBgNVBAMMD3d3dy5leGFtcGxlLmNvbQIBATAHBgUrDgMCGjANBgkqhkiG9w0BAQEFAASCAQDFQn2Zx33cfKgSzlHMPGvZHo6AsZgggFi4bLVrwdnLtpod0klBtmvEBnPhfxB7y8p8F2T4e2NIosfAjVeaT+jRmo6KQpjOwOh5QckYTki3NMct0UD801b0lLkasY3RAa67WsaSS32FzHE+2mLcYnwxUj0ibWE6KYOqjo6mjajc5FWmGm9O8jd-9p6SEudXPlSOQf1Q6rJ1Drp5RP+M6mYuz+x2E1YL9QJQ4tSJq1AyaWP9+icdbyskJiaGwhBn5MnYfF+vlYiJL+8ZaijxTUhMW2l6sfWRpOdn3MT+owDJzbUvdWAcwkFOBUY40xR3djVaBQf7phsGs-+A3sXCpYAw"}, :serviceCatalog [], :user {:username "facebook1428467850", :roles_links [], :id "2eaedac0dcc0435cbfec69dcbd3391b4", :roles [], :name "facebook1428467850"}, :metadata {:is_admin 0, :roles []}}})

(def token-id-mock
    (get-in token-mock [:access :token :id])
)

(def tenant-data-mock {:description "Auto created account", :enabled true, :id "da05a30dff7746b9a20027a68cfe6076", :name "facebook1428467850"})


(comment "two ways to obtain the token-id having a token object response"
  (defn get-token-id[response-body-json] (-> response-body-json :access :token :id))
  (defn get-token-id [data]
    (get-in data [:access :token :id])))
