/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.client.IPromise;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Promise<T>
implements IPromise<T> {
    public final CountDownLatch latch = new CountDownLatch(1);
    public final AtomicReference ref = new AtomicReference<CountDownLatch>(this.latch);

    @Override
    public void deliver(Object value) {
        if (0L < this.latch.getCount() && this.ref.compareAndSet(this.latch, value)) {
            this.latch.countDown();
        }
    }

    @Override
    public T deref() throws IOException {
        try {
            this.latch.await();
            Object value = this.ref.get();
            if (value instanceof IOException) {
                throw (IOException)value;
            }
            if (value instanceof RuntimeException) {
                throw (RuntimeException)value;
            }
            return (T)value;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public T deref(long time, TimeUnit unit) throws IOException {
        return this.deref(time, unit, null);
    }

    @Override
    public T deref(long time, TimeUnit unit, T timeoutValue) throws IOException {
        try {
            if (this.latch.await(time, unit)) {
                Object value = this.ref.get();
                if (value instanceof IOException) {
                    throw (IOException)value;
                }
                if (value instanceof RuntimeException) {
                    throw (RuntimeException)value;
                }
                return (T)value;
            }
            return timeoutValue;
        }
        catch (InterruptedException e) {
            return timeoutValue;
        }
    }
}

