/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.datamodeling;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBReflector;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodb.datamodeling.internal.PaginatedQueryList;
import com.amazonaws.services.dynamodb.datamodeling.internal.PaginatedScanList;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.GetItemRequest;
import com.amazonaws.services.dynamodb.model.GetItemResult;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.QueryResult;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoDBMapper {
    private final AmazonDynamoDB db;
    private final DynamoDBMapperConfig config;
    private static final DynamoDBReflector reflector = new DynamoDBReflector();

    public DynamoDBMapper(AmazonDynamoDB dynamoDB) {
        this(dynamoDB, DynamoDBMapperConfig.DEFAULT);
    }

    public DynamoDBMapper(AmazonDynamoDB dynamoDB, DynamoDBMapperConfig config) {
        this.db = dynamoDB;
        this.config = config;
    }

    public <T> T load(Class<T> clazz, Object hashKey, DynamoDBMapperConfig config) {
        return this.load(clazz, hashKey, null, config);
    }

    public <T> T load(Class<T> clazz, Object hashKey) {
        return this.load(clazz, hashKey, null, this.config);
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey) {
        return this.load(clazz, hashKey, rangeKey, this.config);
    }

    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDBMapperConfig config) {
        GetItemResult item;
        Map<String, AttributeValue> itemAttributes;
        if (config != this.config) {
            config = new DynamoDBMapperConfig(this.config, config);
        }
        String tableName = this.getTableName(clazz, config);
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        AttributeValue hashKeyElement = this.getHashKeyElement(hashKey, hashKeyGetter);
        AttributeValue rangeKeyElement = null;
        if (rangeKey != null) {
            Method rangeKeyMethod = reflector.getRangeKeyGetter(clazz);
            if (rangeKeyMethod == null) {
                throw new DynamoDBMappingException("Zero-parameter range key property must be annotated with " + DynamoDBRangeKey.class);
            }
            rangeKeyElement = this.getRangeKeyElement(rangeKey, rangeKeyMethod);
        }
        if ((itemAttributes = (item = this.db.getItem(new GetItemRequest().withTableName(tableName).withKey(new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement)).withConsistentRead(config.getConsistentReads() == DynamoDBMapperConfig.ConsistentReads.CONSISTENT))).getItem()) == null) {
            return null;
        }
        return this.marshallIntoObject(clazz, itemAttributes);
    }

    private <T> String getTableName(Class<T> clazz, DynamoDBMapperConfig config) {
        DynamoDBTable table = reflector.getTable(clazz);
        String tableName = table.tableName();
        if (config.getTableNameOverride() != null) {
            tableName = config.getTableNameOverride().getTableName();
        }
        return tableName;
    }

    private AttributeValue getHashKeyElement(Object hashKey, Method hashKeyGetter) {
        AttributeValue hashKeyElement = new AttributeValue();
        Class<?> hashKeyMethodReturnType = hashKeyGetter.getReturnType();
        if (hashKeyMethodReturnType.isPrimitive() || Number.class.isAssignableFrom(hashKeyMethodReturnType)) {
            hashKeyElement.setN(String.valueOf(hashKey));
        } else if (String.class.isAssignableFrom(hashKeyMethodReturnType)) {
            hashKeyElement.setS(String.valueOf(hashKey));
        } else {
            throw new DynamoDBMappingException("Hash key property must be either a Number or a String");
        }
        return hashKeyElement;
    }

    private AttributeValue getRangeKeyElement(Object rangeKey, Method rangeKeyMethod) {
        AttributeValue rangeKeyElement = new AttributeValue();
        Class<?> rangeKeyMethodReturnType = rangeKeyMethod.getReturnType();
        if (rangeKeyMethodReturnType.isPrimitive() || Number.class.isAssignableFrom(rangeKeyMethodReturnType)) {
            rangeKeyElement.setN(String.valueOf(rangeKey));
        } else if (String.class.isAssignableFrom(rangeKeyMethodReturnType)) {
            rangeKeyElement.setS(String.valueOf(rangeKey));
        } else {
            throw new DynamoDBMappingException("Range key property must be either a Number or a String");
        }
        return rangeKeyElement;
    }

    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes) {
        T toReturn = null;
        try {
            toReturn = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
        }
        if (itemAttributes == null || itemAttributes.isEmpty()) {
            return toReturn;
        }
        for (Method m : reflector.getRelevantGetters(clazz)) {
            String attributeName = reflector.getAttributeName(m);
            if (!itemAttributes.containsKey(attributeName)) continue;
            this.setValue(toReturn, m, itemAttributes.get(attributeName));
        }
        return toReturn;
    }

    private <T> void setValue(T toReturn, Method getter, AttributeValue value) {
        Object argument;
        Method setter = reflector.getSetter(getter);
        ArgumentUnmarshaller unmarhsaller = reflector.getArgumentUnmarshaller(toReturn, getter, setter);
        unmarhsaller.typeCheck(value, setter);
        try {
            argument = unmarhsaller.unmarshall(value);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't unmarshall value " + value + " for " + setter, e);
        }
        catch (ParseException e) {
            throw new DynamoDBMappingException("Error attempting to parse date string " + value + " for " + setter, e);
        }
        this.safeInvoke(setter, toReturn, argument);
    }

    private AttributeValue getSimpleAttributeValue(Method getter, Object getterReturnResult) {
        if (getterReturnResult == null) {
            return null;
        }
        ArgumentMarshaller marshaller = reflector.getArgumentMarshaller(getter);
        return marshaller.marshall(getterReturnResult);
    }

    public <T> void save(T object) {
        this.save(object, this.config);
    }

    public <T> void save(T object, DynamoDBMapperConfig config) {
        if (config != this.config) {
            config = new DynamoDBMapperConfig(this.config, config);
        }
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, config);
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        AttributeValue hashKeyElement = this.getHashKeyElement(this.safeInvoke(hashKeyGetter, object, new Object[0]), hashKeyGetter);
        AttributeValue rangeKeyElement = null;
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        if (rangeKeyGetter != null) {
            rangeKeyElement = this.getRangeKeyElement(this.safeInvoke(rangeKeyGetter, object, new Object[0]), rangeKeyGetter);
        }
        Key objectKey = new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement);
        HashMap<String, AttributeValueUpdate> updateValues = new HashMap<String, AttributeValueUpdate>();
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        boolean forcePut = false;
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        for (Method method : reflector.getRelevantGetters(clazz)) {
            AttributeValue newVersionValue;
            Object getterResult = this.safeInvoke(method, object, new Object[0]);
            String attributeName = reflector.getAttributeName(method);
            if (reflector.isVersionAttributeGetter(method)) {
                if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER) {
                    ExpectedAttributeValue expected = new ExpectedAttributeValue();
                    AttributeValue currentValue = this.getSimpleAttributeValue(method, getterResult);
                    expected.setExists(currentValue != null);
                    if (currentValue != null) {
                        expected.setValue(currentValue);
                    }
                    expectedValues.put(attributeName, expected);
                }
                newVersionValue = this.getVersionAttributeValue(method, getterResult);
                updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
                inMemoryUpdates.add(new ValueUpdate(method, newVersionValue));
                continue;
            }
            if (getterResult == null && reflector.isAssignableKey(method)) {
                forcePut = true;
                newVersionValue = this.getAutoGeneratedKeyAttributeValue(method, getterResult);
                updateValues.put(attributeName, new AttributeValueUpdate().withAction("PUT").withValue(newVersionValue));
                inMemoryUpdates.add(new ValueUpdate(method, newVersionValue));
                continue;
            }
            if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER && (method.equals(hashKeyGetter) || method.equals(rangeKeyGetter))) continue;
            AttributeValue currentValue = this.getSimpleAttributeValue(method, getterResult);
            if (currentValue != null) {
                updateValues.put(attributeName, new AttributeValueUpdate().withValue(currentValue).withAction("PUT"));
                continue;
            }
            if (config.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER) continue;
            updateValues.put(attributeName, new AttributeValueUpdate().withAction("DELETE"));
        }
        if (config.getSaveBehavior() == DynamoDBMapperConfig.SaveBehavior.CLOBBER || forcePut) {
            this.db.putItem(new PutItemRequest().withTableName(tableName).withItem(this.convertToItem(updateValues)).withExpected(expectedValues));
        } else {
            this.db.updateItem(new UpdateItemRequest().withTableName(tableName).withKey(objectKey).withAttributeUpdates(updateValues).withExpected(expectedValues));
        }
        for (ValueUpdate update : inMemoryUpdates) {
            this.setValue(object, update.method, update.newValue);
        }
    }

    public void delete(Object object) {
        this.delete(object, this.config);
    }

    public void delete(Object object, DynamoDBMapperConfig config) {
        if (this.config != config) {
            config = new DynamoDBMapperConfig(this.config, config);
        }
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, config);
        Method hashKeyGetter = reflector.getHashKeyGetter(clazz);
        AttributeValue hashKeyElement = this.getHashKeyElement(this.safeInvoke(hashKeyGetter, object, new Object[0]), hashKeyGetter);
        AttributeValue rangeKeyElement = null;
        Method rangeKeyGetter = reflector.getRangeKeyGetter(clazz);
        if (rangeKeyGetter != null) {
            rangeKeyElement = this.getRangeKeyElement(this.safeInvoke(rangeKeyGetter, object, new Object[0]), rangeKeyGetter);
        }
        Key objectKey = new Key().withHashKeyElement(hashKeyElement).withRangeKeyElement(rangeKeyElement);
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        if (config.getSaveBehavior() != DynamoDBMapperConfig.SaveBehavior.CLOBBER) {
            for (Method method : reflector.getRelevantGetters(clazz)) {
                if (!reflector.isVersionAttributeGetter(method)) continue;
                Object getterResult = this.safeInvoke(method, object, new Object[0]);
                String attributeName = reflector.getAttributeName(method);
                ExpectedAttributeValue expected = new ExpectedAttributeValue();
                AttributeValue currentValue = this.getSimpleAttributeValue(method, getterResult);
                expected.setExists(currentValue != null);
                if (currentValue != null) {
                    expected.setValue(currentValue);
                }
                expectedValues.put(attributeName, expected);
                break;
            }
        }
        this.db.deleteItem(new DeleteItemRequest().withKey(objectKey).withTableName(tableName).withExpected(expectedValues));
    }

    private Object safeInvoke(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
    }

    private Map<String, AttributeValue> convertToItem(Map<String, AttributeValueUpdate> putValues) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, AttributeValueUpdate> entry : putValues.entrySet()) {
            if (entry.getValue().getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue().getValue());
        }
        return map;
    }

    private AttributeValue getVersionAttributeValue(Method getter, Object getterReturnResult) {
        ArgumentMarshaller marshaller = reflector.getVersionedArgumentMarshaller(getter, getterReturnResult);
        return marshaller.marshall(getterReturnResult);
    }

    private AttributeValue getAutoGeneratedKeyAttributeValue(Method getter, Object getterResult) {
        ArgumentMarshaller marshaller = reflector.getAutoGeneratedKeyArgumentMarshaller(getter);
        return marshaller.marshall(getterResult);
    }

    public <T> List<T> scan(Class<T> clazz, DynamoDBScanExpression scanExpression) throws Exception {
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression);
        ScanResult scanResult = this.db.scan(scanRequest);
        int count = scanResult.getCount();
        if (scanResult.getLastEvaluatedKey() != null) {
            count = this.count(clazz, scanExpression);
        }
        return new PaginatedScanList<T>(this, clazz, this.db, count, scanRequest, scanResult);
    }

    public <T> List<T> query(Class<T> clazz, DynamoDBQueryExpression queryExpression) throws Exception {
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression);
        QueryResult queryResult = this.db.query(queryRequest);
        int count = queryResult.getCount();
        if (queryResult.getLastEvaluatedKey() != null) {
            count = this.count(clazz, queryExpression);
        }
        return new PaginatedQueryList<T>(this, clazz, this.db, count, queryRequest, queryResult);
    }

    public int count(Class<?> clazz, DynamoDBScanExpression scanExpression) throws Exception {
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression);
        scanRequest.setCount(true);
        int count = 0;
        ScanResult scanResult = null;
        do {
            scanResult = this.db.scan(scanRequest);
            count += scanResult.getCount().intValue();
            scanRequest.setExclusiveStartKey(scanResult.getLastEvaluatedKey());
        } while (scanResult.getLastEvaluatedKey() != null);
        return count;
    }

    public int count(Class<?> clazz, DynamoDBQueryExpression queryExpression) throws Exception {
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression);
        queryRequest.setCount(true);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.db.query(queryRequest);
            count += queryResult.getCount().intValue();
            queryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    private ScanRequest createScanRequestFromExpression(Class<?> clazz, DynamoDBScanExpression scanExpression) {
        DynamoDBTable table = reflector.getTable(clazz);
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(table.tableName());
        scanRequest.setScanFilter(scanExpression.getScanFilter());
        return scanRequest;
    }

    private QueryRequest createQueryRequestFromExpression(Class<?> clazz, DynamoDBQueryExpression queryExpression) {
        DynamoDBTable table = reflector.getTable(clazz);
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setConsistentRead(queryExpression.isConsistentRead());
        queryRequest.setTableName(table.tableName());
        queryRequest.setHashKeyValue(queryExpression.getHashKeyValue());
        queryRequest.setScanIndexForward(queryExpression.isScanIndexForward());
        queryRequest.setRangeKeyCondition(queryExpression.getRangeKeyCondition());
        return queryRequest;
    }

    private static final class ValueUpdate {
        private Method method;
        private AttributeValue newValue;

        public ValueUpdate(Method method, AttributeValue newValue) {
            this.method = method;
            this.newValue = newValue;
        }
    }
}

