(ns patterning.temp-test-runner
  (:require [patterning.layouts :as layouts]
            [patterning.library.std :refer [poly square]]
            [patterning.color :refer [p-color]]
            [patterning.view :refer [make-svg]]
            [patterning.groups :as groups]
            [clojure.pprint :as pp]))

(defn -main [& args]
  (println "Running temporary test for aspect-ratio-framed with inner-max...")
  (let [tri (poly 3 1.05 0 0.3
                {:fill (p-color 200 0 100)
                 :stroke (p-color 250 50 150)})
        hex (poly 6 0.8 0 0
                {:fill (p-color 100 150 100)
                 :stroke (p-color 200 255 50)
                 :stroke-weight 2})
        
        inner (layouts/stack
               (square {:fill (p-color 0)})
               (layouts/grid 5 (cycle [hex tri])))
        
        final-pattern (layouts/aspect-ratio-framed 4 6 tri hex inner layouts/inner-max)]
    
    (spit "outs/aspect_ratio_test.svg" (make-svg 800 800 final-pattern))
    (pp/pprint final-pattern (clojure.java.io/writer "outs/aspect_ratio_test.edn"))
    (println "Test finished. Output written to outs/aspect_ratio_test.svg and outs/aspect_ratio_test.edn")))
