/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.play.collection;

import cn.leancloud.play.codec.CastTypeException;
import cn.leancloud.play.codec.CastTypeUtils;
import cn.leancloud.play.codec.CodecsManager;
import cn.leancloud.play.collection.PlayObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;

public final class PlayArray
implements List<Object>,
Cloneable,
RandomAccess,
Serializable {
    public static final PlayArray EMPTY_ARRAY = new PlayArray(Collections.emptyList());
    private static final long serialVersionUID = 1L;
    private final List<Object> list;

    public PlayArray() {
        this.list = new ArrayList<Object>();
    }

    public PlayArray(List<Object> list) {
        this.list = list == null ? new ArrayList<Object>() : list;
    }

    public PlayArray(int initialCapacity) {
        this.list = new ArrayList<Object>(initialCapacity);
    }

    public static PlayArray toPlayArray(List<Object> list) {
        if (list == null) {
            return null;
        }
        return new PlayArray(list);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        return this.list.add(o);
    }

    public PlayArray fluentAdd(Object o) {
        this.list.add(o);
        return this;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    public PlayArray fluentRemove(Object o) {
        this.list.remove(o);
        return this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        return this.list.addAll(c);
    }

    public PlayArray fluentAddAll(Collection<?> c) {
        this.list.addAll(c);
        return this;
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        return this.list.addAll(index, c);
    }

    public PlayArray fluentAddAll(int index, Collection<?> c) {
        this.list.addAll(index, c);
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    public PlayArray fluentRemoveAll(Collection<?> c) {
        this.list.removeAll(c);
        return this;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    public PlayArray fluentRetainAll(Collection<?> c) {
        this.list.retainAll(c);
        return this;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public PlayArray fluentClear() {
        this.list.clear();
        return this;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        if (index == -1) {
            this.list.add(element);
            return null;
        }
        if (this.list.size() <= index) {
            for (int i = this.list.size(); i < index; ++i) {
                this.list.add(null);
            }
            this.list.add(element);
            return null;
        }
        return this.list.set(index, element);
    }

    public PlayArray fluentSet(int index, Object element) {
        this.set(index, element);
        return this;
    }

    @Override
    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    public PlayArray fluentAdd(int index, Object element) {
        this.list.add(index, element);
        return this;
    }

    @Override
    public Object remove(int index) {
        return this.list.remove(index);
    }

    public PlayArray fluentRemove(int index) {
        this.list.remove(index);
        return this;
    }

    public Object clone() {
        return new PlayArray(new ArrayList<Object>(this.list));
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public PlayObject getPlayObject(int index) {
        Object value = this.list.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof PlayObject) {
            return (PlayObject)value;
        }
        if (value instanceof Map) {
            PlayObject m = PlayObject.toPlayObject((Map)value);
            this.set(index, m);
            return m;
        }
        if (value instanceof byte[]) {
            PlayObject m = CodecsManager.getInstance().deserialize((byte[])value, PlayObject.class);
            this.set(index, m);
            return m;
        }
        throw new CastTypeException("can not cast to PlayObject, value : '" + value + "'");
    }

    public PlayArray getPlayArray(int index) {
        Object value = this.list.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof PlayArray) {
            return (PlayArray)value;
        }
        if (value instanceof List) {
            PlayArray array = PlayArray.toPlayArray(this.list);
            this.set(index, array);
            return array;
        }
        if (value instanceof byte[]) {
            PlayArray array = CodecsManager.getInstance().deserialize((byte[])value, PlayArray.class);
            this.set(index, array);
            return array;
        }
        throw new CastTypeException("can not cast to PlayArray, value : '" + value + "'");
    }

    public <T> T getObject(int index, Class<T> clazz) {
        Object value = this.list.get(index);
        return CastTypeUtils.cast(value, clazz);
    }

    public Boolean getBoolean(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBoolean(value);
    }

    public boolean getBooleanValue(int index) {
        Object value = this.get(index);
        Boolean boolV = CastTypeUtils.castToBoolean(value);
        if (boolV == null) {
            return false;
        }
        return boolV;
    }

    public Byte getByte(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToByte(value);
    }

    public byte getByteValue(int index) {
        Object value = this.get(index);
        Byte bValue = CastTypeUtils.castToByte(value);
        if (value == null) {
            return 0;
        }
        return bValue;
    }

    public byte[] getBytes(int index) {
        Object value = this.get(index);
        if (value == null) {
            return null;
        }
        return CastTypeUtils.castToBytes(value);
    }

    public Short getShort(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToShort(value);
    }

    public short getShortValue(int index) {
        Object value = this.get(index);
        Short sValue = CastTypeUtils.castToShort(value);
        if (sValue == null) {
            return 0;
        }
        return sValue;
    }

    public Integer getInteger(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToInt(value);
    }

    public int getIntValue(int index) {
        Object value = this.get(index);
        Integer intValue = CastTypeUtils.castToInt(value);
        if (intValue == null) {
            return 0;
        }
        return intValue;
    }

    public Long getLong(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToLong(value);
    }

    public long getLongValue(int index) {
        Object value = this.get(index);
        Long lVal = CastTypeUtils.castToLong(value);
        if (lVal == null) {
            return 0L;
        }
        return lVal;
    }

    public Float getFloat(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToFloat(value);
    }

    public float getFloatValue(int index) {
        Object value = this.get(index);
        Float fVal = CastTypeUtils.castToFloat(value);
        if (fVal == null) {
            return 0.0f;
        }
        return fVal.floatValue();
    }

    public Double getDouble(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToDouble(value);
    }

    public double getDoubleValue(int index) {
        Object value = this.get(index);
        Double dVal = CastTypeUtils.castToDouble(value);
        if (dVal == null) {
            return 0.0;
        }
        return dVal;
    }

    public String getString(int index) {
        Object value = this.get(index);
        return CastTypeUtils.castToString(value);
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>(this.size());
        for (Object item : this) {
            T classItem = CastTypeUtils.cast(item, clazz);
            list.add(classItem);
        }
        return list;
    }

    public List<Object> getInnerList() {
        return this.list;
    }

    public String toString() {
        return "PlayArray{" + this.list + '}';
    }
}

