goog.provide('shadow.cljs.devtools.client.env');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('cljs.tools.reader');
goog.require('cljs.pprint');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.runtime_id !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.runtime_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
}

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.enabled = goog.define("shadow.cljs.devtools.client.env.enabled",false);

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.autoload = goog.define("shadow.cljs.devtools.client.env.autoload",true);

/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.module_format = goog.define("shadow.cljs.devtools.client.env.module_format","goog");

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.reload_with_state = goog.define("shadow.cljs.devtools.client.env.reload_with_state",false);

/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.build_id = goog.define("shadow.cljs.devtools.client.env.build_id","");

/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.proc_id = goog.define("shadow.cljs.devtools.client.env.proc_id","");

/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.server_host = goog.define("shadow.cljs.devtools.client.env.server_host","");

/**
 * @define {number}
 */
shadow.cljs.devtools.client.env.server_port = goog.define("shadow.cljs.devtools.client.env.server_port",(8200));

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.repl_pprint = goog.define("shadow.cljs.devtools.client.env.repl_pprint",false);

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.use_document_host = goog.define("shadow.cljs.devtools.client.env.use_document_host",true);

/**
 * @define {string}
 */
shadow.cljs.devtools.client.env.devtools_url = goog.define("shadow.cljs.devtools.client.env.devtools_url","");

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.ssl = goog.define("shadow.cljs.devtools.client.env.ssl",false);

/**
 * @define {boolean}
 */
shadow.cljs.devtools.client.env.ignore_warnings = goog.define("shadow.cljs.devtools.client.env.ignore_warnings",false);
shadow.cljs.devtools.client.env.devtools_info = (function shadow$cljs$devtools$client$env$devtools_info(){
return ({"server-port": shadow.cljs.devtools.client.env.server_port, "server-host": shadow.cljs.devtools.client.env.server_host, "build-id": shadow.cljs.devtools.client.env.build_id, "proc-id": shadow.cljs.devtools.client.env.proc_id, "runtime-id": shadow.cljs.devtools.client.env.runtime_id});
});
shadow.cljs.devtools.client.env.get_server_host = (function shadow$cljs$devtools$client$env$get_server_host(){
if(cljs.core.truth_((function (){var and__5583__auto__ = shadow.cljs.devtools.client.env.use_document_host;
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = goog.global.document;
if(cljs.core.truth_(and__5583__auto____$1)){
var and__5583__auto____$2 = goog.global.document.location;
if(cljs.core.truth_(and__5583__auto____$2)){
return cljs.core.seq.call(null,goog.global.document.location.hostname);
} else {
return and__5583__auto____$2;
}
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})())){
return document.location.hostname;
} else {
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.server_host)){
return shadow.cljs.devtools.client.env.server_host;
} else {
return "localhost";

}
}
});
shadow.cljs.devtools.client.env.get_url_base = (function shadow$cljs$devtools$client$env$get_url_base(){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.devtools_url)){
return shadow.cljs.devtools.client.env.devtools_url;
} else {
return ["http",(cljs.core.truth_(shadow.cljs.devtools.client.env.ssl)?"s":null),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_server_host.call(null)),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port)].join('');
}
});
shadow.cljs.devtools.client.env.get_ws_url_base = (function shadow$cljs$devtools$client$env$get_ws_url_base(){
return clojure.string.replace.call(null,shadow.cljs.devtools.client.env.get_url_base.call(null),/^http/,"ws");
});
shadow.cljs.devtools.client.env.ws_url = (function shadow$cljs$devtools$client$env$ws_url(runtime_type){
if((runtime_type instanceof cljs.core.Keyword)){
} else {
throw (new Error("Assert failed: (keyword? runtime-type)"));
}

return [shadow.cljs.devtools.client.env.get_ws_url_base.call(null),"/ws/worker/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/",shadow.cljs.devtools.client.env.runtime_id,"/",cljs.core.name.call(null,runtime_type)].join('');
});
shadow.cljs.devtools.client.env.ws_listener_url = (function shadow$cljs$devtools$client$env$ws_listener_url(client_type){
return [shadow.cljs.devtools.client.env.get_ws_url_base.call(null),"/ws/listener/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/",shadow.cljs.devtools.client.env.runtime_id].join('');
});
shadow.cljs.devtools.client.env.files_url = (function shadow$cljs$devtools$client$env$files_url(){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_url_base.call(null)),"/worker/files/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/",shadow.cljs.devtools.client.env.runtime_id].join('');
});
shadow.cljs.devtools.client.env.repl_print_fn = ((cljs.core.not.call(null,shadow.cljs.devtools.client.env.repl_pprint))?cljs.core.pr_str:(function shadow$cljs$devtools$client$env$repl_pprint(obj){
var sb__6761__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__52625_52721 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__52626_52722 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__52627_52723 = true;
var _STAR_print_fn_STAR__temp_val__52628_52724 = (function (x__6762__auto__){
return sb__6761__auto__.append(x__6762__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__52627_52723);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__52628_52724);

try{cljs.pprint.pprint.call(null,obj);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__52626_52722);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__52625_52721);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__6761__auto__);
}));
shadow.cljs.devtools.client.env.repl_error = (function shadow$cljs$devtools$client$env$repl_error(e){
var G__52630 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","invoke-error","repl/invoke-error",839951858),new cljs.core.Keyword(null,"error","error",-978969032),e.message], null);
if(cljs.core.truth_(e.hasOwnProperty("stack"))){
return cljs.core.assoc.call(null,G__52630,new cljs.core.Keyword(null,"stack","stack",-793405930),e.stack);
} else {
return G__52630;
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.repl_results_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.repl_results_ref = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
shadow.cljs.devtools.client.env.repl_call = (function shadow$cljs$devtools$client$env$repl_call(repl_expr,repl_error){
try{var result_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var result = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","result","repl/result",1421065572),new cljs.core.Keyword(null,"result-id","result-id",-2004530966),result_id], null);
var ret = repl_expr.call(null);
cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.repl_results_ref,cljs.core.assoc,result_id,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timestamp","timestamp",579478971),Date.now(),new cljs.core.Keyword(null,"result","result",1415092211),ret], null));

(cljs.core._STAR_3 = cljs.core._STAR_2);

(cljs.core._STAR_2 = cljs.core._STAR_1);

(cljs.core._STAR_1 = ret);

try{var printed = shadow.cljs.devtools.client.env.repl_print_fn.call(null,ret);
cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.repl_results_ref,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result_id,new cljs.core.Keyword(null,"printed","printed",1871492381)], null),printed);

return cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"value","value",305978217),printed);
}catch (e52632){var e = e52632;
console.log("encoding of result failed",e,ret);

return cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"error","error",-978969032),"ENCODING FAILED");
}}catch (e52631){var e = e52631;
(cljs.core._STAR_e = e);

return repl_error.call(null,e);
}});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.reset_print_fn_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.reset_print_fn_ref = cljs.core.atom.call(null,null);
}
shadow.cljs.devtools.client.env.set_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$set_print_fns_BANG_(msg_fn){
var original_print_fn = cljs.core._STAR_print_fn_STAR_;
var original_print_err_fn = cljs.core._STAR_print_err_fn_STAR_;
cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,(function shadow$cljs$devtools$client$env$set_print_fns_BANG__$_reset_print_fns_BANG_(){
cljs.core.set_print_fn_BANG_.call(null,original_print_fn);

return cljs.core.set_print_err_fn_BANG_.call(null,original_print_err_fn);
}));

cljs.core.set_print_fn_BANG_.call(null,(function() { 
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate = function (args){
msg_fn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","out","repl/out",-905715102),new cljs.core.Keyword(null,"text","text",-1790561697),clojure.string.join.call(null,"",args)], null));

if(cljs.core.truth_(original_print_fn)){
return cljs.core.apply.call(null,original_print_fn,args);
} else {
return null;
}
};
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__52740__i = 0, G__52740__a = new Array(arguments.length -  0);
while (G__52740__i < G__52740__a.length) {G__52740__a[G__52740__i] = arguments[G__52740__i + 0]; ++G__52740__i;}
  args = new cljs.core.IndexedSeq(G__52740__a,0,null);
} 
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate.call(this,args);};
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$lang$maxFixedArity = 0;
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$lang$applyTo = (function (arglist__52748){
var args = cljs.core.seq(arglist__52748);
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate(args);
});
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate;
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn;
})()
);

return cljs.core.set_print_err_fn_BANG_.call(null,(function() { 
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate = function (args){
msg_fn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","err","repl/err",-2086562244),new cljs.core.Keyword(null,"text","text",-1790561697),clojure.string.join.call(null,"",args)], null));

if(cljs.core.truth_(original_print_err_fn)){
return cljs.core.apply.call(null,original_print_err_fn,args);
} else {
return null;
}
};
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__52754__i = 0, G__52754__a = new Array(arguments.length -  0);
while (G__52754__i < G__52754__a.length) {G__52754__a[G__52754__i] = arguments[G__52754__i + 0]; ++G__52754__i;}
  args = new cljs.core.IndexedSeq(G__52754__a,0,null);
} 
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate.call(this,args);};
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$lang$maxFixedArity = 0;
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$lang$applyTo = (function (arglist__52755){
var args = cljs.core.seq(arglist__52755);
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate(args);
});
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$core$IFn$_invoke$arity$variadic = shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate;
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn;
})()
);
});
shadow.cljs.devtools.client.env.reset_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$reset_print_fns_BANG_(){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var x = temp__5720__auto__;
x.call(null);

return cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,null);
} else {
return null;
}
});
shadow.cljs.devtools.client.env.process_ws_msg = (function shadow$cljs$devtools$client$env$process_ws_msg(text,handler){
var _STAR_default_data_reader_fn_STAR__orig_val__52637 = cljs.tools.reader._STAR_default_data_reader_fn_STAR_;
var _STAR_default_data_reader_fn_STAR__temp_val__52638 = (function (tag,value){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tagged-literal","tagged-literal",1758013066),tag,value], null);
});
(cljs.tools.reader._STAR_default_data_reader_fn_STAR_ = _STAR_default_data_reader_fn_STAR__temp_val__52638);

try{try{var msg = cljs.tools.reader.read_string.call(null,text);
return handler.call(null,msg);
}catch (e52642){var e = e52642;
console.warn("failed to parse websocket message",text,e);

throw e;
}}finally {(cljs.tools.reader._STAR_default_data_reader_fn_STAR_ = _STAR_default_data_reader_fn_STAR__orig_val__52637);
}});
shadow.cljs.devtools.client.env.make_task_fn = (function shadow$cljs$devtools$client$env$make_task_fn(p__52643,p__52644){
var map__52645 = p__52643;
var map__52645__$1 = (((((!((map__52645 == null))))?(((((map__52645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52645.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52645):map__52645);
var log_missing_fn = cljs.core.get.call(null,map__52645__$1,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765));
var log_call_async = cljs.core.get.call(null,map__52645__$1,new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192));
var log_call = cljs.core.get.call(null,map__52645__$1,new cljs.core.Keyword(null,"log-call","log-call",412404391));
var map__52646 = p__52644;
var map__52646__$1 = (((((!((map__52646 == null))))?(((((map__52646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52646):map__52646);
var fn_sym = cljs.core.get.call(null,map__52646__$1,new cljs.core.Keyword(null,"fn-sym","fn-sym",1423988510));
var fn_str = cljs.core.get.call(null,map__52646__$1,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402));
var async = cljs.core.get.call(null,map__52646__$1,new cljs.core.Keyword(null,"async","async",1050769601));
return (function (next){
try{var fn_obj = goog.getObjectByName(fn_str,$CLJS);
if((fn_obj == null)){
if(cljs.core.truth_(log_missing_fn)){
log_missing_fn.call(null,fn_sym);
} else {
}

return next.call(null);
} else {
if(cljs.core.truth_(async)){
if(cljs.core.truth_(log_call_async)){
log_call_async.call(null,fn_sym);
} else {
}

return fn_obj.call(null,next);
} else {
if(cljs.core.truth_(log_call)){
log_call.call(null,fn_sym);
} else {
}

fn_obj.call(null);

return next.call(null);

}
}
}catch (e52657){var ex = e52657;
console.warn("error when calling lifecycle function",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym),ex);

return next.call(null);
}});
});
shadow.cljs.devtools.client.env.do_js_reload_STAR_ = (function shadow$cljs$devtools$client$env$do_js_reload_STAR_(failure_fn,p__52660){
var vec__52661 = p__52660;
var seq__52662 = cljs.core.seq.call(null,vec__52661);
var first__52663 = cljs.core.first.call(null,seq__52662);
var seq__52662__$1 = cljs.core.next.call(null,seq__52662);
var task = first__52663;
var remaining_tasks = seq__52662__$1;
if(cljs.core.truth_(task)){
try{return task.call(null,(function (){
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,remaining_tasks);
}));
}catch (e52665){var e = e52665;
return failure_fn.call(null,e,task,remaining_tasks);
}} else {
return null;
}
});
/**
 * should pass the :build-complete message and an additional callback
 * which performs the actual loading of the code (sync)
 * will call all before/after callbacks in order
 */
shadow.cljs.devtools.client.env.do_js_reload = (function shadow$cljs$devtools$client$env$do_js_reload(var_args){
var G__52670 = arguments.length;
switch (G__52670) {
case 2:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2 = (function (msg,load_code_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,(function (){
return null;
}));
}));

(shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3 = (function (msg,load_code_fn,complete_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,complete_fn,(function (error,task,remaining){
return console.warn("JS reload failed",error);
}));
}));

(shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4 = (function (p__52675,load_code_fn,complete_fn,failure_fn){
var map__52676 = p__52675;
var map__52676__$1 = (((((!((map__52676 == null))))?(((((map__52676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52676):map__52676);
var msg = map__52676__$1;
var reload_info = cljs.core.get.call(null,map__52676__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var load_tasks = cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.reverse.call(null,cljs.core.map.call(null,(function (p1__52667_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__52667_SHARP_);
}),new cljs.core.Keyword(null,"before-load","before-load",-2060117064).cljs$core$IFn$_invoke$arity$1(reload_info)))),(function (next){
load_code_fn.call(null);

return next.call(null);
})),cljs.core.map.call(null,(function (p1__52668_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__52668_SHARP_);
})),new cljs.core.Keyword(null,"after-load","after-load",-1278503285).cljs$core$IFn$_invoke$arity$1(reload_info)),(function (next){
complete_fn.call(null);

return next.call(null);
}));
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,load_tasks);
}));

(shadow.cljs.devtools.client.env.do_js_reload.cljs$lang$maxFixedArity = 4);

shadow.cljs.devtools.client.env.before_load_src = (function shadow$cljs$devtools$client$env$before_load_src(p__52679){
var map__52680 = p__52679;
var map__52680__$1 = (((((!((map__52680 == null))))?(((((map__52680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52680):map__52680);
var src = map__52680__$1;
var type = cljs.core.get.call(null,map__52680__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var ns = cljs.core.get.call(null,map__52680__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"cljs","cljs",1492417629),type)){
var seq__52682 = cljs.core.seq.call(null,goog.global.SHADOW_NS_RESET);
var chunk__52683 = null;
var count__52684 = (0);
var i__52685 = (0);
while(true){
if((i__52685 < count__52684)){
var x = cljs.core._nth.call(null,chunk__52683,i__52685);
x.call(null,ns);


var G__52787 = seq__52682;
var G__52788 = chunk__52683;
var G__52789 = count__52684;
var G__52790 = (i__52685 + (1));
seq__52682 = G__52787;
chunk__52683 = G__52788;
count__52684 = G__52789;
i__52685 = G__52790;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__52682);
if(temp__5720__auto__){
var seq__52682__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52682__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__52682__$1);
var G__52791 = cljs.core.chunk_rest.call(null,seq__52682__$1);
var G__52792 = c__6568__auto__;
var G__52793 = cljs.core.count.call(null,c__6568__auto__);
var G__52794 = (0);
seq__52682 = G__52791;
chunk__52683 = G__52792;
count__52684 = G__52793;
i__52685 = G__52794;
continue;
} else {
var x = cljs.core.first.call(null,seq__52682__$1);
x.call(null,ns);


var G__52798 = cljs.core.next.call(null,seq__52682__$1);
var G__52799 = null;
var G__52800 = (0);
var G__52801 = (0);
seq__52682 = G__52798;
chunk__52683 = G__52799;
count__52684 = G__52800;
i__52685 = G__52801;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.custom_msg_subscribers_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.custom_msg_subscribers_ref = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
shadow.cljs.devtools.client.env.subscribe_BANG_ = (function shadow$cljs$devtools$client$env$subscribe_BANG_(sub_id,callback){
return cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.custom_msg_subscribers_ref,cljs.core.assoc,sub_id,callback);
});
shadow.cljs.devtools.client.env.publish_BANG_ = (function shadow$cljs$devtools$client$env$publish_BANG_(msg){
var seq__52688 = cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.env.custom_msg_subscribers_ref));
var chunk__52689 = null;
var count__52690 = (0);
var i__52691 = (0);
while(true){
if((i__52691 < count__52690)){
var vec__52703 = cljs.core._nth.call(null,chunk__52689,i__52691);
var id = cljs.core.nth.call(null,vec__52703,(0),null);
var callback = cljs.core.nth.call(null,vec__52703,(1),null);
try{callback.call(null,msg);
}catch (e52706){var e_52808 = e52706;
console.warn("failed to handle custom msg",id,msg);
}

var G__52809 = seq__52688;
var G__52810 = chunk__52689;
var G__52811 = count__52690;
var G__52812 = (i__52691 + (1));
seq__52688 = G__52809;
chunk__52689 = G__52810;
count__52690 = G__52811;
i__52691 = G__52812;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__52688);
if(temp__5720__auto__){
var seq__52688__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52688__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__52688__$1);
var G__52813 = cljs.core.chunk_rest.call(null,seq__52688__$1);
var G__52814 = c__6568__auto__;
var G__52815 = cljs.core.count.call(null,c__6568__auto__);
var G__52816 = (0);
seq__52688 = G__52813;
chunk__52689 = G__52814;
count__52690 = G__52815;
i__52691 = G__52816;
continue;
} else {
var vec__52707 = cljs.core.first.call(null,seq__52688__$1);
var id = cljs.core.nth.call(null,vec__52707,(0),null);
var callback = cljs.core.nth.call(null,vec__52707,(1),null);
try{callback.call(null,msg);
}catch (e52710){var e_52817 = e52710;
console.warn("failed to handle custom msg",id,msg);
}

var G__52818 = cljs.core.next.call(null,seq__52688__$1);
var G__52819 = null;
var G__52820 = (0);
var G__52821 = (0);
seq__52688 = G__52818;
chunk__52689 = G__52819;
count__52690 = G__52820;
i__52691 = G__52821;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=shadow.cljs.devtools.client.env.js.map
