goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__54440 = arguments.length;
switch (G__54440) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54442 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54442 = (function (f,blockable,meta54443){
this.f = f;
this.blockable = blockable;
this.meta54443 = meta54443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54444,meta54443__$1){
var self__ = this;
var _54444__$1 = this;
return (new cljs.core.async.t_cljs$core$async54442(self__.f,self__.blockable,meta54443__$1));
}));

(cljs.core.async.t_cljs$core$async54442.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54444){
var self__ = this;
var _54444__$1 = this;
return self__.meta54443;
}));

(cljs.core.async.t_cljs$core$async54442.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54442.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async54442.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async54442.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async54442.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta54443","meta54443",-340766161,null)], null);
}));

(cljs.core.async.t_cljs$core$async54442.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54442.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54442");

(cljs.core.async.t_cljs$core$async54442.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async54442");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54442.
 */
cljs.core.async.__GT_t_cljs$core$async54442 = (function cljs$core$async$__GT_t_cljs$core$async54442(f__$1,blockable__$1,meta54443){
return (new cljs.core.async.t_cljs$core$async54442(f__$1,blockable__$1,meta54443));
});

}

return (new cljs.core.async.t_cljs$core$async54442(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__54447 = arguments.length;
switch (G__54447) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__54449 = arguments.length;
switch (G__54449) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__54451 = arguments.length;
switch (G__54451) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_55907 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_55907);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_55907);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__54455 = arguments.length;
switch (G__54455) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__6679__auto___55923 = n;
var x_55924 = (0);
while(true){
if((x_55924 < n__6679__auto___55923)){
(a[x_55924] = x_55924);

var G__55925 = (x_55924 + (1));
x_55924 = G__55925;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54456 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54456 = (function (flag,meta54457){
this.flag = flag;
this.meta54457 = meta54457;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54456.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54458,meta54457__$1){
var self__ = this;
var _54458__$1 = this;
return (new cljs.core.async.t_cljs$core$async54456(self__.flag,meta54457__$1));
}));

(cljs.core.async.t_cljs$core$async54456.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54458){
var self__ = this;
var _54458__$1 = this;
return self__.meta54457;
}));

(cljs.core.async.t_cljs$core$async54456.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54456.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async54456.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async54456.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async54456.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta54457","meta54457",-471027651,null)], null);
}));

(cljs.core.async.t_cljs$core$async54456.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54456.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54456");

(cljs.core.async.t_cljs$core$async54456.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async54456");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54456.
 */
cljs.core.async.__GT_t_cljs$core$async54456 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async54456(flag__$1,meta54457){
return (new cljs.core.async.t_cljs$core$async54456(flag__$1,meta54457));
});

}

return (new cljs.core.async.t_cljs$core$async54456(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54459 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54459 = (function (flag,cb,meta54460){
this.flag = flag;
this.cb = cb;
this.meta54460 = meta54460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54461,meta54460__$1){
var self__ = this;
var _54461__$1 = this;
return (new cljs.core.async.t_cljs$core$async54459(self__.flag,self__.cb,meta54460__$1));
}));

(cljs.core.async.t_cljs$core$async54459.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54461){
var self__ = this;
var _54461__$1 = this;
return self__.meta54460;
}));

(cljs.core.async.t_cljs$core$async54459.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54459.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async54459.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async54459.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async54459.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta54460","meta54460",738698259,null)], null);
}));

(cljs.core.async.t_cljs$core$async54459.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54459.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54459");

(cljs.core.async.t_cljs$core$async54459.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async54459");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54459.
 */
cljs.core.async.__GT_t_cljs$core$async54459 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async54459(flag__$1,cb__$1,meta54460){
return (new cljs.core.async.t_cljs$core$async54459(flag__$1,cb__$1,meta54460));
});

}

return (new cljs.core.async.t_cljs$core$async54459(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54462_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54462_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__54463_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__54463_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__5598__auto__ = wport;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return port;
}
})()], null));
} else {
var G__55954 = (i + (1));
i = G__55954;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5598__auto__ = ret;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__5583__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__5583__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___55969 = arguments.length;
var i__6921__auto___55971 = (0);
while(true){
if((i__6921__auto___55971 < len__6920__auto___55969)){
args__6930__auto__.push((arguments[i__6921__auto___55971]));

var G__55972 = (i__6921__auto___55971 + (1));
i__6921__auto___55971 = G__55972;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__54466){
var map__54467 = p__54466;
var map__54467__$1 = (((((!((map__54467 == null))))?(((((map__54467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54467):map__54467);
var opts = map__54467__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq54464){
var G__54465 = cljs.core.first.call(null,seq54464);
var seq54464__$1 = cljs.core.next.call(null,seq54464);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54465,seq54464__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__54470 = arguments.length;
switch (G__54470) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__54378__auto___55974 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54494){
var state_val_54495 = (state_54494[(1)]);
if((state_val_54495 === (7))){
var inst_54490 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54496_55975 = state_54494__$1;
(statearr_54496_55975[(2)] = inst_54490);

(statearr_54496_55975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (1))){
var state_54494__$1 = state_54494;
var statearr_54497_55976 = state_54494__$1;
(statearr_54497_55976[(2)] = null);

(statearr_54497_55976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (4))){
var inst_54473 = (state_54494[(7)]);
var inst_54473__$1 = (state_54494[(2)]);
var inst_54474 = (inst_54473__$1 == null);
var state_54494__$1 = (function (){var statearr_54498 = state_54494;
(statearr_54498[(7)] = inst_54473__$1);

return statearr_54498;
})();
if(cljs.core.truth_(inst_54474)){
var statearr_54499_55981 = state_54494__$1;
(statearr_54499_55981[(1)] = (5));

} else {
var statearr_54500_55999 = state_54494__$1;
(statearr_54500_55999[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (13))){
var state_54494__$1 = state_54494;
var statearr_54501_56001 = state_54494__$1;
(statearr_54501_56001[(2)] = null);

(statearr_54501_56001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (6))){
var inst_54473 = (state_54494[(7)]);
var state_54494__$1 = state_54494;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54494__$1,(11),to,inst_54473);
} else {
if((state_val_54495 === (3))){
var inst_54492 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54494__$1,inst_54492);
} else {
if((state_val_54495 === (12))){
var state_54494__$1 = state_54494;
var statearr_54502_56003 = state_54494__$1;
(statearr_54502_56003[(2)] = null);

(statearr_54502_56003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (2))){
var state_54494__$1 = state_54494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54494__$1,(4),from);
} else {
if((state_val_54495 === (11))){
var inst_54483 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
if(cljs.core.truth_(inst_54483)){
var statearr_54503_56004 = state_54494__$1;
(statearr_54503_56004[(1)] = (12));

} else {
var statearr_54504_56005 = state_54494__$1;
(statearr_54504_56005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (9))){
var state_54494__$1 = state_54494;
var statearr_54505_56006 = state_54494__$1;
(statearr_54505_56006[(2)] = null);

(statearr_54505_56006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (5))){
var state_54494__$1 = state_54494;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54506_56007 = state_54494__$1;
(statearr_54506_56007[(1)] = (8));

} else {
var statearr_54507_56008 = state_54494__$1;
(statearr_54507_56008[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (14))){
var inst_54488 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54508_56009 = state_54494__$1;
(statearr_54508_56009[(2)] = inst_54488);

(statearr_54508_56009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (10))){
var inst_54480 = (state_54494[(2)]);
var state_54494__$1 = state_54494;
var statearr_54509_56010 = state_54494__$1;
(statearr_54509_56010[(2)] = inst_54480);

(statearr_54509_56010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54495 === (8))){
var inst_54477 = cljs.core.async.close_BANG_.call(null,to);
var state_54494__$1 = state_54494;
var statearr_54510_56013 = state_54494__$1;
(statearr_54510_56013[(2)] = inst_54477);

(statearr_54510_56013[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_54511 = [null,null,null,null,null,null,null,null];
(statearr_54511[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_54511[(1)] = (1));

return statearr_54511;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_54494){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54512){if((e54512 instanceof Object)){
var ex__54298__auto__ = e54512;
var statearr_54513_56014 = state_54494;
(statearr_54513_56014[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54512;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56017 = state_54494;
state_54494 = G__56017;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_54494){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_54494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54514 = f__54379__auto__.call(null);
(statearr_54514[(6)] = c__54378__auto___55974);

return statearr_54514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__54515){
var vec__54516 = p__54515;
var v = cljs.core.nth.call(null,vec__54516,(0),null);
var p = cljs.core.nth.call(null,vec__54516,(1),null);
var job = vec__54516;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__54378__auto___56018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54523){
var state_val_54524 = (state_54523[(1)]);
if((state_val_54524 === (1))){
var state_54523__$1 = state_54523;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54523__$1,(2),res,v);
} else {
if((state_val_54524 === (2))){
var inst_54520 = (state_54523[(2)]);
var inst_54521 = cljs.core.async.close_BANG_.call(null,res);
var state_54523__$1 = (function (){var statearr_54525 = state_54523;
(statearr_54525[(7)] = inst_54520);

return statearr_54525;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54523__$1,inst_54521);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0 = (function (){
var statearr_54526 = [null,null,null,null,null,null,null,null];
(statearr_54526[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__);

(statearr_54526[(1)] = (1));

return statearr_54526;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1 = (function (state_54523){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54527){if((e54527 instanceof Object)){
var ex__54298__auto__ = e54527;
var statearr_54528_56019 = state_54523;
(statearr_54528_56019[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56020 = state_54523;
state_54523 = G__56020;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = function(state_54523){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1.call(this,state_54523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54529 = f__54379__auto__.call(null);
(statearr_54529[(6)] = c__54378__auto___56018);

return statearr_54529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__54530){
var vec__54531 = p__54530;
var v = cljs.core.nth.call(null,vec__54531,(0),null);
var p = cljs.core.nth.call(null,vec__54531,(1),null);
var job = vec__54531;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__6679__auto___56022 = n;
var __56023 = (0);
while(true){
if((__56023 < n__6679__auto___56022)){
var G__54534_56024 = type;
var G__54534_56025__$1 = (((G__54534_56024 instanceof cljs.core.Keyword))?G__54534_56024.fqn:null);
switch (G__54534_56025__$1) {
case "compute":
var c__54378__auto___56027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__56023,c__54378__auto___56027,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async){
return (function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = ((function (__56023,c__54378__auto___56027,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async){
return (function (state_54547){
var state_val_54548 = (state_54547[(1)]);
if((state_val_54548 === (1))){
var state_54547__$1 = state_54547;
var statearr_54549_56028 = state_54547__$1;
(statearr_54549_56028[(2)] = null);

(statearr_54549_56028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54548 === (2))){
var state_54547__$1 = state_54547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54547__$1,(4),jobs);
} else {
if((state_val_54548 === (3))){
var inst_54545 = (state_54547[(2)]);
var state_54547__$1 = state_54547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54547__$1,inst_54545);
} else {
if((state_val_54548 === (4))){
var inst_54537 = (state_54547[(2)]);
var inst_54538 = process.call(null,inst_54537);
var state_54547__$1 = state_54547;
if(cljs.core.truth_(inst_54538)){
var statearr_54550_56033 = state_54547__$1;
(statearr_54550_56033[(1)] = (5));

} else {
var statearr_54551_56034 = state_54547__$1;
(statearr_54551_56034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54548 === (5))){
var state_54547__$1 = state_54547;
var statearr_54552_56035 = state_54547__$1;
(statearr_54552_56035[(2)] = null);

(statearr_54552_56035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54548 === (6))){
var state_54547__$1 = state_54547;
var statearr_54553_56036 = state_54547__$1;
(statearr_54553_56036[(2)] = null);

(statearr_54553_56036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54548 === (7))){
var inst_54543 = (state_54547[(2)]);
var state_54547__$1 = state_54547;
var statearr_54554_56037 = state_54547__$1;
(statearr_54554_56037[(2)] = inst_54543);

(statearr_54554_56037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__56023,c__54378__auto___56027,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async))
;
return ((function (__56023,switch__54294__auto__,c__54378__auto___56027,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0 = (function (){
var statearr_54555 = [null,null,null,null,null,null,null];
(statearr_54555[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__);

(statearr_54555[(1)] = (1));

return statearr_54555;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1 = (function (state_54547){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54556){if((e54556 instanceof Object)){
var ex__54298__auto__ = e54556;
var statearr_54557_56038 = state_54547;
(statearr_54557_56038[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54547);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54556;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56040 = state_54547;
state_54547 = G__56040;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = function(state_54547){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1.call(this,state_54547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__;
})()
;})(__56023,switch__54294__auto__,c__54378__auto___56027,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async))
})();
var state__54380__auto__ = (function (){var statearr_54558 = f__54379__auto__.call(null);
(statearr_54558[(6)] = c__54378__auto___56027);

return statearr_54558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
});})(__56023,c__54378__auto___56027,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async))
);


break;
case "async":
var c__54378__auto___56042 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__56023,c__54378__auto___56042,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async){
return (function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = ((function (__56023,c__54378__auto___56042,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async){
return (function (state_54571){
var state_val_54572 = (state_54571[(1)]);
if((state_val_54572 === (1))){
var state_54571__$1 = state_54571;
var statearr_54573_56043 = state_54571__$1;
(statearr_54573_56043[(2)] = null);

(statearr_54573_56043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (2))){
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54571__$1,(4),jobs);
} else {
if((state_val_54572 === (3))){
var inst_54569 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54571__$1,inst_54569);
} else {
if((state_val_54572 === (4))){
var inst_54561 = (state_54571[(2)]);
var inst_54562 = async.call(null,inst_54561);
var state_54571__$1 = state_54571;
if(cljs.core.truth_(inst_54562)){
var statearr_54574_56044 = state_54571__$1;
(statearr_54574_56044[(1)] = (5));

} else {
var statearr_54575_56045 = state_54571__$1;
(statearr_54575_56045[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (5))){
var state_54571__$1 = state_54571;
var statearr_54576_56050 = state_54571__$1;
(statearr_54576_56050[(2)] = null);

(statearr_54576_56050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (6))){
var state_54571__$1 = state_54571;
var statearr_54577_56054 = state_54571__$1;
(statearr_54577_56054[(2)] = null);

(statearr_54577_56054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54572 === (7))){
var inst_54567 = (state_54571[(2)]);
var state_54571__$1 = state_54571;
var statearr_54578_56055 = state_54571__$1;
(statearr_54578_56055[(2)] = inst_54567);

(statearr_54578_56055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__56023,c__54378__auto___56042,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async))
;
return ((function (__56023,switch__54294__auto__,c__54378__auto___56042,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0 = (function (){
var statearr_54579 = [null,null,null,null,null,null,null];
(statearr_54579[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__);

(statearr_54579[(1)] = (1));

return statearr_54579;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1 = (function (state_54571){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54580){if((e54580 instanceof Object)){
var ex__54298__auto__ = e54580;
var statearr_54581_56062 = state_54571;
(statearr_54581_56062[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54580;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56063 = state_54571;
state_54571 = G__56063;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = function(state_54571){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1.call(this,state_54571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__;
})()
;})(__56023,switch__54294__auto__,c__54378__auto___56042,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async))
})();
var state__54380__auto__ = (function (){var statearr_54582 = f__54379__auto__.call(null);
(statearr_54582[(6)] = c__54378__auto___56042);

return statearr_54582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
});})(__56023,c__54378__auto___56042,G__54534_56024,G__54534_56025__$1,n__6679__auto___56022,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54534_56025__$1)].join('')));

}

var G__56067 = (__56023 + (1));
__56023 = G__56067;
continue;
} else {
}
break;
}

var c__54378__auto___56068 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54604){
var state_val_54605 = (state_54604[(1)]);
if((state_val_54605 === (7))){
var inst_54600 = (state_54604[(2)]);
var state_54604__$1 = state_54604;
var statearr_54606_56073 = state_54604__$1;
(statearr_54606_56073[(2)] = inst_54600);

(statearr_54606_56073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54605 === (1))){
var state_54604__$1 = state_54604;
var statearr_54607_56077 = state_54604__$1;
(statearr_54607_56077[(2)] = null);

(statearr_54607_56077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54605 === (4))){
var inst_54585 = (state_54604[(7)]);
var inst_54585__$1 = (state_54604[(2)]);
var inst_54586 = (inst_54585__$1 == null);
var state_54604__$1 = (function (){var statearr_54608 = state_54604;
(statearr_54608[(7)] = inst_54585__$1);

return statearr_54608;
})();
if(cljs.core.truth_(inst_54586)){
var statearr_54609_56081 = state_54604__$1;
(statearr_54609_56081[(1)] = (5));

} else {
var statearr_54610_56082 = state_54604__$1;
(statearr_54610_56082[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54605 === (6))){
var inst_54585 = (state_54604[(7)]);
var inst_54590 = (state_54604[(8)]);
var inst_54590__$1 = cljs.core.async.chan.call(null,(1));
var inst_54591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54592 = [inst_54585,inst_54590__$1];
var inst_54593 = (new cljs.core.PersistentVector(null,2,(5),inst_54591,inst_54592,null));
var state_54604__$1 = (function (){var statearr_54611 = state_54604;
(statearr_54611[(8)] = inst_54590__$1);

return statearr_54611;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54604__$1,(8),jobs,inst_54593);
} else {
if((state_val_54605 === (3))){
var inst_54602 = (state_54604[(2)]);
var state_54604__$1 = state_54604;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54604__$1,inst_54602);
} else {
if((state_val_54605 === (2))){
var state_54604__$1 = state_54604;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54604__$1,(4),from);
} else {
if((state_val_54605 === (9))){
var inst_54597 = (state_54604[(2)]);
var state_54604__$1 = (function (){var statearr_54612 = state_54604;
(statearr_54612[(9)] = inst_54597);

return statearr_54612;
})();
var statearr_54613_56089 = state_54604__$1;
(statearr_54613_56089[(2)] = null);

(statearr_54613_56089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54605 === (5))){
var inst_54588 = cljs.core.async.close_BANG_.call(null,jobs);
var state_54604__$1 = state_54604;
var statearr_54614_56090 = state_54604__$1;
(statearr_54614_56090[(2)] = inst_54588);

(statearr_54614_56090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54605 === (8))){
var inst_54590 = (state_54604[(8)]);
var inst_54595 = (state_54604[(2)]);
var state_54604__$1 = (function (){var statearr_54615 = state_54604;
(statearr_54615[(10)] = inst_54595);

return statearr_54615;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54604__$1,(9),results,inst_54590);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0 = (function (){
var statearr_54616 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54616[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__);

(statearr_54616[(1)] = (1));

return statearr_54616;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1 = (function (state_54604){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54604);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54617){if((e54617 instanceof Object)){
var ex__54298__auto__ = e54617;
var statearr_54618_56092 = state_54604;
(statearr_54618_56092[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54604);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54617;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56093 = state_54604;
state_54604 = G__56093;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = function(state_54604){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1.call(this,state_54604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54619 = f__54379__auto__.call(null);
(statearr_54619[(6)] = c__54378__auto___56068);

return statearr_54619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


var c__54378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54657){
var state_val_54658 = (state_54657[(1)]);
if((state_val_54658 === (7))){
var inst_54653 = (state_54657[(2)]);
var state_54657__$1 = state_54657;
var statearr_54659_56094 = state_54657__$1;
(statearr_54659_56094[(2)] = inst_54653);

(statearr_54659_56094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (20))){
var state_54657__$1 = state_54657;
var statearr_54660_56095 = state_54657__$1;
(statearr_54660_56095[(2)] = null);

(statearr_54660_56095[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (1))){
var state_54657__$1 = state_54657;
var statearr_54661_56096 = state_54657__$1;
(statearr_54661_56096[(2)] = null);

(statearr_54661_56096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (4))){
var inst_54622 = (state_54657[(7)]);
var inst_54622__$1 = (state_54657[(2)]);
var inst_54623 = (inst_54622__$1 == null);
var state_54657__$1 = (function (){var statearr_54662 = state_54657;
(statearr_54662[(7)] = inst_54622__$1);

return statearr_54662;
})();
if(cljs.core.truth_(inst_54623)){
var statearr_54663_56097 = state_54657__$1;
(statearr_54663_56097[(1)] = (5));

} else {
var statearr_54664_56098 = state_54657__$1;
(statearr_54664_56098[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (15))){
var inst_54635 = (state_54657[(8)]);
var state_54657__$1 = state_54657;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54657__$1,(18),to,inst_54635);
} else {
if((state_val_54658 === (21))){
var inst_54648 = (state_54657[(2)]);
var state_54657__$1 = state_54657;
var statearr_54665_56099 = state_54657__$1;
(statearr_54665_56099[(2)] = inst_54648);

(statearr_54665_56099[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (13))){
var inst_54650 = (state_54657[(2)]);
var state_54657__$1 = (function (){var statearr_54666 = state_54657;
(statearr_54666[(9)] = inst_54650);

return statearr_54666;
})();
var statearr_54667_56100 = state_54657__$1;
(statearr_54667_56100[(2)] = null);

(statearr_54667_56100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (6))){
var inst_54622 = (state_54657[(7)]);
var state_54657__$1 = state_54657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54657__$1,(11),inst_54622);
} else {
if((state_val_54658 === (17))){
var inst_54643 = (state_54657[(2)]);
var state_54657__$1 = state_54657;
if(cljs.core.truth_(inst_54643)){
var statearr_54668_56101 = state_54657__$1;
(statearr_54668_56101[(1)] = (19));

} else {
var statearr_54669_56102 = state_54657__$1;
(statearr_54669_56102[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (3))){
var inst_54655 = (state_54657[(2)]);
var state_54657__$1 = state_54657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54657__$1,inst_54655);
} else {
if((state_val_54658 === (12))){
var inst_54632 = (state_54657[(10)]);
var state_54657__$1 = state_54657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54657__$1,(14),inst_54632);
} else {
if((state_val_54658 === (2))){
var state_54657__$1 = state_54657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54657__$1,(4),results);
} else {
if((state_val_54658 === (19))){
var state_54657__$1 = state_54657;
var statearr_54670_56106 = state_54657__$1;
(statearr_54670_56106[(2)] = null);

(statearr_54670_56106[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (11))){
var inst_54632 = (state_54657[(2)]);
var state_54657__$1 = (function (){var statearr_54671 = state_54657;
(statearr_54671[(10)] = inst_54632);

return statearr_54671;
})();
var statearr_54672_56107 = state_54657__$1;
(statearr_54672_56107[(2)] = null);

(statearr_54672_56107[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (9))){
var state_54657__$1 = state_54657;
var statearr_54673_56108 = state_54657__$1;
(statearr_54673_56108[(2)] = null);

(statearr_54673_56108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (5))){
var state_54657__$1 = state_54657;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54674_56112 = state_54657__$1;
(statearr_54674_56112[(1)] = (8));

} else {
var statearr_54675_56113 = state_54657__$1;
(statearr_54675_56113[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (14))){
var inst_54635 = (state_54657[(8)]);
var inst_54635__$1 = (state_54657[(2)]);
var inst_54636 = (inst_54635__$1 == null);
var inst_54637 = cljs.core.not.call(null,inst_54636);
var state_54657__$1 = (function (){var statearr_54676 = state_54657;
(statearr_54676[(8)] = inst_54635__$1);

return statearr_54676;
})();
if(inst_54637){
var statearr_54677_56115 = state_54657__$1;
(statearr_54677_56115[(1)] = (15));

} else {
var statearr_54678_56117 = state_54657__$1;
(statearr_54678_56117[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (16))){
var state_54657__$1 = state_54657;
var statearr_54679_56119 = state_54657__$1;
(statearr_54679_56119[(2)] = false);

(statearr_54679_56119[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (10))){
var inst_54629 = (state_54657[(2)]);
var state_54657__$1 = state_54657;
var statearr_54680_56120 = state_54657__$1;
(statearr_54680_56120[(2)] = inst_54629);

(statearr_54680_56120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (18))){
var inst_54640 = (state_54657[(2)]);
var state_54657__$1 = state_54657;
var statearr_54681_56121 = state_54657__$1;
(statearr_54681_56121[(2)] = inst_54640);

(statearr_54681_56121[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54658 === (8))){
var inst_54626 = cljs.core.async.close_BANG_.call(null,to);
var state_54657__$1 = state_54657;
var statearr_54682_56122 = state_54657__$1;
(statearr_54682_56122[(2)] = inst_54626);

(statearr_54682_56122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0 = (function (){
var statearr_54683 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54683[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__);

(statearr_54683[(1)] = (1));

return statearr_54683;
});
var cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1 = (function (state_54657){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54684){if((e54684 instanceof Object)){
var ex__54298__auto__ = e54684;
var statearr_54685_56123 = state_54657;
(statearr_54685_56123[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54657);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54684;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56125 = state_54657;
state_54657 = G__56125;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__ = function(state_54657){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1.call(this,state_54657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__54295__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54686 = f__54379__auto__.call(null);
(statearr_54686[(6)] = c__54378__auto__);

return statearr_54686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

return c__54378__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__54688 = arguments.length;
switch (G__54688) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__54690 = arguments.length;
switch (G__54690) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__54692 = arguments.length;
switch (G__54692) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__54378__auto___56145 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54718){
var state_val_54719 = (state_54718[(1)]);
if((state_val_54719 === (7))){
var inst_54714 = (state_54718[(2)]);
var state_54718__$1 = state_54718;
var statearr_54720_56146 = state_54718__$1;
(statearr_54720_56146[(2)] = inst_54714);

(statearr_54720_56146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (1))){
var state_54718__$1 = state_54718;
var statearr_54721_56147 = state_54718__$1;
(statearr_54721_56147[(2)] = null);

(statearr_54721_56147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (4))){
var inst_54695 = (state_54718[(7)]);
var inst_54695__$1 = (state_54718[(2)]);
var inst_54696 = (inst_54695__$1 == null);
var state_54718__$1 = (function (){var statearr_54722 = state_54718;
(statearr_54722[(7)] = inst_54695__$1);

return statearr_54722;
})();
if(cljs.core.truth_(inst_54696)){
var statearr_54723_56148 = state_54718__$1;
(statearr_54723_56148[(1)] = (5));

} else {
var statearr_54724_56155 = state_54718__$1;
(statearr_54724_56155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (13))){
var state_54718__$1 = state_54718;
var statearr_54725_56156 = state_54718__$1;
(statearr_54725_56156[(2)] = null);

(statearr_54725_56156[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (6))){
var inst_54695 = (state_54718[(7)]);
var inst_54701 = p.call(null,inst_54695);
var state_54718__$1 = state_54718;
if(cljs.core.truth_(inst_54701)){
var statearr_54726_56157 = state_54718__$1;
(statearr_54726_56157[(1)] = (9));

} else {
var statearr_54727_56158 = state_54718__$1;
(statearr_54727_56158[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (3))){
var inst_54716 = (state_54718[(2)]);
var state_54718__$1 = state_54718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54718__$1,inst_54716);
} else {
if((state_val_54719 === (12))){
var state_54718__$1 = state_54718;
var statearr_54728_56159 = state_54718__$1;
(statearr_54728_56159[(2)] = null);

(statearr_54728_56159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (2))){
var state_54718__$1 = state_54718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54718__$1,(4),ch);
} else {
if((state_val_54719 === (11))){
var inst_54695 = (state_54718[(7)]);
var inst_54705 = (state_54718[(2)]);
var state_54718__$1 = state_54718;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54718__$1,(8),inst_54705,inst_54695);
} else {
if((state_val_54719 === (9))){
var state_54718__$1 = state_54718;
var statearr_54729_56160 = state_54718__$1;
(statearr_54729_56160[(2)] = tc);

(statearr_54729_56160[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (5))){
var inst_54698 = cljs.core.async.close_BANG_.call(null,tc);
var inst_54699 = cljs.core.async.close_BANG_.call(null,fc);
var state_54718__$1 = (function (){var statearr_54730 = state_54718;
(statearr_54730[(8)] = inst_54698);

return statearr_54730;
})();
var statearr_54731_56167 = state_54718__$1;
(statearr_54731_56167[(2)] = inst_54699);

(statearr_54731_56167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (14))){
var inst_54712 = (state_54718[(2)]);
var state_54718__$1 = state_54718;
var statearr_54732_56168 = state_54718__$1;
(statearr_54732_56168[(2)] = inst_54712);

(statearr_54732_56168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (10))){
var state_54718__$1 = state_54718;
var statearr_54733_56169 = state_54718__$1;
(statearr_54733_56169[(2)] = fc);

(statearr_54733_56169[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54719 === (8))){
var inst_54707 = (state_54718[(2)]);
var state_54718__$1 = state_54718;
if(cljs.core.truth_(inst_54707)){
var statearr_54734_56170 = state_54718__$1;
(statearr_54734_56170[(1)] = (12));

} else {
var statearr_54735_56171 = state_54718__$1;
(statearr_54735_56171[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_54736 = [null,null,null,null,null,null,null,null,null];
(statearr_54736[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_54736[(1)] = (1));

return statearr_54736;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_54718){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54737){if((e54737 instanceof Object)){
var ex__54298__auto__ = e54737;
var statearr_54738_56172 = state_54718;
(statearr_54738_56172[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54718);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56173 = state_54718;
state_54718 = G__56173;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_54718){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_54718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54739 = f__54379__auto__.call(null);
(statearr_54739[(6)] = c__54378__auto___56145);

return statearr_54739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__54378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54760){
var state_val_54761 = (state_54760[(1)]);
if((state_val_54761 === (7))){
var inst_54756 = (state_54760[(2)]);
var state_54760__$1 = state_54760;
var statearr_54762_56180 = state_54760__$1;
(statearr_54762_56180[(2)] = inst_54756);

(statearr_54762_56180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (1))){
var inst_54740 = init;
var state_54760__$1 = (function (){var statearr_54763 = state_54760;
(statearr_54763[(7)] = inst_54740);

return statearr_54763;
})();
var statearr_54764_56181 = state_54760__$1;
(statearr_54764_56181[(2)] = null);

(statearr_54764_56181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (4))){
var inst_54743 = (state_54760[(8)]);
var inst_54743__$1 = (state_54760[(2)]);
var inst_54744 = (inst_54743__$1 == null);
var state_54760__$1 = (function (){var statearr_54765 = state_54760;
(statearr_54765[(8)] = inst_54743__$1);

return statearr_54765;
})();
if(cljs.core.truth_(inst_54744)){
var statearr_54766_56182 = state_54760__$1;
(statearr_54766_56182[(1)] = (5));

} else {
var statearr_54767_56183 = state_54760__$1;
(statearr_54767_56183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (6))){
var inst_54743 = (state_54760[(8)]);
var inst_54740 = (state_54760[(7)]);
var inst_54747 = (state_54760[(9)]);
var inst_54747__$1 = f.call(null,inst_54740,inst_54743);
var inst_54748 = cljs.core.reduced_QMARK_.call(null,inst_54747__$1);
var state_54760__$1 = (function (){var statearr_54768 = state_54760;
(statearr_54768[(9)] = inst_54747__$1);

return statearr_54768;
})();
if(inst_54748){
var statearr_54769_56184 = state_54760__$1;
(statearr_54769_56184[(1)] = (8));

} else {
var statearr_54770_56185 = state_54760__$1;
(statearr_54770_56185[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (3))){
var inst_54758 = (state_54760[(2)]);
var state_54760__$1 = state_54760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54760__$1,inst_54758);
} else {
if((state_val_54761 === (2))){
var state_54760__$1 = state_54760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54760__$1,(4),ch);
} else {
if((state_val_54761 === (9))){
var inst_54747 = (state_54760[(9)]);
var inst_54740 = inst_54747;
var state_54760__$1 = (function (){var statearr_54771 = state_54760;
(statearr_54771[(7)] = inst_54740);

return statearr_54771;
})();
var statearr_54772_56186 = state_54760__$1;
(statearr_54772_56186[(2)] = null);

(statearr_54772_56186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (5))){
var inst_54740 = (state_54760[(7)]);
var state_54760__$1 = state_54760;
var statearr_54773_56187 = state_54760__$1;
(statearr_54773_56187[(2)] = inst_54740);

(statearr_54773_56187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (10))){
var inst_54754 = (state_54760[(2)]);
var state_54760__$1 = state_54760;
var statearr_54774_56188 = state_54760__$1;
(statearr_54774_56188[(2)] = inst_54754);

(statearr_54774_56188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54761 === (8))){
var inst_54747 = (state_54760[(9)]);
var inst_54750 = cljs.core.deref.call(null,inst_54747);
var state_54760__$1 = state_54760;
var statearr_54775_56189 = state_54760__$1;
(statearr_54775_56189[(2)] = inst_54750);

(statearr_54775_56189[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__54295__auto__ = null;
var cljs$core$async$reduce_$_state_machine__54295__auto____0 = (function (){
var statearr_54776 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54776[(0)] = cljs$core$async$reduce_$_state_machine__54295__auto__);

(statearr_54776[(1)] = (1));

return statearr_54776;
});
var cljs$core$async$reduce_$_state_machine__54295__auto____1 = (function (state_54760){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54777){if((e54777 instanceof Object)){
var ex__54298__auto__ = e54777;
var statearr_54778_56190 = state_54760;
(statearr_54778_56190[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56191 = state_54760;
state_54760 = G__56191;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__54295__auto__ = function(state_54760){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__54295__auto____1.call(this,state_54760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__54295__auto____0;
cljs$core$async$reduce_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__54295__auto____1;
return cljs$core$async$reduce_$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54779 = f__54379__auto__.call(null);
(statearr_54779[(6)] = c__54378__auto__);

return statearr_54779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

return c__54378__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__54378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54785){
var state_val_54786 = (state_54785[(1)]);
if((state_val_54786 === (1))){
var inst_54780 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_54785__$1 = state_54785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54785__$1,(2),inst_54780);
} else {
if((state_val_54786 === (2))){
var inst_54782 = (state_54785[(2)]);
var inst_54783 = f__$1.call(null,inst_54782);
var state_54785__$1 = state_54785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54785__$1,inst_54783);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__54295__auto__ = null;
var cljs$core$async$transduce_$_state_machine__54295__auto____0 = (function (){
var statearr_54787 = [null,null,null,null,null,null,null];
(statearr_54787[(0)] = cljs$core$async$transduce_$_state_machine__54295__auto__);

(statearr_54787[(1)] = (1));

return statearr_54787;
});
var cljs$core$async$transduce_$_state_machine__54295__auto____1 = (function (state_54785){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54788){if((e54788 instanceof Object)){
var ex__54298__auto__ = e54788;
var statearr_54789_56197 = state_54785;
(statearr_54789_56197[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54788;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56198 = state_54785;
state_54785 = G__56198;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__54295__auto__ = function(state_54785){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__54295__auto____1.call(this,state_54785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__54295__auto____0;
cljs$core$async$transduce_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__54295__auto____1;
return cljs$core$async$transduce_$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54790 = f__54379__auto__.call(null);
(statearr_54790[(6)] = c__54378__auto__);

return statearr_54790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

return c__54378__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__54792 = arguments.length;
switch (G__54792) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__54378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54817){
var state_val_54818 = (state_54817[(1)]);
if((state_val_54818 === (7))){
var inst_54799 = (state_54817[(2)]);
var state_54817__$1 = state_54817;
var statearr_54819_56202 = state_54817__$1;
(statearr_54819_56202[(2)] = inst_54799);

(statearr_54819_56202[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (1))){
var inst_54793 = cljs.core.seq.call(null,coll);
var inst_54794 = inst_54793;
var state_54817__$1 = (function (){var statearr_54820 = state_54817;
(statearr_54820[(7)] = inst_54794);

return statearr_54820;
})();
var statearr_54821_56203 = state_54817__$1;
(statearr_54821_56203[(2)] = null);

(statearr_54821_56203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (4))){
var inst_54794 = (state_54817[(7)]);
var inst_54797 = cljs.core.first.call(null,inst_54794);
var state_54817__$1 = state_54817;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_54817__$1,(7),ch,inst_54797);
} else {
if((state_val_54818 === (13))){
var inst_54811 = (state_54817[(2)]);
var state_54817__$1 = state_54817;
var statearr_54822_56205 = state_54817__$1;
(statearr_54822_56205[(2)] = inst_54811);

(statearr_54822_56205[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (6))){
var inst_54802 = (state_54817[(2)]);
var state_54817__$1 = state_54817;
if(cljs.core.truth_(inst_54802)){
var statearr_54823_56207 = state_54817__$1;
(statearr_54823_56207[(1)] = (8));

} else {
var statearr_54824_56208 = state_54817__$1;
(statearr_54824_56208[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (3))){
var inst_54815 = (state_54817[(2)]);
var state_54817__$1 = state_54817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54817__$1,inst_54815);
} else {
if((state_val_54818 === (12))){
var state_54817__$1 = state_54817;
var statearr_54825_56209 = state_54817__$1;
(statearr_54825_56209[(2)] = null);

(statearr_54825_56209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (2))){
var inst_54794 = (state_54817[(7)]);
var state_54817__$1 = state_54817;
if(cljs.core.truth_(inst_54794)){
var statearr_54826_56210 = state_54817__$1;
(statearr_54826_56210[(1)] = (4));

} else {
var statearr_54827_56211 = state_54817__$1;
(statearr_54827_56211[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (11))){
var inst_54808 = cljs.core.async.close_BANG_.call(null,ch);
var state_54817__$1 = state_54817;
var statearr_54828_56212 = state_54817__$1;
(statearr_54828_56212[(2)] = inst_54808);

(statearr_54828_56212[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (9))){
var state_54817__$1 = state_54817;
if(cljs.core.truth_(close_QMARK_)){
var statearr_54829_56213 = state_54817__$1;
(statearr_54829_56213[(1)] = (11));

} else {
var statearr_54830_56214 = state_54817__$1;
(statearr_54830_56214[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (5))){
var inst_54794 = (state_54817[(7)]);
var state_54817__$1 = state_54817;
var statearr_54831_56215 = state_54817__$1;
(statearr_54831_56215[(2)] = inst_54794);

(statearr_54831_56215[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (10))){
var inst_54813 = (state_54817[(2)]);
var state_54817__$1 = state_54817;
var statearr_54832_56216 = state_54817__$1;
(statearr_54832_56216[(2)] = inst_54813);

(statearr_54832_56216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54818 === (8))){
var inst_54794 = (state_54817[(7)]);
var inst_54804 = cljs.core.next.call(null,inst_54794);
var inst_54794__$1 = inst_54804;
var state_54817__$1 = (function (){var statearr_54833 = state_54817;
(statearr_54833[(7)] = inst_54794__$1);

return statearr_54833;
})();
var statearr_54834_56217 = state_54817__$1;
(statearr_54834_56217[(2)] = null);

(statearr_54834_56217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_54835 = [null,null,null,null,null,null,null,null];
(statearr_54835[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_54835[(1)] = (1));

return statearr_54835;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_54817){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e54836){if((e54836 instanceof Object)){
var ex__54298__auto__ = e54836;
var statearr_54837_56220 = state_54817;
(statearr_54837_56220[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54817);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54836;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56221 = state_54817;
state_54817 = G__56221;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_54817){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_54817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_54838 = f__54379__auto__.call(null);
(statearr_54838[(6)] = c__54378__auto__);

return statearr_54838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

return c__54378__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_56222 = (function (_){
var x__6346__auto__ = (((_ == null))?null:_);
var m__6347__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,_);
} else {
var m__6344__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_56222.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_56223 = (function (m,ch,close_QMARK_){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6344__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_56223.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_56224 = (function (m,ch){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m,ch);
} else {
var m__6344__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_56224.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_56225 = (function (m){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m);
} else {
var m__6344__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_56225.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async54839 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54839 = (function (ch,cs,meta54840){
this.ch = ch;
this.cs = cs;
this.meta54840 = meta54840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54841,meta54840__$1){
var self__ = this;
var _54841__$1 = this;
return (new cljs.core.async.t_cljs$core$async54839(self__.ch,self__.cs,meta54840__$1));
}));

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54841){
var self__ = this;
var _54841__$1 = this;
return self__.meta54840;
}));

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async54839.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async54839.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta54840","meta54840",4286977,null)], null);
}));

(cljs.core.async.t_cljs$core$async54839.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54839.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54839");

(cljs.core.async.t_cljs$core$async54839.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async54839");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54839.
 */
cljs.core.async.__GT_t_cljs$core$async54839 = (function cljs$core$async$mult_$___GT_t_cljs$core$async54839(ch__$1,cs__$1,meta54840){
return (new cljs.core.async.t_cljs$core$async54839(ch__$1,cs__$1,meta54840));
});

}

return (new cljs.core.async.t_cljs$core$async54839(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__54378__auto___56231 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_54976){
var state_val_54977 = (state_54976[(1)]);
if((state_val_54977 === (7))){
var inst_54972 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_54978_56232 = state_54976__$1;
(statearr_54978_56232[(2)] = inst_54972);

(statearr_54978_56232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (20))){
var inst_54875 = (state_54976[(7)]);
var inst_54887 = cljs.core.first.call(null,inst_54875);
var inst_54888 = cljs.core.nth.call(null,inst_54887,(0),null);
var inst_54889 = cljs.core.nth.call(null,inst_54887,(1),null);
var state_54976__$1 = (function (){var statearr_54979 = state_54976;
(statearr_54979[(8)] = inst_54888);

return statearr_54979;
})();
if(cljs.core.truth_(inst_54889)){
var statearr_54980_56233 = state_54976__$1;
(statearr_54980_56233[(1)] = (22));

} else {
var statearr_54981_56234 = state_54976__$1;
(statearr_54981_56234[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (27))){
var inst_54844 = (state_54976[(9)]);
var inst_54924 = (state_54976[(10)]);
var inst_54919 = (state_54976[(11)]);
var inst_54917 = (state_54976[(12)]);
var inst_54924__$1 = cljs.core._nth.call(null,inst_54917,inst_54919);
var inst_54925 = cljs.core.async.put_BANG_.call(null,inst_54924__$1,inst_54844,done);
var state_54976__$1 = (function (){var statearr_54982 = state_54976;
(statearr_54982[(10)] = inst_54924__$1);

return statearr_54982;
})();
if(cljs.core.truth_(inst_54925)){
var statearr_54983_56242 = state_54976__$1;
(statearr_54983_56242[(1)] = (30));

} else {
var statearr_54984_56243 = state_54976__$1;
(statearr_54984_56243[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (1))){
var state_54976__$1 = state_54976;
var statearr_54985_56244 = state_54976__$1;
(statearr_54985_56244[(2)] = null);

(statearr_54985_56244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (24))){
var inst_54875 = (state_54976[(7)]);
var inst_54894 = (state_54976[(2)]);
var inst_54895 = cljs.core.next.call(null,inst_54875);
var inst_54853 = inst_54895;
var inst_54854 = null;
var inst_54855 = (0);
var inst_54856 = (0);
var state_54976__$1 = (function (){var statearr_54986 = state_54976;
(statearr_54986[(13)] = inst_54855);

(statearr_54986[(14)] = inst_54894);

(statearr_54986[(15)] = inst_54853);

(statearr_54986[(16)] = inst_54854);

(statearr_54986[(17)] = inst_54856);

return statearr_54986;
})();
var statearr_54987_56248 = state_54976__$1;
(statearr_54987_56248[(2)] = null);

(statearr_54987_56248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (39))){
var state_54976__$1 = state_54976;
var statearr_54991_56252 = state_54976__$1;
(statearr_54991_56252[(2)] = null);

(statearr_54991_56252[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (4))){
var inst_54844 = (state_54976[(9)]);
var inst_54844__$1 = (state_54976[(2)]);
var inst_54845 = (inst_54844__$1 == null);
var state_54976__$1 = (function (){var statearr_54992 = state_54976;
(statearr_54992[(9)] = inst_54844__$1);

return statearr_54992;
})();
if(cljs.core.truth_(inst_54845)){
var statearr_54993_56253 = state_54976__$1;
(statearr_54993_56253[(1)] = (5));

} else {
var statearr_54994_56254 = state_54976__$1;
(statearr_54994_56254[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (15))){
var inst_54855 = (state_54976[(13)]);
var inst_54853 = (state_54976[(15)]);
var inst_54854 = (state_54976[(16)]);
var inst_54856 = (state_54976[(17)]);
var inst_54871 = (state_54976[(2)]);
var inst_54872 = (inst_54856 + (1));
var tmp54988 = inst_54855;
var tmp54989 = inst_54853;
var tmp54990 = inst_54854;
var inst_54853__$1 = tmp54989;
var inst_54854__$1 = tmp54990;
var inst_54855__$1 = tmp54988;
var inst_54856__$1 = inst_54872;
var state_54976__$1 = (function (){var statearr_54995 = state_54976;
(statearr_54995[(13)] = inst_54855__$1);

(statearr_54995[(15)] = inst_54853__$1);

(statearr_54995[(18)] = inst_54871);

(statearr_54995[(16)] = inst_54854__$1);

(statearr_54995[(17)] = inst_54856__$1);

return statearr_54995;
})();
var statearr_54996_56262 = state_54976__$1;
(statearr_54996_56262[(2)] = null);

(statearr_54996_56262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (21))){
var inst_54898 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55000_56263 = state_54976__$1;
(statearr_55000_56263[(2)] = inst_54898);

(statearr_55000_56263[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (31))){
var inst_54924 = (state_54976[(10)]);
var inst_54928 = done.call(null,null);
var inst_54929 = cljs.core.async.untap_STAR_.call(null,m,inst_54924);
var state_54976__$1 = (function (){var statearr_55001 = state_54976;
(statearr_55001[(19)] = inst_54928);

return statearr_55001;
})();
var statearr_55002_56264 = state_54976__$1;
(statearr_55002_56264[(2)] = inst_54929);

(statearr_55002_56264[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (32))){
var inst_54916 = (state_54976[(20)]);
var inst_54919 = (state_54976[(11)]);
var inst_54917 = (state_54976[(12)]);
var inst_54918 = (state_54976[(21)]);
var inst_54931 = (state_54976[(2)]);
var inst_54932 = (inst_54919 + (1));
var tmp54997 = inst_54916;
var tmp54998 = inst_54917;
var tmp54999 = inst_54918;
var inst_54916__$1 = tmp54997;
var inst_54917__$1 = tmp54998;
var inst_54918__$1 = tmp54999;
var inst_54919__$1 = inst_54932;
var state_54976__$1 = (function (){var statearr_55003 = state_54976;
(statearr_55003[(20)] = inst_54916__$1);

(statearr_55003[(11)] = inst_54919__$1);

(statearr_55003[(12)] = inst_54917__$1);

(statearr_55003[(21)] = inst_54918__$1);

(statearr_55003[(22)] = inst_54931);

return statearr_55003;
})();
var statearr_55004_56265 = state_54976__$1;
(statearr_55004_56265[(2)] = null);

(statearr_55004_56265[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (40))){
var inst_54944 = (state_54976[(23)]);
var inst_54948 = done.call(null,null);
var inst_54949 = cljs.core.async.untap_STAR_.call(null,m,inst_54944);
var state_54976__$1 = (function (){var statearr_55005 = state_54976;
(statearr_55005[(24)] = inst_54948);

return statearr_55005;
})();
var statearr_55006_56267 = state_54976__$1;
(statearr_55006_56267[(2)] = inst_54949);

(statearr_55006_56267[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (33))){
var inst_54935 = (state_54976[(25)]);
var inst_54937 = cljs.core.chunked_seq_QMARK_.call(null,inst_54935);
var state_54976__$1 = state_54976;
if(inst_54937){
var statearr_55007_56269 = state_54976__$1;
(statearr_55007_56269[(1)] = (36));

} else {
var statearr_55008_56270 = state_54976__$1;
(statearr_55008_56270[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (13))){
var inst_54865 = (state_54976[(26)]);
var inst_54868 = cljs.core.async.close_BANG_.call(null,inst_54865);
var state_54976__$1 = state_54976;
var statearr_55009_56271 = state_54976__$1;
(statearr_55009_56271[(2)] = inst_54868);

(statearr_55009_56271[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (22))){
var inst_54888 = (state_54976[(8)]);
var inst_54891 = cljs.core.async.close_BANG_.call(null,inst_54888);
var state_54976__$1 = state_54976;
var statearr_55010_56272 = state_54976__$1;
(statearr_55010_56272[(2)] = inst_54891);

(statearr_55010_56272[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (36))){
var inst_54935 = (state_54976[(25)]);
var inst_54939 = cljs.core.chunk_first.call(null,inst_54935);
var inst_54940 = cljs.core.chunk_rest.call(null,inst_54935);
var inst_54941 = cljs.core.count.call(null,inst_54939);
var inst_54916 = inst_54940;
var inst_54917 = inst_54939;
var inst_54918 = inst_54941;
var inst_54919 = (0);
var state_54976__$1 = (function (){var statearr_55011 = state_54976;
(statearr_55011[(20)] = inst_54916);

(statearr_55011[(11)] = inst_54919);

(statearr_55011[(12)] = inst_54917);

(statearr_55011[(21)] = inst_54918);

return statearr_55011;
})();
var statearr_55012_56273 = state_54976__$1;
(statearr_55012_56273[(2)] = null);

(statearr_55012_56273[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (41))){
var inst_54935 = (state_54976[(25)]);
var inst_54951 = (state_54976[(2)]);
var inst_54952 = cljs.core.next.call(null,inst_54935);
var inst_54916 = inst_54952;
var inst_54917 = null;
var inst_54918 = (0);
var inst_54919 = (0);
var state_54976__$1 = (function (){var statearr_55013 = state_54976;
(statearr_55013[(27)] = inst_54951);

(statearr_55013[(20)] = inst_54916);

(statearr_55013[(11)] = inst_54919);

(statearr_55013[(12)] = inst_54917);

(statearr_55013[(21)] = inst_54918);

return statearr_55013;
})();
var statearr_55014_56274 = state_54976__$1;
(statearr_55014_56274[(2)] = null);

(statearr_55014_56274[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (43))){
var state_54976__$1 = state_54976;
var statearr_55015_56275 = state_54976__$1;
(statearr_55015_56275[(2)] = null);

(statearr_55015_56275[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (29))){
var inst_54960 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55016_56276 = state_54976__$1;
(statearr_55016_56276[(2)] = inst_54960);

(statearr_55016_56276[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (44))){
var inst_54969 = (state_54976[(2)]);
var state_54976__$1 = (function (){var statearr_55017 = state_54976;
(statearr_55017[(28)] = inst_54969);

return statearr_55017;
})();
var statearr_55018_56277 = state_54976__$1;
(statearr_55018_56277[(2)] = null);

(statearr_55018_56277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (6))){
var inst_54908 = (state_54976[(29)]);
var inst_54907 = cljs.core.deref.call(null,cs);
var inst_54908__$1 = cljs.core.keys.call(null,inst_54907);
var inst_54909 = cljs.core.count.call(null,inst_54908__$1);
var inst_54910 = cljs.core.reset_BANG_.call(null,dctr,inst_54909);
var inst_54915 = cljs.core.seq.call(null,inst_54908__$1);
var inst_54916 = inst_54915;
var inst_54917 = null;
var inst_54918 = (0);
var inst_54919 = (0);
var state_54976__$1 = (function (){var statearr_55019 = state_54976;
(statearr_55019[(30)] = inst_54910);

(statearr_55019[(20)] = inst_54916);

(statearr_55019[(29)] = inst_54908__$1);

(statearr_55019[(11)] = inst_54919);

(statearr_55019[(12)] = inst_54917);

(statearr_55019[(21)] = inst_54918);

return statearr_55019;
})();
var statearr_55020_56278 = state_54976__$1;
(statearr_55020_56278[(2)] = null);

(statearr_55020_56278[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (28))){
var inst_54916 = (state_54976[(20)]);
var inst_54935 = (state_54976[(25)]);
var inst_54935__$1 = cljs.core.seq.call(null,inst_54916);
var state_54976__$1 = (function (){var statearr_55021 = state_54976;
(statearr_55021[(25)] = inst_54935__$1);

return statearr_55021;
})();
if(inst_54935__$1){
var statearr_55022_56283 = state_54976__$1;
(statearr_55022_56283[(1)] = (33));

} else {
var statearr_55023_56284 = state_54976__$1;
(statearr_55023_56284[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (25))){
var inst_54919 = (state_54976[(11)]);
var inst_54918 = (state_54976[(21)]);
var inst_54921 = (inst_54919 < inst_54918);
var inst_54922 = inst_54921;
var state_54976__$1 = state_54976;
if(cljs.core.truth_(inst_54922)){
var statearr_55024_56285 = state_54976__$1;
(statearr_55024_56285[(1)] = (27));

} else {
var statearr_55025_56286 = state_54976__$1;
(statearr_55025_56286[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (34))){
var state_54976__$1 = state_54976;
var statearr_55026_56287 = state_54976__$1;
(statearr_55026_56287[(2)] = null);

(statearr_55026_56287[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (17))){
var state_54976__$1 = state_54976;
var statearr_55027_56288 = state_54976__$1;
(statearr_55027_56288[(2)] = null);

(statearr_55027_56288[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (3))){
var inst_54974 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54976__$1,inst_54974);
} else {
if((state_val_54977 === (12))){
var inst_54903 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55028_56289 = state_54976__$1;
(statearr_55028_56289[(2)] = inst_54903);

(statearr_55028_56289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (2))){
var state_54976__$1 = state_54976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54976__$1,(4),ch);
} else {
if((state_val_54977 === (23))){
var state_54976__$1 = state_54976;
var statearr_55029_56294 = state_54976__$1;
(statearr_55029_56294[(2)] = null);

(statearr_55029_56294[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (35))){
var inst_54958 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55030_56296 = state_54976__$1;
(statearr_55030_56296[(2)] = inst_54958);

(statearr_55030_56296[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (19))){
var inst_54875 = (state_54976[(7)]);
var inst_54879 = cljs.core.chunk_first.call(null,inst_54875);
var inst_54880 = cljs.core.chunk_rest.call(null,inst_54875);
var inst_54881 = cljs.core.count.call(null,inst_54879);
var inst_54853 = inst_54880;
var inst_54854 = inst_54879;
var inst_54855 = inst_54881;
var inst_54856 = (0);
var state_54976__$1 = (function (){var statearr_55031 = state_54976;
(statearr_55031[(13)] = inst_54855);

(statearr_55031[(15)] = inst_54853);

(statearr_55031[(16)] = inst_54854);

(statearr_55031[(17)] = inst_54856);

return statearr_55031;
})();
var statearr_55032_56297 = state_54976__$1;
(statearr_55032_56297[(2)] = null);

(statearr_55032_56297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (11))){
var inst_54853 = (state_54976[(15)]);
var inst_54875 = (state_54976[(7)]);
var inst_54875__$1 = cljs.core.seq.call(null,inst_54853);
var state_54976__$1 = (function (){var statearr_55033 = state_54976;
(statearr_55033[(7)] = inst_54875__$1);

return statearr_55033;
})();
if(inst_54875__$1){
var statearr_55034_56299 = state_54976__$1;
(statearr_55034_56299[(1)] = (16));

} else {
var statearr_55035_56300 = state_54976__$1;
(statearr_55035_56300[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (9))){
var inst_54905 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55036_56301 = state_54976__$1;
(statearr_55036_56301[(2)] = inst_54905);

(statearr_55036_56301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (5))){
var inst_54851 = cljs.core.deref.call(null,cs);
var inst_54852 = cljs.core.seq.call(null,inst_54851);
var inst_54853 = inst_54852;
var inst_54854 = null;
var inst_54855 = (0);
var inst_54856 = (0);
var state_54976__$1 = (function (){var statearr_55037 = state_54976;
(statearr_55037[(13)] = inst_54855);

(statearr_55037[(15)] = inst_54853);

(statearr_55037[(16)] = inst_54854);

(statearr_55037[(17)] = inst_54856);

return statearr_55037;
})();
var statearr_55038_56303 = state_54976__$1;
(statearr_55038_56303[(2)] = null);

(statearr_55038_56303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (14))){
var state_54976__$1 = state_54976;
var statearr_55039_56307 = state_54976__$1;
(statearr_55039_56307[(2)] = null);

(statearr_55039_56307[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (45))){
var inst_54966 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55040_56308 = state_54976__$1;
(statearr_55040_56308[(2)] = inst_54966);

(statearr_55040_56308[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (26))){
var inst_54908 = (state_54976[(29)]);
var inst_54962 = (state_54976[(2)]);
var inst_54963 = cljs.core.seq.call(null,inst_54908);
var state_54976__$1 = (function (){var statearr_55041 = state_54976;
(statearr_55041[(31)] = inst_54962);

return statearr_55041;
})();
if(inst_54963){
var statearr_55042_56309 = state_54976__$1;
(statearr_55042_56309[(1)] = (42));

} else {
var statearr_55043_56310 = state_54976__$1;
(statearr_55043_56310[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (16))){
var inst_54875 = (state_54976[(7)]);
var inst_54877 = cljs.core.chunked_seq_QMARK_.call(null,inst_54875);
var state_54976__$1 = state_54976;
if(inst_54877){
var statearr_55044_56311 = state_54976__$1;
(statearr_55044_56311[(1)] = (19));

} else {
var statearr_55045_56312 = state_54976__$1;
(statearr_55045_56312[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (38))){
var inst_54955 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55046_56313 = state_54976__$1;
(statearr_55046_56313[(2)] = inst_54955);

(statearr_55046_56313[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (30))){
var state_54976__$1 = state_54976;
var statearr_55047_56314 = state_54976__$1;
(statearr_55047_56314[(2)] = null);

(statearr_55047_56314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (10))){
var inst_54854 = (state_54976[(16)]);
var inst_54856 = (state_54976[(17)]);
var inst_54864 = cljs.core._nth.call(null,inst_54854,inst_54856);
var inst_54865 = cljs.core.nth.call(null,inst_54864,(0),null);
var inst_54866 = cljs.core.nth.call(null,inst_54864,(1),null);
var state_54976__$1 = (function (){var statearr_55048 = state_54976;
(statearr_55048[(26)] = inst_54865);

return statearr_55048;
})();
if(cljs.core.truth_(inst_54866)){
var statearr_55049_56315 = state_54976__$1;
(statearr_55049_56315[(1)] = (13));

} else {
var statearr_55050_56316 = state_54976__$1;
(statearr_55050_56316[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (18))){
var inst_54901 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_55051_56317 = state_54976__$1;
(statearr_55051_56317[(2)] = inst_54901);

(statearr_55051_56317[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (42))){
var state_54976__$1 = state_54976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54976__$1,(45),dchan);
} else {
if((state_val_54977 === (37))){
var inst_54944 = (state_54976[(23)]);
var inst_54844 = (state_54976[(9)]);
var inst_54935 = (state_54976[(25)]);
var inst_54944__$1 = cljs.core.first.call(null,inst_54935);
var inst_54945 = cljs.core.async.put_BANG_.call(null,inst_54944__$1,inst_54844,done);
var state_54976__$1 = (function (){var statearr_55052 = state_54976;
(statearr_55052[(23)] = inst_54944__$1);

return statearr_55052;
})();
if(cljs.core.truth_(inst_54945)){
var statearr_55053_56318 = state_54976__$1;
(statearr_55053_56318[(1)] = (39));

} else {
var statearr_55054_56319 = state_54976__$1;
(statearr_55054_56319[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (8))){
var inst_54855 = (state_54976[(13)]);
var inst_54856 = (state_54976[(17)]);
var inst_54858 = (inst_54856 < inst_54855);
var inst_54859 = inst_54858;
var state_54976__$1 = state_54976;
if(cljs.core.truth_(inst_54859)){
var statearr_55055_56320 = state_54976__$1;
(statearr_55055_56320[(1)] = (10));

} else {
var statearr_55056_56321 = state_54976__$1;
(statearr_55056_56321[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__54295__auto__ = null;
var cljs$core$async$mult_$_state_machine__54295__auto____0 = (function (){
var statearr_55057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55057[(0)] = cljs$core$async$mult_$_state_machine__54295__auto__);

(statearr_55057[(1)] = (1));

return statearr_55057;
});
var cljs$core$async$mult_$_state_machine__54295__auto____1 = (function (state_54976){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_54976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55058){if((e55058 instanceof Object)){
var ex__54298__auto__ = e55058;
var statearr_55059_56322 = state_54976;
(statearr_55059_56322[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54976);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55058;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56323 = state_54976;
state_54976 = G__56323;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__54295__auto__ = function(state_54976){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__54295__auto____1.call(this,state_54976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__54295__auto____0;
cljs$core$async$mult_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__54295__auto____1;
return cljs$core$async$mult_$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55060 = f__54379__auto__.call(null);
(statearr_55060[(6)] = c__54378__auto___56231);

return statearr_55060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__55062 = arguments.length;
switch (G__55062) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_56328 = (function (m,ch){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m,ch);
} else {
var m__6344__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_56328.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_56329 = (function (m,ch){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m,ch);
} else {
var m__6344__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_56329.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_56330 = (function (m){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m);
} else {
var m__6344__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_56330.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_56332 = (function (m,state_map){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m,state_map);
} else {
var m__6344__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_56332.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_56333 = (function (m,mode){
var x__6346__auto__ = (((m == null))?null:m);
var m__6347__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,m,mode);
} else {
var m__6344__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_56333.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___56334 = arguments.length;
var i__6921__auto___56335 = (0);
while(true){
if((i__6921__auto___56335 < len__6920__auto___56334)){
args__6930__auto__.push((arguments[i__6921__auto___56335]));

var G__56336 = (i__6921__auto___56335 + (1));
i__6921__auto___56335 = G__56336;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((3) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6931__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__55067){
var map__55068 = p__55067;
var map__55068__$1 = (((((!((map__55068 == null))))?(((((map__55068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55068.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__55068):map__55068);
var opts = map__55068__$1;
var statearr_55070_56341 = state;
(statearr_55070_56341[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_55071_56342 = state;
(statearr_55071_56342[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_55072_56344 = state;
(statearr_55072_56344[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq55063){
var G__55064 = cljs.core.first.call(null,seq55063);
var seq55063__$1 = cljs.core.next.call(null,seq55063);
var G__55065 = cljs.core.first.call(null,seq55063__$1);
var seq55063__$2 = cljs.core.next.call(null,seq55063__$1);
var G__55066 = cljs.core.first.call(null,seq55063__$2);
var seq55063__$3 = cljs.core.next.call(null,seq55063__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55064,G__55065,G__55066,seq55063__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55073 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55073 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta55074){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta55074 = meta55074;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55075,meta55074__$1){
var self__ = this;
var _55075__$1 = this;
return (new cljs.core.async.t_cljs$core$async55073(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta55074__$1));
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55075){
var self__ = this;
var _55075__$1 = this;
return self__.meta55074;
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async55073.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async55073.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta55074","meta55074",1509216876,null)], null);
}));

(cljs.core.async.t_cljs$core$async55073.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async55073.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55073");

(cljs.core.async.t_cljs$core$async55073.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async55073");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55073.
 */
cljs.core.async.__GT_t_cljs$core$async55073 = (function cljs$core$async$mix_$___GT_t_cljs$core$async55073(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta55074){
return (new cljs.core.async.t_cljs$core$async55073(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta55074));
});

}

return (new cljs.core.async.t_cljs$core$async55073(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__54378__auto___56350 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55177){
var state_val_55178 = (state_55177[(1)]);
if((state_val_55178 === (7))){
var inst_55092 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
var statearr_55179_56354 = state_55177__$1;
(statearr_55179_56354[(2)] = inst_55092);

(statearr_55179_56354[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (20))){
var inst_55104 = (state_55177[(7)]);
var state_55177__$1 = state_55177;
var statearr_55180_56355 = state_55177__$1;
(statearr_55180_56355[(2)] = inst_55104);

(statearr_55180_56355[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (27))){
var state_55177__$1 = state_55177;
var statearr_55181_56356 = state_55177__$1;
(statearr_55181_56356[(2)] = null);

(statearr_55181_56356[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (1))){
var inst_55079 = (state_55177[(8)]);
var inst_55079__$1 = calc_state.call(null);
var inst_55081 = (inst_55079__$1 == null);
var inst_55082 = cljs.core.not.call(null,inst_55081);
var state_55177__$1 = (function (){var statearr_55182 = state_55177;
(statearr_55182[(8)] = inst_55079__$1);

return statearr_55182;
})();
if(inst_55082){
var statearr_55183_56357 = state_55177__$1;
(statearr_55183_56357[(1)] = (2));

} else {
var statearr_55184_56358 = state_55177__$1;
(statearr_55184_56358[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (24))){
var inst_55128 = (state_55177[(9)]);
var inst_55151 = (state_55177[(10)]);
var inst_55137 = (state_55177[(11)]);
var inst_55151__$1 = inst_55128.call(null,inst_55137);
var state_55177__$1 = (function (){var statearr_55185 = state_55177;
(statearr_55185[(10)] = inst_55151__$1);

return statearr_55185;
})();
if(cljs.core.truth_(inst_55151__$1)){
var statearr_55186_56359 = state_55177__$1;
(statearr_55186_56359[(1)] = (29));

} else {
var statearr_55187_56360 = state_55177__$1;
(statearr_55187_56360[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (4))){
var inst_55095 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55095)){
var statearr_55188_56361 = state_55177__$1;
(statearr_55188_56361[(1)] = (8));

} else {
var statearr_55189_56362 = state_55177__$1;
(statearr_55189_56362[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (15))){
var inst_55122 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55122)){
var statearr_55190_56363 = state_55177__$1;
(statearr_55190_56363[(1)] = (19));

} else {
var statearr_55191_56364 = state_55177__$1;
(statearr_55191_56364[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (21))){
var inst_55127 = (state_55177[(12)]);
var inst_55127__$1 = (state_55177[(2)]);
var inst_55128 = cljs.core.get.call(null,inst_55127__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_55129 = cljs.core.get.call(null,inst_55127__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_55130 = cljs.core.get.call(null,inst_55127__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_55177__$1 = (function (){var statearr_55192 = state_55177;
(statearr_55192[(12)] = inst_55127__$1);

(statearr_55192[(9)] = inst_55128);

(statearr_55192[(13)] = inst_55129);

return statearr_55192;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_55177__$1,(22),inst_55130);
} else {
if((state_val_55178 === (31))){
var inst_55159 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55159)){
var statearr_55193_56365 = state_55177__$1;
(statearr_55193_56365[(1)] = (32));

} else {
var statearr_55194_56367 = state_55177__$1;
(statearr_55194_56367[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (32))){
var inst_55136 = (state_55177[(14)]);
var state_55177__$1 = state_55177;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55177__$1,(35),out,inst_55136);
} else {
if((state_val_55178 === (33))){
var inst_55127 = (state_55177[(12)]);
var inst_55104 = inst_55127;
var state_55177__$1 = (function (){var statearr_55195 = state_55177;
(statearr_55195[(7)] = inst_55104);

return statearr_55195;
})();
var statearr_55196_56368 = state_55177__$1;
(statearr_55196_56368[(2)] = null);

(statearr_55196_56368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (13))){
var inst_55104 = (state_55177[(7)]);
var inst_55111 = inst_55104.cljs$lang$protocol_mask$partition0$;
var inst_55112 = (inst_55111 & (64));
var inst_55113 = inst_55104.cljs$core$ISeq$;
var inst_55114 = (cljs.core.PROTOCOL_SENTINEL === inst_55113);
var inst_55115 = ((inst_55112) || (inst_55114));
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55115)){
var statearr_55197_56369 = state_55177__$1;
(statearr_55197_56369[(1)] = (16));

} else {
var statearr_55198_56370 = state_55177__$1;
(statearr_55198_56370[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (22))){
var inst_55136 = (state_55177[(14)]);
var inst_55137 = (state_55177[(11)]);
var inst_55135 = (state_55177[(2)]);
var inst_55136__$1 = cljs.core.nth.call(null,inst_55135,(0),null);
var inst_55137__$1 = cljs.core.nth.call(null,inst_55135,(1),null);
var inst_55138 = (inst_55136__$1 == null);
var inst_55139 = cljs.core._EQ_.call(null,inst_55137__$1,change);
var inst_55140 = ((inst_55138) || (inst_55139));
var state_55177__$1 = (function (){var statearr_55199 = state_55177;
(statearr_55199[(14)] = inst_55136__$1);

(statearr_55199[(11)] = inst_55137__$1);

return statearr_55199;
})();
if(cljs.core.truth_(inst_55140)){
var statearr_55200_56371 = state_55177__$1;
(statearr_55200_56371[(1)] = (23));

} else {
var statearr_55201_56372 = state_55177__$1;
(statearr_55201_56372[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (36))){
var inst_55127 = (state_55177[(12)]);
var inst_55104 = inst_55127;
var state_55177__$1 = (function (){var statearr_55202 = state_55177;
(statearr_55202[(7)] = inst_55104);

return statearr_55202;
})();
var statearr_55203_56373 = state_55177__$1;
(statearr_55203_56373[(2)] = null);

(statearr_55203_56373[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (29))){
var inst_55151 = (state_55177[(10)]);
var state_55177__$1 = state_55177;
var statearr_55204_56374 = state_55177__$1;
(statearr_55204_56374[(2)] = inst_55151);

(statearr_55204_56374[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (6))){
var state_55177__$1 = state_55177;
var statearr_55205_56375 = state_55177__$1;
(statearr_55205_56375[(2)] = false);

(statearr_55205_56375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (28))){
var inst_55147 = (state_55177[(2)]);
var inst_55148 = calc_state.call(null);
var inst_55104 = inst_55148;
var state_55177__$1 = (function (){var statearr_55206 = state_55177;
(statearr_55206[(7)] = inst_55104);

(statearr_55206[(15)] = inst_55147);

return statearr_55206;
})();
var statearr_55207_56376 = state_55177__$1;
(statearr_55207_56376[(2)] = null);

(statearr_55207_56376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (25))){
var inst_55173 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
var statearr_55208_56377 = state_55177__$1;
(statearr_55208_56377[(2)] = inst_55173);

(statearr_55208_56377[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (34))){
var inst_55171 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
var statearr_55209_56379 = state_55177__$1;
(statearr_55209_56379[(2)] = inst_55171);

(statearr_55209_56379[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (17))){
var state_55177__$1 = state_55177;
var statearr_55210_56383 = state_55177__$1;
(statearr_55210_56383[(2)] = false);

(statearr_55210_56383[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (3))){
var state_55177__$1 = state_55177;
var statearr_55211_56384 = state_55177__$1;
(statearr_55211_56384[(2)] = false);

(statearr_55211_56384[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (12))){
var inst_55175 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55177__$1,inst_55175);
} else {
if((state_val_55178 === (2))){
var inst_55079 = (state_55177[(8)]);
var inst_55084 = inst_55079.cljs$lang$protocol_mask$partition0$;
var inst_55085 = (inst_55084 & (64));
var inst_55086 = inst_55079.cljs$core$ISeq$;
var inst_55087 = (cljs.core.PROTOCOL_SENTINEL === inst_55086);
var inst_55088 = ((inst_55085) || (inst_55087));
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55088)){
var statearr_55212_56389 = state_55177__$1;
(statearr_55212_56389[(1)] = (5));

} else {
var statearr_55213_56390 = state_55177__$1;
(statearr_55213_56390[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (23))){
var inst_55136 = (state_55177[(14)]);
var inst_55142 = (inst_55136 == null);
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55142)){
var statearr_55214_56391 = state_55177__$1;
(statearr_55214_56391[(1)] = (26));

} else {
var statearr_55215_56392 = state_55177__$1;
(statearr_55215_56392[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (35))){
var inst_55162 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
if(cljs.core.truth_(inst_55162)){
var statearr_55216_56393 = state_55177__$1;
(statearr_55216_56393[(1)] = (36));

} else {
var statearr_55217_56395 = state_55177__$1;
(statearr_55217_56395[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (19))){
var inst_55104 = (state_55177[(7)]);
var inst_55124 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55104);
var state_55177__$1 = state_55177;
var statearr_55218_56397 = state_55177__$1;
(statearr_55218_56397[(2)] = inst_55124);

(statearr_55218_56397[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (11))){
var inst_55104 = (state_55177[(7)]);
var inst_55108 = (inst_55104 == null);
var inst_55109 = cljs.core.not.call(null,inst_55108);
var state_55177__$1 = state_55177;
if(inst_55109){
var statearr_55219_56398 = state_55177__$1;
(statearr_55219_56398[(1)] = (13));

} else {
var statearr_55220_56399 = state_55177__$1;
(statearr_55220_56399[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (9))){
var inst_55079 = (state_55177[(8)]);
var state_55177__$1 = state_55177;
var statearr_55221_56400 = state_55177__$1;
(statearr_55221_56400[(2)] = inst_55079);

(statearr_55221_56400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (5))){
var state_55177__$1 = state_55177;
var statearr_55222_56401 = state_55177__$1;
(statearr_55222_56401[(2)] = true);

(statearr_55222_56401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (14))){
var state_55177__$1 = state_55177;
var statearr_55223_56402 = state_55177__$1;
(statearr_55223_56402[(2)] = false);

(statearr_55223_56402[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (26))){
var inst_55137 = (state_55177[(11)]);
var inst_55144 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_55137);
var state_55177__$1 = state_55177;
var statearr_55224_56403 = state_55177__$1;
(statearr_55224_56403[(2)] = inst_55144);

(statearr_55224_56403[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (16))){
var state_55177__$1 = state_55177;
var statearr_55225_56404 = state_55177__$1;
(statearr_55225_56404[(2)] = true);

(statearr_55225_56404[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (38))){
var inst_55167 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
var statearr_55226_56405 = state_55177__$1;
(statearr_55226_56405[(2)] = inst_55167);

(statearr_55226_56405[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (30))){
var inst_55128 = (state_55177[(9)]);
var inst_55129 = (state_55177[(13)]);
var inst_55137 = (state_55177[(11)]);
var inst_55154 = cljs.core.empty_QMARK_.call(null,inst_55128);
var inst_55155 = inst_55129.call(null,inst_55137);
var inst_55156 = cljs.core.not.call(null,inst_55155);
var inst_55157 = ((inst_55154) && (inst_55156));
var state_55177__$1 = state_55177;
var statearr_55227_56406 = state_55177__$1;
(statearr_55227_56406[(2)] = inst_55157);

(statearr_55227_56406[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (10))){
var inst_55079 = (state_55177[(8)]);
var inst_55100 = (state_55177[(2)]);
var inst_55101 = cljs.core.get.call(null,inst_55100,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_55102 = cljs.core.get.call(null,inst_55100,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_55103 = cljs.core.get.call(null,inst_55100,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_55104 = inst_55079;
var state_55177__$1 = (function (){var statearr_55228 = state_55177;
(statearr_55228[(16)] = inst_55103);

(statearr_55228[(17)] = inst_55101);

(statearr_55228[(7)] = inst_55104);

(statearr_55228[(18)] = inst_55102);

return statearr_55228;
})();
var statearr_55229_56407 = state_55177__$1;
(statearr_55229_56407[(2)] = null);

(statearr_55229_56407[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (18))){
var inst_55119 = (state_55177[(2)]);
var state_55177__$1 = state_55177;
var statearr_55230_56408 = state_55177__$1;
(statearr_55230_56408[(2)] = inst_55119);

(statearr_55230_56408[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (37))){
var state_55177__$1 = state_55177;
var statearr_55231_56409 = state_55177__$1;
(statearr_55231_56409[(2)] = null);

(statearr_55231_56409[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55178 === (8))){
var inst_55079 = (state_55177[(8)]);
var inst_55097 = cljs.core.apply.call(null,cljs.core.hash_map,inst_55079);
var state_55177__$1 = state_55177;
var statearr_55232_56410 = state_55177__$1;
(statearr_55232_56410[(2)] = inst_55097);

(statearr_55232_56410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__54295__auto__ = null;
var cljs$core$async$mix_$_state_machine__54295__auto____0 = (function (){
var statearr_55233 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55233[(0)] = cljs$core$async$mix_$_state_machine__54295__auto__);

(statearr_55233[(1)] = (1));

return statearr_55233;
});
var cljs$core$async$mix_$_state_machine__54295__auto____1 = (function (state_55177){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55234){if((e55234 instanceof Object)){
var ex__54298__auto__ = e55234;
var statearr_55235_56411 = state_55177;
(statearr_55235_56411[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55234;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56412 = state_55177;
state_55177 = G__56412;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__54295__auto__ = function(state_55177){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__54295__auto____1.call(this,state_55177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__54295__auto____0;
cljs$core$async$mix_$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__54295__auto____1;
return cljs$core$async$mix_$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55236 = f__54379__auto__.call(null);
(statearr_55236[(6)] = c__54378__auto___56350);

return statearr_55236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_56416 = (function (p,v,ch,close_QMARK_){
var x__6346__auto__ = (((p == null))?null:p);
var m__6347__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6344__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_56416.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_56424 = (function (p,v,ch){
var x__6346__auto__ = (((p == null))?null:p);
var m__6347__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,p,v,ch);
} else {
var m__6344__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_56424.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_56431 = (function() {
var G__56432 = null;
var G__56432__1 = (function (p){
var x__6346__auto__ = (((p == null))?null:p);
var m__6347__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,p);
} else {
var m__6344__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__56432__2 = (function (p,v){
var x__6346__auto__ = (((p == null))?null:p);
var m__6347__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,p,v);
} else {
var m__6344__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__56432 = function(p,v){
switch(arguments.length){
case 1:
return G__56432__1.call(this,p);
case 2:
return G__56432__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__56432.cljs$core$IFn$_invoke$arity$1 = G__56432__1;
G__56432.cljs$core$IFn$_invoke$arity$2 = G__56432__2;
return G__56432;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__55238 = arguments.length;
switch (G__55238) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_56431.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_56431.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__55241 = arguments.length;
switch (G__55241) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5598__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__55239_SHARP_){
if(cljs.core.truth_(p1__55239_SHARP_.call(null,topic))){
return p1__55239_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__55239_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55242 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55242 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta55243){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta55243 = meta55243;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55244,meta55243__$1){
var self__ = this;
var _55244__$1 = this;
return (new cljs.core.async.t_cljs$core$async55242(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta55243__$1));
}));

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55244){
var self__ = this;
var _55244__$1 = this;
return self__.meta55243;
}));

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async55242.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async55242.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta55243","meta55243",-1494469563,null)], null);
}));

(cljs.core.async.t_cljs$core$async55242.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async55242.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55242");

(cljs.core.async.t_cljs$core$async55242.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async55242");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55242.
 */
cljs.core.async.__GT_t_cljs$core$async55242 = (function cljs$core$async$__GT_t_cljs$core$async55242(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta55243){
return (new cljs.core.async.t_cljs$core$async55242(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta55243));
});

}

return (new cljs.core.async.t_cljs$core$async55242(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__54378__auto___56460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55316){
var state_val_55317 = (state_55316[(1)]);
if((state_val_55317 === (7))){
var inst_55312 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55318_56461 = state_55316__$1;
(statearr_55318_56461[(2)] = inst_55312);

(statearr_55318_56461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (20))){
var state_55316__$1 = state_55316;
var statearr_55319_56462 = state_55316__$1;
(statearr_55319_56462[(2)] = null);

(statearr_55319_56462[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (1))){
var state_55316__$1 = state_55316;
var statearr_55320_56463 = state_55316__$1;
(statearr_55320_56463[(2)] = null);

(statearr_55320_56463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (24))){
var inst_55295 = (state_55316[(7)]);
var inst_55304 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_55295);
var state_55316__$1 = state_55316;
var statearr_55321_56464 = state_55316__$1;
(statearr_55321_56464[(2)] = inst_55304);

(statearr_55321_56464[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (4))){
var inst_55247 = (state_55316[(8)]);
var inst_55247__$1 = (state_55316[(2)]);
var inst_55248 = (inst_55247__$1 == null);
var state_55316__$1 = (function (){var statearr_55322 = state_55316;
(statearr_55322[(8)] = inst_55247__$1);

return statearr_55322;
})();
if(cljs.core.truth_(inst_55248)){
var statearr_55323_56465 = state_55316__$1;
(statearr_55323_56465[(1)] = (5));

} else {
var statearr_55324_56466 = state_55316__$1;
(statearr_55324_56466[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (15))){
var inst_55289 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55325_56473 = state_55316__$1;
(statearr_55325_56473[(2)] = inst_55289);

(statearr_55325_56473[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (21))){
var inst_55309 = (state_55316[(2)]);
var state_55316__$1 = (function (){var statearr_55326 = state_55316;
(statearr_55326[(9)] = inst_55309);

return statearr_55326;
})();
var statearr_55327_56474 = state_55316__$1;
(statearr_55327_56474[(2)] = null);

(statearr_55327_56474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (13))){
var inst_55271 = (state_55316[(10)]);
var inst_55273 = cljs.core.chunked_seq_QMARK_.call(null,inst_55271);
var state_55316__$1 = state_55316;
if(inst_55273){
var statearr_55328_56475 = state_55316__$1;
(statearr_55328_56475[(1)] = (16));

} else {
var statearr_55329_56476 = state_55316__$1;
(statearr_55329_56476[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (22))){
var inst_55301 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
if(cljs.core.truth_(inst_55301)){
var statearr_55330_56477 = state_55316__$1;
(statearr_55330_56477[(1)] = (23));

} else {
var statearr_55331_56478 = state_55316__$1;
(statearr_55331_56478[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (6))){
var inst_55297 = (state_55316[(11)]);
var inst_55295 = (state_55316[(7)]);
var inst_55247 = (state_55316[(8)]);
var inst_55295__$1 = topic_fn.call(null,inst_55247);
var inst_55296 = cljs.core.deref.call(null,mults);
var inst_55297__$1 = cljs.core.get.call(null,inst_55296,inst_55295__$1);
var state_55316__$1 = (function (){var statearr_55332 = state_55316;
(statearr_55332[(11)] = inst_55297__$1);

(statearr_55332[(7)] = inst_55295__$1);

return statearr_55332;
})();
if(cljs.core.truth_(inst_55297__$1)){
var statearr_55333_56485 = state_55316__$1;
(statearr_55333_56485[(1)] = (19));

} else {
var statearr_55334_56486 = state_55316__$1;
(statearr_55334_56486[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (25))){
var inst_55306 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55335_56487 = state_55316__$1;
(statearr_55335_56487[(2)] = inst_55306);

(statearr_55335_56487[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (17))){
var inst_55271 = (state_55316[(10)]);
var inst_55280 = cljs.core.first.call(null,inst_55271);
var inst_55281 = cljs.core.async.muxch_STAR_.call(null,inst_55280);
var inst_55282 = cljs.core.async.close_BANG_.call(null,inst_55281);
var inst_55283 = cljs.core.next.call(null,inst_55271);
var inst_55257 = inst_55283;
var inst_55258 = null;
var inst_55259 = (0);
var inst_55260 = (0);
var state_55316__$1 = (function (){var statearr_55336 = state_55316;
(statearr_55336[(12)] = inst_55259);

(statearr_55336[(13)] = inst_55282);

(statearr_55336[(14)] = inst_55260);

(statearr_55336[(15)] = inst_55257);

(statearr_55336[(16)] = inst_55258);

return statearr_55336;
})();
var statearr_55337_56488 = state_55316__$1;
(statearr_55337_56488[(2)] = null);

(statearr_55337_56488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (3))){
var inst_55314 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55316__$1,inst_55314);
} else {
if((state_val_55317 === (12))){
var inst_55291 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55338_56489 = state_55316__$1;
(statearr_55338_56489[(2)] = inst_55291);

(statearr_55338_56489[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (2))){
var state_55316__$1 = state_55316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55316__$1,(4),ch);
} else {
if((state_val_55317 === (23))){
var state_55316__$1 = state_55316;
var statearr_55339_56490 = state_55316__$1;
(statearr_55339_56490[(2)] = null);

(statearr_55339_56490[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (19))){
var inst_55297 = (state_55316[(11)]);
var inst_55247 = (state_55316[(8)]);
var inst_55299 = cljs.core.async.muxch_STAR_.call(null,inst_55297);
var state_55316__$1 = state_55316;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55316__$1,(22),inst_55299,inst_55247);
} else {
if((state_val_55317 === (11))){
var inst_55257 = (state_55316[(15)]);
var inst_55271 = (state_55316[(10)]);
var inst_55271__$1 = cljs.core.seq.call(null,inst_55257);
var state_55316__$1 = (function (){var statearr_55340 = state_55316;
(statearr_55340[(10)] = inst_55271__$1);

return statearr_55340;
})();
if(inst_55271__$1){
var statearr_55341_56491 = state_55316__$1;
(statearr_55341_56491[(1)] = (13));

} else {
var statearr_55342_56492 = state_55316__$1;
(statearr_55342_56492[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (9))){
var inst_55293 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55343_56493 = state_55316__$1;
(statearr_55343_56493[(2)] = inst_55293);

(statearr_55343_56493[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (5))){
var inst_55254 = cljs.core.deref.call(null,mults);
var inst_55255 = cljs.core.vals.call(null,inst_55254);
var inst_55256 = cljs.core.seq.call(null,inst_55255);
var inst_55257 = inst_55256;
var inst_55258 = null;
var inst_55259 = (0);
var inst_55260 = (0);
var state_55316__$1 = (function (){var statearr_55344 = state_55316;
(statearr_55344[(12)] = inst_55259);

(statearr_55344[(14)] = inst_55260);

(statearr_55344[(15)] = inst_55257);

(statearr_55344[(16)] = inst_55258);

return statearr_55344;
})();
var statearr_55345_56494 = state_55316__$1;
(statearr_55345_56494[(2)] = null);

(statearr_55345_56494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (14))){
var state_55316__$1 = state_55316;
var statearr_55349_56495 = state_55316__$1;
(statearr_55349_56495[(2)] = null);

(statearr_55349_56495[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (16))){
var inst_55271 = (state_55316[(10)]);
var inst_55275 = cljs.core.chunk_first.call(null,inst_55271);
var inst_55276 = cljs.core.chunk_rest.call(null,inst_55271);
var inst_55277 = cljs.core.count.call(null,inst_55275);
var inst_55257 = inst_55276;
var inst_55258 = inst_55275;
var inst_55259 = inst_55277;
var inst_55260 = (0);
var state_55316__$1 = (function (){var statearr_55350 = state_55316;
(statearr_55350[(12)] = inst_55259);

(statearr_55350[(14)] = inst_55260);

(statearr_55350[(15)] = inst_55257);

(statearr_55350[(16)] = inst_55258);

return statearr_55350;
})();
var statearr_55351_56496 = state_55316__$1;
(statearr_55351_56496[(2)] = null);

(statearr_55351_56496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (10))){
var inst_55259 = (state_55316[(12)]);
var inst_55260 = (state_55316[(14)]);
var inst_55257 = (state_55316[(15)]);
var inst_55258 = (state_55316[(16)]);
var inst_55265 = cljs.core._nth.call(null,inst_55258,inst_55260);
var inst_55266 = cljs.core.async.muxch_STAR_.call(null,inst_55265);
var inst_55267 = cljs.core.async.close_BANG_.call(null,inst_55266);
var inst_55268 = (inst_55260 + (1));
var tmp55346 = inst_55259;
var tmp55347 = inst_55257;
var tmp55348 = inst_55258;
var inst_55257__$1 = tmp55347;
var inst_55258__$1 = tmp55348;
var inst_55259__$1 = tmp55346;
var inst_55260__$1 = inst_55268;
var state_55316__$1 = (function (){var statearr_55352 = state_55316;
(statearr_55352[(12)] = inst_55259__$1);

(statearr_55352[(14)] = inst_55260__$1);

(statearr_55352[(15)] = inst_55257__$1);

(statearr_55352[(16)] = inst_55258__$1);

(statearr_55352[(17)] = inst_55267);

return statearr_55352;
})();
var statearr_55353_56499 = state_55316__$1;
(statearr_55353_56499[(2)] = null);

(statearr_55353_56499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (18))){
var inst_55286 = (state_55316[(2)]);
var state_55316__$1 = state_55316;
var statearr_55354_56500 = state_55316__$1;
(statearr_55354_56500[(2)] = inst_55286);

(statearr_55354_56500[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55317 === (8))){
var inst_55259 = (state_55316[(12)]);
var inst_55260 = (state_55316[(14)]);
var inst_55262 = (inst_55260 < inst_55259);
var inst_55263 = inst_55262;
var state_55316__$1 = state_55316;
if(cljs.core.truth_(inst_55263)){
var statearr_55355_56501 = state_55316__$1;
(statearr_55355_56501[(1)] = (10));

} else {
var statearr_55356_56502 = state_55316__$1;
(statearr_55356_56502[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55357[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55357[(1)] = (1));

return statearr_55357;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55316){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55358){if((e55358 instanceof Object)){
var ex__54298__auto__ = e55358;
var statearr_55359_56503 = state_55316;
(statearr_55359_56503[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55316);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55358;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56505 = state_55316;
state_55316 = G__56505;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55316){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55360 = f__54379__auto__.call(null);
(statearr_55360[(6)] = c__54378__auto___56460);

return statearr_55360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__55362 = arguments.length;
switch (G__55362) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__55364 = arguments.length;
switch (G__55364) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__55366 = arguments.length;
switch (G__55366) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__54378__auto___56517 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55405){
var state_val_55406 = (state_55405[(1)]);
if((state_val_55406 === (7))){
var state_55405__$1 = state_55405;
var statearr_55407_56519 = state_55405__$1;
(statearr_55407_56519[(2)] = null);

(statearr_55407_56519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (1))){
var state_55405__$1 = state_55405;
var statearr_55408_56521 = state_55405__$1;
(statearr_55408_56521[(2)] = null);

(statearr_55408_56521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (4))){
var inst_55369 = (state_55405[(7)]);
var inst_55371 = (inst_55369 < cnt);
var state_55405__$1 = state_55405;
if(cljs.core.truth_(inst_55371)){
var statearr_55409_56524 = state_55405__$1;
(statearr_55409_56524[(1)] = (6));

} else {
var statearr_55410_56525 = state_55405__$1;
(statearr_55410_56525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (15))){
var inst_55401 = (state_55405[(2)]);
var state_55405__$1 = state_55405;
var statearr_55411_56526 = state_55405__$1;
(statearr_55411_56526[(2)] = inst_55401);

(statearr_55411_56526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (13))){
var inst_55394 = cljs.core.async.close_BANG_.call(null,out);
var state_55405__$1 = state_55405;
var statearr_55412_56527 = state_55405__$1;
(statearr_55412_56527[(2)] = inst_55394);

(statearr_55412_56527[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (6))){
var state_55405__$1 = state_55405;
var statearr_55413_56529 = state_55405__$1;
(statearr_55413_56529[(2)] = null);

(statearr_55413_56529[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (3))){
var inst_55403 = (state_55405[(2)]);
var state_55405__$1 = state_55405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55405__$1,inst_55403);
} else {
if((state_val_55406 === (12))){
var inst_55391 = (state_55405[(8)]);
var inst_55391__$1 = (state_55405[(2)]);
var inst_55392 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_55391__$1);
var state_55405__$1 = (function (){var statearr_55414 = state_55405;
(statearr_55414[(8)] = inst_55391__$1);

return statearr_55414;
})();
if(cljs.core.truth_(inst_55392)){
var statearr_55415_56530 = state_55405__$1;
(statearr_55415_56530[(1)] = (13));

} else {
var statearr_55416_56531 = state_55405__$1;
(statearr_55416_56531[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (2))){
var inst_55368 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_55369 = (0);
var state_55405__$1 = (function (){var statearr_55417 = state_55405;
(statearr_55417[(9)] = inst_55368);

(statearr_55417[(7)] = inst_55369);

return statearr_55417;
})();
var statearr_55418_56533 = state_55405__$1;
(statearr_55418_56533[(2)] = null);

(statearr_55418_56533[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (11))){
var inst_55369 = (state_55405[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_55405,(10),Object,null,(9));
var inst_55378 = chs__$1.call(null,inst_55369);
var inst_55379 = done.call(null,inst_55369);
var inst_55380 = cljs.core.async.take_BANG_.call(null,inst_55378,inst_55379);
var state_55405__$1 = state_55405;
var statearr_55419_56534 = state_55405__$1;
(statearr_55419_56534[(2)] = inst_55380);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55405__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (9))){
var inst_55369 = (state_55405[(7)]);
var inst_55382 = (state_55405[(2)]);
var inst_55383 = (inst_55369 + (1));
var inst_55369__$1 = inst_55383;
var state_55405__$1 = (function (){var statearr_55420 = state_55405;
(statearr_55420[(10)] = inst_55382);

(statearr_55420[(7)] = inst_55369__$1);

return statearr_55420;
})();
var statearr_55421_56535 = state_55405__$1;
(statearr_55421_56535[(2)] = null);

(statearr_55421_56535[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (5))){
var inst_55389 = (state_55405[(2)]);
var state_55405__$1 = (function (){var statearr_55422 = state_55405;
(statearr_55422[(11)] = inst_55389);

return statearr_55422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55405__$1,(12),dchan);
} else {
if((state_val_55406 === (14))){
var inst_55391 = (state_55405[(8)]);
var inst_55396 = cljs.core.apply.call(null,f,inst_55391);
var state_55405__$1 = state_55405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55405__$1,(16),out,inst_55396);
} else {
if((state_val_55406 === (16))){
var inst_55398 = (state_55405[(2)]);
var state_55405__$1 = (function (){var statearr_55423 = state_55405;
(statearr_55423[(12)] = inst_55398);

return statearr_55423;
})();
var statearr_55424_56536 = state_55405__$1;
(statearr_55424_56536[(2)] = null);

(statearr_55424_56536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (10))){
var inst_55373 = (state_55405[(2)]);
var inst_55374 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_55405__$1 = (function (){var statearr_55425 = state_55405;
(statearr_55425[(13)] = inst_55373);

return statearr_55425;
})();
var statearr_55426_56537 = state_55405__$1;
(statearr_55426_56537[(2)] = inst_55374);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55405__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55406 === (8))){
var inst_55387 = (state_55405[(2)]);
var state_55405__$1 = state_55405;
var statearr_55427_56539 = state_55405__$1;
(statearr_55427_56539[(2)] = inst_55387);

(statearr_55427_56539[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55428 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55428[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55428[(1)] = (1));

return statearr_55428;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55405){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55429){if((e55429 instanceof Object)){
var ex__54298__auto__ = e55429;
var statearr_55430_56541 = state_55405;
(statearr_55430_56541[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55429;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56543 = state_55405;
state_55405 = G__56543;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55431 = f__54379__auto__.call(null);
(statearr_55431[(6)] = c__54378__auto___56517);

return statearr_55431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__55434 = arguments.length;
switch (G__55434) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54378__auto___56546 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55466){
var state_val_55467 = (state_55466[(1)]);
if((state_val_55467 === (7))){
var inst_55446 = (state_55466[(7)]);
var inst_55445 = (state_55466[(8)]);
var inst_55445__$1 = (state_55466[(2)]);
var inst_55446__$1 = cljs.core.nth.call(null,inst_55445__$1,(0),null);
var inst_55447 = cljs.core.nth.call(null,inst_55445__$1,(1),null);
var inst_55448 = (inst_55446__$1 == null);
var state_55466__$1 = (function (){var statearr_55468 = state_55466;
(statearr_55468[(7)] = inst_55446__$1);

(statearr_55468[(9)] = inst_55447);

(statearr_55468[(8)] = inst_55445__$1);

return statearr_55468;
})();
if(cljs.core.truth_(inst_55448)){
var statearr_55469_56548 = state_55466__$1;
(statearr_55469_56548[(1)] = (8));

} else {
var statearr_55470_56549 = state_55466__$1;
(statearr_55470_56549[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (1))){
var inst_55435 = cljs.core.vec.call(null,chs);
var inst_55436 = inst_55435;
var state_55466__$1 = (function (){var statearr_55471 = state_55466;
(statearr_55471[(10)] = inst_55436);

return statearr_55471;
})();
var statearr_55472_56550 = state_55466__$1;
(statearr_55472_56550[(2)] = null);

(statearr_55472_56550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (4))){
var inst_55436 = (state_55466[(10)]);
var state_55466__$1 = state_55466;
return cljs.core.async.ioc_alts_BANG_.call(null,state_55466__$1,(7),inst_55436);
} else {
if((state_val_55467 === (6))){
var inst_55462 = (state_55466[(2)]);
var state_55466__$1 = state_55466;
var statearr_55473_56551 = state_55466__$1;
(statearr_55473_56551[(2)] = inst_55462);

(statearr_55473_56551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (3))){
var inst_55464 = (state_55466[(2)]);
var state_55466__$1 = state_55466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55466__$1,inst_55464);
} else {
if((state_val_55467 === (2))){
var inst_55436 = (state_55466[(10)]);
var inst_55438 = cljs.core.count.call(null,inst_55436);
var inst_55439 = (inst_55438 > (0));
var state_55466__$1 = state_55466;
if(cljs.core.truth_(inst_55439)){
var statearr_55475_56553 = state_55466__$1;
(statearr_55475_56553[(1)] = (4));

} else {
var statearr_55476_56554 = state_55466__$1;
(statearr_55476_56554[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (11))){
var inst_55436 = (state_55466[(10)]);
var inst_55455 = (state_55466[(2)]);
var tmp55474 = inst_55436;
var inst_55436__$1 = tmp55474;
var state_55466__$1 = (function (){var statearr_55477 = state_55466;
(statearr_55477[(11)] = inst_55455);

(statearr_55477[(10)] = inst_55436__$1);

return statearr_55477;
})();
var statearr_55478_56555 = state_55466__$1;
(statearr_55478_56555[(2)] = null);

(statearr_55478_56555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (9))){
var inst_55446 = (state_55466[(7)]);
var state_55466__$1 = state_55466;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55466__$1,(11),out,inst_55446);
} else {
if((state_val_55467 === (5))){
var inst_55460 = cljs.core.async.close_BANG_.call(null,out);
var state_55466__$1 = state_55466;
var statearr_55479_56556 = state_55466__$1;
(statearr_55479_56556[(2)] = inst_55460);

(statearr_55479_56556[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (10))){
var inst_55458 = (state_55466[(2)]);
var state_55466__$1 = state_55466;
var statearr_55480_56558 = state_55466__$1;
(statearr_55480_56558[(2)] = inst_55458);

(statearr_55480_56558[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55467 === (8))){
var inst_55446 = (state_55466[(7)]);
var inst_55447 = (state_55466[(9)]);
var inst_55436 = (state_55466[(10)]);
var inst_55445 = (state_55466[(8)]);
var inst_55450 = (function (){var cs = inst_55436;
var vec__55441 = inst_55445;
var v = inst_55446;
var c = inst_55447;
return (function (p1__55432_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__55432_SHARP_);
});
})();
var inst_55451 = cljs.core.filterv.call(null,inst_55450,inst_55436);
var inst_55436__$1 = inst_55451;
var state_55466__$1 = (function (){var statearr_55481 = state_55466;
(statearr_55481[(10)] = inst_55436__$1);

return statearr_55481;
})();
var statearr_55482_56567 = state_55466__$1;
(statearr_55482_56567[(2)] = null);

(statearr_55482_56567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55483 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55483[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55483[(1)] = (1));

return statearr_55483;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55466){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55484){if((e55484 instanceof Object)){
var ex__54298__auto__ = e55484;
var statearr_55485_56576 = state_55466;
(statearr_55485_56576[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55466);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55484;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56577 = state_55466;
state_55466 = G__56577;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55466){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55486 = f__54379__auto__.call(null);
(statearr_55486[(6)] = c__54378__auto___56546);

return statearr_55486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__55488 = arguments.length;
switch (G__55488) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54378__auto___56583 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55512){
var state_val_55513 = (state_55512[(1)]);
if((state_val_55513 === (7))){
var inst_55494 = (state_55512[(7)]);
var inst_55494__$1 = (state_55512[(2)]);
var inst_55495 = (inst_55494__$1 == null);
var inst_55496 = cljs.core.not.call(null,inst_55495);
var state_55512__$1 = (function (){var statearr_55514 = state_55512;
(statearr_55514[(7)] = inst_55494__$1);

return statearr_55514;
})();
if(inst_55496){
var statearr_55515_56589 = state_55512__$1;
(statearr_55515_56589[(1)] = (8));

} else {
var statearr_55516_56591 = state_55512__$1;
(statearr_55516_56591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (1))){
var inst_55489 = (0);
var state_55512__$1 = (function (){var statearr_55517 = state_55512;
(statearr_55517[(8)] = inst_55489);

return statearr_55517;
})();
var statearr_55518_56596 = state_55512__$1;
(statearr_55518_56596[(2)] = null);

(statearr_55518_56596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (4))){
var state_55512__$1 = state_55512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55512__$1,(7),ch);
} else {
if((state_val_55513 === (6))){
var inst_55507 = (state_55512[(2)]);
var state_55512__$1 = state_55512;
var statearr_55519_56598 = state_55512__$1;
(statearr_55519_56598[(2)] = inst_55507);

(statearr_55519_56598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (3))){
var inst_55509 = (state_55512[(2)]);
var inst_55510 = cljs.core.async.close_BANG_.call(null,out);
var state_55512__$1 = (function (){var statearr_55520 = state_55512;
(statearr_55520[(9)] = inst_55509);

return statearr_55520;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55512__$1,inst_55510);
} else {
if((state_val_55513 === (2))){
var inst_55489 = (state_55512[(8)]);
var inst_55491 = (inst_55489 < n);
var state_55512__$1 = state_55512;
if(cljs.core.truth_(inst_55491)){
var statearr_55521_56604 = state_55512__$1;
(statearr_55521_56604[(1)] = (4));

} else {
var statearr_55522_56609 = state_55512__$1;
(statearr_55522_56609[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (11))){
var inst_55489 = (state_55512[(8)]);
var inst_55499 = (state_55512[(2)]);
var inst_55500 = (inst_55489 + (1));
var inst_55489__$1 = inst_55500;
var state_55512__$1 = (function (){var statearr_55523 = state_55512;
(statearr_55523[(10)] = inst_55499);

(statearr_55523[(8)] = inst_55489__$1);

return statearr_55523;
})();
var statearr_55524_56614 = state_55512__$1;
(statearr_55524_56614[(2)] = null);

(statearr_55524_56614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (9))){
var state_55512__$1 = state_55512;
var statearr_55525_56618 = state_55512__$1;
(statearr_55525_56618[(2)] = null);

(statearr_55525_56618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (5))){
var state_55512__$1 = state_55512;
var statearr_55526_56619 = state_55512__$1;
(statearr_55526_56619[(2)] = null);

(statearr_55526_56619[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (10))){
var inst_55504 = (state_55512[(2)]);
var state_55512__$1 = state_55512;
var statearr_55527_56620 = state_55512__$1;
(statearr_55527_56620[(2)] = inst_55504);

(statearr_55527_56620[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55513 === (8))){
var inst_55494 = (state_55512[(7)]);
var state_55512__$1 = state_55512;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55512__$1,(11),out,inst_55494);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55528 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55528[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55528[(1)] = (1));

return statearr_55528;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55512){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55529){if((e55529 instanceof Object)){
var ex__54298__auto__ = e55529;
var statearr_55530_56624 = state_55512;
(statearr_55530_56624[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55529;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56626 = state_55512;
state_55512 = G__56626;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55531 = f__54379__auto__.call(null);
(statearr_55531[(6)] = c__54378__auto___56583);

return statearr_55531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55533 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55533 = (function (f,ch,meta55534){
this.f = f;
this.ch = ch;
this.meta55534 = meta55534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55535,meta55534__$1){
var self__ = this;
var _55535__$1 = this;
return (new cljs.core.async.t_cljs$core$async55533(self__.f,self__.ch,meta55534__$1));
}));

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55535){
var self__ = this;
var _55535__$1 = this;
return self__.meta55534;
}));

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55536 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55536 = (function (f,ch,meta55534,_,fn1,meta55537){
this.f = f;
this.ch = ch;
this.meta55534 = meta55534;
this._ = _;
this.fn1 = fn1;
this.meta55537 = meta55537;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async55536.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55538,meta55537__$1){
var self__ = this;
var _55538__$1 = this;
return (new cljs.core.async.t_cljs$core$async55536(self__.f,self__.ch,self__.meta55534,self__._,self__.fn1,meta55537__$1));
}));

(cljs.core.async.t_cljs$core$async55536.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55538){
var self__ = this;
var _55538__$1 = this;
return self__.meta55537;
}));

(cljs.core.async.t_cljs$core$async55536.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55536.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async55536.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async55536.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__55532_SHARP_){
return f1.call(null,(((p1__55532_SHARP_ == null))?null:self__.f.call(null,p1__55532_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async55536.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55534","meta55534",557003670,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async55533","cljs.core.async/t_cljs$core$async55533",1902642219,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta55537","meta55537",1324934608,null)], null);
}));

(cljs.core.async.t_cljs$core$async55536.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async55536.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55536");

(cljs.core.async.t_cljs$core$async55536.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async55536");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55536.
 */
cljs.core.async.__GT_t_cljs$core$async55536 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async55536(f__$1,ch__$1,meta55534__$1,___$2,fn1__$1,meta55537){
return (new cljs.core.async.t_cljs$core$async55536(f__$1,ch__$1,meta55534__$1,___$2,fn1__$1,meta55537));
});

}

return (new cljs.core.async.t_cljs$core$async55536(self__.f,self__.ch,self__.meta55534,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5583__auto__ = ret;
if(cljs.core.truth_(and__5583__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__5583__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55533.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async55533.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55534","meta55534",557003670,null)], null);
}));

(cljs.core.async.t_cljs$core$async55533.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async55533.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55533");

(cljs.core.async.t_cljs$core$async55533.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async55533");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55533.
 */
cljs.core.async.__GT_t_cljs$core$async55533 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async55533(f__$1,ch__$1,meta55534){
return (new cljs.core.async.t_cljs$core$async55533(f__$1,ch__$1,meta55534));
});

}

return (new cljs.core.async.t_cljs$core$async55533(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55539 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55539 = (function (f,ch,meta55540){
this.f = f;
this.ch = ch;
this.meta55540 = meta55540;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55541,meta55540__$1){
var self__ = this;
var _55541__$1 = this;
return (new cljs.core.async.t_cljs$core$async55539(self__.f,self__.ch,meta55540__$1));
}));

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55541){
var self__ = this;
var _55541__$1 = this;
return self__.meta55540;
}));

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55539.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async55539.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55540","meta55540",-1872454146,null)], null);
}));

(cljs.core.async.t_cljs$core$async55539.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async55539.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55539");

(cljs.core.async.t_cljs$core$async55539.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async55539");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55539.
 */
cljs.core.async.__GT_t_cljs$core$async55539 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async55539(f__$1,ch__$1,meta55540){
return (new cljs.core.async.t_cljs$core$async55539(f__$1,ch__$1,meta55540));
});

}

return (new cljs.core.async.t_cljs$core$async55539(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async55542 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async55542 = (function (p,ch,meta55543){
this.p = p;
this.ch = ch;
this.meta55543 = meta55543;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_55544,meta55543__$1){
var self__ = this;
var _55544__$1 = this;
return (new cljs.core.async.t_cljs$core$async55542(self__.p,self__.ch,meta55543__$1));
}));

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_55544){
var self__ = this;
var _55544__$1 = this;
return self__.meta55543;
}));

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async55542.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async55542.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta55543","meta55543",-1360672891,null)], null);
}));

(cljs.core.async.t_cljs$core$async55542.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async55542.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async55542");

(cljs.core.async.t_cljs$core$async55542.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core.async/t_cljs$core$async55542");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async55542.
 */
cljs.core.async.__GT_t_cljs$core$async55542 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async55542(p__$1,ch__$1,meta55543){
return (new cljs.core.async.t_cljs$core$async55542(p__$1,ch__$1,meta55543));
});

}

return (new cljs.core.async.t_cljs$core$async55542(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__55546 = arguments.length;
switch (G__55546) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54378__auto___56731 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55567){
var state_val_55568 = (state_55567[(1)]);
if((state_val_55568 === (7))){
var inst_55563 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
var statearr_55569_56732 = state_55567__$1;
(statearr_55569_56732[(2)] = inst_55563);

(statearr_55569_56732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (1))){
var state_55567__$1 = state_55567;
var statearr_55570_56737 = state_55567__$1;
(statearr_55570_56737[(2)] = null);

(statearr_55570_56737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (4))){
var inst_55549 = (state_55567[(7)]);
var inst_55549__$1 = (state_55567[(2)]);
var inst_55550 = (inst_55549__$1 == null);
var state_55567__$1 = (function (){var statearr_55571 = state_55567;
(statearr_55571[(7)] = inst_55549__$1);

return statearr_55571;
})();
if(cljs.core.truth_(inst_55550)){
var statearr_55572_56745 = state_55567__$1;
(statearr_55572_56745[(1)] = (5));

} else {
var statearr_55573_56750 = state_55567__$1;
(statearr_55573_56750[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (6))){
var inst_55549 = (state_55567[(7)]);
var inst_55554 = p.call(null,inst_55549);
var state_55567__$1 = state_55567;
if(cljs.core.truth_(inst_55554)){
var statearr_55574_56751 = state_55567__$1;
(statearr_55574_56751[(1)] = (8));

} else {
var statearr_55575_56753 = state_55567__$1;
(statearr_55575_56753[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (3))){
var inst_55565 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55567__$1,inst_55565);
} else {
if((state_val_55568 === (2))){
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55567__$1,(4),ch);
} else {
if((state_val_55568 === (11))){
var inst_55557 = (state_55567[(2)]);
var state_55567__$1 = state_55567;
var statearr_55576_56755 = state_55567__$1;
(statearr_55576_56755[(2)] = inst_55557);

(statearr_55576_56755[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (9))){
var state_55567__$1 = state_55567;
var statearr_55577_56756 = state_55567__$1;
(statearr_55577_56756[(2)] = null);

(statearr_55577_56756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (5))){
var inst_55552 = cljs.core.async.close_BANG_.call(null,out);
var state_55567__$1 = state_55567;
var statearr_55578_56760 = state_55567__$1;
(statearr_55578_56760[(2)] = inst_55552);

(statearr_55578_56760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (10))){
var inst_55560 = (state_55567[(2)]);
var state_55567__$1 = (function (){var statearr_55579 = state_55567;
(statearr_55579[(8)] = inst_55560);

return statearr_55579;
})();
var statearr_55580_56761 = state_55567__$1;
(statearr_55580_56761[(2)] = null);

(statearr_55580_56761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55568 === (8))){
var inst_55549 = (state_55567[(7)]);
var state_55567__$1 = state_55567;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55567__$1,(11),out,inst_55549);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55581 = [null,null,null,null,null,null,null,null,null];
(statearr_55581[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55581[(1)] = (1));

return statearr_55581;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55567){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55567);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55582){if((e55582 instanceof Object)){
var ex__54298__auto__ = e55582;
var statearr_55583_56763 = state_55567;
(statearr_55583_56763[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55582;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56764 = state_55567;
state_55567 = G__56764;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55567){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55584 = f__54379__auto__.call(null);
(statearr_55584[(6)] = c__54378__auto___56731);

return statearr_55584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__55586 = arguments.length;
switch (G__55586) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__54378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55648){
var state_val_55649 = (state_55648[(1)]);
if((state_val_55649 === (7))){
var inst_55644 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
var statearr_55650_56817 = state_55648__$1;
(statearr_55650_56817[(2)] = inst_55644);

(statearr_55650_56817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (20))){
var inst_55614 = (state_55648[(7)]);
var inst_55625 = (state_55648[(2)]);
var inst_55626 = cljs.core.next.call(null,inst_55614);
var inst_55600 = inst_55626;
var inst_55601 = null;
var inst_55602 = (0);
var inst_55603 = (0);
var state_55648__$1 = (function (){var statearr_55651 = state_55648;
(statearr_55651[(8)] = inst_55603);

(statearr_55651[(9)] = inst_55625);

(statearr_55651[(10)] = inst_55602);

(statearr_55651[(11)] = inst_55600);

(statearr_55651[(12)] = inst_55601);

return statearr_55651;
})();
var statearr_55652_56828 = state_55648__$1;
(statearr_55652_56828[(2)] = null);

(statearr_55652_56828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (1))){
var state_55648__$1 = state_55648;
var statearr_55653_56830 = state_55648__$1;
(statearr_55653_56830[(2)] = null);

(statearr_55653_56830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (4))){
var inst_55589 = (state_55648[(13)]);
var inst_55589__$1 = (state_55648[(2)]);
var inst_55590 = (inst_55589__$1 == null);
var state_55648__$1 = (function (){var statearr_55654 = state_55648;
(statearr_55654[(13)] = inst_55589__$1);

return statearr_55654;
})();
if(cljs.core.truth_(inst_55590)){
var statearr_55655_56834 = state_55648__$1;
(statearr_55655_56834[(1)] = (5));

} else {
var statearr_55656_56835 = state_55648__$1;
(statearr_55656_56835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (15))){
var state_55648__$1 = state_55648;
var statearr_55660_56836 = state_55648__$1;
(statearr_55660_56836[(2)] = null);

(statearr_55660_56836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (21))){
var state_55648__$1 = state_55648;
var statearr_55661_56837 = state_55648__$1;
(statearr_55661_56837[(2)] = null);

(statearr_55661_56837[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (13))){
var inst_55603 = (state_55648[(8)]);
var inst_55602 = (state_55648[(10)]);
var inst_55600 = (state_55648[(11)]);
var inst_55601 = (state_55648[(12)]);
var inst_55610 = (state_55648[(2)]);
var inst_55611 = (inst_55603 + (1));
var tmp55657 = inst_55602;
var tmp55658 = inst_55600;
var tmp55659 = inst_55601;
var inst_55600__$1 = tmp55658;
var inst_55601__$1 = tmp55659;
var inst_55602__$1 = tmp55657;
var inst_55603__$1 = inst_55611;
var state_55648__$1 = (function (){var statearr_55662 = state_55648;
(statearr_55662[(8)] = inst_55603__$1);

(statearr_55662[(10)] = inst_55602__$1);

(statearr_55662[(14)] = inst_55610);

(statearr_55662[(11)] = inst_55600__$1);

(statearr_55662[(12)] = inst_55601__$1);

return statearr_55662;
})();
var statearr_55663_56845 = state_55648__$1;
(statearr_55663_56845[(2)] = null);

(statearr_55663_56845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (22))){
var state_55648__$1 = state_55648;
var statearr_55664_56846 = state_55648__$1;
(statearr_55664_56846[(2)] = null);

(statearr_55664_56846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (6))){
var inst_55589 = (state_55648[(13)]);
var inst_55598 = f.call(null,inst_55589);
var inst_55599 = cljs.core.seq.call(null,inst_55598);
var inst_55600 = inst_55599;
var inst_55601 = null;
var inst_55602 = (0);
var inst_55603 = (0);
var state_55648__$1 = (function (){var statearr_55665 = state_55648;
(statearr_55665[(8)] = inst_55603);

(statearr_55665[(10)] = inst_55602);

(statearr_55665[(11)] = inst_55600);

(statearr_55665[(12)] = inst_55601);

return statearr_55665;
})();
var statearr_55666_56847 = state_55648__$1;
(statearr_55666_56847[(2)] = null);

(statearr_55666_56847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (17))){
var inst_55614 = (state_55648[(7)]);
var inst_55618 = cljs.core.chunk_first.call(null,inst_55614);
var inst_55619 = cljs.core.chunk_rest.call(null,inst_55614);
var inst_55620 = cljs.core.count.call(null,inst_55618);
var inst_55600 = inst_55619;
var inst_55601 = inst_55618;
var inst_55602 = inst_55620;
var inst_55603 = (0);
var state_55648__$1 = (function (){var statearr_55667 = state_55648;
(statearr_55667[(8)] = inst_55603);

(statearr_55667[(10)] = inst_55602);

(statearr_55667[(11)] = inst_55600);

(statearr_55667[(12)] = inst_55601);

return statearr_55667;
})();
var statearr_55668_56856 = state_55648__$1;
(statearr_55668_56856[(2)] = null);

(statearr_55668_56856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (3))){
var inst_55646 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55648__$1,inst_55646);
} else {
if((state_val_55649 === (12))){
var inst_55634 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
var statearr_55669_56861 = state_55648__$1;
(statearr_55669_56861[(2)] = inst_55634);

(statearr_55669_56861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (2))){
var state_55648__$1 = state_55648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55648__$1,(4),in$);
} else {
if((state_val_55649 === (23))){
var inst_55642 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
var statearr_55670_56864 = state_55648__$1;
(statearr_55670_56864[(2)] = inst_55642);

(statearr_55670_56864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (19))){
var inst_55629 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
var statearr_55671_56865 = state_55648__$1;
(statearr_55671_56865[(2)] = inst_55629);

(statearr_55671_56865[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (11))){
var inst_55600 = (state_55648[(11)]);
var inst_55614 = (state_55648[(7)]);
var inst_55614__$1 = cljs.core.seq.call(null,inst_55600);
var state_55648__$1 = (function (){var statearr_55672 = state_55648;
(statearr_55672[(7)] = inst_55614__$1);

return statearr_55672;
})();
if(inst_55614__$1){
var statearr_55673_56867 = state_55648__$1;
(statearr_55673_56867[(1)] = (14));

} else {
var statearr_55674_56869 = state_55648__$1;
(statearr_55674_56869[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (9))){
var inst_55636 = (state_55648[(2)]);
var inst_55637 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_55648__$1 = (function (){var statearr_55675 = state_55648;
(statearr_55675[(15)] = inst_55636);

return statearr_55675;
})();
if(cljs.core.truth_(inst_55637)){
var statearr_55676_56870 = state_55648__$1;
(statearr_55676_56870[(1)] = (21));

} else {
var statearr_55677_56871 = state_55648__$1;
(statearr_55677_56871[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (5))){
var inst_55592 = cljs.core.async.close_BANG_.call(null,out);
var state_55648__$1 = state_55648;
var statearr_55678_56872 = state_55648__$1;
(statearr_55678_56872[(2)] = inst_55592);

(statearr_55678_56872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (14))){
var inst_55614 = (state_55648[(7)]);
var inst_55616 = cljs.core.chunked_seq_QMARK_.call(null,inst_55614);
var state_55648__$1 = state_55648;
if(inst_55616){
var statearr_55679_56873 = state_55648__$1;
(statearr_55679_56873[(1)] = (17));

} else {
var statearr_55680_56874 = state_55648__$1;
(statearr_55680_56874[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (16))){
var inst_55632 = (state_55648[(2)]);
var state_55648__$1 = state_55648;
var statearr_55681_56875 = state_55648__$1;
(statearr_55681_56875[(2)] = inst_55632);

(statearr_55681_56875[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55649 === (10))){
var inst_55603 = (state_55648[(8)]);
var inst_55601 = (state_55648[(12)]);
var inst_55608 = cljs.core._nth.call(null,inst_55601,inst_55603);
var state_55648__$1 = state_55648;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55648__$1,(13),out,inst_55608);
} else {
if((state_val_55649 === (18))){
var inst_55614 = (state_55648[(7)]);
var inst_55623 = cljs.core.first.call(null,inst_55614);
var state_55648__$1 = state_55648;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55648__$1,(20),out,inst_55623);
} else {
if((state_val_55649 === (8))){
var inst_55603 = (state_55648[(8)]);
var inst_55602 = (state_55648[(10)]);
var inst_55605 = (inst_55603 < inst_55602);
var inst_55606 = inst_55605;
var state_55648__$1 = state_55648;
if(cljs.core.truth_(inst_55606)){
var statearr_55682_56876 = state_55648__$1;
(statearr_55682_56876[(1)] = (10));

} else {
var statearr_55683_56878 = state_55648__$1;
(statearr_55683_56878[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__54295__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__54295__auto____0 = (function (){
var statearr_55684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55684[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__54295__auto__);

(statearr_55684[(1)] = (1));

return statearr_55684;
});
var cljs$core$async$mapcat_STAR__$_state_machine__54295__auto____1 = (function (state_55648){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55685){if((e55685 instanceof Object)){
var ex__54298__auto__ = e55685;
var statearr_55686_56880 = state_55648;
(statearr_55686_56880[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55685;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56881 = state_55648;
state_55648 = G__56881;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__54295__auto__ = function(state_55648){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__54295__auto____1.call(this,state_55648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__54295__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__54295__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55687 = f__54379__auto__.call(null);
(statearr_55687[(6)] = c__54378__auto__);

return statearr_55687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

return c__54378__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__55689 = arguments.length;
switch (G__55689) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__55691 = arguments.length;
switch (G__55691) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__55693 = arguments.length;
switch (G__55693) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54378__auto___56891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55717){
var state_val_55718 = (state_55717[(1)]);
if((state_val_55718 === (7))){
var inst_55712 = (state_55717[(2)]);
var state_55717__$1 = state_55717;
var statearr_55719_56892 = state_55717__$1;
(statearr_55719_56892[(2)] = inst_55712);

(statearr_55719_56892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (1))){
var inst_55694 = null;
var state_55717__$1 = (function (){var statearr_55720 = state_55717;
(statearr_55720[(7)] = inst_55694);

return statearr_55720;
})();
var statearr_55721_56897 = state_55717__$1;
(statearr_55721_56897[(2)] = null);

(statearr_55721_56897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (4))){
var inst_55697 = (state_55717[(8)]);
var inst_55697__$1 = (state_55717[(2)]);
var inst_55698 = (inst_55697__$1 == null);
var inst_55699 = cljs.core.not.call(null,inst_55698);
var state_55717__$1 = (function (){var statearr_55722 = state_55717;
(statearr_55722[(8)] = inst_55697__$1);

return statearr_55722;
})();
if(inst_55699){
var statearr_55723_56898 = state_55717__$1;
(statearr_55723_56898[(1)] = (5));

} else {
var statearr_55724_56899 = state_55717__$1;
(statearr_55724_56899[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (6))){
var state_55717__$1 = state_55717;
var statearr_55725_56901 = state_55717__$1;
(statearr_55725_56901[(2)] = null);

(statearr_55725_56901[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (3))){
var inst_55714 = (state_55717[(2)]);
var inst_55715 = cljs.core.async.close_BANG_.call(null,out);
var state_55717__$1 = (function (){var statearr_55726 = state_55717;
(statearr_55726[(9)] = inst_55714);

return statearr_55726;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55717__$1,inst_55715);
} else {
if((state_val_55718 === (2))){
var state_55717__$1 = state_55717;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55717__$1,(4),ch);
} else {
if((state_val_55718 === (11))){
var inst_55697 = (state_55717[(8)]);
var inst_55706 = (state_55717[(2)]);
var inst_55694 = inst_55697;
var state_55717__$1 = (function (){var statearr_55727 = state_55717;
(statearr_55727[(10)] = inst_55706);

(statearr_55727[(7)] = inst_55694);

return statearr_55727;
})();
var statearr_55728_56902 = state_55717__$1;
(statearr_55728_56902[(2)] = null);

(statearr_55728_56902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (9))){
var inst_55697 = (state_55717[(8)]);
var state_55717__$1 = state_55717;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55717__$1,(11),out,inst_55697);
} else {
if((state_val_55718 === (5))){
var inst_55694 = (state_55717[(7)]);
var inst_55697 = (state_55717[(8)]);
var inst_55701 = cljs.core._EQ_.call(null,inst_55697,inst_55694);
var state_55717__$1 = state_55717;
if(inst_55701){
var statearr_55730_56903 = state_55717__$1;
(statearr_55730_56903[(1)] = (8));

} else {
var statearr_55731_56904 = state_55717__$1;
(statearr_55731_56904[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (10))){
var inst_55709 = (state_55717[(2)]);
var state_55717__$1 = state_55717;
var statearr_55732_56905 = state_55717__$1;
(statearr_55732_56905[(2)] = inst_55709);

(statearr_55732_56905[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55718 === (8))){
var inst_55694 = (state_55717[(7)]);
var tmp55729 = inst_55694;
var inst_55694__$1 = tmp55729;
var state_55717__$1 = (function (){var statearr_55733 = state_55717;
(statearr_55733[(7)] = inst_55694__$1);

return statearr_55733;
})();
var statearr_55734_56909 = state_55717__$1;
(statearr_55734_56909[(2)] = null);

(statearr_55734_56909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55735 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55735[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55735[(1)] = (1));

return statearr_55735;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55717){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55736){if((e55736 instanceof Object)){
var ex__54298__auto__ = e55736;
var statearr_55737_56910 = state_55717;
(statearr_55737_56910[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55717);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56911 = state_55717;
state_55717 = G__56911;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55717){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55738 = f__54379__auto__.call(null);
(statearr_55738[(6)] = c__54378__auto___56891);

return statearr_55738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__55740 = arguments.length;
switch (G__55740) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54378__auto___56914 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55778){
var state_val_55779 = (state_55778[(1)]);
if((state_val_55779 === (7))){
var inst_55774 = (state_55778[(2)]);
var state_55778__$1 = state_55778;
var statearr_55780_56916 = state_55778__$1;
(statearr_55780_56916[(2)] = inst_55774);

(statearr_55780_56916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (1))){
var inst_55741 = (new Array(n));
var inst_55742 = inst_55741;
var inst_55743 = (0);
var state_55778__$1 = (function (){var statearr_55781 = state_55778;
(statearr_55781[(7)] = inst_55742);

(statearr_55781[(8)] = inst_55743);

return statearr_55781;
})();
var statearr_55782_56917 = state_55778__$1;
(statearr_55782_56917[(2)] = null);

(statearr_55782_56917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (4))){
var inst_55746 = (state_55778[(9)]);
var inst_55746__$1 = (state_55778[(2)]);
var inst_55747 = (inst_55746__$1 == null);
var inst_55748 = cljs.core.not.call(null,inst_55747);
var state_55778__$1 = (function (){var statearr_55783 = state_55778;
(statearr_55783[(9)] = inst_55746__$1);

return statearr_55783;
})();
if(inst_55748){
var statearr_55784_56920 = state_55778__$1;
(statearr_55784_56920[(1)] = (5));

} else {
var statearr_55785_56921 = state_55778__$1;
(statearr_55785_56921[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (15))){
var inst_55768 = (state_55778[(2)]);
var state_55778__$1 = state_55778;
var statearr_55786_56923 = state_55778__$1;
(statearr_55786_56923[(2)] = inst_55768);

(statearr_55786_56923[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (13))){
var state_55778__$1 = state_55778;
var statearr_55787_56924 = state_55778__$1;
(statearr_55787_56924[(2)] = null);

(statearr_55787_56924[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (6))){
var inst_55743 = (state_55778[(8)]);
var inst_55764 = (inst_55743 > (0));
var state_55778__$1 = state_55778;
if(cljs.core.truth_(inst_55764)){
var statearr_55788_56925 = state_55778__$1;
(statearr_55788_56925[(1)] = (12));

} else {
var statearr_55789_56926 = state_55778__$1;
(statearr_55789_56926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (3))){
var inst_55776 = (state_55778[(2)]);
var state_55778__$1 = state_55778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55778__$1,inst_55776);
} else {
if((state_val_55779 === (12))){
var inst_55742 = (state_55778[(7)]);
var inst_55766 = cljs.core.vec.call(null,inst_55742);
var state_55778__$1 = state_55778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55778__$1,(15),out,inst_55766);
} else {
if((state_val_55779 === (2))){
var state_55778__$1 = state_55778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55778__$1,(4),ch);
} else {
if((state_val_55779 === (11))){
var inst_55758 = (state_55778[(2)]);
var inst_55759 = (new Array(n));
var inst_55742 = inst_55759;
var inst_55743 = (0);
var state_55778__$1 = (function (){var statearr_55790 = state_55778;
(statearr_55790[(10)] = inst_55758);

(statearr_55790[(7)] = inst_55742);

(statearr_55790[(8)] = inst_55743);

return statearr_55790;
})();
var statearr_55791_56929 = state_55778__$1;
(statearr_55791_56929[(2)] = null);

(statearr_55791_56929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (9))){
var inst_55742 = (state_55778[(7)]);
var inst_55756 = cljs.core.vec.call(null,inst_55742);
var state_55778__$1 = state_55778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55778__$1,(11),out,inst_55756);
} else {
if((state_val_55779 === (5))){
var inst_55751 = (state_55778[(11)]);
var inst_55746 = (state_55778[(9)]);
var inst_55742 = (state_55778[(7)]);
var inst_55743 = (state_55778[(8)]);
var inst_55750 = (inst_55742[inst_55743] = inst_55746);
var inst_55751__$1 = (inst_55743 + (1));
var inst_55752 = (inst_55751__$1 < n);
var state_55778__$1 = (function (){var statearr_55792 = state_55778;
(statearr_55792[(11)] = inst_55751__$1);

(statearr_55792[(12)] = inst_55750);

return statearr_55792;
})();
if(cljs.core.truth_(inst_55752)){
var statearr_55793_56943 = state_55778__$1;
(statearr_55793_56943[(1)] = (8));

} else {
var statearr_55794_56944 = state_55778__$1;
(statearr_55794_56944[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (14))){
var inst_55771 = (state_55778[(2)]);
var inst_55772 = cljs.core.async.close_BANG_.call(null,out);
var state_55778__$1 = (function (){var statearr_55796 = state_55778;
(statearr_55796[(13)] = inst_55771);

return statearr_55796;
})();
var statearr_55797_56949 = state_55778__$1;
(statearr_55797_56949[(2)] = inst_55772);

(statearr_55797_56949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (10))){
var inst_55762 = (state_55778[(2)]);
var state_55778__$1 = state_55778;
var statearr_55798_56962 = state_55778__$1;
(statearr_55798_56962[(2)] = inst_55762);

(statearr_55798_56962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55779 === (8))){
var inst_55751 = (state_55778[(11)]);
var inst_55742 = (state_55778[(7)]);
var tmp55795 = inst_55742;
var inst_55742__$1 = tmp55795;
var inst_55743 = inst_55751;
var state_55778__$1 = (function (){var statearr_55799 = state_55778;
(statearr_55799[(7)] = inst_55742__$1);

(statearr_55799[(8)] = inst_55743);

return statearr_55799;
})();
var statearr_55800_56969 = state_55778__$1;
(statearr_55800_56969[(2)] = null);

(statearr_55800_56969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55801[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55801[(1)] = (1));

return statearr_55801;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55778){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55802){if((e55802 instanceof Object)){
var ex__54298__auto__ = e55802;
var statearr_55803_56981 = state_55778;
(statearr_55803_56981[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55802;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57000 = state_55778;
state_55778 = G__57000;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55804 = f__54379__auto__.call(null);
(statearr_55804[(6)] = c__54378__auto___56914);

return statearr_55804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__55806 = arguments.length;
switch (G__55806) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__54378__auto___57033 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_55848){
var state_val_55849 = (state_55848[(1)]);
if((state_val_55849 === (7))){
var inst_55844 = (state_55848[(2)]);
var state_55848__$1 = state_55848;
var statearr_55850_57050 = state_55848__$1;
(statearr_55850_57050[(2)] = inst_55844);

(statearr_55850_57050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (1))){
var inst_55807 = [];
var inst_55808 = inst_55807;
var inst_55809 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_55848__$1 = (function (){var statearr_55851 = state_55848;
(statearr_55851[(7)] = inst_55808);

(statearr_55851[(8)] = inst_55809);

return statearr_55851;
})();
var statearr_55852_57055 = state_55848__$1;
(statearr_55852_57055[(2)] = null);

(statearr_55852_57055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (4))){
var inst_55812 = (state_55848[(9)]);
var inst_55812__$1 = (state_55848[(2)]);
var inst_55813 = (inst_55812__$1 == null);
var inst_55814 = cljs.core.not.call(null,inst_55813);
var state_55848__$1 = (function (){var statearr_55853 = state_55848;
(statearr_55853[(9)] = inst_55812__$1);

return statearr_55853;
})();
if(inst_55814){
var statearr_55854_57065 = state_55848__$1;
(statearr_55854_57065[(1)] = (5));

} else {
var statearr_55855_57066 = state_55848__$1;
(statearr_55855_57066[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (15))){
var inst_55838 = (state_55848[(2)]);
var state_55848__$1 = state_55848;
var statearr_55856_57075 = state_55848__$1;
(statearr_55856_57075[(2)] = inst_55838);

(statearr_55856_57075[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (13))){
var state_55848__$1 = state_55848;
var statearr_55857_57077 = state_55848__$1;
(statearr_55857_57077[(2)] = null);

(statearr_55857_57077[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (6))){
var inst_55808 = (state_55848[(7)]);
var inst_55833 = inst_55808.length;
var inst_55834 = (inst_55833 > (0));
var state_55848__$1 = state_55848;
if(cljs.core.truth_(inst_55834)){
var statearr_55858_57079 = state_55848__$1;
(statearr_55858_57079[(1)] = (12));

} else {
var statearr_55859_57080 = state_55848__$1;
(statearr_55859_57080[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (3))){
var inst_55846 = (state_55848[(2)]);
var state_55848__$1 = state_55848;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55848__$1,inst_55846);
} else {
if((state_val_55849 === (12))){
var inst_55808 = (state_55848[(7)]);
var inst_55836 = cljs.core.vec.call(null,inst_55808);
var state_55848__$1 = state_55848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55848__$1,(15),out,inst_55836);
} else {
if((state_val_55849 === (2))){
var state_55848__$1 = state_55848;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55848__$1,(4),ch);
} else {
if((state_val_55849 === (11))){
var inst_55816 = (state_55848[(10)]);
var inst_55812 = (state_55848[(9)]);
var inst_55826 = (state_55848[(2)]);
var inst_55827 = [];
var inst_55828 = inst_55827.push(inst_55812);
var inst_55808 = inst_55827;
var inst_55809 = inst_55816;
var state_55848__$1 = (function (){var statearr_55860 = state_55848;
(statearr_55860[(11)] = inst_55826);

(statearr_55860[(7)] = inst_55808);

(statearr_55860[(8)] = inst_55809);

(statearr_55860[(12)] = inst_55828);

return statearr_55860;
})();
var statearr_55861_57085 = state_55848__$1;
(statearr_55861_57085[(2)] = null);

(statearr_55861_57085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (9))){
var inst_55808 = (state_55848[(7)]);
var inst_55824 = cljs.core.vec.call(null,inst_55808);
var state_55848__$1 = state_55848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_55848__$1,(11),out,inst_55824);
} else {
if((state_val_55849 === (5))){
var inst_55816 = (state_55848[(10)]);
var inst_55812 = (state_55848[(9)]);
var inst_55809 = (state_55848[(8)]);
var inst_55816__$1 = f.call(null,inst_55812);
var inst_55817 = cljs.core._EQ_.call(null,inst_55816__$1,inst_55809);
var inst_55818 = cljs.core.keyword_identical_QMARK_.call(null,inst_55809,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_55819 = ((inst_55817) || (inst_55818));
var state_55848__$1 = (function (){var statearr_55862 = state_55848;
(statearr_55862[(10)] = inst_55816__$1);

return statearr_55862;
})();
if(cljs.core.truth_(inst_55819)){
var statearr_55863_57088 = state_55848__$1;
(statearr_55863_57088[(1)] = (8));

} else {
var statearr_55864_57089 = state_55848__$1;
(statearr_55864_57089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (14))){
var inst_55841 = (state_55848[(2)]);
var inst_55842 = cljs.core.async.close_BANG_.call(null,out);
var state_55848__$1 = (function (){var statearr_55866 = state_55848;
(statearr_55866[(13)] = inst_55841);

return statearr_55866;
})();
var statearr_55867_57091 = state_55848__$1;
(statearr_55867_57091[(2)] = inst_55842);

(statearr_55867_57091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (10))){
var inst_55831 = (state_55848[(2)]);
var state_55848__$1 = state_55848;
var statearr_55868_57092 = state_55848__$1;
(statearr_55868_57092[(2)] = inst_55831);

(statearr_55868_57092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55849 === (8))){
var inst_55808 = (state_55848[(7)]);
var inst_55816 = (state_55848[(10)]);
var inst_55812 = (state_55848[(9)]);
var inst_55821 = inst_55808.push(inst_55812);
var tmp55865 = inst_55808;
var inst_55808__$1 = tmp55865;
var inst_55809 = inst_55816;
var state_55848__$1 = (function (){var statearr_55869 = state_55848;
(statearr_55869[(14)] = inst_55821);

(statearr_55869[(7)] = inst_55808__$1);

(statearr_55869[(8)] = inst_55809);

return statearr_55869;
})();
var statearr_55870_57093 = state_55848__$1;
(statearr_55870_57093[(2)] = null);

(statearr_55870_57093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__54295__auto__ = null;
var cljs$core$async$state_machine__54295__auto____0 = (function (){
var statearr_55871 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55871[(0)] = cljs$core$async$state_machine__54295__auto__);

(statearr_55871[(1)] = (1));

return statearr_55871;
});
var cljs$core$async$state_machine__54295__auto____1 = (function (state_55848){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_55848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e55872){if((e55872 instanceof Object)){
var ex__54298__auto__ = e55872;
var statearr_55873_57097 = state_55848;
(statearr_55873_57097[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_55848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e55872;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57099 = state_55848;
state_55848 = G__57099;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
cljs$core$async$state_machine__54295__auto__ = function(state_55848){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__54295__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__54295__auto____1.call(this,state_55848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__54295__auto____0;
cljs$core$async$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__54295__auto____1;
return cljs$core$async$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_55874 = f__54379__auto__.call(null);
(statearr_55874[(6)] = c__54378__auto___57033);

return statearr_55874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
