goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.call(null,null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return cljs.core._vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.active_modules_ref,cljs.core.conj.call(null,cljs.core._deref.call(null,shadow.cljs.devtools.client.browser.active_modules_ref),cljs.core.keyword.call(null,name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_.call(null,null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48878 = arguments.length;
var i__4731__auto___48879 = (0);
while(true){
if((i__4731__auto___48879 < len__4730__auto___48878)){
args__4736__auto__.push((arguments[i__4731__auto___48879]));

var G__48880 = (i__4731__auto___48879 + (1));
i__4731__auto___48879 = G__48880;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(null,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq48613){
var G__48614 = cljs.core.first.call(null,seq48613);
var seq48613__$1 = cljs.core.next.call(null,seq48613);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48614,seq48613__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5718__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s.send(cljs.core.pr_str.call(null,msg));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.call(null,msg));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__48624){
var map__48625 = p__48624;
var map__48625__$1 = (((((!((map__48625 == null))))?(((((map__48625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48625):map__48625);
var src = map__48625__$1;
var resource_id = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__48625__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4131__auto__ = cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_.call(null,output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__48632 = cljs.core.seq.call(null,sources);
var chunk__48633 = null;
var count__48634 = (0);
var i__48635 = (0);
while(true){
if((i__48635 < count__48634)){
var map__48643 = cljs.core._nth.call(null,chunk__48633,i__48635);
var map__48643__$1 = (((((!((map__48643 == null))))?(((((map__48643.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48643.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48643):map__48643);
var src = map__48643__$1;
var resource_id = cljs.core.get.call(null,map__48643__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__48643__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__48643__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__48643__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__48886 = seq__48632;
var G__48887 = chunk__48633;
var G__48888 = count__48634;
var G__48889 = (i__48635 + (1));
seq__48632 = G__48886;
chunk__48633 = G__48887;
count__48634 = G__48888;
i__48635 = G__48889;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__48632);
if(temp__5720__auto__){
var seq__48632__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48632__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__48632__$1);
var G__48890 = cljs.core.chunk_rest.call(null,seq__48632__$1);
var G__48891 = c__4550__auto__;
var G__48892 = cljs.core.count.call(null,c__4550__auto__);
var G__48893 = (0);
seq__48632 = G__48890;
chunk__48633 = G__48891;
count__48634 = G__48892;
i__48635 = G__48893;
continue;
} else {
var map__48654 = cljs.core.first.call(null,seq__48632__$1);
var map__48654__$1 = (((((!((map__48654 == null))))?(((((map__48654.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48654.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48654):map__48654);
var src = map__48654__$1;
var resource_id = cljs.core.get.call(null,map__48654__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__48654__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__48654__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__48654__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__48894 = cljs.core.next.call(null,seq__48632__$1);
var G__48895 = null;
var G__48896 = (0);
var G__48897 = (0);
seq__48632 = G__48894;
chunk__48633 = G__48895;
count__48634 = G__48896;
i__48635 = G__48897;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,cljs.core.assoc.call(null,msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})),(function (){
return shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__48660 = cljs.core.seq.call(null,js_requires);
var chunk__48661 = null;
var count__48662 = (0);
var i__48663 = (0);
while(true){
if((i__48663 < count__48662)){
var js_ns = cljs.core._nth.call(null,chunk__48661,i__48663);
var require_str_48898 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_48898);


var G__48899 = seq__48660;
var G__48900 = chunk__48661;
var G__48901 = count__48662;
var G__48902 = (i__48663 + (1));
seq__48660 = G__48899;
chunk__48661 = G__48900;
count__48662 = G__48901;
i__48663 = G__48902;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__48660);
if(temp__5720__auto__){
var seq__48660__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48660__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__48660__$1);
var G__48903 = cljs.core.chunk_rest.call(null,seq__48660__$1);
var G__48904 = c__4550__auto__;
var G__48905 = cljs.core.count.call(null,c__4550__auto__);
var G__48906 = (0);
seq__48660 = G__48903;
chunk__48661 = G__48904;
count__48662 = G__48905;
i__48663 = G__48906;
continue;
} else {
var js_ns = cljs.core.first.call(null,seq__48660__$1);
var require_str_48907 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_48907);


var G__48908 = cljs.core.next.call(null,seq__48660__$1);
var G__48909 = null;
var G__48910 = (0);
var G__48911 = (0);
seq__48660 = G__48908;
chunk__48661 = G__48909;
count__48662 = G__48910;
i__48663 = G__48911;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_.call(null,sources)){
return callback.call(null,cljs.core.PersistentVector.EMPTY);
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url.call(null),(function (res){
var req = this;
var content = cljs.reader.read_string.call(null,req.getResponseText());
return callback.call(null,content);
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__48680){
var map__48682 = p__48680;
var map__48682__$1 = (((((!((map__48682 == null))))?(((((map__48682.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48682.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48682):map__48682);
var msg = map__48682__$1;
var info = cljs.core.get.call(null,map__48682__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.call(null,map__48682__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__48685 = info;
var map__48685__$1 = (((((!((map__48685 == null))))?(((((map__48685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48685.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48685):map__48685);
var sources = cljs.core.get.call(null,map__48685__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__48685__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.distinct.call(null,(function (){var iter__4523__auto__ = ((function (map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48687(s__48688){
return (new cljs.core.LazySeq(null,((function (map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info){
return (function (){
var s__48688__$1 = s__48688;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__48688__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var map__48694 = cljs.core.first.call(null,xs__6277__auto__);
var map__48694__$1 = (((((!((map__48694 == null))))?(((((map__48694.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48694.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48694):map__48694);
var src = map__48694__$1;
var resource_name = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.call(null,map__48694__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4519__auto__ = ((function (s__48688__$1,map__48694,map__48694__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48687_$_iter__48689(s__48690){
return (new cljs.core.LazySeq(null,((function (s__48688__$1,map__48694,map__48694__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info){
return (function (){
var s__48690__$1 = s__48690;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__48690__$1);
if(temp__5720__auto____$1){
var s__48690__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__48690__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__48690__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__48692 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__48691 = (0);
while(true){
if((i__48691 < size__4522__auto__)){
var warning = cljs.core._nth.call(null,c__4521__auto__,i__48691);
cljs.core.chunk_append.call(null,b__48692,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__48924 = (i__48691 + (1));
i__48691 = G__48924;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__48692),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48687_$_iter__48689.call(null,cljs.core.chunk_rest.call(null,s__48690__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__48692),null);
}
} else {
var warning = cljs.core.first.call(null,s__48690__$2);
return cljs.core.cons.call(null,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48687_$_iter__48689.call(null,cljs.core.rest.call(null,s__48690__$2)));
}
} else {
return null;
}
break;
}
});})(s__48688__$1,map__48694,map__48694__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info))
,null,null));
});})(s__48688__$1,map__48694,map__48694__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info))
;
var fs__4520__auto__ = cljs.core.seq.call(null,iterys__4519__auto__.call(null,warnings));
if(fs__4520__auto__){
return cljs.core.concat.call(null,fs__4520__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__48687.call(null,cljs.core.rest.call(null,s__48688__$1)));
} else {
var G__48932 = cljs.core.rest.call(null,s__48688__$1);
s__48688__$1 = G__48932;
continue;
}
} else {
var G__48933 = cljs.core.rest.call(null,s__48688__$1);
s__48688__$1 = G__48933;
continue;
}
} else {
return null;
}
break;
}
});})(map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info))
,null,null));
});})(map__48685,map__48685__$1,sources,compiled,map__48682,map__48682__$1,msg,info,reload_info))
;
return iter__4523__auto__.call(null,sources);
})()));
var seq__48700_48935 = cljs.core.seq.call(null,warnings);
var chunk__48701_48936 = null;
var count__48702_48937 = (0);
var i__48703_48938 = (0);
while(true){
if((i__48703_48938 < count__48702_48937)){
var map__48709_48939 = cljs.core._nth.call(null,chunk__48701_48936,i__48703_48938);
var map__48709_48940__$1 = (((((!((map__48709_48939 == null))))?(((((map__48709_48939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48709_48939.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48709_48939):map__48709_48939);
var w_48941 = map__48709_48940__$1;
var msg_48942__$1 = cljs.core.get.call(null,map__48709_48940__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_48943 = cljs.core.get.call(null,map__48709_48940__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_48944 = cljs.core.get.call(null,map__48709_48940__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_48945 = cljs.core.get.call(null,map__48709_48940__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_48945)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_48943),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_48944),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_48942__$1)].join(''));


var G__48946 = seq__48700_48935;
var G__48947 = chunk__48701_48936;
var G__48948 = count__48702_48937;
var G__48949 = (i__48703_48938 + (1));
seq__48700_48935 = G__48946;
chunk__48701_48936 = G__48947;
count__48702_48937 = G__48948;
i__48703_48938 = G__48949;
continue;
} else {
var temp__5720__auto___48950 = cljs.core.seq.call(null,seq__48700_48935);
if(temp__5720__auto___48950){
var seq__48700_48954__$1 = temp__5720__auto___48950;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48700_48954__$1)){
var c__4550__auto___48956 = cljs.core.chunk_first.call(null,seq__48700_48954__$1);
var G__48957 = cljs.core.chunk_rest.call(null,seq__48700_48954__$1);
var G__48958 = c__4550__auto___48956;
var G__48959 = cljs.core.count.call(null,c__4550__auto___48956);
var G__48960 = (0);
seq__48700_48935 = G__48957;
chunk__48701_48936 = G__48958;
count__48702_48937 = G__48959;
i__48703_48938 = G__48960;
continue;
} else {
var map__48721_48961 = cljs.core.first.call(null,seq__48700_48954__$1);
var map__48721_48962__$1 = (((((!((map__48721_48961 == null))))?(((((map__48721_48961.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48721_48961.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48721_48961):map__48721_48961);
var w_48963 = map__48721_48962__$1;
var msg_48964__$1 = cljs.core.get.call(null,map__48721_48962__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_48965 = cljs.core.get.call(null,map__48721_48962__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_48966 = cljs.core.get.call(null,map__48721_48962__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_48967 = cljs.core.get.call(null,map__48721_48962__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_48967)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_48965),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_48966),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_48964__$1)].join(''));


var G__48970 = cljs.core.next.call(null,seq__48700_48954__$1);
var G__48971 = null;
var G__48972 = (0);
var G__48973 = (0);
seq__48700_48935 = G__48970;
chunk__48701_48936 = G__48971;
count__48702_48937 = G__48972;
i__48703_48938 = G__48973;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(((cljs.core.empty_QMARK_.call(null,warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,((function (map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info){
return (function (p__48723){
var map__48724 = p__48723;
var map__48724__$1 = (((((!((map__48724 == null))))?(((((map__48724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48724.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48724):map__48724);
var src = map__48724__$1;
var ns = cljs.core.get.call(null,map__48724__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__48724__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src))) || (((cljs.core.contains_QMARK_.call(null,compiled,resource_id)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info))
,cljs.core.remove.call(null,((function (map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info){
return (function (p__48726){
var map__48727 = p__48726;
var map__48727__$1 = (((((!((map__48727 == null))))?(((((map__48727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48727):map__48727);
var ns = cljs.core.get.call(null,map__48727__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info))
,cljs.core.filter.call(null,((function (map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info){
return (function (p__48729){
var map__48730 = p__48729;
var map__48730__$1 = (((((!((map__48730 == null))))?(((((map__48730.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48730.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48730):map__48730);
var rc = map__48730__$1;
var module = cljs.core.get.call(null,map__48730__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.call(null,"js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.browser.module_is_active_QMARK_.call(null,module)));
});})(map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not.call(null,cljs.core.seq.call(null,sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(cljs.core.seq.call(null,cljs.core.get_in.call(null,msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"reloading code but no :after-load hooks are configured!","https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks");
}

return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_get,((function (sources_to_get,map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info){
return (function (p1__48679_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload.call(null,msg,p1__48679_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,map__48685,map__48685__$1,sources,compiled,warnings,map__48682,map__48682__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.call(null,"file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.call(null,new$,(1));
if(((cljs.core._EQ_.call(null,old,rel_new)) || (clojure.string.starts_with_QMARK_.call(null,old,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(rel_new),"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
var and__4120__auto__ = ((cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not.call(null,node_uri.hasDomain())));
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core._EQ_.call(null,node_abs,new$);
if(and__4120__auto____$1){
return new$;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__48736){
var map__48737 = p__48736;
var map__48737__$1 = (((((!((map__48737 == null))))?(((((map__48737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48737.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48737):map__48737);
var msg = map__48737__$1;
var updates = cljs.core.get.call(null,map__48737__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__48739 = cljs.core.seq.call(null,updates);
var chunk__48741 = null;
var count__48742 = (0);
var i__48743 = (0);
while(true){
if((i__48743 < count__48742)){
var path = cljs.core._nth.call(null,chunk__48741,i__48743);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__48771_48976 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__48775_48977 = null;
var count__48776_48978 = (0);
var i__48777_48979 = (0);
while(true){
if((i__48777_48979 < count__48776_48978)){
var node_48980 = cljs.core._nth.call(null,chunk__48775_48977,i__48777_48979);
var path_match_48981 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_48980.getAttribute("href"),path);
if(cljs.core.truth_(path_match_48981)){
var new_link_48982 = (function (){var G__48783 = node_48980.cloneNode(true);
G__48783.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_48981),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48783;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_48981);

goog.dom.insertSiblingAfter(new_link_48982,node_48980);

goog.dom.removeNode(node_48980);


var G__48983 = seq__48771_48976;
var G__48984 = chunk__48775_48977;
var G__48985 = count__48776_48978;
var G__48986 = (i__48777_48979 + (1));
seq__48771_48976 = G__48983;
chunk__48775_48977 = G__48984;
count__48776_48978 = G__48985;
i__48777_48979 = G__48986;
continue;
} else {
var G__48987 = seq__48771_48976;
var G__48988 = chunk__48775_48977;
var G__48989 = count__48776_48978;
var G__48990 = (i__48777_48979 + (1));
seq__48771_48976 = G__48987;
chunk__48775_48977 = G__48988;
count__48776_48978 = G__48989;
i__48777_48979 = G__48990;
continue;
}
} else {
var temp__5720__auto___48991 = cljs.core.seq.call(null,seq__48771_48976);
if(temp__5720__auto___48991){
var seq__48771_48992__$1 = temp__5720__auto___48991;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48771_48992__$1)){
var c__4550__auto___48993 = cljs.core.chunk_first.call(null,seq__48771_48992__$1);
var G__48994 = cljs.core.chunk_rest.call(null,seq__48771_48992__$1);
var G__48995 = c__4550__auto___48993;
var G__48996 = cljs.core.count.call(null,c__4550__auto___48993);
var G__48997 = (0);
seq__48771_48976 = G__48994;
chunk__48775_48977 = G__48995;
count__48776_48978 = G__48996;
i__48777_48979 = G__48997;
continue;
} else {
var node_48998 = cljs.core.first.call(null,seq__48771_48992__$1);
var path_match_48999 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_48998.getAttribute("href"),path);
if(cljs.core.truth_(path_match_48999)){
var new_link_49000 = (function (){var G__48784 = node_48998.cloneNode(true);
G__48784.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_48999),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48784;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_48999);

goog.dom.insertSiblingAfter(new_link_49000,node_48998);

goog.dom.removeNode(node_48998);


var G__49001 = cljs.core.next.call(null,seq__48771_48992__$1);
var G__49002 = null;
var G__49003 = (0);
var G__49004 = (0);
seq__48771_48976 = G__49001;
chunk__48775_48977 = G__49002;
count__48776_48978 = G__49003;
i__48777_48979 = G__49004;
continue;
} else {
var G__49005 = cljs.core.next.call(null,seq__48771_48992__$1);
var G__49006 = null;
var G__49007 = (0);
var G__49008 = (0);
seq__48771_48976 = G__49005;
chunk__48775_48977 = G__49006;
count__48776_48978 = G__49007;
i__48777_48979 = G__49008;
continue;
}
}
} else {
}
}
break;
}


var G__49009 = seq__48739;
var G__49010 = chunk__48741;
var G__49011 = count__48742;
var G__49012 = (i__48743 + (1));
seq__48739 = G__49009;
chunk__48741 = G__49010;
count__48742 = G__49011;
i__48743 = G__49012;
continue;
} else {
var G__49013 = seq__48739;
var G__49014 = chunk__48741;
var G__49015 = count__48742;
var G__49016 = (i__48743 + (1));
seq__48739 = G__49013;
chunk__48741 = G__49014;
count__48742 = G__49015;
i__48743 = G__49016;
continue;
}
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__48739);
if(temp__5720__auto__){
var seq__48739__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48739__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__48739__$1);
var G__49017 = cljs.core.chunk_rest.call(null,seq__48739__$1);
var G__49018 = c__4550__auto__;
var G__49019 = cljs.core.count.call(null,c__4550__auto__);
var G__49020 = (0);
seq__48739 = G__49017;
chunk__48741 = G__49018;
count__48742 = G__49019;
i__48743 = G__49020;
continue;
} else {
var path = cljs.core.first.call(null,seq__48739__$1);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__48785_49021 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__48788_49022 = null;
var count__48789_49023 = (0);
var i__48790_49024 = (0);
while(true){
if((i__48790_49024 < count__48789_49023)){
var node_49025 = cljs.core._nth.call(null,chunk__48788_49022,i__48790_49024);
var path_match_49026 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_49025.getAttribute("href"),path);
if(cljs.core.truth_(path_match_49026)){
var new_link_49027 = (function (){var G__48795 = node_49025.cloneNode(true);
G__48795.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_49026),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48795;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_49026);

goog.dom.insertSiblingAfter(new_link_49027,node_49025);

goog.dom.removeNode(node_49025);


var G__49028 = seq__48785_49021;
var G__49029 = chunk__48788_49022;
var G__49030 = count__48789_49023;
var G__49031 = (i__48790_49024 + (1));
seq__48785_49021 = G__49028;
chunk__48788_49022 = G__49029;
count__48789_49023 = G__49030;
i__48790_49024 = G__49031;
continue;
} else {
var G__49032 = seq__48785_49021;
var G__49033 = chunk__48788_49022;
var G__49034 = count__48789_49023;
var G__49035 = (i__48790_49024 + (1));
seq__48785_49021 = G__49032;
chunk__48788_49022 = G__49033;
count__48789_49023 = G__49034;
i__48790_49024 = G__49035;
continue;
}
} else {
var temp__5720__auto___49036__$1 = cljs.core.seq.call(null,seq__48785_49021);
if(temp__5720__auto___49036__$1){
var seq__48785_49037__$1 = temp__5720__auto___49036__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48785_49037__$1)){
var c__4550__auto___49038 = cljs.core.chunk_first.call(null,seq__48785_49037__$1);
var G__49039 = cljs.core.chunk_rest.call(null,seq__48785_49037__$1);
var G__49040 = c__4550__auto___49038;
var G__49041 = cljs.core.count.call(null,c__4550__auto___49038);
var G__49042 = (0);
seq__48785_49021 = G__49039;
chunk__48788_49022 = G__49040;
count__48789_49023 = G__49041;
i__48790_49024 = G__49042;
continue;
} else {
var node_49043 = cljs.core.first.call(null,seq__48785_49037__$1);
var path_match_49044 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_49043.getAttribute("href"),path);
if(cljs.core.truth_(path_match_49044)){
var new_link_49045 = (function (){var G__48796 = node_49043.cloneNode(true);
G__48796.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_49044),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__48796;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_49044);

goog.dom.insertSiblingAfter(new_link_49045,node_49043);

goog.dom.removeNode(node_49043);


var G__49046 = cljs.core.next.call(null,seq__48785_49037__$1);
var G__49047 = null;
var G__49048 = (0);
var G__49049 = (0);
seq__48785_49021 = G__49046;
chunk__48788_49022 = G__49047;
count__48789_49023 = G__49048;
i__48790_49024 = G__49049;
continue;
} else {
var G__49050 = cljs.core.next.call(null,seq__48785_49037__$1);
var G__49051 = null;
var G__49052 = (0);
var G__49053 = (0);
seq__48785_49021 = G__49050;
chunk__48788_49022 = G__49051;
count__48789_49023 = G__49052;
i__48790_49024 = G__49053;
continue;
}
}
} else {
}
}
break;
}


var G__49054 = cljs.core.next.call(null,seq__48739__$1);
var G__49055 = null;
var G__49056 = (0);
var G__49057 = (0);
seq__48739 = G__49054;
chunk__48741 = G__49055;
count__48742 = G__49056;
i__48743 = G__49057;
continue;
} else {
var G__49058 = cljs.core.next.call(null,seq__48739__$1);
var G__49059 = null;
var G__49060 = (0);
var G__49061 = (0);
seq__48739 = G__49058;
chunk__48741 = G__49059;
count__48742 = G__49060;
i__48743 = G__49061;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace.call(null,s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.call(null,shadow.cljs.devtools.client.env.repl_error.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product.call(null),new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root.call(null));
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__48805){
var map__48806 = p__48805;
var map__48806__$1 = (((((!((map__48806 == null))))?(((((map__48806.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48806.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48806):map__48806);
var id = cljs.core.get.call(null,map__48806__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.call(null,map__48806__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call.call(null,((function (map__48806,map__48806__$1,id,js){
return (function (){
return eval(js);
});})(map__48806,map__48806__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg.call(null,cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__48808){
var map__48809 = p__48808;
var map__48809__$1 = (((((!((map__48809 == null))))?(((((map__48809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48809):map__48809);
var msg = map__48809__$1;
var id = cljs.core.get.call(null,map__48809__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.call(null,map__48809__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.call(null,map__48809__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.call(null,map__48809__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,((function (map__48809,map__48809__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__48815){
var map__48816 = p__48815;
var map__48816__$1 = (((((!((map__48816 == null))))?(((((map__48816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48816):map__48816);
var src = map__48816__$1;
var provides = cljs.core.get.call(null,map__48816__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4120__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,cljs.core.some.call(null,reload_namespaces,provides));
} else {
return and__4120__auto__;
}
});})(map__48809,map__48809__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_load,((function (sources_to_load,map__48809,map__48809__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources__$1);

if(cljs.core.seq.call(null,js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires.call(null,js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
});})(sources_to_load,map__48809,map__48809__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__48820){
var map__48821 = p__48820;
var map__48821__$1 = (((((!((map__48821 == null))))?(((((map__48821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48821.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48821):map__48821);
var repl_state = cljs.core.get.call(null,map__48821__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.call(null,map__48821__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__48821,map__48821__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);

shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"REPL session start successful");
});})(map__48821,map__48821__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__48824){
var map__48825 = p__48824;
var map__48825__$1 = (((((!((map__48825 == null))))?(((((map__48825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48825.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48825):map__48825);
var id = cljs.core.get.call(null,map__48825__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.call(null,map__48825__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_.call(null,null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__48831){
var map__48832 = p__48831;
var map__48832__$1 = (((((!((map__48832 == null))))?(((((map__48832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48832):map__48832);
var msg = map__48832__$1;
var type = cljs.core.get.call(null,map__48832__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

var G__48835 = type;
var G__48835__$1 = (((G__48835 instanceof cljs.core.Keyword))?G__48835.fqn:null);
switch (G__48835__$1) {
case "asset-watch":
return shadow.cljs.devtools.client.browser.handle_asset_watch.call(null,msg);

break;
case "repl/invoke":
return shadow.cljs.devtools.client.browser.repl_invoke.call(null,msg);

break;
case "repl/require":
return shadow.cljs.devtools.client.browser.repl_require.call(null,msg);

break;
case "repl/set-ns":
return shadow.cljs.devtools.client.browser.repl_set_ns.call(null,msg);

break;
case "repl/init":
return shadow.cljs.devtools.client.browser.repl_init.call(null,msg);

break;
case "repl/session-start":
return shadow.cljs.devtools.client.browser.repl_init.call(null,msg);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

return shadow.cljs.devtools.client.browser.handle_build_complete.call(null,msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end.call(null);

return shadow.cljs.devtools.client.hud.hud_error.call(null,msg);

break;
case "build-init":
return shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide.call(null);

return shadow.cljs.devtools.client.hud.load_start.call(null);

break;
case "pong":
return null;

break;
case "client/stale":
return cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
return cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
return shadow.cljs.devtools.client.env.publish_BANG_.call(null,new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:
return new cljs.core.Keyword(null,"ignored","ignored",1227374526);

}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.call(null,req.getResponseText());
if(cljs.core.truth_(callback)){
return callback.call(null,actions);
} else {
return null;
}
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)),({"content-type": "application/edn; charset=utf-8"}));
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var s = temp__5720__auto__;
s.send(cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url.call(null,new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg.call(null,e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.call(null,"goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error.call(null,(function (){var or__4131__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_.call(null);
});})(print_fn,ws_url,socket))
;

socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error.call(null,"Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"websocket error",e);
});})(print_fn,ws_url,socket))
;

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
}catch (e48843){var e = e48843;
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket setup failed",e);
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5720__auto___49077 = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto___49077)){
var s_49078 = temp__5720__auto___49077;
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"connection reset!");

s_49078.onclose = ((function (s_49078,temp__5720__auto___49077){
return (function (e){
return null;
});})(s_49078,temp__5720__auto___49077))
;

s_49078.close();

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var s = temp__5720__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4120__auto__ = document;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.call(null,"loading",document.readyState);
} else {
return and__4120__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
