goog.provide('shadow.xhr');
goog.require('cljs.core');
goog.require('goog.result');
goog.require('goog.result.SimpleResult');
goog.require('goog.labs.net.xhr');
goog.require('cljs.reader');
goog.require('goog.uri.utils');
goog.require('goog.json');
goog.require('shadow.object');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('shadow.util');
shadow.xhr.result_chain = (function shadow$xhr$result_chain(res,handler){
return goog.result.chain(res,handler);
});
shadow.xhr.result_combine = (function shadow$xhr$result_combine(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48056 = arguments.length;
var i__4731__auto___48057 = (0);
while(true){
if((i__4731__auto___48057 < len__4730__auto___48056)){
args__4736__auto__.push((arguments[i__4731__auto___48057]));

var G__48058 = (i__4731__auto___48057 + (1));
i__4731__auto___48057 = G__48058;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic = (function (results){
return cljs.core.apply.call(null,goog.result.combine,results);
});

shadow.xhr.result_combine.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.xhr.result_combine.cljs$lang$applyTo = (function (seq47962){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq47962));
});

shadow.xhr.result_wait_on_success = (function shadow$xhr$result_wait_on_success(res,callback){
return goog.result.waitOnSuccess(res,callback);
});
shadow.xhr.result_success_QMARK_ = (function shadow$xhr$result_success_QMARK_(res){
return cljs.core._EQ_.call(null,goog.result.Result.State.SUCCESS,res.getState());
});
shadow.xhr.result_value = (function shadow$xhr$result_value(res){
return res.getValue();
});
shadow.xhr.result_immediate = (function shadow$xhr$result_immediate(value){
return goog.result.successfulResult(value);
});
shadow.xhr.result_error = (function shadow$xhr$result_error(res,callback){
return goog.result.waitOnError(res,callback);
});
shadow.xhr.edn_transform = (function shadow$xhr$edn_transform(body){
return cljs.reader.read_string.call(null,body);
});
shadow.xhr.json_transform = (function shadow$xhr$json_transform(body){
return cljs.core.js__GT_clj.call(null,JSON.parse(body));
});
shadow.xhr.goog_keys = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"timeout","timeout",-318625318),"timeoutMs",new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),"withCredentials",new cljs.core.Keyword(null,"headers","headers",-835030129),"headers",new cljs.core.Keyword(null,"mime-type","mime-type",1058646439),"mimeType"], null);
shadow.xhr.make_request_options = (function shadow$xhr$make_request_options(options){
var obj = ({});
var seq__47965_48059 = cljs.core.seq.call(null,options);
var chunk__47966_48060 = null;
var count__47967_48061 = (0);
var i__47968_48062 = (0);
while(true){
if((i__47968_48062 < count__47967_48061)){
var vec__47975_48063 = cljs.core._nth.call(null,chunk__47966_48060,i__47968_48062);
var k_48064 = cljs.core.nth.call(null,vec__47975_48063,(0),null);
var v_48065 = cljs.core.nth.call(null,vec__47975_48063,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_48064)] = cljs.core.clj__GT_js.call(null,v_48065));


var G__48072 = seq__47965_48059;
var G__48073 = chunk__47966_48060;
var G__48074 = count__47967_48061;
var G__48075 = (i__47968_48062 + (1));
seq__47965_48059 = G__48072;
chunk__47966_48060 = G__48073;
count__47967_48061 = G__48074;
i__47968_48062 = G__48075;
continue;
} else {
var temp__5720__auto___48077 = cljs.core.seq.call(null,seq__47965_48059);
if(temp__5720__auto___48077){
var seq__47965_48079__$1 = temp__5720__auto___48077;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47965_48079__$1)){
var c__4550__auto___48080 = cljs.core.chunk_first.call(null,seq__47965_48079__$1);
var G__48081 = cljs.core.chunk_rest.call(null,seq__47965_48079__$1);
var G__48082 = c__4550__auto___48080;
var G__48083 = cljs.core.count.call(null,c__4550__auto___48080);
var G__48084 = (0);
seq__47965_48059 = G__48081;
chunk__47966_48060 = G__48082;
count__47967_48061 = G__48083;
i__47968_48062 = G__48084;
continue;
} else {
var vec__47978_48085 = cljs.core.first.call(null,seq__47965_48079__$1);
var k_48086 = cljs.core.nth.call(null,vec__47978_48085,(0),null);
var v_48087 = cljs.core.nth.call(null,vec__47978_48085,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_48086)] = cljs.core.clj__GT_js.call(null,v_48087));


var G__48088 = cljs.core.next.call(null,seq__47965_48079__$1);
var G__48089 = null;
var G__48090 = (0);
var G__48091 = (0);
seq__47965_48059 = G__48088;
chunk__47966_48060 = G__48089;
count__47967_48061 = G__48090;
i__47968_48062 = G__48091;
continue;
}
} else {
}
}
break;
}

return obj;
});
shadow.xhr.content_transforms = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 5, ["text/edn",shadow.xhr.edn_transform,"application/edn",shadow.xhr.edn_transform,"application/json",shadow.xhr.json_transform,"text/html",cljs.core.identity,"text/plain",cljs.core.identity], null));
shadow.xhr.register_transform = (function shadow$xhr$register_transform(content_type,transform_fn){
return cljs.core.swap_BANG_.call(null,shadow.xhr.content_transforms,cljs.core.assoc,content_type,transform_fn);
});
shadow.xhr.auto_transform = (function shadow$xhr$auto_transform(req){
var content_type = (function (){var ct = clojure.string.lower_case.call(null,req.getResponseHeader("Content-Type"));
var sep = ct.indexOf(";");
if(cljs.core.not_EQ_.call(null,(-1),sep)){
return ct.substring((0),sep);
} else {
return ct;
}
})();
var transform_fn = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.xhr.content_transforms),content_type);
if((transform_fn == null)){
throw cljs.core.ex_info.call(null,"unsupported content-type",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"req","req",-326448303),req,new cljs.core.Keyword(null,"content-type","content-type",-508222634),content_type], null));
} else {
return transform_fn.call(null,req.responseText);
}
});
shadow.xhr.make_url = (function shadow$xhr$make_url(url,params){
return goog.uri.utils.appendParamsFromMap(url,cljs.core.clj__GT_js.call(null,params));
});
shadow.xhr.transform_request_body = (function shadow$xhr$transform_request_body(data){
if(typeof data === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/plain; charset=utf-8",data], null);
} else {
if((((!((data == null))))?(((((data.cljs$lang$protocol_mask$partition0$ & (2147483648))) || ((cljs.core.PROTOCOL_SENTINEL === data.cljs$core$IPrintWithWriter$))))?true:(((!data.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/edn; charset=utf-8",cljs.core.pr_str.call(null,data)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["application/octet-stream",data], null);

}
}
});
shadow.xhr.as_url = (function shadow$xhr$as_url(input){
if(typeof input === 'string'){
return input;
} else {
if(((cljs.core.vector_QMARK_.call(null,input)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,input))) && (typeof cljs.core.first.call(null,input) === 'string') && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,input))))){
var vec__47983 = input;
var url = cljs.core.nth.call(null,vec__47983,(0),null);
var params = cljs.core.nth.call(null,vec__47983,(1),null);
return shadow.xhr.make_url.call(null,url,params);
} else {
throw cljs.core.ex_info.call(null,"doesnt look like an url",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),input], null));

}
}
});
shadow.xhr.e__GT_data = (function shadow$xhr$e__GT_data(e){
return e;
});
shadow.xhr.event_handler = (function shadow$xhr$event_handler(req,events,event_type){
return (function (e){
if(cljs.core.map_QMARK_.call(null,events)){
var temp__5720__auto__ = cljs.core.get.call(null,events,event_type);
if(cljs.core.truth_(temp__5720__auto__)){
var c = temp__5720__auto__;
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;
}
} else {
if((!((events == null)))){
return cljs.core.async.put_BANG_.call(null,events,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;

}
}
});
});
shadow.xhr.request_ok_QMARK_ = (function shadow$xhr$request_ok_QMARK_(status){
return cljs.core._EQ_.call(null,(200),status);
});
shadow.xhr.request_error_QMARK_ = (function shadow$xhr$request_error_QMARK_(status){
return (status >= (400));
});
/**
 * creates a channel and performs xhr request like (chan :GET "/something")
 * 
 * accepts url as string or [url params]
 * 
 * this channel will receive one message [status body req] on load
 * loadend will close the result channel, so you will get nil results on request errors/timeouts
 * 
 * use options hash to pass in extra channels
 * 
 * (chan :POST "/something" some-data {:events chan-or-map
 *                                       :upload chan-or-map})
 * 
 * when given a chan that channels receives messages in form of [event-type event-data req]
 * when given a map a channel is expected for each eventtype and will receive [event-data req]
 * {:timeout some-chan}, if no channel for a given event is present, no message is sent
 * 
 * event types are :loadstart :progress :abort :error :timeout :loadend :load (see xhr spec)
 * only exception is that status >= 500 does not return a result and produces an error event instead
 */
shadow.xhr.chan = (function shadow$xhr$chan(var_args){
var G__47988 = arguments.length;
switch (G__47988) {
case 2:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.chan.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.chan.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,p__47990){
var map__47991 = p__47990;
var map__47991__$1 = (((((!((map__47991 == null))))?(((((map__47991.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47991.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47991):map__47991);
var options = map__47991__$1;
var events = cljs.core.get.call(null,map__47991__$1,new cljs.core.Keyword(null,"events","events",1792552201));
var upload = cljs.core.get.call(null,map__47991__$1,new cljs.core.Keyword(null,"upload","upload",-255769218));
var body_only = cljs.core.get.call(null,map__47991__$1,new cljs.core.Keyword(null,"body-only","body-only",-698120682));
var req = (new XMLHttpRequest());
var body_QMARK_ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
var vec__47993 = ((body_QMARK_)?shadow.xhr.transform_request_body.call(null,data):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null));
var content_type = cljs.core.nth.call(null,vec__47993,(0),null);
var body = cljs.core.nth.call(null,vec__47993,(1),null);
var result_chan = cljs.core.async.chan.call(null,(1));
if(cljs.core.truth_((function (){var and__4120__auto__ = body_QMARK_;
if(and__4120__auto__){
return upload;
} else {
return and__4120__auto__;
}
})())){
shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"error","error",-978969032),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"error","error",-978969032)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"load","load",-1318641184),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));
} else {
}

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadend","loadend",1430560564),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadend","loadend",1430560564));
return ((function (callback,req,body_QMARK_,vec__47993,content_type,body,result_chan,map__47991,map__47991__$1,options,events,upload,body_only){
return (function (e){
callback.call(null,e);

return cljs.core.async.close_BANG_.call(null,result_chan);
});
;})(callback,req,body_QMARK_,vec__47993,content_type,body,result_chan,map__47991,map__47991__$1,options,events,upload,body_only))
})());

var error_handler_48100 = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"error","error",-978969032));
shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"error","error",-978969032),error_handler_48100);

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"load","load",-1318641184),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"load","load",-1318641184));
return ((function (callback,error_handler_48100,req,body_QMARK_,vec__47993,content_type,body,result_chan,map__47991,map__47991__$1,options,events,upload,body_only){
return (function (e){
var status = req.status;
var body__$1 = (function (){var temp__5718__auto__ = new cljs.core.Keyword(null,"transform","transform",1381301764).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(temp__5718__auto__)){
var transform = temp__5718__auto__;
return transform.call(null,req.responseText,req);
} else {
return shadow.xhr.auto_transform.call(null,req);
}
})();
if(shadow.xhr.request_error_QMARK_.call(null,status)){
return error_handler_48100.call(null,e);
} else {
callback.call(null,e);

if(cljs.core.truth_(body_only)){
return cljs.core.async.put_BANG_.call(null,result_chan,body__$1);
} else {
return cljs.core.async.put_BANG_.call(null,result_chan,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,body__$1,req], null));
}
}
});
;})(callback,error_handler_48100,req,body_QMARK_,vec__47993,content_type,body,result_chan,map__47991,map__47991__$1,options,events,upload,body_only))
})());

req.open(cljs.core.name.call(null,method),shadow.xhr.as_url.call(null,url),true);

req.responseType = "text";

req.withCredentials = (!(new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235).cljs$core$IFn$_invoke$arity$1(options) === false));

if(body_QMARK_){
req.setRequestHeader("Content-Type",content_type);
} else {
}

if(body_QMARK_){
req.send(body);
} else {
req.send();
}

return result_chan;
});

shadow.xhr.chan.cljs$lang$maxFixedArity = 4;

shadow.xhr.request = (function shadow$xhr$request(var_args){
var G__48006 = arguments.length;
switch (G__48006) {
case 2:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.xhr.request.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.request.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.request.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.request.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.xhr.request.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,options){
if((((!(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"DELETE","DELETE",1688673772),null,new cljs.core.Keyword(null,"GET","GET",1736591026),null], null), null),method)))) && ((data == null)))){
throw cljs.core.ex_info.call(null,"request needs data",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),method,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"options","options",99638489),options], null));
} else {
}

var body_QMARK_ = (!(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method)) || ((data == null)))));
var vec__48026 = shadow.xhr.transform_request_body.call(null,data);
var content_type = cljs.core.nth.call(null,vec__48026,(0),null);
var body = cljs.core.nth.call(null,vec__48026,(1),null);
var req = goog.labs.net.xhr.send(cljs.core.name.call(null,method),(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
if(and__4120__auto__){
return data;
} else {
return and__4120__auto__;
}
})())?shadow.xhr.make_url.call(null,url,data):url),((body_QMARK_)?body:null),shadow.xhr.make_request_options.call(null,((body_QMARK_)?cljs.core.assoc_in.call(null,options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Content-Type"], null),content_type):options)));
var req__$1 = goog.result.SimpleResult.fromPromise(req);
return goog.result.transform(req__$1,shadow.xhr.auto_transform);
});

shadow.xhr.request.cljs$lang$maxFixedArity = 4;

shadow.xhr.upload = (function shadow$xhr$upload(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48102 = arguments.length;
var i__4731__auto___48103 = (0);
while(true){
if((i__4731__auto___48103 < len__4730__auto___48102)){
args__4736__auto__.push((arguments[i__4731__auto___48103]));

var G__48104 = (i__4731__auto___48103 + (1));
i__4731__auto___48103 = G__48104;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic = (function (url,file,events){
var xhr = (new XMLHttpRequest());
var seq__48037_48105 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),events));
var chunk__48039_48106 = null;
var count__48040_48107 = (0);
var i__48041_48108 = (0);
while(true){
if((i__48041_48108 < count__48040_48107)){
var vec__48049_48109 = cljs.core._nth.call(null,chunk__48039_48106,i__48041_48108);
var ev_id_48110 = cljs.core.nth.call(null,vec__48049_48109,(0),null);
var ev_handler_48111 = cljs.core.nth.call(null,vec__48049_48109,(1),null);
var target_48112 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_48110))?(xhr["upload"]):xhr);
target_48112.addEventListener(cljs.core.name.call(null,ev_id_48110),ev_handler_48111);


var G__48114 = seq__48037_48105;
var G__48115 = chunk__48039_48106;
var G__48116 = count__48040_48107;
var G__48117 = (i__48041_48108 + (1));
seq__48037_48105 = G__48114;
chunk__48039_48106 = G__48115;
count__48040_48107 = G__48116;
i__48041_48108 = G__48117;
continue;
} else {
var temp__5720__auto___48118 = cljs.core.seq.call(null,seq__48037_48105);
if(temp__5720__auto___48118){
var seq__48037_48119__$1 = temp__5720__auto___48118;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__48037_48119__$1)){
var c__4550__auto___48120 = cljs.core.chunk_first.call(null,seq__48037_48119__$1);
var G__48121 = cljs.core.chunk_rest.call(null,seq__48037_48119__$1);
var G__48122 = c__4550__auto___48120;
var G__48123 = cljs.core.count.call(null,c__4550__auto___48120);
var G__48124 = (0);
seq__48037_48105 = G__48121;
chunk__48039_48106 = G__48122;
count__48040_48107 = G__48123;
i__48041_48108 = G__48124;
continue;
} else {
var vec__48052_48125 = cljs.core.first.call(null,seq__48037_48119__$1);
var ev_id_48126 = cljs.core.nth.call(null,vec__48052_48125,(0),null);
var ev_handler_48127 = cljs.core.nth.call(null,vec__48052_48125,(1),null);
var target_48128 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_48126))?(xhr["upload"]):xhr);
target_48128.addEventListener(cljs.core.name.call(null,ev_id_48126),ev_handler_48127);


var G__48129 = cljs.core.next.call(null,seq__48037_48119__$1);
var G__48130 = null;
var G__48131 = (0);
var G__48132 = (0);
seq__48037_48105 = G__48129;
chunk__48039_48106 = G__48130;
count__48040_48107 = G__48131;
i__48041_48108 = G__48132;
continue;
}
} else {
}
}
break;
}

var G__48055 = xhr;
G__48055.open("PUT",url);

G__48055.send(file);

return G__48055;
});

shadow.xhr.upload.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.xhr.upload.cljs$lang$applyTo = (function (seq48034){
var G__48035 = cljs.core.first.call(null,seq48034);
var seq48034__$1 = cljs.core.next.call(null,seq48034);
var G__48036 = cljs.core.first.call(null,seq48034__$1);
var seq48034__$2 = cljs.core.next.call(null,seq48034__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48035,G__48036,seq48034__$2);
});


//# sourceMappingURL=shadow.xhr.js.map
