goog.provide('shadow.object');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.data');
goog.require('cljs.core.async.impl.protocols');
goog.require('shadow.util');
shadow.object.console_friendly = shadow.util.console_friendly;
shadow.object.log = shadow.util.log;
shadow.object.debug = shadow.util.log;
shadow.object.info = shadow.util.log;
shadow.object.warn = shadow.util.log;
shadow.object.error = shadow.util.log;
shadow.object.obj_id = cljs.core.atom.call(null,(0));
shadow.object.next_id = (function shadow$object$next_id(){
return cljs.core.swap_BANG_.call(null,shadow.object.obj_id,cljs.core.inc);
});
shadow.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.behavior_fns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instances = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_parent = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_children = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.events = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.define_event = (function shadow$object$define_event(event_name,desc,args){
return cljs.core.swap_BANG_.call(null,shadow.object.events,cljs.core.assoc,event_name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),event_name,new cljs.core.Keyword(null,"description","description",-1428560544),desc,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
});
shadow.object.unmunge = (function shadow$object$unmunge(s){
return clojure.string.replace.call(null,clojure.string.replace.call(null,s,/_DOT_/,"."),/_/,"-");
});
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),"object initialization",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"destroy","destroy",-843660405),"object descruction",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cause","cause",231901252),"cause of destruction, :parent means the parent was destroyed, :direct is default"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","init","dom/init",-1875647652),"called after the dom was created but has not entered the document yet",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dom","dom",-1236537922),"the dom that was created"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","entered","dom/entered",506699596),"should be called whenever a dom node is added to the document, since that\n   is not in control of this library its up to you to call this\n   use (so/notify-tree! your-obj :dom/entered) to notify the node and every child you created",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160),"need to rethink this",cljs.core.PersistentVector.EMPTY);

/**
 * @interface
 */
shadow.object.IObject = function(){};

shadow.object._id = (function shadow$object$_id(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_id$arity$1 == null)))))){
return this$.shadow$object$IObject$_id$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._id[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.object._id["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-id",this$);
}
}
}
});

shadow.object._type = (function shadow$object$_type(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_type$arity$1 == null)))))){
return this$.shadow$object$IObject$_type$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._type[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.object._type["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-type",this$);
}
}
}
});

shadow.object._data = (function shadow$object$_data(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_data$arity$1 == null)))))){
return this$.shadow$object$IObject$_data$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._data[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.object._data["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-data",this$);
}
}
}
});

/**
 * update and notify watches
 */
shadow.object._update = (function shadow$object$_update(this$,update_fn){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_update$arity$2 == null)))))){
return this$.shadow$object$IObject$_update$arity$2(this$,update_fn);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._update[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$,update_fn);
} else {
var m__4431__auto__ = (shadow.object._update["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$,update_fn);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-update",this$);
}
}
}
});

shadow.object._destroy_BANG_ = (function shadow$object$_destroy_BANG_(this$,cause){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_destroy_BANG_$arity$2 == null)))))){
return this$.shadow$object$IObject$_destroy_BANG_$arity$2(this$,cause);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.object._destroy_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$,cause);
} else {
var m__4431__auto__ = (shadow.object._destroy_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$,cause);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-destroy!",this$);
}
}
}
});

shadow.object.get_type = (function shadow$object$get_type(this$){
return shadow.object._type.call(null,this$);
});
shadow.object.get_type_attr = (function shadow$object$get_type_attr(var_args){
var G__47341 = arguments.length;
switch (G__47341) {
case 2:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2 = (function (oref,key){
if((oref == null)){
return null;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null));
}
});

shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3 = (function (oref,key,default$){
if((oref == null)){
return default$;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null),default$);
}
});

shadow.object.get_type_attr.cljs$lang$maxFixedArity = 3;

shadow.object.get_dom = (function shadow$object$get_dom(oref){
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(oref);
});
goog.exportSymbol('shadow.object.get_dom', shadow.object.get_dom);
shadow.object.get_by_id = (function shadow$object$get_by_id(id){
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),id);
});
goog.exportSymbol('shadow.object.get_by_id', shadow.object.get_by_id);
shadow.object.get_from_dom = (function shadow$object$get_from_dom(dom){
var oid = shadow.dom.data.call(null,dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(oid)){
return shadow.object.get_by_id.call(null,parseInt(oid,(10)));
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_from_dom', shadow.object.get_from_dom);
shadow.object.is_object_QMARK_ = (function shadow$object$is_object_QMARK_(obj_or_dom){
var or__4131__auto__ = (((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return shadow.object.get_from_dom.call(null,obj_or_dom);
}
});
shadow.object.equal_QMARK_ = (function shadow$object$equal_QMARK_(obj,obj_or_dom){
if((((!((obj == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj.shadow$object$IObject$))))?true:(((!obj.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj))){
} else {
throw (new Error(["Assert failed: ","can only test objects","\n","(satisfies? IObject obj)"].join('')));
}

if((((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom))){
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),shadow.object._id.call(null,obj_or_dom));
} else {
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),(function (){var temp__5720__auto__ = shadow.dom.data.call(null,obj_or_dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(temp__5720__auto__)){
var oid = temp__5720__auto__;
return parseInt(oid,(10));
} else {
return null;
}
})());
}
});
shadow.object.get_parent = (function shadow$object$get_parent(oref){
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),shadow.object._id.call(null,oref));
if(cljs.core.truth_(temp__5720__auto__)){
var parent_id = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),parent_id);
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_parent', shadow.object.get_parent);
shadow.object.get_parent_of_type = (function shadow$object$get_parent_of_type(oref,parent_type){
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(oref);
while(true){
if(cljs.core.truth_(parent)){
if(cljs.core._EQ_.call(null,shadow.object._type.call(null,parent),parent_type)){
return parent;
} else {
var G__47986 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(parent);
parent = G__47986;
continue;
}
} else {
return null;
}
break;
}
});
goog.exportSymbol('shadow.object.get_parent_of_type', shadow.object.get_parent_of_type);
shadow.object.get_children = (function shadow$object$get_children(parent){
var parent_id = shadow.object._id.call(null,parent);
var child_ids = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_children),parent_id,cljs.core.PersistentVector.EMPTY);
var instances = cljs.core.deref.call(null,shadow.object.instances);
return cljs.core.vec.call(null,cljs.core.map.call(null,((function (parent_id,child_ids,instances){
return (function (p1__47380_SHARP_){
return cljs.core.get.call(null,instances,p1__47380_SHARP_);
});})(parent_id,child_ids,instances))
,child_ids));
});
goog.exportSymbol('shadow.object.get_children', shadow.object.get_children);
shadow.object.tree_seq = (function shadow$object$tree_seq(var_args){
var G__47382 = arguments.length;
switch (G__47382) {
case 1:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('shadow.object.tree_seq', shadow.object.tree_seq);

shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1 = (function (root){
return shadow.object.tree_seq.call(null,root,(function (node){
return true;
}));
});

shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2 = (function (root,branch_QMARK_){
return cljs.core.tree_seq.call(null,branch_QMARK_,shadow.object.get_children,root);
});

shadow.object.tree_seq.cljs$lang$maxFixedArity = 2;

shadow.object.get_children_of_type = (function shadow$object$get_children_of_type(oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,((function (type_kw){
return (function (p1__47383_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__47383_SHARP_));
});})(type_kw))
,shadow.object.get_children.call(null,oref));
});
/**
 * basically (get-children (:parent this))
 */
shadow.object.get_siblings = (function shadow$object$get_siblings(p__47384){
var map__47385 = p__47384;
var map__47385__$1 = (((((!((map__47385 == null))))?(((((map__47385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47385):map__47385);
var oref = map__47385__$1;
var parent = cljs.core.get.call(null,map__47385__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
if(cljs.core.truth_(parent)){
} else {
throw cljs.core.ex_info.call(null,"object has no parent, thus has no siblings",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

return shadow.object.get_children.call(null,parent);
});
/**
 * returns set of all siblings of a common type
 */
shadow.object.get_siblings_of_type = (function shadow$object$get_siblings_of_type(var_args){
var G__47390 = arguments.length;
switch (G__47390) {
case 1:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.get_siblings_of_type.call(null,oref,oref);
});

shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2 = (function (oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,((function (type_kw){
return (function (p1__47388_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__47388_SHARP_));
});})(type_kw))
,shadow.object.get_siblings.call(null,oref));
});

shadow.object.get_siblings_of_type.cljs$lang$maxFixedArity = 2;

shadow.object.get_collection_item = (function shadow$object$get_collection_item(oref){
var item_key = new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref);
return cljs.core.get.call(null,oref,item_key);
});
/**
 * find the object that contains this dom node
 */
shadow.object.find_containing_object = (function shadow$object$find_containing_object(dom){
while(true){
var temp__5718__auto__ = shadow.object.get_from_dom.call(null,dom);
if(cljs.core.truth_(temp__5718__auto__)){
var obj = temp__5718__auto__;
return obj;
} else {
var temp__5720__auto__ = dom.parentElement;
if(cljs.core.truth_(temp__5720__auto__)){
var parent = temp__5720__auto__;
var G__47997 = parent;
dom = G__47997;
continue;
} else {
return null;
}
}
break;
}
});
shadow.object.notify_BANG_ = (function shadow$object$notify_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47998 = arguments.length;
var i__4731__auto___47999 = (0);
while(true){
if((i__4731__auto___47999 < len__4730__auto___47998)){
args__4736__auto__.push((arguments[i__4731__auto___47999]));

var G__48000 = (i__4731__auto___47999 + (1));
i__4731__auto___47999 = G__48000;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var temp__5720__auto__ = cljs.core.get_in.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),ev], null));
if(cljs.core.truth_(temp__5720__auto__)){
var reactions_to_trigger = temp__5720__auto__;
var seq__47428 = cljs.core.seq.call(null,reactions_to_trigger);
var chunk__47429 = null;
var count__47430 = (0);
var i__47431 = (0);
while(true){
if((i__47431 < count__47430)){
var rfn = cljs.core._nth.call(null,chunk__47429,i__47431);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__48001 = seq__47428;
var G__48002 = chunk__47429;
var G__48003 = count__47430;
var G__48004 = (i__47431 + (1));
seq__47428 = G__48001;
chunk__47429 = G__48002;
count__47430 = G__48003;
i__47431 = G__48004;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__47428);
if(temp__5720__auto____$1){
var seq__47428__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47428__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__47428__$1);
var G__48007 = cljs.core.chunk_rest.call(null,seq__47428__$1);
var G__48008 = c__4550__auto__;
var G__48009 = cljs.core.count.call(null,c__4550__auto__);
var G__48010 = (0);
seq__47428 = G__48007;
chunk__47429 = G__48008;
count__47430 = G__48009;
i__47431 = G__48010;
continue;
} else {
var rfn = cljs.core.first.call(null,seq__47428__$1);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__48011 = cljs.core.next.call(null,seq__47428__$1);
var G__48012 = null;
var G__48013 = (0);
var G__48014 = (0);
seq__47428 = G__48011;
chunk__47429 = G__48012;
count__47430 = G__48013;
i__47431 = G__48014;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});

shadow.object.notify_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.notify_BANG_.cljs$lang$applyTo = (function (seq47407){
var G__47409 = cljs.core.first.call(null,seq47407);
var seq47407__$1 = cljs.core.next.call(null,seq47407);
var G__47411 = cljs.core.first.call(null,seq47407__$1);
var seq47407__$2 = cljs.core.next.call(null,seq47407__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47409,G__47411,seq47407__$2);
});

shadow.object.do_notify_tree = (function shadow$object$do_notify_tree(current_obj,ev,notify_fn){
var seq__47491_48015 = cljs.core.seq.call(null,shadow.object.get_children.call(null,current_obj));
var chunk__47492_48016 = null;
var count__47493_48017 = (0);
var i__47494_48018 = (0);
while(true){
if((i__47494_48018 < count__47493_48017)){
var child_48019 = cljs.core._nth.call(null,chunk__47492_48016,i__47494_48018);
shadow.object.do_notify_tree.call(null,child_48019,ev,notify_fn);


var G__48020 = seq__47491_48015;
var G__48021 = chunk__47492_48016;
var G__48022 = count__47493_48017;
var G__48023 = (i__47494_48018 + (1));
seq__47491_48015 = G__48020;
chunk__47492_48016 = G__48021;
count__47493_48017 = G__48022;
i__47494_48018 = G__48023;
continue;
} else {
var temp__5720__auto___48024 = cljs.core.seq.call(null,seq__47491_48015);
if(temp__5720__auto___48024){
var seq__47491_48025__$1 = temp__5720__auto___48024;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47491_48025__$1)){
var c__4550__auto___48029 = cljs.core.chunk_first.call(null,seq__47491_48025__$1);
var G__48030 = cljs.core.chunk_rest.call(null,seq__47491_48025__$1);
var G__48031 = c__4550__auto___48029;
var G__48032 = cljs.core.count.call(null,c__4550__auto___48029);
var G__48033 = (0);
seq__47491_48015 = G__48030;
chunk__47492_48016 = G__48031;
count__47493_48017 = G__48032;
i__47494_48018 = G__48033;
continue;
} else {
var child_48066 = cljs.core.first.call(null,seq__47491_48025__$1);
shadow.object.do_notify_tree.call(null,child_48066,ev,notify_fn);


var G__48067 = cljs.core.next.call(null,seq__47491_48025__$1);
var G__48068 = null;
var G__48069 = (0);
var G__48070 = (0);
seq__47491_48015 = G__48067;
chunk__47492_48016 = G__48068;
count__47493_48017 = G__48069;
i__47494_48018 = G__48070;
continue;
}
} else {
}
}
break;
}

return notify_fn.call(null,current_obj);
});
shadow.object.notify_tree_BANG_ = (function shadow$object$notify_tree_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48071 = arguments.length;
var i__4731__auto___48076 = (0);
while(true){
if((i__4731__auto___48076 < len__4730__auto___48071)){
args__4736__auto__.push((arguments[i__4731__auto___48076]));

var G__48078 = (i__4731__auto___48076 + (1));
i__4731__auto___48076 = G__48078;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var notify_fn = (function (obj){
return cljs.core.apply.call(null,shadow.object.notify_BANG_,obj,ev,args);
});
return shadow.object.do_notify_tree.call(null,oref,ev,notify_fn);
});

shadow.object.notify_tree_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.notify_tree_BANG_.cljs$lang$applyTo = (function (seq47513){
var G__47514 = cljs.core.first.call(null,seq47513);
var seq47513__$1 = cljs.core.next.call(null,seq47513);
var G__47515 = cljs.core.first.call(null,seq47513__$1);
var seq47513__$2 = cljs.core.next.call(null,seq47513__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47514,G__47515,seq47513__$2);
});

shadow.object.notify_down_BANG_ = shadow.object.notify_tree_BANG_;
shadow.object.notify_up_BANG_ = (function shadow$object$notify_up_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48092 = arguments.length;
var i__4731__auto___48093 = (0);
while(true){
if((i__4731__auto___48093 < len__4730__auto___48092)){
args__4736__auto__.push((arguments[i__4731__auto___48093]));

var G__48094 = (i__4731__auto___48093 + (1));
i__4731__auto___48093 = G__48094;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var current = shadow.object.get_parent.call(null,oref);
while(true){
if(cljs.core.truth_(current)){
cljs.core.apply.call(null,shadow.object.notify_BANG_,current,ev,args);

var G__48095 = shadow.object.get_parent.call(null,current);
current = G__48095;
continue;
} else {
return null;
}
break;
}
});

shadow.object.notify_up_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.notify_up_BANG_.cljs$lang$applyTo = (function (seq47520){
var G__47521 = cljs.core.first.call(null,seq47520);
var seq47520__$1 = cljs.core.next.call(null,seq47520);
var G__47522 = cljs.core.first.call(null,seq47520__$1);
var seq47520__$2 = cljs.core.next.call(null,seq47520__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47521,G__47522,seq47520__$2);
});

shadow.object.update_BANG_ = (function shadow$object$update_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48096 = arguments.length;
var i__4731__auto___48097 = (0);
while(true){
if((i__4731__auto___48097 < len__4730__auto___48096)){
args__4736__auto__.push((arguments[i__4731__auto___48097]));

var G__48098 = (i__4731__auto___48097 + (1));
i__4731__auto___48097 = G__48098;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,update_fn,args){
if(cljs.core.fn_QMARK_.call(null,update_fn)){
} else {
throw ["update! expects a fn as second arg, not ",cljs.core.pr_str.call(null,update_fn)].join('');
}

var id = shadow.object._id.call(null,oref);
var data = shadow.object._data.call(null,oref);
var work_fn = ((function (id,data){
return (function (data__$1){
return cljs.core.apply.call(null,update_fn,data__$1,args);
});})(id,data))
;
return shadow.object._update.call(null,oref,work_fn);
});

shadow.object.update_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.update_BANG_.cljs$lang$applyTo = (function (seq47531){
var G__47532 = cljs.core.first.call(null,seq47531);
var seq47531__$1 = cljs.core.next.call(null,seq47531);
var G__47533 = cljs.core.first.call(null,seq47531__$1);
var seq47531__$2 = cljs.core.next.call(null,seq47531__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47532,G__47533,seq47531__$2);
});

shadow.object.return_value = (function shadow$object$return_value(oref,return_value){
return shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360),return_value);
});
shadow.object.set_parent_BANG_ = (function shadow$object$set_parent_BANG_(child,parent){
var child_id = shadow.object._id.call(null,child);
var parent_id = shadow.object._id.call(null,parent);
cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.assoc,child_id,parent_id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_children,((function (child_id,parent_id){
return (function (x){
var current = cljs.core.get.call(null,x,parent_id,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.assoc.call(null,x,parent_id,cljs.core.conj.call(null,current,child_id));
});})(child_id,parent_id))
);

return true;
});
shadow.object.dom_destroy = (function shadow$object$dom_destroy(this$,cause){
if(cljs.core._EQ_.call(null,cause,new cljs.core.Keyword(null,"parent","parent",-878878779))){
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
var temp__5718__auto__ = shadow.object.get_type_attr.call(null,this$,new cljs.core.Keyword("dom","remove","dom/remove",-131527420));
if(cljs.core.truth_(temp__5718__auto__)){
var custom_remove = temp__5718__auto__;
return custom_remove.call(null,this$,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
}
}
});
shadow.object.destroy_BANG_ = (function shadow$object$destroy_BANG_(var_args){
var G__47582 = arguments.length;
switch (G__47582) {
case 1:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.destroy_BANG_.call(null,oref,new cljs.core.Keyword(null,"direct","direct",-1775717856));
});

shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,cause){
return shadow.object._destroy_BANG_.call(null,oref,cause);
});

shadow.object.destroy_BANG_.cljs$lang$maxFixedArity = 2;

shadow.object.bind_dom_events = (function shadow$object$bind_dom_events(oref,dom,dom_events){
if((cljs.core.rem.call(null,cljs.core.count.call(null,dom_events),(2)) === (0))){
} else {
throw cljs.core.ex_info.call(null,"object defined invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object-type","object-type",-1889869015),shadow.object._type.call(null,oref),new cljs.core.Keyword("dom","events","dom/events",1793437527),dom_events], null));
}

var seq__47591 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),dom_events));
var chunk__47592 = null;
var count__47593 = (0);
var i__47594 = (0);
while(true){
if((i__47594 < count__47593)){
var vec__47618 = cljs.core._nth.call(null,chunk__47592,i__47594);
var ev = cljs.core.nth.call(null,vec__47618,(0),null);
var handler = cljs.core.nth.call(null,vec__47618,(1),null);
var ev_def = vec__47618;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_48133__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__47591,chunk__47592,count__47593,i__47594,vec__47618,ev,handler,ev_def){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__47591,chunk__47592,count__47593,i__47594,vec__47618,ev,handler,ev_def))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__47591,chunk__47592,count__47593,i__47594,handler_48133__$1,vec__47618,ev,handler,ev_def){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_48133__$1.call(null,oref,e,el);
});})(seq__47591,chunk__47592,count__47593,i__47594,handler_48133__$1,vec__47618,ev,handler,ev_def))
);


var G__48134 = seq__47591;
var G__48135 = chunk__47592;
var G__48136 = count__47593;
var G__48137 = (i__47594 + (1));
seq__47591 = G__48134;
chunk__47592 = G__48135;
count__47593 = G__48136;
i__47594 = G__48137;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__47591);
if(temp__5720__auto__){
var seq__47591__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47591__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__47591__$1);
var G__48138 = cljs.core.chunk_rest.call(null,seq__47591__$1);
var G__48139 = c__4550__auto__;
var G__48140 = cljs.core.count.call(null,c__4550__auto__);
var G__48141 = (0);
seq__47591 = G__48138;
chunk__47592 = G__48139;
count__47593 = G__48140;
i__47594 = G__48141;
continue;
} else {
var vec__47624 = cljs.core.first.call(null,seq__47591__$1);
var ev = cljs.core.nth.call(null,vec__47624,(0),null);
var handler = cljs.core.nth.call(null,vec__47624,(1),null);
var ev_def = vec__47624;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_48142__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__47591,chunk__47592,count__47593,i__47594,vec__47624,ev,handler,ev_def,seq__47591__$1,temp__5720__auto__){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__47591,chunk__47592,count__47593,i__47594,vec__47624,ev,handler,ev_def,seq__47591__$1,temp__5720__auto__))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__47591,chunk__47592,count__47593,i__47594,handler_48142__$1,vec__47624,ev,handler,ev_def,seq__47591__$1,temp__5720__auto__){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_48142__$1.call(null,oref,e,el);
});})(seq__47591,chunk__47592,count__47593,i__47594,handler_48142__$1,vec__47624,ev,handler,ev_def,seq__47591__$1,temp__5720__auto__))
);


var G__48143 = cljs.core.next.call(null,seq__47591__$1);
var G__48144 = null;
var G__48145 = (0);
var G__48146 = (0);
seq__47591 = G__48143;
chunk__47592 = G__48144;
count__47593 = G__48145;
i__47594 = G__48146;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.object.reaction_merge = (function shadow$object$reaction_merge(result,p__47632){
var vec__47634 = p__47632;
var event = cljs.core.nth.call(null,vec__47634,(0),null);
var handler = cljs.core.nth.call(null,vec__47634,(1),null);
if(cljs.core.truth_((function (){var and__4120__auto__ = event;
if(cljs.core.truth_(and__4120__auto__)){
return handler;
} else {
return and__4120__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"invalid reaction",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
}

var current = cljs.core.get.call(null,result,event,cljs.core.List.EMPTY);
return cljs.core.assoc.call(null,result,event,cljs.core.conj.call(null,current,handler));
});
shadow.object.merge_reactions = (function shadow$object$merge_reactions(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
} else {
throw cljs.core.ex_info.call(null,"behaviors must be vectors",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,behavior))){
} else {
throw cljs.core.ex_info.call(null,"invalid behavior",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

return cljs.core.reduce.call(null,shadow.object.reaction_merge,result,cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),behavior)));
});
shadow.object.merge_behaviors = (function shadow$object$merge_behaviors(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,behavior);
} else {
if(cljs.core.map_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"watch","watch",380988277)], null),(function (watches){
return cljs.core.concat.call(null,watches,new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY));
})),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dom","events","dom/events",1793437527)], null),(function (default$){
return cljs.core.vec.call(null,cljs.core.concat.call(null,default$,new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)));
}));
} else {
throw cljs.core.ex_info.call(null,"behavior not understood",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));

}
}
});
shadow.object.define = (function shadow$object$define(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48147 = arguments.length;
var i__4731__auto___48148 = (0);
while(true){
if((i__4731__auto___48148 < len__4730__auto___48147)){
args__4736__auto__.push((arguments[i__4731__auto___48148]));

var G__48149 = (i__4731__auto___48148 + (1));
i__4731__auto___48148 = G__48149;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.object.define.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.object.define.cljs$core$IFn$_invoke$arity$variadic = (function (id,args){
if((id instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"object id needs to be a keyword",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,args))){
} else {
throw ["invalid object definition ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," args: ",cljs.core.pr_str.call(null,args)].join('');
}

if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),id)){
console.warn(["object already defined ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''));
} else {
}

try{var odef = cljs.core.apply.call(null,cljs.core.hash_map,args);
var reactions = shadow.object.merge_reactions.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY));
var odef__$1 = cljs.core.assoc.call(null,odef,new cljs.core.Keyword("shadow.object","id","shadow.object/id",-647954841),id,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),reactions);
var odef__$2 = cljs.core.reduce.call(null,shadow.object.merge_behaviors,odef__$1,cljs.core.reverse.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",120724909).cljs$core$IFn$_invoke$arity$2(odef__$1,cljs.core.PersistentVector.EMPTY)));
cljs.core.swap_BANG_.call(null,shadow.object.object_defs,cljs.core.assoc,id,odef__$2);

return odef__$2;
}catch (e47641){if((e47641 instanceof Object)){
var e = e47641;
throw cljs.core.ex_info.call(null,"failed to define object",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
} else {
throw e47641;

}
}});

shadow.object.define.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.object.define.cljs$lang$applyTo = (function (seq47639){
var G__47640 = cljs.core.first.call(null,seq47639);
var seq47639__$1 = cljs.core.next.call(null,seq47639);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47640,seq47639__$1);
});

shadow.object.merge_defaults = (function shadow$object$merge_defaults(data,type){
var defaults = cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
if((defaults == null)){
return data;
} else {
if(cljs.core.map_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults,data);
} else {
if(cljs.core.fn_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults.call(null),data);
} else {
throw cljs.core.ex_info.call(null,"invalid object defaults",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"defaults","defaults",976027214),defaults,new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
}
}
});
shadow.object.make_dom = (function shadow$object$make_dom(var_args){
var G__47643 = arguments.length;
switch (G__47643) {
case 3:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3 = (function (oref,dom_key,events_key){
return shadow.object.make_dom.call(null,oref,dom_key,events_key,null);
});

shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4 = (function (oref,dom_key,events_key,value){
var dom_fn = (((dom_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,dom_key):dom_key);
var events = (((events_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,events_key,cljs.core.PersistentVector.EMPTY):events_key);
var dom = shadow.dom.build.call(null,dom_fn.call(null,oref,value));
shadow.object.bind_dom_events.call(null,oref,dom,events);

return dom;
});

shadow.object.make_dom.cljs$lang$maxFixedArity = 4;

shadow.object.alive_QMARK_ = (function shadow$object$alive_QMARK_(obj){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.instances),shadow.object._id.call(null,obj));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.object.Watch = (function (key,handler,__meta,__extmap,__hash){
this.key = key;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k47645,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__47650 = k47645;
var G__47650__$1 = (((G__47650 instanceof cljs.core.Keyword))?G__47650.fqn:null);
switch (G__47650__$1) {
case "key":
return self__.key;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47645,else__4388__auto__);

}
});

shadow.object.Watch.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__47651){
var vec__47652 = p__47651;
var k__4408__auto__ = cljs.core.nth.call(null,vec__47652,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__47652,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.object.Watch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#shadow.object.Watch{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
});

shadow.object.Watch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47644){
var self__ = this;
var G__47644__$1 = this;
return (new cljs.core.RecordIter((0),G__47644__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

shadow.object.Watch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.object.Watch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.object.Watch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

shadow.object.Watch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-17677043 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
.call(null,this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.object.Watch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47646,other47647){
var self__ = this;
var this47646__$1 = this;
return (((!((other47647 == null)))) && ((this47646__$1.constructor === other47647.constructor)) && (cljs.core._EQ_.call(null,this47646__$1.key,other47647.key)) && (cljs.core._EQ_.call(null,this47646__$1.handler,other47647.handler)) && (cljs.core._EQ_.call(null,this47646__$1.__extmap,other47647.__extmap)));
});

shadow.object.Watch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

shadow.object.Watch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__47644){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__47655 = cljs.core.keyword_identical_QMARK_;
var expr__47656 = k__4393__auto__;
if(cljs.core.truth_(pred__47655.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__47656))){
return (new shadow.object.Watch(G__47644,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47655.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__47656))){
return (new shadow.object.Watch(self__.key,G__47644,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__47644),null));
}
}
});

shadow.object.Watch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"key","key",-1516042587),self__.key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null))], null),self__.__extmap));
});

shadow.object.Watch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__47644){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,G__47644,self__.__extmap,self__.__hash));
});

shadow.object.Watch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4391__auto__,(0)),cljs.core._nth.call(null,entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.object.Watch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
});

shadow.object.Watch.cljs$lang$type = true;

shadow.object.Watch.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.object/Watch",null,(1),null));
});

shadow.object.Watch.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.object/Watch");
});

/**
 * Positional factory function for shadow.object/Watch.
 */
shadow.object.__GT_Watch = (function shadow$object$__GT_Watch(key,handler){
return (new shadow.object.Watch(key,handler,null,null,null));
});

/**
 * Factory function for shadow.object/Watch, taking a map of keywords to field values.
 */
shadow.object.map__GT_Watch = (function shadow$object$map__GT_Watch(G__47648){
var extmap__4424__auto__ = (function (){var G__47662 = cljs.core.dissoc.call(null,G__47648,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.record_QMARK_.call(null,G__47648)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__47662);
} else {
return G__47662;
}
})();
return (new shadow.object.Watch(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__47648),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__47648),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {shadow.object.IObject}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {shadow.dom.SVGElement}
 * @implements {cljs.core.ILookup}
*/
shadow.object.ObjectRef = (function (id,type,data,watches,result_chan){
this.id = id;
this.type = type;
this.data = data;
this.watches = watches;
this.result_chan = result_chan;
this.cljs$lang$protocol_mask$partition0$ = 2149613824;
this.cljs$lang$protocol_mask$partition1$ = 2;
});
shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.result_chan,handler);
});

shadow.object.ObjectRef.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str.call(null,this$);
});

shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k);
}
});

shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,d){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k,d);
}
});

shadow.object.ObjectRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._write.call(null,writer,["#<ObjectRef {:id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),", :type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.type),"}>"].join(''));
});

shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
});

shadow.object.ObjectRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((other instanceof shadow.object.ObjectRef)) && (cljs.core._EQ_.call(null,shadow.object._id.call(null,this$__$1),shadow.object._id.call(null,other))));
});

shadow.object.ObjectRef.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
});

shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
throw (new Error("who be calling?"));
});

shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
return self__.watches = cljs.core.conj.call(null,self__.watches,(new shadow.object.Watch(key,f,null,null,null)));
});

shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return self__.watches = cljs.core.remove.call(null,((function (this$__$1){
return (function (p1__47665_SHARP_){
return cljs.core._EQ_.call(null,key,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(p1__47665_SHARP_));
});})(this$__$1))
,self__.watches);
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$ = cljs.core.PROTOCOL_SENTINEL;

shadow.object.ObjectRef.prototype.shadow$object$IObject$_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.id;
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_type$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.type;
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_data$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_update$arity$2 = (function (this$,update_fn){
var self__ = this;
var this$__$1 = this;
var old = self__.data;
var new$ = update_fn.call(null,self__.data);
self__.data = new$;

var seq__47685 = cljs.core.seq.call(null,self__.watches);
var chunk__47686 = null;
var count__47687 = (0);
var i__47688 = (0);
while(true){
if((i__47688 < count__47687)){
var map__47719 = cljs.core._nth.call(null,chunk__47686,i__47688);
var map__47719__$1 = (((((!((map__47719 == null))))?(((((map__47719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47719.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47719):map__47719);
var watch = map__47719__$1;
var key = cljs.core.get.call(null,map__47719__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__47719__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__48152 = seq__47685;
var G__48153 = chunk__47686;
var G__48154 = count__47687;
var G__48155 = (i__47688 + (1));
seq__47685 = G__48152;
chunk__47686 = G__48153;
count__47687 = G__48154;
i__47688 = G__48155;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__47685);
if(temp__5720__auto__){
var seq__47685__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47685__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__47685__$1);
var G__48156 = cljs.core.chunk_rest.call(null,seq__47685__$1);
var G__48157 = c__4550__auto__;
var G__48158 = cljs.core.count.call(null,c__4550__auto__);
var G__48159 = (0);
seq__47685 = G__48156;
chunk__47686 = G__48157;
count__47687 = G__48158;
i__47688 = G__48159;
continue;
} else {
var map__47722 = cljs.core.first.call(null,seq__47685__$1);
var map__47722__$1 = (((((!((map__47722 == null))))?(((((map__47722.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47722.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47722):map__47722);
var watch = map__47722__$1;
var key = cljs.core.get.call(null,map__47722__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__47722__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__48160 = cljs.core.next.call(null,seq__47685__$1);
var G__48161 = null;
var G__48162 = (0);
var G__48163 = (0);
seq__47685 = G__48160;
chunk__47686 = G__48161;
count__47687 = G__48162;
i__47688 = G__48163;
continue;
}
} else {
return null;
}
}
break;
}
});

shadow.object.ObjectRef.prototype.shadow$object$IObject$_destroy_BANG_$arity$2 = (function (this$,cause){
var self__ = this;
var this$__$1 = this;
var parent_id = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),self__.id);
var seq__47727_48164 = cljs.core.seq.call(null,shadow.object.get_children.call(null,this$__$1));
var chunk__47728_48165 = null;
var count__47729_48166 = (0);
var i__47730_48167 = (0);
while(true){
if((i__47730_48167 < count__47729_48166)){
var child_48168 = cljs.core._nth.call(null,chunk__47728_48165,i__47730_48167);
shadow.object._destroy_BANG_.call(null,child_48168,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__48169 = seq__47727_48164;
var G__48170 = chunk__47728_48165;
var G__48171 = count__47729_48166;
var G__48172 = (i__47730_48167 + (1));
seq__47727_48164 = G__48169;
chunk__47728_48165 = G__48170;
count__47729_48166 = G__48171;
i__47730_48167 = G__48172;
continue;
} else {
var temp__5720__auto___48173 = cljs.core.seq.call(null,seq__47727_48164);
if(temp__5720__auto___48173){
var seq__47727_48174__$1 = temp__5720__auto___48173;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47727_48174__$1)){
var c__4550__auto___48175 = cljs.core.chunk_first.call(null,seq__47727_48174__$1);
var G__48176 = cljs.core.chunk_rest.call(null,seq__47727_48174__$1);
var G__48177 = c__4550__auto___48175;
var G__48178 = cljs.core.count.call(null,c__4550__auto___48175);
var G__48179 = (0);
seq__47727_48164 = G__48176;
chunk__47728_48165 = G__48177;
count__47729_48166 = G__48178;
i__47730_48167 = G__48179;
continue;
} else {
var child_48180 = cljs.core.first.call(null,seq__47727_48174__$1);
shadow.object._destroy_BANG_.call(null,child_48180,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__48181 = cljs.core.next.call(null,seq__47727_48174__$1);
var G__48182 = null;
var G__48183 = (0);
var G__48184 = (0);
seq__47727_48164 = G__48181;
chunk__47728_48165 = G__48182;
count__47729_48166 = G__48183;
i__47730_48167 = G__48184;
continue;
}
} else {
}
}
break;
}

shadow.object.notify_BANG_.call(null,this$__$1,new cljs.core.Keyword(null,"destroy","destroy",-843660405),cause);

shadow.object.dom_destroy.call(null,this$__$1,cause);

var return_value_48185 = new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360).cljs$core$IFn$_invoke$arity$1(this$__$1);
if((return_value_48185 == null)){
} else {
cljs.core.async.put_BANG_.call(null,self__.result_chan,return_value_48185);
}

cljs.core.async.close_BANG_.call(null,self__.result_chan);

cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.dissoc,self__.id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.dissoc,self__.id);

if(cljs.core.truth_(parent_id)){
return cljs.core.swap_BANG_.call(null,shadow.object.instance_children,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent_id], null),cljs.core.disj,self__.id);
} else {
return null;
}
});

shadow.object.ObjectRef.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
});

shadow.object.ObjectRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"result-chan","result-chan",3070926,null)], null);
});

shadow.object.ObjectRef.cljs$lang$type = true;

shadow.object.ObjectRef.cljs$lang$ctorStr = "shadow.object/ObjectRef";

shadow.object.ObjectRef.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"shadow.object/ObjectRef");
});

/**
 * Positional factory function for shadow.object/ObjectRef.
 */
shadow.object.__GT_ObjectRef = (function shadow$object$__GT_ObjectRef(id,type,data,watches,result_chan){
return (new shadow.object.ObjectRef(id,type,data,watches,result_chan));
});

shadow.object.add_reaction_BANG_ = (function shadow$object$add_reaction_BANG_(var_args){
var G__47774 = arguments.length;
switch (G__47774) {
case 3:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (oref,ev,handler_fn){
return shadow.object.add_reaction_BANG_.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev,handler_fn], null));
});

shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,list){
return shadow.object.update_BANG_.call(null,oref,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,list);
});

shadow.object.add_reaction_BANG_.cljs$lang$maxFixedArity = 3;

shadow.object.bind_change = (function shadow$object$bind_change(var_args){
var G__47798 = arguments.length;
switch (G__47798) {
case 3:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,callback){
return shadow.object.bind_change.call(null,oref,attr,callback,cljs.core.gensym.call(null,"bind-change"));
});

shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4 = (function (oref,attr,callback,watch_key){
if((((!((oref == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === oref.shadow$object$IObject$))))?true:(((!oref.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref))){
} else {
throw cljs.core.ex_info.call(null,"binding currently only supports shadow objects, other atoms might leak, may add later",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref,new cljs.core.Keyword(null,"attr","attr",-604132353),attr], null));
}

var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
return cljs.core.add_watch.call(null,oref,watch_key,((function (attr__$1){
return (function shadow$object$bind_change_watch(_,___$1,old,new$){
var ov = cljs.core.get_in.call(null,old,attr__$1);
var nv = cljs.core.get_in.call(null,new$,attr__$1);
if(cljs.core._EQ_.call(null,ov,nv)){
return null;
} else {
return callback.call(null,ov,nv);
}
});})(attr__$1))
);
});

shadow.object.bind_change.cljs$lang$maxFixedArity = 4;

shadow.object.dom_enter = (function shadow$object$dom_enter(parent,child){
shadow.dom.append.call(null,parent,child);

if(cljs.core.truth_(shadow.dom.contains_QMARK_.call(null,parent))){
return shadow.object.notify_tree_BANG_.call(null,child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
} else {
return null;
}
});
shadow.object.create = (function shadow$object$create(var_args){
var args__4736__auto__ = [];
var len__4730__auto___48196 = arguments.length;
var i__4731__auto___48197 = (0);
while(true){
if((i__4731__auto___48197 < len__4730__auto___48196)){
args__4736__auto__.push((arguments[i__4731__auto___48197]));

var G__48198 = (i__4731__auto___48197 + (1));
i__4731__auto___48197 = G__48198;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return shadow.object.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

shadow.object.create.cljs$core$IFn$_invoke$arity$variadic = (function (type,args,node_children){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type)){
} else {
throw cljs.core.ex_info.call(null,["cannot create unknown child type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.map_QMARK_.call(null,args)){
} else {
throw cljs.core.ex_info.call(null,"so/create second arg must be a map",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

var oid = shadow.object.next_id.call(null);
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(args);
var result_chan = cljs.core.async.chan.call(null,(1));
var odef = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type);
var obj = cljs.core.dissoc.call(null,shadow.object.merge_defaults.call(null,cljs.core.assoc.call(null,args,new cljs.core.Keyword("shadow.object","object-id","shadow.object/object-id",-685993804),oid,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.get.call(null,odef,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.PersistentArrayMap.EMPTY)),type),new cljs.core.Keyword(null,"parent","parent",-878878779),new cljs.core.Keyword(null,"dom","dom",-1236537922));
var oref = (new shadow.object.ObjectRef(oid,type,obj,cljs.core.PersistentVector.EMPTY,result_chan));
cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.assoc,oid,oref);

if(cljs.core.truth_(parent)){
shadow.object.set_parent_BANG_.call(null,oref,parent);
} else {
}

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword(null,"init","init",-1875481434));

var dom_events_48206 = new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY);
var temp__5718__auto___48207 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(args);
if(cljs.core.truth_(temp__5718__auto___48207)){
var dom_48208 = temp__5718__auto___48207;
shadow.dom.set_data.call(null,dom_48208,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.bind_dom_events.call(null,oref,dom_48208,dom_events_48206);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_48208);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_48208);
} else {
var temp__5720__auto___48209 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___48209)){
var dom_fn_48210 = temp__5720__auto___48209;
var dom_48211 = shadow.dom.build.call(null,dom_fn_48210.call(null,oref,node_children));
shadow.dom.set_data.call(null,dom_48211,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_48211);

shadow.object.bind_dom_events.call(null,oref,dom_48211,dom_events_48206);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_48211);
} else {
}
}

var temp__5720__auto___48213 = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___48213)){
var watches_48214 = temp__5720__auto___48213;
var seq__47851_48215 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),watches_48214));
var chunk__47852_48216 = null;
var count__47853_48217 = (0);
var i__47854_48218 = (0);
while(true){
if((i__47854_48218 < count__47853_48217)){
var vec__47864_48219 = cljs.core._nth.call(null,chunk__47852_48216,i__47854_48218);
var attr_48220 = cljs.core.nth.call(null,vec__47864_48219,(0),null);
var handler_48221 = cljs.core.nth.call(null,vec__47864_48219,(1),null);
shadow.object.bind_change.call(null,oref,attr_48220,((function (seq__47851_48215,chunk__47852_48216,count__47853_48217,i__47854_48218,vec__47864_48219,attr_48220,handler_48221,watches_48214,temp__5720__auto___48213,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_48221.call(null,oref,old,new$);
});})(seq__47851_48215,chunk__47852_48216,count__47853_48217,i__47854_48218,vec__47864_48219,attr_48220,handler_48221,watches_48214,temp__5720__auto___48213,oid,parent,result_chan,odef,obj,oref))
);


var G__48222 = seq__47851_48215;
var G__48223 = chunk__47852_48216;
var G__48224 = count__47853_48217;
var G__48225 = (i__47854_48218 + (1));
seq__47851_48215 = G__48222;
chunk__47852_48216 = G__48223;
count__47853_48217 = G__48224;
i__47854_48218 = G__48225;
continue;
} else {
var temp__5720__auto___48226__$1 = cljs.core.seq.call(null,seq__47851_48215);
if(temp__5720__auto___48226__$1){
var seq__47851_48228__$1 = temp__5720__auto___48226__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47851_48228__$1)){
var c__4550__auto___48229 = cljs.core.chunk_first.call(null,seq__47851_48228__$1);
var G__48233 = cljs.core.chunk_rest.call(null,seq__47851_48228__$1);
var G__48234 = c__4550__auto___48229;
var G__48235 = cljs.core.count.call(null,c__4550__auto___48229);
var G__48236 = (0);
seq__47851_48215 = G__48233;
chunk__47852_48216 = G__48234;
count__47853_48217 = G__48235;
i__47854_48218 = G__48236;
continue;
} else {
var vec__47870_48237 = cljs.core.first.call(null,seq__47851_48228__$1);
var attr_48238 = cljs.core.nth.call(null,vec__47870_48237,(0),null);
var handler_48239 = cljs.core.nth.call(null,vec__47870_48237,(1),null);
shadow.object.bind_change.call(null,oref,attr_48238,((function (seq__47851_48215,chunk__47852_48216,count__47853_48217,i__47854_48218,vec__47870_48237,attr_48238,handler_48239,seq__47851_48228__$1,temp__5720__auto___48226__$1,watches_48214,temp__5720__auto___48213,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_48239.call(null,oref,old,new$);
});})(seq__47851_48215,chunk__47852_48216,count__47853_48217,i__47854_48218,vec__47870_48237,attr_48238,handler_48239,seq__47851_48228__$1,temp__5720__auto___48226__$1,watches_48214,temp__5720__auto___48213,oid,parent,result_chan,odef,obj,oref))
);


var G__48240 = cljs.core.next.call(null,seq__47851_48228__$1);
var G__48241 = null;
var G__48242 = (0);
var G__48243 = (0);
seq__47851_48215 = G__48240;
chunk__47852_48216 = G__48241;
count__47853_48217 = G__48242;
i__47854_48218 = G__48243;
continue;
}
} else {
}
}
break;
}
} else {
}

return oref;
});

shadow.object.create.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
shadow.object.create.cljs$lang$applyTo = (function (seq47833){
var G__47834 = cljs.core.first.call(null,seq47833);
var seq47833__$1 = cljs.core.next.call(null,seq47833);
var G__47835 = cljs.core.first.call(null,seq47833__$1);
var seq47833__$2 = cljs.core.next.call(null,seq47833__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47834,G__47835,seq47833__$2);
});

/**
 * [oref attr node-gen] produces a node via (node-gen new-value)
 * watches obj for changes and replaces the generated node on change (node-gen defaults to str)
 * 
 *   only use if the node has no attached behavior like clicks, use bind with an extra object for those
 */
shadow.object.bind_simple = (function shadow$object$bind_simple(var_args){
var G__47880 = arguments.length;
switch (G__47880) {
case 2:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2 = (function (oref,attr){
return shadow.object.bind_simple.call(null,oref,attr,cljs.core.str);
});

shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,node_gen){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var node_get = ((function (attr__$1){
return (function (p1__47878_SHARP_){
return shadow.dom.build.call(null,node_gen.call(null,p1__47878_SHARP_));
});})(attr__$1))
;
var node = cljs.core.atom.call(null,node_get.call(null,cljs.core.get_in.call(null,oref,attr__$1)));
var bind_key = cljs.core.gensym.call(null,"bind");
shadow.object.bind_change.call(null,oref,attr__$1,((function (attr__$1,node_get,node,bind_key){
return (function (old,new$){
var new_node = node_get.call(null,new$);
var current_node = cljs.core.deref.call(null,node);
shadow.dom.replace_node.call(null,current_node,new_node);

return cljs.core.reset_BANG_.call(null,node,new_node);
});})(attr__$1,node_get,node,bind_key))
);

return cljs.core.deref.call(null,node);
});

shadow.object.bind_simple.cljs$lang$maxFixedArity = 3;

/**
 * bind the given attribute a child item
 *   the item will be recreated whenever the value changes (old one will be destroyed)
 */
shadow.object.bind = (function shadow$object$bind(oref,attr,item_type,item_key,item_attrs){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var curval = cljs.core.get_in.call(null,oref,attr__$1);
var make_child_fn = ((function (attr__$1,curval){
return (function (value){
return shadow.object.create.call(null,item_type,cljs.core.merge.call(null,item_attrs,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),oref,item_key,value])));
});})(attr__$1,curval))
;
var child = cljs.core.atom.call(null,make_child_fn.call(null,curval));
shadow.object.bind_change.call(null,oref,attr__$1,((function (attr__$1,curval,make_child_fn,child){
return (function (old,new$){
var new_child = make_child_fn.call(null,new$);
var current_node = cljs.core.deref.call(null,child);
shadow.dom.replace_node.call(null,current_node,new_child);

shadow.object.destroy_BANG_.call(null,cljs.core.deref.call(null,child));

cljs.core.reset_BANG_.call(null,child,new_child);

return shadow.object.notify_down_BANG_.call(null,new_child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
});})(attr__$1,curval,make_child_fn,child))
);

return cljs.core.deref.call(null,child);
});
shadow.object.coll_destroy_children = (function shadow$object$coll_destroy_children(children,c,diff){
var seq__47890_48248 = cljs.core.seq.call(null,cljs.core.subvec.call(null,children,(c + diff),c));
var chunk__47891_48249 = null;
var count__47892_48250 = (0);
var i__47893_48251 = (0);
while(true){
if((i__47893_48251 < count__47892_48250)){
var obj_48252 = cljs.core._nth.call(null,chunk__47891_48249,i__47893_48251);
var obj_48253__$1 = shadow.object.get_from_dom.call(null,obj_48252);
shadow.object.destroy_BANG_.call(null,obj_48253__$1);


var G__48254 = seq__47890_48248;
var G__48255 = chunk__47891_48249;
var G__48256 = count__47892_48250;
var G__48257 = (i__47893_48251 + (1));
seq__47890_48248 = G__48254;
chunk__47891_48249 = G__48255;
count__47892_48250 = G__48256;
i__47893_48251 = G__48257;
continue;
} else {
var temp__5720__auto___48258 = cljs.core.seq.call(null,seq__47890_48248);
if(temp__5720__auto___48258){
var seq__47890_48259__$1 = temp__5720__auto___48258;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47890_48259__$1)){
var c__4550__auto___48260 = cljs.core.chunk_first.call(null,seq__47890_48259__$1);
var G__48261 = cljs.core.chunk_rest.call(null,seq__47890_48259__$1);
var G__48262 = c__4550__auto___48260;
var G__48263 = cljs.core.count.call(null,c__4550__auto___48260);
var G__48264 = (0);
seq__47890_48248 = G__48261;
chunk__47891_48249 = G__48262;
count__47892_48250 = G__48263;
i__47893_48251 = G__48264;
continue;
} else {
var obj_48265 = cljs.core.first.call(null,seq__47890_48259__$1);
var obj_48266__$1 = shadow.object.get_from_dom.call(null,obj_48265);
shadow.object.destroy_BANG_.call(null,obj_48266__$1);


var G__48267 = cljs.core.next.call(null,seq__47890_48259__$1);
var G__48268 = null;
var G__48269 = (0);
var G__48270 = (0);
seq__47890_48248 = G__48267;
chunk__47891_48249 = G__48268;
count__47892_48250 = G__48269;
i__47893_48251 = G__48270;
continue;
}
} else {
}
}
break;
}

return cljs.core.subvec.call(null,children,(0),(c + diff));
});
shadow.object.bind_children = (function shadow$object$bind_children(var_args){
var G__47904 = arguments.length;
switch (G__47904) {
case 5:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5 = (function (node,parent,attr,item_type,item_key){
return shadow.object.bind_children.call(null,node,parent,attr,item_type,item_key,(function (p1__47901_SHARP_){
return cljs.core.map_indexed.call(null,cljs.core.vector,p1__47901_SHARP_);
}));
});

shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6 = (function (node,parent,attr,item_type,item_key,coll_transform){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var update_children = cljs.core.atom.call(null,true);
var coll_dom = shadow.dom.build.call(null,node);
var make_item_fn = ((function (attr__$1,update_children,coll_dom){
return (function (p__47908){
var vec__47909 = p__47908;
var key = cljs.core.nth.call(null,vec__47909,(0),null);
var val = cljs.core.nth.call(null,vec__47909,(1),null);
var obj = shadow.object.create.call(null,item_type,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),parent,new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048),attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616),key,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366),item_key,item_key,val]));
shadow.object.bind_change.call(null,obj,item_key,((function (obj,vec__47909,key,val,attr__$1,update_children,coll_dom){
return (function (old,new$){
var parent_key = cljs.core.conj.call(null,attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(obj));
shadow.object.log.call(null,"direct child update",parent,obj,key,parent_key,new$);

cljs.core.reset_BANG_.call(null,update_children,false);

shadow.object.update_BANG_.call(null,parent,cljs.core.assoc_in,parent_key,new$);

return cljs.core.reset_BANG_.call(null,update_children,true);
});})(obj,vec__47909,key,val,attr__$1,update_children,coll_dom))
);

return obj;
});})(attr__$1,update_children,coll_dom))
;
var seq__47912_48281 = cljs.core.seq.call(null,coll_transform.call(null,cljs.core.get_in.call(null,parent,attr__$1)));
var chunk__47913_48282 = null;
var count__47914_48283 = (0);
var i__47915_48284 = (0);
while(true){
if((i__47915_48284 < count__47914_48283)){
var item_48285 = cljs.core._nth.call(null,chunk__47913_48282,i__47915_48284);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48285));


var G__48286 = seq__47912_48281;
var G__48287 = chunk__47913_48282;
var G__48288 = count__47914_48283;
var G__48289 = (i__47915_48284 + (1));
seq__47912_48281 = G__48286;
chunk__47913_48282 = G__48287;
count__47914_48283 = G__48288;
i__47915_48284 = G__48289;
continue;
} else {
var temp__5720__auto___48290 = cljs.core.seq.call(null,seq__47912_48281);
if(temp__5720__auto___48290){
var seq__47912_48291__$1 = temp__5720__auto___48290;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47912_48291__$1)){
var c__4550__auto___48292 = cljs.core.chunk_first.call(null,seq__47912_48291__$1);
var G__48293 = cljs.core.chunk_rest.call(null,seq__47912_48291__$1);
var G__48294 = c__4550__auto___48292;
var G__48295 = cljs.core.count.call(null,c__4550__auto___48292);
var G__48296 = (0);
seq__47912_48281 = G__48293;
chunk__47913_48282 = G__48294;
count__47914_48283 = G__48295;
i__47915_48284 = G__48296;
continue;
} else {
var item_48297 = cljs.core.first.call(null,seq__47912_48291__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48297));


var G__48298 = cljs.core.next.call(null,seq__47912_48291__$1);
var G__48299 = null;
var G__48300 = (0);
var G__48301 = (0);
seq__47912_48281 = G__48298;
chunk__47913_48282 = G__48299;
count__47914_48283 = G__48300;
i__47915_48284 = G__48301;
continue;
}
} else {
}
}
break;
}

shadow.object.bind_change.call(null,parent,attr__$1,((function (attr__$1,update_children,coll_dom,make_item_fn){
return (function shadow$object$bind_children_watch(old,new$){
if(cljs.core.truth_(cljs.core.deref.call(null,update_children))){
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,shadow.dom.children.call(null,coll_dom));
var new_coll = cljs.core.vec.call(null,coll_transform.call(null,new$));
var count_children = cljs.core.count.call(null,children);
var count_new = cljs.core.count.call(null,new$);
var diff = (count_new - count_children);
var children__$1 = (((diff < (0)))?shadow.object.coll_destroy_children.call(null,children,count_children,diff):children);
var count_children__$1 = (function (){var x__4222__auto__ = count_new;
var y__4223__auto__ = count_children;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var n__4607__auto___48306 = count_children__$1;
var idx_48307 = (0);
while(true){
if((idx_48307 < n__4607__auto___48306)){
var cn_48308 = cljs.core.nth.call(null,children__$1,idx_48307);
var cc_48309 = shadow.object.get_from_dom.call(null,cn_48308);
var ckey_48310 = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(cc_48309);
var cval_48311 = cljs.core.get.call(null,cc_48309,item_key);
var vec__47925_48312 = cljs.core.nth.call(null,new_coll,idx_48307);
var nkey_48313 = cljs.core.nth.call(null,vec__47925_48312,(0),null);
var nval_48314 = cljs.core.nth.call(null,vec__47925_48312,(1),null);
if(((cljs.core._EQ_.call(null,ckey_48310,nkey_48313)) && (cljs.core._EQ_.call(null,cval_48311,nval_48314)))){
} else {
var new_obj_48315 = make_item_fn.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nkey_48313,nval_48314], null));
shadow.dom.replace_node.call(null,cn_48308,new_obj_48315);

shadow.object.destroy_BANG_.call(null,cc_48309);

shadow.object.notify_tree_BANG_.call(null,new_obj_48315,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}

var G__48316 = (idx_48307 + (1));
idx_48307 = G__48316;
continue;
} else {
}
break;
}

if((diff > (0))){
var seq__47928_48326 = cljs.core.seq.call(null,cljs.core.subvec.call(null,new_coll,count_children__$1,count_new));
var chunk__47929_48327 = null;
var count__47930_48328 = (0);
var i__47931_48329 = (0);
while(true){
if((i__47931_48329 < count__47930_48328)){
var item_48331 = cljs.core._nth.call(null,chunk__47929_48327,i__47931_48329);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48331));


var G__48332 = seq__47928_48326;
var G__48333 = chunk__47929_48327;
var G__48334 = count__47930_48328;
var G__48335 = (i__47931_48329 + (1));
seq__47928_48326 = G__48332;
chunk__47929_48327 = G__48333;
count__47930_48328 = G__48334;
i__47931_48329 = G__48335;
continue;
} else {
var temp__5720__auto___48336 = cljs.core.seq.call(null,seq__47928_48326);
if(temp__5720__auto___48336){
var seq__47928_48337__$1 = temp__5720__auto___48336;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47928_48337__$1)){
var c__4550__auto___48338 = cljs.core.chunk_first.call(null,seq__47928_48337__$1);
var G__48339 = cljs.core.chunk_rest.call(null,seq__47928_48337__$1);
var G__48340 = c__4550__auto___48338;
var G__48341 = cljs.core.count.call(null,c__4550__auto___48338);
var G__48342 = (0);
seq__47928_48326 = G__48339;
chunk__47929_48327 = G__48340;
count__47930_48328 = G__48341;
i__47931_48329 = G__48342;
continue;
} else {
var item_48343 = cljs.core.first.call(null,seq__47928_48337__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_48343));


var G__48344 = cljs.core.next.call(null,seq__47928_48337__$1);
var G__48345 = null;
var G__48346 = (0);
var G__48347 = (0);
seq__47928_48326 = G__48344;
chunk__47929_48327 = G__48345;
count__47930_48328 = G__48346;
i__47931_48329 = G__48347;
continue;
}
} else {
}
}
break;
}
} else {
}

return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160));
} else {
return null;
}
});})(attr__$1,update_children,coll_dom,make_item_fn))
);

return coll_dom;
});

shadow.object.bind_children.cljs$lang$maxFixedArity = 6;

shadow.object.remove_in_parent_BANG_ = (function shadow$object$remove_in_parent_BANG_(oref){
var parent = shadow.object.get_parent.call(null,oref);
var key = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(oref);
var value = cljs.core.get.call(null,oref,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref));
var path = new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048).cljs$core$IFn$_invoke$arity$1(oref);
if(cljs.core.truth_((function (){var and__4120__auto__ = key;
if(cljs.core.truth_(and__4120__auto__)){
return path;
} else {
return and__4120__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"remove-in-parent! should only be called from items created via so/bind-children",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

var coll = cljs.core.get_in.call(null,parent,path);
var new_coll = shadow.util.remove_item_from_coll.call(null,coll,key,value);
return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword("bind","update","bind/update",1048601733),path,new_coll);
});
shadow.object.inspect_BANG_ = (function shadow$object$inspect_BANG_(oref){
return shadow.object.info.call(null,"inspect!",shadow.object._id.call(null,oref),cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.object._type.call(null,oref)),cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,shadow.object._data.call(null,oref))));
});
shadow.object.dump_BANG_ = (function shadow$object$dump_BANG_(){
shadow.object.info.call(null,"--------------- LIVE OBJECTS ------------");

var seq__47943_48350 = cljs.core.seq.call(null,cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.object.instances)));
var chunk__47944_48351 = null;
var count__47945_48352 = (0);
var i__47946_48353 = (0);
while(true){
if((i__47946_48353 < count__47945_48352)){
var vec__47955_48355 = cljs.core._nth.call(null,chunk__47944_48351,i__47946_48353);
var id_48356 = cljs.core.nth.call(null,vec__47955_48355,(0),null);
var oref_48357 = cljs.core.nth.call(null,vec__47955_48355,(1),null);
shadow.object.info.call(null,"dump",id_48356,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_48357)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_48357)));


var G__48358 = seq__47943_48350;
var G__48359 = chunk__47944_48351;
var G__48360 = count__47945_48352;
var G__48361 = (i__47946_48353 + (1));
seq__47943_48350 = G__48358;
chunk__47944_48351 = G__48359;
count__47945_48352 = G__48360;
i__47946_48353 = G__48361;
continue;
} else {
var temp__5720__auto___48362 = cljs.core.seq.call(null,seq__47943_48350);
if(temp__5720__auto___48362){
var seq__47943_48363__$1 = temp__5720__auto___48362;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47943_48363__$1)){
var c__4550__auto___48364 = cljs.core.chunk_first.call(null,seq__47943_48363__$1);
var G__48365 = cljs.core.chunk_rest.call(null,seq__47943_48363__$1);
var G__48366 = c__4550__auto___48364;
var G__48367 = cljs.core.count.call(null,c__4550__auto___48364);
var G__48368 = (0);
seq__47943_48350 = G__48365;
chunk__47944_48351 = G__48366;
count__47945_48352 = G__48367;
i__47946_48353 = G__48368;
continue;
} else {
var vec__47959_48369 = cljs.core.first.call(null,seq__47943_48363__$1);
var id_48370 = cljs.core.nth.call(null,vec__47959_48369,(0),null);
var oref_48371 = cljs.core.nth.call(null,vec__47959_48369,(1),null);
shadow.object.info.call(null,"dump",id_48370,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_48371)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_48371)));


var G__48373 = cljs.core.next.call(null,seq__47943_48363__$1);
var G__48374 = null;
var G__48375 = (0);
var G__48376 = (0);
seq__47943_48350 = G__48373;
chunk__47944_48351 = G__48374;
count__47945_48352 = G__48375;
i__47946_48353 = G__48376;
continue;
}
} else {
}
}
break;
}

return shadow.object.info.call(null,"--------------- //LIVE OBJECTS ------------");
});
goog.exportSymbol('shadow.object.dump_BANG_', shadow.object.dump_BANG_);

//# sourceMappingURL=shadow.object.js.map
