goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__43038){
var map__43039 = p__43038;
var map__43039__$1 = (((((!((map__43039 == null))))?(((((map__43039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43039):map__43039);
var m = map__43039__$1;
var n = cljs.core.get.call(null,map__43039__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__43039__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5720__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__43047_43125 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__43048_43126 = null;
var count__43049_43127 = (0);
var i__43050_43128 = (0);
while(true){
if((i__43050_43128 < count__43049_43127)){
var f_43129 = cljs.core._nth.call(null,chunk__43048_43126,i__43050_43128);
cljs.core.println.call(null,"  ",f_43129);


var G__43130 = seq__43047_43125;
var G__43131 = chunk__43048_43126;
var G__43132 = count__43049_43127;
var G__43133 = (i__43050_43128 + (1));
seq__43047_43125 = G__43130;
chunk__43048_43126 = G__43131;
count__43049_43127 = G__43132;
i__43050_43128 = G__43133;
continue;
} else {
var temp__5720__auto___43134 = cljs.core.seq.call(null,seq__43047_43125);
if(temp__5720__auto___43134){
var seq__43047_43135__$1 = temp__5720__auto___43134;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43047_43135__$1)){
var c__4550__auto___43136 = cljs.core.chunk_first.call(null,seq__43047_43135__$1);
var G__43137 = cljs.core.chunk_rest.call(null,seq__43047_43135__$1);
var G__43138 = c__4550__auto___43136;
var G__43139 = cljs.core.count.call(null,c__4550__auto___43136);
var G__43140 = (0);
seq__43047_43125 = G__43137;
chunk__43048_43126 = G__43138;
count__43049_43127 = G__43139;
i__43050_43128 = G__43140;
continue;
} else {
var f_43141 = cljs.core.first.call(null,seq__43047_43135__$1);
cljs.core.println.call(null,"  ",f_43141);


var G__43142 = cljs.core.next.call(null,seq__43047_43135__$1);
var G__43143 = null;
var G__43144 = (0);
var G__43145 = (0);
seq__43047_43125 = G__43142;
chunk__43048_43126 = G__43143;
count__43049_43127 = G__43144;
i__43050_43128 = G__43145;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_43146 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_43146);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_43146)))?cljs.core.second.call(null,arglists_43146):arglists_43146));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__43054_43147 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__43055_43148 = null;
var count__43056_43149 = (0);
var i__43057_43150 = (0);
while(true){
if((i__43057_43150 < count__43056_43149)){
var vec__43068_43151 = cljs.core._nth.call(null,chunk__43055_43148,i__43057_43150);
var name_43152 = cljs.core.nth.call(null,vec__43068_43151,(0),null);
var map__43071_43153 = cljs.core.nth.call(null,vec__43068_43151,(1),null);
var map__43071_43154__$1 = (((((!((map__43071_43153 == null))))?(((((map__43071_43153.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43071_43153.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43071_43153):map__43071_43153);
var doc_43155 = cljs.core.get.call(null,map__43071_43154__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43156 = cljs.core.get.call(null,map__43071_43154__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_43152);

cljs.core.println.call(null," ",arglists_43156);

if(cljs.core.truth_(doc_43155)){
cljs.core.println.call(null," ",doc_43155);
} else {
}


var G__43167 = seq__43054_43147;
var G__43168 = chunk__43055_43148;
var G__43169 = count__43056_43149;
var G__43170 = (i__43057_43150 + (1));
seq__43054_43147 = G__43167;
chunk__43055_43148 = G__43168;
count__43056_43149 = G__43169;
i__43057_43150 = G__43170;
continue;
} else {
var temp__5720__auto___43171 = cljs.core.seq.call(null,seq__43054_43147);
if(temp__5720__auto___43171){
var seq__43054_43172__$1 = temp__5720__auto___43171;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43054_43172__$1)){
var c__4550__auto___43173 = cljs.core.chunk_first.call(null,seq__43054_43172__$1);
var G__43174 = cljs.core.chunk_rest.call(null,seq__43054_43172__$1);
var G__43175 = c__4550__auto___43173;
var G__43176 = cljs.core.count.call(null,c__4550__auto___43173);
var G__43177 = (0);
seq__43054_43147 = G__43174;
chunk__43055_43148 = G__43175;
count__43056_43149 = G__43176;
i__43057_43150 = G__43177;
continue;
} else {
var vec__43073_43178 = cljs.core.first.call(null,seq__43054_43172__$1);
var name_43179 = cljs.core.nth.call(null,vec__43073_43178,(0),null);
var map__43076_43180 = cljs.core.nth.call(null,vec__43073_43178,(1),null);
var map__43076_43181__$1 = (((((!((map__43076_43180 == null))))?(((((map__43076_43180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43076_43180.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43076_43180):map__43076_43180);
var doc_43182 = cljs.core.get.call(null,map__43076_43181__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_43183 = cljs.core.get.call(null,map__43076_43181__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_43179);

cljs.core.println.call(null," ",arglists_43183);

if(cljs.core.truth_(doc_43182)){
cljs.core.println.call(null," ",doc_43182);
} else {
}


var G__43184 = cljs.core.next.call(null,seq__43054_43172__$1);
var G__43185 = null;
var G__43186 = (0);
var G__43187 = (0);
seq__43054_43147 = G__43184;
chunk__43055_43148 = G__43185;
count__43056_43149 = G__43186;
i__43057_43150 = G__43187;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5720__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5720__auto__)){
var fnspec = temp__5720__auto__;
cljs.core.print.call(null,"Spec");

var seq__43078 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__43079 = null;
var count__43080 = (0);
var i__43081 = (0);
while(true){
if((i__43081 < count__43080)){
var role = cljs.core._nth.call(null,chunk__43079,i__43081);
var temp__5720__auto___43188__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___43188__$1)){
var spec_43189 = temp__5720__auto___43188__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_43189));
} else {
}


var G__43193 = seq__43078;
var G__43194 = chunk__43079;
var G__43195 = count__43080;
var G__43196 = (i__43081 + (1));
seq__43078 = G__43193;
chunk__43079 = G__43194;
count__43080 = G__43195;
i__43081 = G__43196;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__43078);
if(temp__5720__auto____$1){
var seq__43078__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43078__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__43078__$1);
var G__43197 = cljs.core.chunk_rest.call(null,seq__43078__$1);
var G__43198 = c__4550__auto__;
var G__43199 = cljs.core.count.call(null,c__4550__auto__);
var G__43200 = (0);
seq__43078 = G__43197;
chunk__43079 = G__43198;
count__43080 = G__43199;
i__43081 = G__43200;
continue;
} else {
var role = cljs.core.first.call(null,seq__43078__$1);
var temp__5720__auto___43201__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___43201__$2)){
var spec_43202 = temp__5720__auto___43201__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_43202));
} else {
}


var G__43203 = cljs.core.next.call(null,seq__43078__$1);
var G__43204 = null;
var G__43205 = (0);
var G__43206 = (0);
seq__43078 = G__43203;
chunk__43079 = G__43204;
count__43080 = G__43205;
i__43081 = G__43206;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var ed = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__43207 = cljs.core.conj.call(null,via,t);
var G__43208 = cljs.core.ex_cause.call(null,t);
via = G__43207;
t = G__43208;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var root_msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var data = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5720__auto__)){
var phase = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__43084 = datafied_throwable;
var map__43084__$1 = (((((!((map__43084 == null))))?(((((map__43084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43084):map__43084);
var via = cljs.core.get.call(null,map__43084__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__43084__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__43084__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__43085 = cljs.core.last.call(null,via);
var map__43085__$1 = (((((!((map__43085 == null))))?(((((map__43085.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43085.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43085):map__43085);
var type = cljs.core.get.call(null,map__43085__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__43085__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__43085__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__43086 = data;
var map__43086__$1 = (((((!((map__43086 == null))))?(((((map__43086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43086.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43086):map__43086);
var problems = cljs.core.get.call(null,map__43086__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__43086__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__43086__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__43087 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__43087__$1 = (((((!((map__43087 == null))))?(((((map__43087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43087.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43087):map__43087);
var top_data = map__43087__$1;
var source = cljs.core.get.call(null,map__43087__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__43092 = phase;
var G__43092__$1 = (((G__43092 instanceof cljs.core.Keyword))?G__43092.fqn:null);
switch (G__43092__$1) {
case "read-source":
var map__43093 = data;
var map__43093__$1 = (((((!((map__43093 == null))))?(((((map__43093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43093.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43093):map__43093);
var line = cljs.core.get.call(null,map__43093__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__43093__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__43095 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__43095__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__43095,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__43095);
var G__43095__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__43095__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__43095__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__43095__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__43095__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__43096 = top_data;
var G__43096__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__43096,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__43096);
var G__43096__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__43096__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__43096__$1);
var G__43096__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__43096__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__43096__$2);
var G__43096__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__43096__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__43096__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__43096__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__43096__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__43097 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__43097,(0),null);
var method = cljs.core.nth.call(null,vec__43097,(1),null);
var file = cljs.core.nth.call(null,vec__43097,(2),null);
var line = cljs.core.nth.call(null,vec__43097,(3),null);
var G__43100 = top_data;
var G__43100__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__43100,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__43100);
var G__43100__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__43100__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__43100__$1);
var G__43100__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__43100__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__43100__$2);
var G__43100__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__43100__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__43100__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__43100__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__43100__$4;
}

break;
case "execution":
var vec__43101 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__43101,(0),null);
var method = cljs.core.nth.call(null,vec__43101,(1),null);
var file = cljs.core.nth.call(null,vec__43101,(2),null);
var line = cljs.core.nth.call(null,vec__43101,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__43101,source__$1,method,file,line,G__43092,G__43092__$1,map__43084,map__43084__$1,via,trace,phase,map__43085,map__43085__$1,type,message,data,map__43086,map__43086__$1,problems,fn,caller,map__43087,map__43087__$1,top_data,source){
return (function (p1__43083_SHARP_){
var or__4131__auto__ = (p1__43083_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__43083_SHARP_);
}
});})(vec__43101,source__$1,method,file,line,G__43092,G__43092__$1,map__43084,map__43084__$1,via,trace,phase,map__43085,map__43085__$1,type,message,data,map__43086,map__43086__$1,problems,fn,caller,map__43087,map__43087__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__43106 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__43106__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__43106,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__43106);
var G__43106__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__43106__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__43106__$1);
var G__43106__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__43106__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__43106__$2);
var G__43106__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__43106__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__43106__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__43106__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__43106__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43092__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__43110){
var map__43111 = p__43110;
var map__43111__$1 = (((((!((map__43111 == null))))?(((((map__43111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43111.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43111):map__43111);
var triage_data = map__43111__$1;
var phase = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__43111__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__43113 = phase;
var G__43113__$1 = (((G__43113 instanceof cljs.core.Keyword))?G__43113.fqn:null);
switch (G__43113__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43114_43228 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43115_43229 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43116_43230 = true;
var _STAR_print_fn_STAR__temp_val__43117_43231 = ((function (_STAR_print_newline_STAR__orig_val__43114_43228,_STAR_print_fn_STAR__orig_val__43115_43229,_STAR_print_newline_STAR__temp_val__43116_43230,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__43114_43228,_STAR_print_fn_STAR__orig_val__43115_43229,_STAR_print_newline_STAR__temp_val__43116_43230,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43116_43230;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43117_43231;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__43114_43228,_STAR_print_fn_STAR__orig_val__43115_43229,_STAR_print_newline_STAR__temp_val__43116_43230,_STAR_print_fn_STAR__temp_val__43117_43231,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__43114_43228,_STAR_print_fn_STAR__orig_val__43115_43229,_STAR_print_newline_STAR__temp_val__43116_43230,_STAR_print_fn_STAR__temp_val__43117_43231,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__43108_SHARP_){
return cljs.core.dissoc.call(null,p1__43108_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__43114_43228,_STAR_print_fn_STAR__orig_val__43115_43229,_STAR_print_newline_STAR__temp_val__43116_43230,_STAR_print_fn_STAR__temp_val__43117_43231,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__43114_43228,_STAR_print_fn_STAR__orig_val__43115_43229,_STAR_print_newline_STAR__temp_val__43116_43230,_STAR_print_fn_STAR__temp_val__43117_43231,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43115_43229;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43114_43228;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43118_43232 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43119_43233 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43120_43234 = true;
var _STAR_print_fn_STAR__temp_val__43121_43235 = ((function (_STAR_print_newline_STAR__orig_val__43118_43232,_STAR_print_fn_STAR__orig_val__43119_43233,_STAR_print_newline_STAR__temp_val__43120_43234,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__43118_43232,_STAR_print_fn_STAR__orig_val__43119_43233,_STAR_print_newline_STAR__temp_val__43120_43234,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43120_43234;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43121_43235;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__43118_43232,_STAR_print_fn_STAR__orig_val__43119_43233,_STAR_print_newline_STAR__temp_val__43120_43234,_STAR_print_fn_STAR__temp_val__43121_43235,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__43118_43232,_STAR_print_fn_STAR__orig_val__43119_43233,_STAR_print_newline_STAR__temp_val__43120_43234,_STAR_print_fn_STAR__temp_val__43121_43235,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__43109_SHARP_){
return cljs.core.dissoc.call(null,p1__43109_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__43118_43232,_STAR_print_fn_STAR__orig_val__43119_43233,_STAR_print_newline_STAR__temp_val__43120_43234,_STAR_print_fn_STAR__temp_val__43121_43235,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__43118_43232,_STAR_print_fn_STAR__orig_val__43119_43233,_STAR_print_newline_STAR__temp_val__43120_43234,_STAR_print_fn_STAR__temp_val__43121_43235,sb__4661__auto__,G__43113,G__43113__$1,loc,class_name,simple_class,cause_type,format,map__43111,map__43111__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43119_43233;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43118_43232;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43113__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=cljs.repl.js.map
