goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.call(null,null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return cljs.core._vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.active_modules_ref,cljs.core.conj.call(null,cljs.core._deref.call(null,shadow.cljs.devtools.client.browser.active_modules_ref),cljs.core.keyword.call(null,name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_.call(null,null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__6930__auto__ = [];
var len__6920__auto___58078 = arguments.length;
var i__6921__auto___58080 = (0);
while(true){
if((i__6921__auto___58080 < len__6920__auto___58078)){
args__6930__auto__.push((arguments[i__6921__auto___58080]));

var G__58081 = (i__6921__auto___58080 + (1));
i__6921__auto___58080 = G__58081;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(null,cljs.core.into_array.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq57818){
var G__57819 = cljs.core.first.call(null,seq57818);
var seq57818__$1 = cljs.core.next.call(null,seq57818);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57819,seq57818__$1);
}));

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5718__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s.send(cljs.core.pr_str.call(null,msg));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.call(null,msg));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__57843){
var map__57844 = p__57843;
var map__57844__$1 = (((((!((map__57844 == null))))?(((((map__57844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57844):map__57844);
var src = map__57844__$1;
var resource_id = cljs.core.get.call(null,map__57844__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__57844__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__5598__auto__ = cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_.call(null,output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__57853 = cljs.core.seq.call(null,sources);
var chunk__57854 = null;
var count__57855 = (0);
var i__57856 = (0);
while(true){
if((i__57856 < count__57855)){
var map__57864 = cljs.core._nth.call(null,chunk__57854,i__57856);
var map__57864__$1 = (((((!((map__57864 == null))))?(((((map__57864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57864.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57864):map__57864);
var src = map__57864__$1;
var resource_id = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__57864__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__58106 = seq__57853;
var G__58107 = chunk__57854;
var G__58108 = count__57855;
var G__58109 = (i__57856 + (1));
seq__57853 = G__58106;
chunk__57854 = G__58107;
count__57855 = G__58108;
i__57856 = G__58109;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__57853);
if(temp__5720__auto__){
var seq__57853__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57853__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__57853__$1);
var G__58112 = cljs.core.chunk_rest.call(null,seq__57853__$1);
var G__58113 = c__6568__auto__;
var G__58114 = cljs.core.count.call(null,c__6568__auto__);
var G__58115 = (0);
seq__57853 = G__58112;
chunk__57854 = G__58113;
count__57855 = G__58114;
i__57856 = G__58115;
continue;
} else {
var map__57868 = cljs.core.first.call(null,seq__57853__$1);
var map__57868__$1 = (((((!((map__57868 == null))))?(((((map__57868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57868):map__57868);
var src = map__57868__$1;
var resource_id = cljs.core.get.call(null,map__57868__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.call(null,map__57868__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.call(null,map__57868__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.call(null,map__57868__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load JS",resource_name);

shadow.cljs.devtools.client.env.before_load_src.call(null,src);

shadow.cljs.devtools.client.browser.script_eval.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__58119 = cljs.core.next.call(null,seq__57853__$1);
var G__58120 = null;
var G__58121 = (0);
var G__58122 = (0);
seq__57853 = G__58119;
chunk__57854 = G__58120;
count__57855 = G__58121;
i__57856 = G__58122;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,cljs.core.assoc.call(null,msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})),(function (){
return shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__57878 = cljs.core.seq.call(null,js_requires);
var chunk__57879 = null;
var count__57880 = (0);
var i__57881 = (0);
while(true){
if((i__57881 < count__57880)){
var js_ns = cljs.core._nth.call(null,chunk__57879,i__57881);
var require_str_58128 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_58128);


var G__58130 = seq__57878;
var G__58131 = chunk__57879;
var G__58132 = count__57880;
var G__58133 = (i__57881 + (1));
seq__57878 = G__58130;
chunk__57879 = G__58131;
count__57880 = G__58132;
i__57881 = G__58133;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__57878);
if(temp__5720__auto__){
var seq__57878__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57878__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__57878__$1);
var G__58134 = cljs.core.chunk_rest.call(null,seq__57878__$1);
var G__58135 = c__6568__auto__;
var G__58136 = cljs.core.count.call(null,c__6568__auto__);
var G__58137 = (0);
seq__57878 = G__58134;
chunk__57879 = G__58135;
count__57880 = G__58136;
i__57881 = G__58137;
continue;
} else {
var js_ns = cljs.core.first.call(null,seq__57878__$1);
var require_str_58138 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval.call(null,require_str_58138);


var G__58139 = cljs.core.next.call(null,seq__57878__$1);
var G__58140 = null;
var G__58141 = (0);
var G__58142 = (0);
seq__57878 = G__58139;
chunk__57879 = G__58140;
count__57880 = G__58141;
i__57881 = G__58142;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_.call(null,sources)){
return callback.call(null,cljs.core.PersistentVector.EMPTY);
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url.call(null),(function (res){
var req = this;
var content = cljs.reader.read_string.call(null,req.getResponseText());
return callback.call(null,content);
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__57889){
var map__57890 = p__57889;
var map__57890__$1 = (((((!((map__57890 == null))))?(((((map__57890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57890):map__57890);
var msg = map__57890__$1;
var info = cljs.core.get.call(null,map__57890__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.call(null,map__57890__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__57894 = info;
var map__57894__$1 = (((((!((map__57894 == null))))?(((((map__57894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57894.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57894):map__57894);
var sources = cljs.core.get.call(null,map__57894__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.call(null,map__57894__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.distinct.call(null,(function (){var iter__6519__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__57897(s__57898){
return (new cljs.core.LazySeq(null,(function (){
var s__57898__$1 = s__57898;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__57898__$1);
if(temp__5720__auto__){
var xs__6277__auto__ = temp__5720__auto__;
var map__57903 = cljs.core.first.call(null,xs__6277__auto__);
var map__57903__$1 = (((((!((map__57903 == null))))?(((((map__57903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57903):map__57903);
var src = map__57903__$1;
var resource_name = cljs.core.get.call(null,map__57903__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.call(null,map__57903__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__6515__auto__ = ((function (s__57898__$1,map__57903,map__57903__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__57894,map__57894__$1,sources,compiled,map__57890,map__57890__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__57897_$_iter__57899(s__57900){
return (new cljs.core.LazySeq(null,((function (s__57898__$1,map__57903,map__57903__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__57894,map__57894__$1,sources,compiled,map__57890,map__57890__$1,msg,info,reload_info){
return (function (){
var s__57900__$1 = s__57900;
while(true){
var temp__5720__auto____$1 = cljs.core.seq.call(null,s__57900__$1);
if(temp__5720__auto____$1){
var s__57900__$2 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__57900__$2)){
var c__6517__auto__ = cljs.core.chunk_first.call(null,s__57900__$2);
var size__6518__auto__ = cljs.core.count.call(null,c__6517__auto__);
var b__57902 = cljs.core.chunk_buffer.call(null,size__6518__auto__);
if((function (){var i__57901 = (0);
while(true){
if((i__57901 < size__6518__auto__)){
var warning = cljs.core._nth.call(null,c__6517__auto__,i__57901);
cljs.core.chunk_append.call(null,b__57902,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__58151 = (i__57901 + (1));
i__57901 = G__58151;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__57902),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__57897_$_iter__57899.call(null,cljs.core.chunk_rest.call(null,s__57900__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__57902),null);
}
} else {
var warning = cljs.core.first.call(null,s__57900__$2);
return cljs.core.cons.call(null,cljs.core.assoc.call(null,warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__57897_$_iter__57899.call(null,cljs.core.rest.call(null,s__57900__$2)));
}
} else {
return null;
}
break;
}
});})(s__57898__$1,map__57903,map__57903__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__57894,map__57894__$1,sources,compiled,map__57890,map__57890__$1,msg,info,reload_info))
,null,null));
});})(s__57898__$1,map__57903,map__57903__$1,src,resource_name,warnings,xs__6277__auto__,temp__5720__auto__,map__57894,map__57894__$1,sources,compiled,map__57890,map__57890__$1,msg,info,reload_info))
;
var fs__6516__auto__ = cljs.core.seq.call(null,iterys__6515__auto__.call(null,warnings));
if(fs__6516__auto__){
return cljs.core.concat.call(null,fs__6516__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__57897.call(null,cljs.core.rest.call(null,s__57898__$1)));
} else {
var G__58152 = cljs.core.rest.call(null,s__57898__$1);
s__57898__$1 = G__58152;
continue;
}
} else {
var G__58153 = cljs.core.rest.call(null,s__57898__$1);
s__57898__$1 = G__58153;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6519__auto__.call(null,sources);
})()));
var seq__57907_58154 = cljs.core.seq.call(null,warnings);
var chunk__57908_58155 = null;
var count__57909_58156 = (0);
var i__57910_58157 = (0);
while(true){
if((i__57910_58157 < count__57909_58156)){
var map__57916_58158 = cljs.core._nth.call(null,chunk__57908_58155,i__57910_58157);
var map__57916_58159__$1 = (((((!((map__57916_58158 == null))))?(((((map__57916_58158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57916_58158.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57916_58158):map__57916_58158);
var w_58160 = map__57916_58159__$1;
var msg_58161__$1 = cljs.core.get.call(null,map__57916_58159__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_58162 = cljs.core.get.call(null,map__57916_58159__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_58163 = cljs.core.get.call(null,map__57916_58159__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_58164 = cljs.core.get.call(null,map__57916_58159__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_58164)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_58162),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_58163),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_58161__$1)].join(''));


var G__58165 = seq__57907_58154;
var G__58166 = chunk__57908_58155;
var G__58167 = count__57909_58156;
var G__58168 = (i__57910_58157 + (1));
seq__57907_58154 = G__58165;
chunk__57908_58155 = G__58166;
count__57909_58156 = G__58167;
i__57910_58157 = G__58168;
continue;
} else {
var temp__5720__auto___58169 = cljs.core.seq.call(null,seq__57907_58154);
if(temp__5720__auto___58169){
var seq__57907_58170__$1 = temp__5720__auto___58169;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57907_58170__$1)){
var c__6568__auto___58171 = cljs.core.chunk_first.call(null,seq__57907_58170__$1);
var G__58172 = cljs.core.chunk_rest.call(null,seq__57907_58170__$1);
var G__58173 = c__6568__auto___58171;
var G__58174 = cljs.core.count.call(null,c__6568__auto___58171);
var G__58175 = (0);
seq__57907_58154 = G__58172;
chunk__57908_58155 = G__58173;
count__57909_58156 = G__58174;
i__57910_58157 = G__58175;
continue;
} else {
var map__57918_58176 = cljs.core.first.call(null,seq__57907_58170__$1);
var map__57918_58177__$1 = (((((!((map__57918_58176 == null))))?(((((map__57918_58176.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57918_58176.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57918_58176):map__57918_58176);
var w_58178 = map__57918_58177__$1;
var msg_58179__$1 = cljs.core.get.call(null,map__57918_58177__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_58180 = cljs.core.get.call(null,map__57918_58177__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_58181 = cljs.core.get.call(null,map__57918_58177__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_58182 = cljs.core.get.call(null,map__57918_58177__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_58182)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_58180),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_58181),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_58179__$1)].join(''));


var G__58183 = cljs.core.next.call(null,seq__57907_58170__$1);
var G__58184 = null;
var G__58185 = (0);
var G__58186 = (0);
seq__57907_58154 = G__58183;
chunk__57908_58155 = G__58184;
count__57909_58156 = G__58185;
i__57910_58157 = G__58186;
continue;
}
} else {
}
}
break;
}

if(cljs.core.not.call(null,shadow.cljs.devtools.client.env.autoload)){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(cljs.core.truth_((function (){var or__5598__auto__ = cljs.core.empty_QMARK_.call(null,warnings);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return shadow.cljs.devtools.client.env.ignore_warnings;
}
})())){
var sources_to_get = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,(function (p__57920){
var map__57921 = p__57920;
var map__57921__$1 = (((((!((map__57921 == null))))?(((((map__57921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57921):map__57921);
var src = map__57921__$1;
var ns = cljs.core.get.call(null,map__57921__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.call(null,map__57921__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src))) || (((cljs.core.contains_QMARK_.call(null,compiled,resource_id)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
}),cljs.core.remove.call(null,(function (p__57923){
var map__57924 = p__57923;
var map__57924__$1 = (((((!((map__57924 == null))))?(((((map__57924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57924):map__57924);
var ns = cljs.core.get.call(null,map__57924__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
}),cljs.core.filter.call(null,(function (p__57926){
var map__57927 = p__57926;
var map__57927__$1 = (((((!((map__57927 == null))))?(((((map__57927.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57927.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57927):map__57927);
var rc = map__57927__$1;
var module = cljs.core.get.call(null,map__57927__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.call(null,"js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.browser.module_is_active_QMARK_.call(null,module)));
}),sources))));
if(cljs.core.not.call(null,cljs.core.seq.call(null,sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success.call(null);
} else {
if(cljs.core.seq.call(null,cljs.core.get_in.call(null,msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"reloading code but no :after-load hooks are configured!","https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks");
}

return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_get,(function (p1__57888_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload.call(null,msg,p1__57888_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.call(null,"file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.call(null,new$,(1));
if(((cljs.core._EQ_.call(null,old,rel_new)) || (clojure.string.starts_with_QMARK_.call(null,old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.call(null,shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not.call(null,node_uri.hasDomain())))){
if(cljs.core._EQ_.call(null,node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__57936){
var map__57937 = p__57936;
var map__57937__$1 = (((((!((map__57937 == null))))?(((((map__57937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57937.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57937):map__57937);
var msg = map__57937__$1;
var updates = cljs.core.get.call(null,map__57937__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__57939 = cljs.core.seq.call(null,updates);
var chunk__57941 = null;
var count__57942 = (0);
var i__57943 = (0);
while(true){
if((i__57943 < count__57942)){
var path = cljs.core._nth.call(null,chunk__57941,i__57943);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__57980_58189 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__57983_58190 = null;
var count__57984_58191 = (0);
var i__57985_58192 = (0);
while(true){
if((i__57985_58192 < count__57984_58191)){
var node_58193 = cljs.core._nth.call(null,chunk__57983_58190,i__57985_58192);
var path_match_58194 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_58193.getAttribute("href"),path);
if(cljs.core.truth_(path_match_58194)){
var new_link_58195 = (function (){var G__57990 = node_58193.cloneNode(true);
G__57990.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_58194),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__57990;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_58194);

goog.dom.insertSiblingAfter(new_link_58195,node_58193);

goog.dom.removeNode(node_58193);


var G__58196 = seq__57980_58189;
var G__58197 = chunk__57983_58190;
var G__58198 = count__57984_58191;
var G__58199 = (i__57985_58192 + (1));
seq__57980_58189 = G__58196;
chunk__57983_58190 = G__58197;
count__57984_58191 = G__58198;
i__57985_58192 = G__58199;
continue;
} else {
var G__58200 = seq__57980_58189;
var G__58201 = chunk__57983_58190;
var G__58202 = count__57984_58191;
var G__58203 = (i__57985_58192 + (1));
seq__57980_58189 = G__58200;
chunk__57983_58190 = G__58201;
count__57984_58191 = G__58202;
i__57985_58192 = G__58203;
continue;
}
} else {
var temp__5720__auto___58204 = cljs.core.seq.call(null,seq__57980_58189);
if(temp__5720__auto___58204){
var seq__57980_58207__$1 = temp__5720__auto___58204;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57980_58207__$1)){
var c__6568__auto___58208 = cljs.core.chunk_first.call(null,seq__57980_58207__$1);
var G__58209 = cljs.core.chunk_rest.call(null,seq__57980_58207__$1);
var G__58210 = c__6568__auto___58208;
var G__58211 = cljs.core.count.call(null,c__6568__auto___58208);
var G__58212 = (0);
seq__57980_58189 = G__58209;
chunk__57983_58190 = G__58210;
count__57984_58191 = G__58211;
i__57985_58192 = G__58212;
continue;
} else {
var node_58213 = cljs.core.first.call(null,seq__57980_58207__$1);
var path_match_58214 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_58213.getAttribute("href"),path);
if(cljs.core.truth_(path_match_58214)){
var new_link_58215 = (function (){var G__57991 = node_58213.cloneNode(true);
G__57991.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_58214),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__57991;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_58214);

goog.dom.insertSiblingAfter(new_link_58215,node_58213);

goog.dom.removeNode(node_58213);


var G__58217 = cljs.core.next.call(null,seq__57980_58207__$1);
var G__58218 = null;
var G__58219 = (0);
var G__58220 = (0);
seq__57980_58189 = G__58217;
chunk__57983_58190 = G__58218;
count__57984_58191 = G__58219;
i__57985_58192 = G__58220;
continue;
} else {
var G__58221 = cljs.core.next.call(null,seq__57980_58207__$1);
var G__58222 = null;
var G__58223 = (0);
var G__58224 = (0);
seq__57980_58189 = G__58221;
chunk__57983_58190 = G__58222;
count__57984_58191 = G__58223;
i__57985_58192 = G__58224;
continue;
}
}
} else {
}
}
break;
}


var G__58225 = seq__57939;
var G__58226 = chunk__57941;
var G__58227 = count__57942;
var G__58228 = (i__57943 + (1));
seq__57939 = G__58225;
chunk__57941 = G__58226;
count__57942 = G__58227;
i__57943 = G__58228;
continue;
} else {
var G__58229 = seq__57939;
var G__58230 = chunk__57941;
var G__58231 = count__57942;
var G__58232 = (i__57943 + (1));
seq__57939 = G__58229;
chunk__57941 = G__58230;
count__57942 = G__58231;
i__57943 = G__58232;
continue;
}
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__57939);
if(temp__5720__auto__){
var seq__57939__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57939__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__57939__$1);
var G__58233 = cljs.core.chunk_rest.call(null,seq__57939__$1);
var G__58234 = c__6568__auto__;
var G__58235 = cljs.core.count.call(null,c__6568__auto__);
var G__58236 = (0);
seq__57939 = G__58233;
chunk__57941 = G__58234;
count__57942 = G__58235;
i__57943 = G__58236;
continue;
} else {
var path = cljs.core.first.call(null,seq__57939__$1);
if(clojure.string.ends_with_QMARK_.call(null,path,"css")){
var seq__57992_58237 = cljs.core.seq.call(null,cljs.core.array_seq.call(null,document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__57995_58238 = null;
var count__57996_58239 = (0);
var i__57997_58240 = (0);
while(true){
if((i__57997_58240 < count__57996_58239)){
var node_58241 = cljs.core._nth.call(null,chunk__57995_58238,i__57997_58240);
var path_match_58242 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_58241.getAttribute("href"),path);
if(cljs.core.truth_(path_match_58242)){
var new_link_58243 = (function (){var G__58002 = node_58241.cloneNode(true);
G__58002.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_58242),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__58002;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_58242);

goog.dom.insertSiblingAfter(new_link_58243,node_58241);

goog.dom.removeNode(node_58241);


var G__58244 = seq__57992_58237;
var G__58245 = chunk__57995_58238;
var G__58246 = count__57996_58239;
var G__58247 = (i__57997_58240 + (1));
seq__57992_58237 = G__58244;
chunk__57995_58238 = G__58245;
count__57996_58239 = G__58246;
i__57997_58240 = G__58247;
continue;
} else {
var G__58248 = seq__57992_58237;
var G__58249 = chunk__57995_58238;
var G__58250 = count__57996_58239;
var G__58251 = (i__57997_58240 + (1));
seq__57992_58237 = G__58248;
chunk__57995_58238 = G__58249;
count__57996_58239 = G__58250;
i__57997_58240 = G__58251;
continue;
}
} else {
var temp__5720__auto___58252__$1 = cljs.core.seq.call(null,seq__57992_58237);
if(temp__5720__auto___58252__$1){
var seq__57992_58253__$1 = temp__5720__auto___58252__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57992_58253__$1)){
var c__6568__auto___58254 = cljs.core.chunk_first.call(null,seq__57992_58253__$1);
var G__58255 = cljs.core.chunk_rest.call(null,seq__57992_58253__$1);
var G__58256 = c__6568__auto___58254;
var G__58257 = cljs.core.count.call(null,c__6568__auto___58254);
var G__58258 = (0);
seq__57992_58237 = G__58255;
chunk__57995_58238 = G__58256;
count__57996_58239 = G__58257;
i__57997_58240 = G__58258;
continue;
} else {
var node_58259 = cljs.core.first.call(null,seq__57992_58253__$1);
var path_match_58260 = shadow.cljs.devtools.client.browser.match_paths.call(null,node_58259.getAttribute("href"),path);
if(cljs.core.truth_(path_match_58260)){
var new_link_58261 = (function (){var G__58003 = node_58259.cloneNode(true);
G__58003.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_58260),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.call(null))].join(''));

return G__58003;
})();
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"load CSS",path_match_58260);

goog.dom.insertSiblingAfter(new_link_58261,node_58259);

goog.dom.removeNode(node_58259);


var G__58262 = cljs.core.next.call(null,seq__57992_58253__$1);
var G__58263 = null;
var G__58264 = (0);
var G__58265 = (0);
seq__57992_58237 = G__58262;
chunk__57995_58238 = G__58263;
count__57996_58239 = G__58264;
i__57997_58240 = G__58265;
continue;
} else {
var G__58266 = cljs.core.next.call(null,seq__57992_58253__$1);
var G__58267 = null;
var G__58268 = (0);
var G__58269 = (0);
seq__57992_58237 = G__58266;
chunk__57995_58238 = G__58267;
count__57996_58239 = G__58268;
i__57997_58240 = G__58269;
continue;
}
}
} else {
}
}
break;
}


var G__58270 = cljs.core.next.call(null,seq__57939__$1);
var G__58271 = null;
var G__58272 = (0);
var G__58273 = (0);
seq__57939 = G__58270;
chunk__57941 = G__58271;
count__57942 = G__58272;
i__57943 = G__58273;
continue;
} else {
var G__58274 = cljs.core.next.call(null,seq__57939__$1);
var G__58275 = null;
var G__58276 = (0);
var G__58277 = (0);
seq__57939 = G__58274;
chunk__57941 = G__58275;
count__57942 = G__58276;
i__57943 = G__58277;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace.call(null,s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.call(null,shadow.cljs.devtools.client.env.repl_error.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product.call(null),new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root.call(null));
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__58006){
var map__58007 = p__58006;
var map__58007__$1 = (((((!((map__58007 == null))))?(((((map__58007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58007.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58007):map__58007);
var id = cljs.core.get.call(null,map__58007__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.call(null,map__58007__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call.call(null,(function (){
return eval(js);
}),shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg.call(null,cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__58011){
var map__58012 = p__58011;
var map__58012__$1 = (((((!((map__58012 == null))))?(((((map__58012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58012.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58012):map__58012);
var msg = map__58012__$1;
var id = cljs.core.get.call(null,map__58012__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.call(null,map__58012__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.call(null,map__58012__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.call(null,map__58012__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,(function (p__58014){
var map__58015 = p__58014;
var map__58015__$1 = (((((!((map__58015 == null))))?(((((map__58015.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58015.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58015):map__58015);
var src = map__58015__$1;
var provides = cljs.core.get.call(null,map__58015__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__5583__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_.call(null,src);
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core.not.call(null,cljs.core.some.call(null,reload_namespaces,provides));
} else {
return and__5583__auto__;
}
}),sources));
return shadow.cljs.devtools.client.browser.load_sources.call(null,sources_to_load,(function (sources__$1){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources__$1);

if(cljs.core.seq.call(null,js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires.call(null,js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}));
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__58017){
var map__58018 = p__58017;
var map__58018__$1 = (((((!((map__58018 == null))))?(((((map__58018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58018.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58018):map__58018);
var repl_state = cljs.core.get.call(null,map__58018__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.call(null,map__58018__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load.call(null,sources);

shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"REPL session start successful");
}));
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__58020){
var map__58021 = p__58020;
var map__58021__$1 = (((((!((map__58021 == null))))?(((((map__58021.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58021.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58021):map__58021);
var id = cljs.core.get.call(null,map__58021__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.call(null,map__58021__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_.call(null,null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__58023){
var map__58024 = p__58023;
var map__58024__$1 = (((((!((map__58024 == null))))?(((((map__58024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__58024.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__58024):map__58024);
var msg = map__58024__$1;
var type = cljs.core.get.call(null,map__58024__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

var G__58027 = type;
var G__58027__$1 = (((G__58027 instanceof cljs.core.Keyword))?G__58027.fqn:null);
switch (G__58027__$1) {
case "asset-watch":
return shadow.cljs.devtools.client.browser.handle_asset_watch.call(null,msg);

break;
case "repl/invoke":
return shadow.cljs.devtools.client.browser.repl_invoke.call(null,msg);

break;
case "repl/require":
return shadow.cljs.devtools.client.browser.repl_require.call(null,msg);

break;
case "repl/set-ns":
return shadow.cljs.devtools.client.browser.repl_set_ns.call(null,msg);

break;
case "repl/init":
return shadow.cljs.devtools.client.browser.repl_init.call(null,msg);

break;
case "repl/session-start":
return shadow.cljs.devtools.client.browser.repl_init.call(null,msg);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

return shadow.cljs.devtools.client.browser.handle_build_complete.call(null,msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end.call(null);

return shadow.cljs.devtools.client.hud.hud_error.call(null,msg);

break;
case "build-init":
return shadow.cljs.devtools.client.hud.hud_warnings.call(null,msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide.call(null);

return shadow.cljs.devtools.client.hud.load_start.call(null);

break;
case "pong":
return null;

break;
case "client/stale":
return cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
return cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"\" not running"].join(''));

break;
case "custom-msg":
return shadow.cljs.devtools.client.env.publish_BANG_.call(null,new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:
return new cljs.core.Keyword(null,"ignored","ignored",1227374526);

}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",(cljs.core.truth_(shadow.cljs.devtools.client.env.ssl)?"s":null),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_host),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.call(null,req.getResponseText());
if(cljs.core.truth_(callback)){
return callback.call(null,actions);
} else {
return null;
}
}),"POST",cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)),({"content-type": "application/edn; charset=utf-8"}));
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var s = temp__5720__auto__;
s.send(cljs.core.pr_str.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url.call(null,new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,socket);

(socket.onmessage = (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg.call(null,e.data,shadow.cljs.devtools.client.browser.handle_message);
}));

(socket.onopen = (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_.call(null);

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.call(null,"goog",shadow.cljs.devtools.client.env.module_format)){
(goog.provide = goog.constructNamespace_);
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_.call(null,shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket connected!");
}));

(socket.onclose = (function (e){
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error.call(null,(function (){var or__5598__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_.call(null);
}));

(socket.onerror = (function (e){
shadow.cljs.devtools.client.hud.connection_error.call(null,"Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"websocket error",e);
}));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
}catch (e58038){var e = e58038;
return shadow.cljs.devtools.client.browser.devtools_msg.call(null,"WebSocket setup failed",e);
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5720__auto___58283 = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto___58283)){
var s_58284 = temp__5720__auto___58283;
shadow.cljs.devtools.client.browser.devtools_msg.call(null,"connection reset!");

(s_58284.onclose = (function (e){
return null;
}));

s_58284.close();

cljs.core.vreset_BANG_.call(null,shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var s = temp__5720__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__5583__auto__ = document;
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core._EQ_.call(null,"loading",document.readyState);
} else {
return and__5583__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
