goog.provide('cljs.core');
goog.require('goog.math.Long');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
if((typeof setTimeout !== 'undefined')){
var and__5583__auto__ = setTimeout(f,(0));
if(cljs.core.truth_(and__5583__auto__)){
return true;
} else {
return and__5583__auto__;
}
} else {
return false;
}
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_.call(null,(function (){
var xs = arguments;
return console.log.apply(console,goog.array.clone(xs));
}));

cljs.core.set_print_err_fn_BANG_.call(null,(function (){
var xs = arguments;
return console.error.apply(console,goog.array.clone(xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type.call(null,obj);
var ty__$1 = (cljs.core.truth_((function (){var and__5583__auto__ = ty;
if(cljs.core.truth_(and__5583__auto__)){
return ty.cljs$lang$type;
} else {
return and__5583__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5718__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5718__auto__)){
var s = temp__5718__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__43446 = arguments.length;
switch (G__43446) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44616 = arguments.length;
var i__6921__auto___44619 = (0);
while(true){
if((i__6921__auto___44619 < len__6920__auto___44616)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44619]));

var G__44621 = (i__6921__auto___44619 + (1));
i__6921__auto___44619 = G__44621;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__6679__auto___44637 = dimarray.length;
var i_44639 = (0);
while(true){
if((i_44639 < n__6679__auto___44637)){
(dimarray[i_44639] = cljs.core.apply.call(null,cljs.core.make_array,null,dims));

var G__44643 = (i_44639 + (1));
i_44639 = G__44643;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function (seq43443){
var G__43444 = cljs.core.first.call(null,seq43443);
var seq43443__$1 = cljs.core.next.call(null,seq43443);
var G__43445 = cljs.core.first.call(null,seq43443__$1);
var seq43443__$2 = cljs.core.next.call(null,seq43443__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43444,G__43445,seq43443__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__6679__auto___44644 = len;
var i_44645 = (0);
while(true){
if((i_44645 < n__6679__auto___44644)){
(new_arr[i_44645] = (arr[i_44645]));

var G__44646 = (i_44645 + (1));
i_44645 = G__44646;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__44648 = (i + (1));
i = G__44648;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return cljs.core._STAR_print_err_fn_STAR_.call(null,e);
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__43451 = arguments.length;
switch (G__43451) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44650 = arguments.length;
var i__6921__auto___44651 = (0);
while(true){
if((i__6921__auto___44651 < len__6920__auto___44650)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44651]));

var G__44652 = (i__6921__auto___44651 + (1));
i__6921__auto___44651 = G__44652;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
try{if(cljs.core.truth_((function (){var or__5598__auto__ = cljs.core.array_QMARK_.call(null,array);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e43452){var e_44661 = e43452;
cljs.core.maybe_warn.call(null,e_44661);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.call(null,cljs.core.checked_aget,cljs.core.checked_aget.call(null,array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function (seq43448){
var G__43449 = cljs.core.first.call(null,seq43448);
var seq43448__$1 = cljs.core.next.call(null,seq43448);
var G__43450 = cljs.core.first.call(null,seq43448__$1);
var seq43448__$2 = cljs.core.next.call(null,seq43448__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43449,G__43450,seq43448__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__43458 = arguments.length;
switch (G__43458) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44665 = arguments.length;
var i__6921__auto___44666 = (0);
while(true){
if((i__6921__auto___44666 < len__6920__auto___44665)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44666]));

var G__44669 = (i__6921__auto___44666 + (1));
i__6921__auto___44666 = G__44669;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
try{if(cljs.core.truth_((function (){var or__5598__auto__ = cljs.core.array_QMARK_.call(null,array);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e43459){var e_44675 = e43459;
cljs.core.maybe_warn.call(null,e_44675);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.call(null,cljs.core.checked_aset,cljs.core.checked_aget.call(null,array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function (seq43454){
var G__43455 = cljs.core.first.call(null,seq43454);
var seq43454__$1 = cljs.core.next.call(null,seq43454);
var G__43456 = cljs.core.first.call(null,seq43454__$1);
var seq43454__$2 = cljs.core.next.call(null,seq43454__$1);
var G__43457 = cljs.core.first.call(null,seq43454__$2);
var seq43454__$3 = cljs.core.next.call(null,seq43454__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43455,G__43456,G__43457,seq43454__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__43464 = arguments.length;
switch (G__43464) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44687 = arguments.length;
var i__6921__auto___44688 = (0);
while(true){
if((i__6921__auto___44688 < len__6920__auto___44687)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44688]));

var G__44689 = (i__6921__auto___44688 + (1));
i__6921__auto___44688 = G__44689;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
if(cljs.core.truth_((function (){var or__5598__auto__ = cljs.core.array_QMARK_.call(null,array);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.call(null,cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.call(null,array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq43461){
var G__43462 = cljs.core.first.call(null,seq43461);
var seq43461__$1 = cljs.core.next.call(null,seq43461);
var G__43463 = cljs.core.first.call(null,seq43461__$1);
var seq43461__$2 = cljs.core.next.call(null,seq43461__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43462,G__43463,seq43461__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__43470 = arguments.length;
switch (G__43470) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44701 = arguments.length;
var i__6921__auto___44702 = (0);
while(true){
if((i__6921__auto___44702 < len__6920__auto___44701)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44702]));

var G__44703 = (i__6921__auto___44702 + (1));
i__6921__auto___44702 = G__44703;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
if(cljs.core.truth_((function (){var or__5598__auto__ = cljs.core.array_QMARK_.call(null,array);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.call(null,cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.call(null,array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq43466){
var G__43467 = cljs.core.first.call(null,seq43466);
var seq43466__$1 = cljs.core.next.call(null,seq43466);
var G__43468 = cljs.core.first.call(null,seq43466__$1);
var seq43466__$2 = cljs.core.next.call(null,seq43466__$1);
var G__43469 = cljs.core.first.call(null,seq43466__$2);
var seq43466__$3 = cljs.core.next.call(null,seq43466__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43467,G__43468,G__43469,seq43466__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__43475 = arguments.length;
switch (G__43475) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44718 = arguments.length;
var i__6921__auto___44719 = (0);
while(true){
if((i__6921__auto___44719 < len__6920__auto___44718)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44719]));

var G__44722 = (i__6921__auto___44719 + (1));
i__6921__auto___44719 = G__44722;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.call(null,cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function (seq43472){
var G__43473 = cljs.core.first.call(null,seq43472);
var seq43472__$1 = cljs.core.next.call(null,seq43472);
var G__43474 = cljs.core.first.call(null,seq43472__$1);
var seq43472__$2 = cljs.core.next.call(null,seq43472__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43473,G__43474,seq43472__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__43481 = arguments.length;
switch (G__43481) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___44738 = arguments.length;
var i__6921__auto___44739 = (0);
while(true){
if((i__6921__auto___44739 < len__6920__auto___44738)){
args_arr__6949__auto__.push((arguments[i__6921__auto___44739]));

var G__44740 = (i__6921__auto___44739 + (1));
i__6921__auto___44739 = G__44740;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.call(null,cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function (seq43477){
var G__43478 = cljs.core.first.call(null,seq43477);
var seq43477__$1 = cljs.core.next.call(null,seq43477);
var G__43479 = cljs.core.first.call(null,seq43477__$1);
var seq43477__$2 = cljs.core.next.call(null,seq43477__$1);
var G__43480 = cljs.core.first.call(null,seq43477__$2);
var seq43477__$3 = cljs.core.next.call(null,seq43477__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43478,G__43479,G__43480,seq43477__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__43483 = arguments.length;
switch (G__43483) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.call(null,null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
return cljs.core.reduce.call(null,(function (a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__6930__auto__ = [];
var len__6920__auto___44750 = arguments.length;
var i__6921__auto___44751 = (0);
while(true){
if((i__6921__auto___44751 < len__6920__auto___44750)){
args__6930__auto__.push((arguments[i__6921__auto___44751]));

var G__44752 = (i__6921__auto___44751 + (1));
i__6921__auto___44751 = G__44752;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.call(null,args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function (seq43484){
var G__43485 = cljs.core.first.call(null,seq43484);
var seq43484__$1 = cljs.core.next.call(null,seq43484);
var G__43486 = cljs.core.first.call(null,seq43484__$1);
var seq43484__$2 = cljs.core.next.call(null,seq43484__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43485,G__43486,seq43484__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_44758 = (function() {
var G__44759 = null;
var G__44759__1 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__2 = (function (this$,a){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__3 = (function (this$,a,b){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__4 = (function (this$,a,b,c){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__5 = (function (this$,a,b,c,d){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__6 = (function (this$,a,b,c,d,e){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__7 = (function (this$,a,b,c,d,e,f){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__8 = (function (this$,a,b,c,d,e,f,g){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
var G__44759__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._invoke[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var m__6344__auto__ = (cljs.core._invoke["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
});
G__44759 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__44759__1.call(this,this$);
case 2:
return G__44759__2.call(this,this$,a);
case 3:
return G__44759__3.call(this,this$,a,b);
case 4:
return G__44759__4.call(this,this$,a,b,c);
case 5:
return G__44759__5.call(this,this$,a,b,c,d);
case 6:
return G__44759__6.call(this,this$,a,b,c,d,e);
case 7:
return G__44759__7.call(this,this$,a,b,c,d,e,f);
case 8:
return G__44759__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return G__44759__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return G__44759__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return G__44759__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__44759__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__44759__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__44759__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__44759__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__44759__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__44759__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__44759__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__44759__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__44759__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__44759__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__44759__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__44759.cljs$core$IFn$_invoke$arity$1 = G__44759__1;
G__44759.cljs$core$IFn$_invoke$arity$2 = G__44759__2;
G__44759.cljs$core$IFn$_invoke$arity$3 = G__44759__3;
G__44759.cljs$core$IFn$_invoke$arity$4 = G__44759__4;
G__44759.cljs$core$IFn$_invoke$arity$5 = G__44759__5;
G__44759.cljs$core$IFn$_invoke$arity$6 = G__44759__6;
G__44759.cljs$core$IFn$_invoke$arity$7 = G__44759__7;
G__44759.cljs$core$IFn$_invoke$arity$8 = G__44759__8;
G__44759.cljs$core$IFn$_invoke$arity$9 = G__44759__9;
G__44759.cljs$core$IFn$_invoke$arity$10 = G__44759__10;
G__44759.cljs$core$IFn$_invoke$arity$11 = G__44759__11;
G__44759.cljs$core$IFn$_invoke$arity$12 = G__44759__12;
G__44759.cljs$core$IFn$_invoke$arity$13 = G__44759__13;
G__44759.cljs$core$IFn$_invoke$arity$14 = G__44759__14;
G__44759.cljs$core$IFn$_invoke$arity$15 = G__44759__15;
G__44759.cljs$core$IFn$_invoke$arity$16 = G__44759__16;
G__44759.cljs$core$IFn$_invoke$arity$17 = G__44759__17;
G__44759.cljs$core$IFn$_invoke$arity$18 = G__44759__18;
G__44759.cljs$core$IFn$_invoke$arity$19 = G__44759__19;
G__44759.cljs$core$IFn$_invoke$arity$20 = G__44759__20;
G__44759.cljs$core$IFn$_invoke$arity$21 = G__44759__21;
G__44759.cljs$core$IFn$_invoke$arity$22 = G__44759__22;
return G__44759;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__43488 = arguments.length;
switch (G__43488) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_44758.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_45169 = (function (value){
var x__6346__auto__ = (((value == null))?null:value);
var m__6347__auto__ = (cljs.core._clone[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,value);
} else {
var m__6344__auto__ = (cljs.core._clone["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,value);
} else {
throw cljs.core.missing_protocol.call(null,"ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_45169.call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_45175 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._count[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._count["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_45175.call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_45178 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._empty[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._empty["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_45178.call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_45188 = (function (coll,o){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._conj[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,o);
} else {
var m__6344__auto__ = (cljs.core._conj["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,o);
} else {
throw cljs.core.missing_protocol.call(null,"ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_45188.call(null,coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_45193 = (function() {
var G__45194 = null;
var G__45194__2 = (function (coll,n){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._nth[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,n);
} else {
var m__6344__auto__ = (cljs.core._nth["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,n);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexed.-nth",coll);
}
}
});
var G__45194__3 = (function (coll,n,not_found){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._nth[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,n,not_found);
} else {
var m__6344__auto__ = (cljs.core._nth["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,n,not_found);
} else {
throw cljs.core.missing_protocol.call(null,"IIndexed.-nth",coll);
}
}
});
G__45194 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return G__45194__2.call(this,coll,n);
case 3:
return G__45194__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45194.cljs$core$IFn$_invoke$arity$2 = G__45194__2;
G__45194.cljs$core$IFn$_invoke$arity$3 = G__45194__3;
return G__45194;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__43490 = arguments.length;
switch (G__43490) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_45193.call(null,coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_45193.call(null,coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_45235 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._first[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._first["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_45235.call(null,coll);
}
});

var cljs$core$ISeq$_rest$dyn_45248 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._rest[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._rest["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_45248.call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_45255 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._next[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._next["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_45255.call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_45260 = (function() {
var G__45261 = null;
var G__45261__2 = (function (o,k){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._lookup[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,k);
} else {
var m__6344__auto__ = (cljs.core._lookup["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,k);
} else {
throw cljs.core.missing_protocol.call(null,"ILookup.-lookup",o);
}
}
});
var G__45261__3 = (function (o,k,not_found){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._lookup[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,k,not_found);
} else {
var m__6344__auto__ = (cljs.core._lookup["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,k,not_found);
} else {
throw cljs.core.missing_protocol.call(null,"ILookup.-lookup",o);
}
}
});
G__45261 = function(o,k,not_found){
switch(arguments.length){
case 2:
return G__45261__2.call(this,o,k);
case 3:
return G__45261__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45261.cljs$core$IFn$_invoke$arity$2 = G__45261__2;
G__45261.cljs$core$IFn$_invoke$arity$3 = G__45261__3;
return G__45261;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__43492 = arguments.length;
switch (G__43492) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_45260.call(null,o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_45260.call(null,o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_45272 = (function (coll,k){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,k);
} else {
var m__6344__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,k);
} else {
throw cljs.core.missing_protocol.call(null,"IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_45272.call(null,coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_45284 = (function (coll,k,v){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._assoc[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,k,v);
} else {
var m__6344__auto__ = (cljs.core._assoc["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,k,v);
} else {
throw cljs.core.missing_protocol.call(null,"IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_45284.call(null,coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_45290 = (function (coll,k){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._find[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,k);
} else {
var m__6344__auto__ = (cljs.core._find["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,k);
} else {
throw cljs.core.missing_protocol.call(null,"IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_45290.call(null,coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_45296 = (function (coll,k){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._dissoc[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,k);
} else {
var m__6344__auto__ = (cljs.core._dissoc["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,k);
} else {
throw cljs.core.missing_protocol.call(null,"IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_45296.call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_45307 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._key[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._key["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_45307.call(null,coll);
}
});

var cljs$core$IMapEntry$_val$dyn_45314 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._val[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._val["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_45314.call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_45332 = (function (coll,v){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._disjoin[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,v);
} else {
var m__6344__auto__ = (cljs.core._disjoin["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,v);
} else {
throw cljs.core.missing_protocol.call(null,"ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_45332.call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_45350 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._peek[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._peek["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_45350.call(null,coll);
}
});

var cljs$core$IStack$_pop$dyn_45354 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._pop[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._pop["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_45354.call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_45358 = (function (coll,n,val){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._assoc_n[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,n,val);
} else {
var m__6344__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,n,val);
} else {
throw cljs.core.missing_protocol.call(null,"IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_45358.call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_45360 = (function (o){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._deref[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o);
} else {
var m__6344__auto__ = (cljs.core._deref["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o);
} else {
throw cljs.core.missing_protocol.call(null,"IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_45360.call(null,o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_45363 = (function (o,msec,timeout_val){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,msec,timeout_val);
} else {
var m__6344__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,msec,timeout_val);
} else {
throw cljs.core.missing_protocol.call(null,"IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_45363.call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_45370 = (function (o){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._meta[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o);
} else {
var m__6344__auto__ = (cljs.core._meta["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o);
} else {
throw cljs.core.missing_protocol.call(null,"IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_45370.call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_45374 = (function (o,meta){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._with_meta[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,meta);
} else {
var m__6344__auto__ = (cljs.core._with_meta["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,meta);
} else {
throw cljs.core.missing_protocol.call(null,"IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_45374.call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_45377 = (function() {
var G__45378 = null;
var G__45378__2 = (function (coll,f){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._reduce[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,f);
} else {
var m__6344__auto__ = (cljs.core._reduce["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,f);
} else {
throw cljs.core.missing_protocol.call(null,"IReduce.-reduce",coll);
}
}
});
var G__45378__3 = (function (coll,f,start){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._reduce[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,f,start);
} else {
var m__6344__auto__ = (cljs.core._reduce["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,f,start);
} else {
throw cljs.core.missing_protocol.call(null,"IReduce.-reduce",coll);
}
}
});
G__45378 = function(coll,f,start){
switch(arguments.length){
case 2:
return G__45378__2.call(this,coll,f);
case 3:
return G__45378__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45378.cljs$core$IFn$_invoke$arity$2 = G__45378__2;
G__45378.cljs$core$IFn$_invoke$arity$3 = G__45378__3;
return G__45378;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__43494 = arguments.length;
switch (G__43494) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_45377.call(null,coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_45377.call(null,coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_45392 = (function (coll,f,init){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,f,init);
} else {
var m__6344__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,f,init);
} else {
throw cljs.core.missing_protocol.call(null,"IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_45392.call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_45415 = (function (o,other){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._equiv[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,other);
} else {
var m__6344__auto__ = (cljs.core._equiv["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,other);
} else {
throw cljs.core.missing_protocol.call(null,"IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_45415.call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_45420 = (function (o){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._hash[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o);
} else {
var m__6344__auto__ = (cljs.core._hash["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o);
} else {
throw cljs.core.missing_protocol.call(null,"IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_45420.call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_45426 = (function (o){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._seq[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o);
} else {
var m__6344__auto__ = (cljs.core._seq["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o);
} else {
throw cljs.core.missing_protocol.call(null,"ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_45426.call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_45432 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._rseq[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._rseq["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_45432.call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_45437 = (function (coll,ascending_QMARK_){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,ascending_QMARK_);
} else {
var m__6344__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,ascending_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_45437.call(null,coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_45438 = (function (coll,k,ascending_QMARK_){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,k,ascending_QMARK_);
} else {
var m__6344__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,k,ascending_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_45438.call(null,coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_45440 = (function (coll,entry){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._entry_key[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll,entry);
} else {
var m__6344__auto__ = (cljs.core._entry_key["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll,entry);
} else {
throw cljs.core.missing_protocol.call(null,"ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_45440.call(null,coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_45441 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._comparator[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._comparator["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_45441.call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_45442 = (function (writer,s){
var x__6346__auto__ = (((writer == null))?null:writer);
var m__6347__auto__ = (cljs.core._write[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,writer,s);
} else {
var m__6344__auto__ = (cljs.core._write["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,writer,s);
} else {
throw cljs.core.missing_protocol.call(null,"IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_45442.call(null,writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_45448 = (function (writer){
var x__6346__auto__ = (((writer == null))?null:writer);
var m__6347__auto__ = (cljs.core._flush[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,writer);
} else {
var m__6344__auto__ = (cljs.core._flush["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,writer);
} else {
throw cljs.core.missing_protocol.call(null,"IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_45448.call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_45449 = (function (o,writer,opts){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._pr_writer[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,writer,opts);
} else {
var m__6344__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,writer,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_45449.call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_45454 = (function (x){
var x__6346__auto__ = (((x == null))?null:x);
var m__6347__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,x);
} else {
var m__6344__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_45454.call(null,x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_45460 = (function (this$,oldval,newval){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._notify_watches[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,oldval,newval);
} else {
var m__6344__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,oldval,newval);
} else {
throw cljs.core.missing_protocol.call(null,"IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_45460.call(null,this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_45463 = (function (this$,key,f){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._add_watch[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,key,f);
} else {
var m__6344__auto__ = (cljs.core._add_watch["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,key,f);
} else {
throw cljs.core.missing_protocol.call(null,"IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_45463.call(null,this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_45467 = (function (this$,key){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (cljs.core._remove_watch[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,key);
} else {
var m__6344__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,key);
} else {
throw cljs.core.missing_protocol.call(null,"IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_45467.call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_45478 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._as_transient[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._as_transient["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_45478.call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_45504 = (function (tcoll,val){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll,val);
} else {
var m__6344__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll,val);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_45504.call(null,tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_45514 = (function (tcoll){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll);
} else {
var m__6344__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_45514.call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_45519 = (function (tcoll,key,val){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll,key,val);
} else {
var m__6344__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll,key,val);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_45519.call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_45537 = (function (tcoll,key){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll,key);
} else {
var m__6344__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll,key);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_45537.call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_45547 = (function (tcoll,n,val){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll,n,val);
} else {
var m__6344__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll,n,val);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_45547.call(null,tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_45557 = (function (tcoll){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll);
} else {
var m__6344__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_45557.call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_45560 = (function (tcoll,v){
var x__6346__auto__ = (((tcoll == null))?null:tcoll);
var m__6347__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,tcoll,v);
} else {
var m__6344__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,tcoll,v);
} else {
throw cljs.core.missing_protocol.call(null,"ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_45560.call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_45569 = (function (x,y){
var x__6346__auto__ = (((x == null))?null:x);
var m__6347__auto__ = (cljs.core._compare[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,x,y);
} else {
var m__6344__auto__ = (cljs.core._compare["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,x,y);
} else {
throw cljs.core.missing_protocol.call(null,"IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_45569.call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_45573 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._drop_first[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._drop_first["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_45573.call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_45582 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._chunked_first[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_45582.call(null,coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_45588 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_45588.call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_45593 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._chunked_next[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_45593.call(null,coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_45597 = (function (x){
var x__6346__auto__ = (((x == null))?null:x);
var m__6347__auto__ = (cljs.core._name[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,x);
} else {
var m__6344__auto__ = (cljs.core._name["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_45597.call(null,x);
}
});

var cljs$core$INamed$_namespace$dyn_45598 = (function (x){
var x__6346__auto__ = (((x == null))?null:x);
var m__6347__auto__ = (cljs.core._namespace[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,x);
} else {
var m__6344__auto__ = (cljs.core._namespace["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_45598.call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_45601 = (function (o,new_value){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,new_value);
} else {
var m__6344__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,new_value);
} else {
throw cljs.core.missing_protocol.call(null,"IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_45601.call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_45605 = (function() {
var G__45606 = null;
var G__45606__2 = (function (o,f){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,f);
} else {
var m__6344__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,f);
} else {
throw cljs.core.missing_protocol.call(null,"ISwap.-swap!",o);
}
}
});
var G__45606__3 = (function (o,f,a){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,f,a);
} else {
var m__6344__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,f,a);
} else {
throw cljs.core.missing_protocol.call(null,"ISwap.-swap!",o);
}
}
});
var G__45606__4 = (function (o,f,a,b){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,f,a,b);
} else {
var m__6344__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,f,a,b);
} else {
throw cljs.core.missing_protocol.call(null,"ISwap.-swap!",o);
}
}
});
var G__45606__5 = (function (o,f,a,b,xs){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,f,a,b,xs);
} else {
var m__6344__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,f,a,b,xs);
} else {
throw cljs.core.missing_protocol.call(null,"ISwap.-swap!",o);
}
}
});
G__45606 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return G__45606__2.call(this,o,f);
case 3:
return G__45606__3.call(this,o,f,a);
case 4:
return G__45606__4.call(this,o,f,a,b);
case 5:
return G__45606__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45606.cljs$core$IFn$_invoke$arity$2 = G__45606__2;
G__45606.cljs$core$IFn$_invoke$arity$3 = G__45606__3;
G__45606.cljs$core$IFn$_invoke$arity$4 = G__45606__4;
G__45606.cljs$core$IFn$_invoke$arity$5 = G__45606__5;
return G__45606;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__43496 = arguments.length;
switch (G__43496) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_45605.call(null,o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_45605.call(null,o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_45605.call(null,o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_45605.call(null,o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_45625 = (function (o,new_value){
var x__6346__auto__ = (((o == null))?null:o);
var m__6347__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,o,new_value);
} else {
var m__6344__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,o,new_value);
} else {
throw cljs.core.missing_protocol.call(null,"IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_45625.call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_45626 = (function (coll){
var x__6346__auto__ = (((coll == null))?null:coll);
var m__6347__auto__ = (cljs.core._iterator[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,coll);
} else {
var m__6344__auto__ = (cljs.core._iterator["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,coll);
} else {
throw cljs.core.missing_protocol.call(null,"IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_45626.call(null,coll);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core._pr_writer.call(null,obj,writer,cljs.core.pr_opts.call(null));

cljs.core._flush.call(null,writer);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul.call(null,cljs.core.int_rotate_left.call(null,cljs.core.imul.call(null,(k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul.call(null,cljs.core.int_rotate_left.call(null,((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul.call(null,h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul.call(null,h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1.call(null,in$);
var h1 = cljs.core.m3_mix_H1.call(null,cljs.core.m3_seed,k1);
return cljs.core.m3_fmix.call(null,h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__45642 = (i + (2));
var G__45643 = cljs.core.m3_mix_H1.call(null,h1,cljs.core.m3_mix_K1.call(null,(in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__45642;
h1 = G__45643;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1.call(null,in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix.call(null,h1__$1,cljs.core.imul.call(null,(2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__45645 = (i + (1));
var G__45646 = (cljs.core.imul.call(null,(31),hash) + s.charCodeAt(i));
i = G__45645;
hash = G__45646;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_.call(null,k);
goog.object.set(cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache.call(null,k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (cljs.core._hash.call(null,o) ^ (0));
} else {
if(typeof o === 'number'){
if(cljs.core.truth_(isFinite(o))){
return (Math.floor(o) % (2147483647));
} else {
var G__43502 = o;
switch (G__43502) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int.call(null,cljs.core.hash_string.call(null,o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash.call(null,o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine.call(null,cljs.core.m3_hash_unencoded_chars.call(null,sym.name),cljs.core.hash_string.call(null,sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_(((cljs.core.not.call(null,a.ns))?b.ns:false))){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not.call(null,b.ns)){
return (1);
} else {
var nsc = goog.array.defaultCompare(a.ns,b.ns);
if(((0) === nsc)){
return goog.array.defaultCompare(a.name,b.name);
} else {
return nsc;
}
}
} else {
return goog.array.defaultCompare(a.name,b.name);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var G__45652 = null;
var G__45652__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.call(null,coll,sym);
});
var G__45652__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.call(null,coll,sym,not_found);
});
G__45652 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__45652__2.call(this,self__,coll);
case 3:
return G__45652__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__45652.cljs$core$IFn$_invoke$arity$2 = G__45652__2;
G__45652.cljs$core$IFn$_invoke$arity$3 = G__45652__3;
return G__45652;
})()
);

(cljs.core.Symbol.prototype.apply = (function (self__,args43503){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args43503)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core.get.call(null,coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.call(null,coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__6060__auto__ = self__._hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_symbol.call(null,sym__$1);
(self__._hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write.call(null,writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__43505 = arguments.length;
switch (G__43505) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.call(null,null,name);
} else {
return cljs.core.symbol.call(null,name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_.call(null,name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__45655 = name.fqn;
name = G__45655;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return self__.val.call(null).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.val.call(null);
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.call(null,this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol.call(null,self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var G__45658 = null;
var G__45658__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null);
});
var G__45658__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a);
});
var G__45658__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b);
});
var G__45658__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c);
});
var G__45658__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d);
});
var G__45658__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e);
});
var G__45658__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f);
});
var G__45658__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g);
});
var G__45658__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h);
});
var G__45658__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i);
});
var G__45658__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__45658__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__45658__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__45658__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__45658__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__45658__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__45658__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__45658__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__45658__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__45658__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__45658__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__45658__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.call(null,self__.val.call(null),a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
});
G__45658 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__45658__1.call(this,self__);
case 2:
return G__45658__2.call(this,self__,a);
case 3:
return G__45658__3.call(this,self__,a,b);
case 4:
return G__45658__4.call(this,self__,a,b,c);
case 5:
return G__45658__5.call(this,self__,a,b,c,d);
case 6:
return G__45658__6.call(this,self__,a,b,c,d,e);
case 7:
return G__45658__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__45658__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__45658__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__45658__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__45658__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__45658__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__45658__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__45658__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__45658__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__45658__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__45658__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__45658__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__45658__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__45658__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__45658__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__45658__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__45658.cljs$core$IFn$_invoke$arity$1 = G__45658__1;
G__45658.cljs$core$IFn$_invoke$arity$2 = G__45658__2;
G__45658.cljs$core$IFn$_invoke$arity$3 = G__45658__3;
G__45658.cljs$core$IFn$_invoke$arity$4 = G__45658__4;
G__45658.cljs$core$IFn$_invoke$arity$5 = G__45658__5;
G__45658.cljs$core$IFn$_invoke$arity$6 = G__45658__6;
G__45658.cljs$core$IFn$_invoke$arity$7 = G__45658__7;
G__45658.cljs$core$IFn$_invoke$arity$8 = G__45658__8;
G__45658.cljs$core$IFn$_invoke$arity$9 = G__45658__9;
G__45658.cljs$core$IFn$_invoke$arity$10 = G__45658__10;
G__45658.cljs$core$IFn$_invoke$arity$11 = G__45658__11;
G__45658.cljs$core$IFn$_invoke$arity$12 = G__45658__12;
G__45658.cljs$core$IFn$_invoke$arity$13 = G__45658__13;
G__45658.cljs$core$IFn$_invoke$arity$14 = G__45658__14;
G__45658.cljs$core$IFn$_invoke$arity$15 = G__45658__15;
G__45658.cljs$core$IFn$_invoke$arity$16 = G__45658__16;
G__45658.cljs$core$IFn$_invoke$arity$17 = G__45658__17;
G__45658.cljs$core$IFn$_invoke$arity$18 = G__45658__18;
G__45658.cljs$core$IFn$_invoke$arity$19 = G__45658__19;
G__45658.cljs$core$IFn$_invoke$arity$20 = G__45658__20;
G__45658.cljs$core$IFn$_invoke$arity$21 = G__45658__21;
G__45658.cljs$core$IFn$_invoke$arity$22 = G__45658__22;
return G__45658;
})()
);

(cljs.core.Var.prototype.apply = (function (self__,args43506){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args43506)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return self__.val.call(null).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.call(null,self__.val.call(null),a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}));

(cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return goog.object.containsKey(x,cljs.core.ITER_SYMBOL);
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone.call(null,value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core._seq.call(null,coll);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.truth_(cljs.core.js_iterable_QMARK_.call(null,coll))){
return cljs.core.es6_iterator_seq.call(null,goog.object.get(coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISeqable,coll)){
return cljs.core._seq.call(null,coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return cljs.core._first.call(null,coll);
} else {
var s = cljs.core.seq.call(null,coll);
if((s == null)){
return null;
} else {
return cljs.core._first.call(null,s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return cljs.core._rest.call(null,coll);
} else {
var s = cljs.core.seq.call(null,coll);
if(s){
return cljs.core._rest.call(null,s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return cljs.core._next.call(null,coll);
} else {
return cljs.core.seq.call(null,cljs.core.rest.call(null,coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__43517 = arguments.length;
switch (G__43517) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___45783 = arguments.length;
var i__6921__auto___45787 = (0);
while(true){
if((i__6921__auto___45787 < len__6920__auto___45783)){
args_arr__6949__auto__.push((arguments[i__6921__auto___45787]));

var G__45788 = (i__6921__auto___45787 + (1));
i__6921__auto___45787 = G__45788;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv.call(null,x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.call(null,x,y)){
if(cljs.core.next.call(null,more)){
var G__45799 = y;
var G__45800 = cljs.core.first.call(null,more);
var G__45801 = cljs.core.next.call(null,more);
x = G__45799;
y = G__45800;
more = G__45801;
continue;
} else {
return cljs.core._EQ_.call(null,y,cljs.core.first.call(null,more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function (seq43514){
var G__43515 = cljs.core.first.call(null,seq43514);
var seq43514__$1 = cljs.core.next.call(null,seq43514);
var G__43516 = cljs.core.first.call(null,seq43514__$1);
var seq43514__$2 = cljs.core.next.call(null,seq43514__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43515,G__43516,seq43514__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first.call(null,self__.s);
(self__.s = cljs.core.next.call(null,self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq.call(null,coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq.call(null,self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1.call(null,hash_basis);
var h1__$1 = cljs.core.m3_mix_H1.call(null,h1,k1);
return cljs.core.m3_fmix.call(null,h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq.call(null,coll);
while(true){
if((!((coll__$1 == null)))){
var G__45822 = (n + (1));
var G__45823 = ((cljs.core.imul.call(null,(31),hash_code) + cljs.core.hash.call(null,cljs.core.first.call(null,coll__$1))) | (0));
var G__45824 = cljs.core.next.call(null,coll__$1);
n = G__45822;
hash_code = G__45823;
coll__$1 = G__45824;
continue;
} else {
return cljs.core.mix_collection_hash.call(null,hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash.call(null,(1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq.call(null,coll);
while(true){
if((!((coll__$1 == null)))){
var G__45841 = (n + (1));
var G__45842 = ((hash_code + cljs.core.hash.call(null,cljs.core.first.call(null,coll__$1))) | (0));
var G__45843 = cljs.core.next.call(null,coll__$1);
n = G__45841;
hash_code = G__45842;
coll__$1 = G__45843;
continue;
} else {
return cljs.core.mix_collection_hash.call(null,hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash.call(null,(0),(0));


goog.object.set(cljs.core.ICounted,"null",true);

goog.object.set(cljs.core._count,"null",(function (_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
return goog.array.defaultCompare(this$__$1.valueOf(),other.valueOf());
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_45857 = (function (inst){
var x__6346__auto__ = (((inst == null))?null:inst);
var m__6347__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,inst);
} else {
var m__6344__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,inst);
} else {
throw cljs.core.missing_protocol.call(null,"Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_45857.call(null,inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_.call(null,inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.Inst,x);
}
});
goog.object.set(cljs.core.IEquiv,"number",true);

goog.object.set(cljs.core._equiv,"number",(function (x,o){
return (x === o);
}));
goog.object.set(cljs.core.Fn,"function",true);

goog.object.set(cljs.core.IMeta,"function",true);

goog.object.set(cljs.core._meta,"function",(function (_){
return null;
}));
goog.object.set(cljs.core.IHash,"_",true);

goog.object.set(cljs.core._hash,"_",(function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_.call(null,x)){
return x;
} else {
return cljs.core.reduced.call(null,x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_.call(null,x)){
return cljs.core.deref.call(null,x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref.call(null,o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__43520 = arguments.length;
switch (G__43520) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count.call(null,cicoll);
if((cnt === (0))){
return f.call(null);
} else {
var val = cljs.core._nth.call(null,cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = f.call(null,val,cljs.core._nth.call(null,cicoll,n));
if(cljs.core.reduced_QMARK_.call(null,nval)){
return cljs.core.deref.call(null,nval);
} else {
var G__45874 = nval;
var G__45875 = (n + (1));
val = G__45874;
n = G__45875;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count.call(null,cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = f.call(null,val__$1,cljs.core._nth.call(null,cicoll,n));
if(cljs.core.reduced_QMARK_.call(null,nval)){
return cljs.core.deref.call(null,nval);
} else {
var G__45876 = nval;
var G__45877 = (n + (1));
val__$1 = G__45876;
n = G__45877;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__43522 = arguments.length;
switch (G__43522) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return f.call(null);
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = f.call(null,val,(arr[n]));
if(cljs.core.reduced_QMARK_.call(null,nval)){
return cljs.core.deref.call(null,nval);
} else {
var G__45879 = nval;
var G__45880 = (n + (1));
val = G__45879;
n = G__45880;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = f.call(null,val__$1,(arr[n]));
if(cljs.core.reduced_QMARK_.call(null,nval)){
return cljs.core.deref.call(null,nval);
} else {
var G__45881 = nval;
var G__45882 = (n + (1));
val__$1 = G__45881;
n = G__45882;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = f.call(null,val__$1,(arr[n]));
if(cljs.core.reduced_QMARK_.call(null,nval)){
return cljs.core.deref.call(null,nval);
} else {
var G__45883 = nval;
var G__45884 = (n + (1));
val__$1 = G__45883;
n = G__45884;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__43526 = arguments.length;
switch (G__43526) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.call(null,coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = cljs.core.count.call(null,coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__5956__auto__ = (0);
var y__5957__auto__ = (start + len);
return ((x__5956__auto__ > y__5957__auto__) ? x__5956__auto__ : y__5957__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.call(null,cljs.core.nth.call(null,coll,idx),x)){
return idx;
} else {
var G__45899 = (idx + (1));
idx = G__45899;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__43528 = arguments.length;
switch (G__43528) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = cljs.core.count.call(null,coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__5963__auto__ = (len - (1));
var y__5964__auto__ = start;
return ((x__5963__auto__ < y__5964__auto__) ? x__5963__auto__ : y__5964__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.call(null,cljs.core.nth.call(null,coll,idx),x)){
return idx;
} else {
var G__45906 = (idx - (1));
idx = G__45906;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__45919 = null;
var G__45919__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__45919__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__45919 = function(x,start){
switch(arguments.length){
case 1:
return G__45919__1.call(this,x);
case 2:
return G__45919__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45919.cljs$core$IFn$_invoke$arity$1 = G__45919__1;
G__45919.cljs$core$IFn$_invoke$arity$2 = G__45919__2;
return G__45919;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__45923 = null;
var G__45923__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__45923__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__45923 = function(x,start){
switch(arguments.length){
case 1:
return G__45923__1.call(this,x);
case 2:
return G__45923__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45923.cljs$core$IFn$_invoke$arity$1 = G__45923__1;
G__45923.cljs$core$IFn$_invoke$arity$2 = G__45923__2;
return G__45923;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__5956__auto__ = (0);
var y__5957__auto__ = (self__.arr.length - self__.i);
return ((x__5956__auto__ > y__5957__auto__) ? x__5956__auto__ : y__5957__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count.call(null,coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll.call(null,coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.call(null,self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.call(null,self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

goog.object.set(cljs.core.IndexedSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__43530 = arguments.length;
switch (G__43530) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.call(null,prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__43532 = arguments.length;
switch (G__43532) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.call(null,array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.call(null,array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var G__45942 = null;
var G__45942__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__45942__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__45942 = function(x,start){
switch(arguments.length){
case 1:
return G__45942__1.call(this,x);
case 2:
return G__45942__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45942.cljs$core$IFn$_invoke$arity$1 = G__45942__1;
G__45942.cljs$core$IFn$_invoke$arity$2 = G__45942__2;
return G__45942;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__45943 = null;
var G__45943__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__45943__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__45943 = function(x,start){
switch(arguments.length){
case 1:
return G__45943__1.call(this,x);
case 2:
return G__45943__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45943.cljs$core$IFn$_invoke$arity$1 = G__45943__1;
G__45943.cljs$core$IFn$_invoke$arity$2 = G__45943__2;
return G__45943;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll.call(null,coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.call(null,f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.call(null,self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

goog.object.set(cljs.core.RSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first.call(null,cljs.core.next.call(null,coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first.call(null,cljs.core.first.call(null,coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next.call(null,cljs.core.first.call(null,coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first.call(null,cljs.core.next.call(null,coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next.call(null,cljs.core.next.call(null,coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next.call(null,s);
if((!((sn == null)))){
var G__45944 = sn;
s = G__45944;
continue;
} else {
return cljs.core.first.call(null,s);
}
break;
}
});
goog.object.set(cljs.core.IEquiv,"_",true);

goog.object.set(cljs.core._equiv,"_",(function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__43537 = arguments.length;
switch (G__43537) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___45949 = arguments.length;
var i__6921__auto___45950 = (0);
while(true){
if((i__6921__auto___45950 < len__6920__auto___45949)){
args_arr__6949__auto__.push((arguments[i__6921__auto___45950]));

var G__45951 = (i__6921__auto___45950 + (1));
i__6921__auto___45950 = G__45951;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if((!((coll == null)))){
return cljs.core._conj.call(null,coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__45952 = cljs.core.conj.call(null,coll,x);
var G__45953 = cljs.core.first.call(null,xs);
var G__45954 = cljs.core.next.call(null,xs);
coll = G__45952;
x = G__45953;
xs = G__45954;
continue;
} else {
return cljs.core.conj.call(null,coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function (seq43534){
var G__43535 = cljs.core.first.call(null,seq43534);
var seq43534__$1 = cljs.core.next.call(null,seq43534);
var G__43536 = cljs.core.first.call(null,seq43534__$1);
var seq43534__$2 = cljs.core.next.call(null,seq43534__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43535,G__43536,seq43534__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return cljs.core._empty.call(null,coll);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty.call(null,coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq.call(null,coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_.call(null,s)){
return (acc + cljs.core._count.call(null,s));
} else {
var G__45955 = cljs.core.next.call(null,s);
var G__45956 = (acc + (1));
s = G__45955;
acc = G__45956;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return cljs.core._count.call(null,coll);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count.call(null,coll);
} else {
return cljs.core._count.call(null,coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__43543 = arguments.length;
switch (G__43543) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq.call(null,coll)){
return cljs.core.first.call(null,coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_.call(null,coll)){
return cljs.core._nth.call(null,coll,n);
} else {
if(cljs.core.seq.call(null,coll)){
var G__45958 = cljs.core.next.call(null,coll);
var G__45959 = (n - (1));
coll = G__45958;
n = G__45959;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq.call(null,coll)){
return cljs.core.first.call(null,coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_.call(null,coll)){
return cljs.core._nth.call(null,coll,n,not_found);
} else {
if(cljs.core.seq.call(null,coll)){
var G__45961 = cljs.core.next.call(null,coll);
var G__45962 = (n - (1));
var G__45963 = not_found;
coll = G__45961;
n = G__45962;
not_found = G__45963;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__43545 = arguments.length;
switch (G__43545) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return cljs.core._nth.call(null,coll,n);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__5598__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__5598__auto__){
return or__5598__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.call(null,coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IIndexed,coll)){
return cljs.core._nth.call(null,coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str.call(null,cljs.core.type.call(null,coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return cljs.core._nth.call(null,coll,n,not_found);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__5598__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__5598__auto__){
return or__5598__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.call(null,coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IIndexed,coll)){
return cljs.core._nth.call(null,coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str.call(null,cljs.core.type.call(null,coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
var temp__5718__auto__ = (((n__$1 > (0))) && (cljs.core.seq.call(null,xs)));
if(temp__5718__auto__){
var xs__$1 = temp__5718__auto__;
var G__45978 = (n__$1 - (1));
var G__45979 = cljs.core.rest.call(null,xs__$1);
n__$1 = G__45978;
xs = G__45979;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__43555 = arguments.length;
switch (G__43555) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return cljs.core._lookup.call(null,o,k);
} else {
if(cljs.core.array_QMARK_.call(null,o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ILookup,o)){
return cljs.core._lookup.call(null,o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return cljs.core._lookup.call(null,o,k,not_found);
} else {
if(cljs.core.array_QMARK_.call(null,o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ILookup,o)){
return cljs.core._lookup.call(null,o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__43563 = arguments.length;
switch (G__43563) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___45982 = arguments.length;
var i__6921__auto___45983 = (0);
while(true){
if((i__6921__auto___45983 < len__6920__auto___45982)){
args_arr__6949__auto__.push((arguments[i__6921__auto___45983]));

var G__45984 = (i__6921__auto___45983 + (1));
i__6921__auto___45983 = G__45984;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return cljs.core._assoc.call(null,coll,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc.call(null,coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.call(null,coll,k,v);
if(cljs.core.truth_(kvs)){
var G__45985 = ret;
var G__45986 = cljs.core.first.call(null,kvs);
var G__45987 = cljs.core.second.call(null,kvs);
var G__45988 = cljs.core.nnext.call(null,kvs);
coll = G__45985;
k = G__45986;
v = G__45987;
kvs = G__45988;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function (seq43559){
var G__43560 = cljs.core.first.call(null,seq43559);
var seq43559__$1 = cljs.core.next.call(null,seq43559);
var G__43561 = cljs.core.first.call(null,seq43559__$1);
var seq43559__$2 = cljs.core.next.call(null,seq43559__$1);
var G__43562 = cljs.core.first.call(null,seq43559__$2);
var seq43559__$3 = cljs.core.next.call(null,seq43559__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43560,G__43561,G__43562,seq43559__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__43569 = arguments.length;
switch (G__43569) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___45993 = arguments.length;
var i__6921__auto___45994 = (0);
while(true){
if((i__6921__auto___45994 < len__6920__auto___45993)){
args_arr__6949__auto__.push((arguments[i__6921__auto___45994]));

var G__45995 = (i__6921__auto___45994 + (1));
i__6921__auto___45994 = G__45995;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc.call(null,coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.call(null,coll,k);
if(cljs.core.truth_(ks)){
var G__45996 = ret;
var G__45997 = cljs.core.first.call(null,ks);
var G__45998 = cljs.core.next.call(null,ks);
coll = G__45996;
k = G__45997;
ks = G__45998;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function (seq43566){
var G__43567 = cljs.core.first.call(null,seq43566);
var seq43566__$1 = cljs.core.next.call(null,seq43566);
var G__43568 = cljs.core.first.call(null,seq43566__$1);
var seq43566__$2 = cljs.core.next.call(null,seq43566__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43567,G__43568,seq43566__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__5598__auto__ = goog.isFunction(f);
if(or__5598__auto__){
return or__5598__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var G__45999 = null;
var G__45999__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null);
});
var G__45999__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a);
});
var G__45999__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b);
});
var G__45999__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c);
});
var G__45999__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d);
});
var G__45999__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e);
});
var G__45999__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f);
});
var G__45999__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g);
});
var G__45999__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h);
});
var G__45999__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i);
});
var G__45999__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__45999__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__45999__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__45999__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__45999__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__45999__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__45999__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__45999__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__45999__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__45999__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__45999__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__45999__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
});
G__45999 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__45999__1.call(this,self__);
case 2:
return G__45999__2.call(this,self__,a);
case 3:
return G__45999__3.call(this,self__,a,b);
case 4:
return G__45999__4.call(this,self__,a,b,c);
case 5:
return G__45999__5.call(this,self__,a,b,c,d);
case 6:
return G__45999__6.call(this,self__,a,b,c,d,e);
case 7:
return G__45999__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__45999__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__45999__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__45999__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__45999__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__45999__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__45999__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__45999__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__45999__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__45999__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__45999__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__45999__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__45999__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__45999__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__45999__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__45999__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__45999.cljs$core$IFn$_invoke$arity$1 = G__45999__1;
G__45999.cljs$core$IFn$_invoke$arity$2 = G__45999__2;
G__45999.cljs$core$IFn$_invoke$arity$3 = G__45999__3;
G__45999.cljs$core$IFn$_invoke$arity$4 = G__45999__4;
G__45999.cljs$core$IFn$_invoke$arity$5 = G__45999__5;
G__45999.cljs$core$IFn$_invoke$arity$6 = G__45999__6;
G__45999.cljs$core$IFn$_invoke$arity$7 = G__45999__7;
G__45999.cljs$core$IFn$_invoke$arity$8 = G__45999__8;
G__45999.cljs$core$IFn$_invoke$arity$9 = G__45999__9;
G__45999.cljs$core$IFn$_invoke$arity$10 = G__45999__10;
G__45999.cljs$core$IFn$_invoke$arity$11 = G__45999__11;
G__45999.cljs$core$IFn$_invoke$arity$12 = G__45999__12;
G__45999.cljs$core$IFn$_invoke$arity$13 = G__45999__13;
G__45999.cljs$core$IFn$_invoke$arity$14 = G__45999__14;
G__45999.cljs$core$IFn$_invoke$arity$15 = G__45999__15;
G__45999.cljs$core$IFn$_invoke$arity$16 = G__45999__16;
G__45999.cljs$core$IFn$_invoke$arity$17 = G__45999__17;
G__45999.cljs$core$IFn$_invoke$arity$18 = G__45999__18;
G__45999.cljs$core$IFn$_invoke$arity$19 = G__45999__19;
G__45999.cljs$core$IFn$_invoke$arity$20 = G__45999__20;
G__45999.cljs$core$IFn$_invoke$arity$21 = G__45999__21;
G__45999.cljs$core$IFn$_invoke$arity$22 = G__45999__22;
return G__45999;
})()
);

(cljs.core.MetaFn.prototype.apply = (function (self__,args43572){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args43572)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return self__.afn.call(null);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return self__.afn.call(null,a);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}));

(cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta.call(null,o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((((!((o == null))))?(((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$))))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IMeta,o):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IMeta,o)):false)){
return cljs.core._meta.call(null,o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek.call(null,coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop.call(null,coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__43579 = arguments.length;
switch (G__43579) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46029 = arguments.length;
var i__6921__auto___46030 = (0);
while(true){
if((i__6921__auto___46030 < len__6920__auto___46029)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46030]));

var G__46031 = (i__6921__auto___46030 + (1));
i__6921__auto___46030 = G__46031;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin.call(null,coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.call(null,coll,k);
if(cljs.core.truth_(ks)){
var G__46033 = ret;
var G__46034 = cljs.core.first.call(null,ks);
var G__46035 = cljs.core.next.call(null,ks);
coll = G__46033;
k = G__46034;
ks = G__46035;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function (seq43576){
var G__43577 = cljs.core.first.call(null,seq43576);
var seq43576__$1 = cljs.core.next.call(null,seq43576);
var G__43578 = cljs.core.first.call(null,seq43576__$1);
var seq43576__$2 = cljs.core.next.call(null,seq43576__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43577,G__43578,seq43576__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return (((coll == null)) || (cljs.core.not.call(null,cljs.core.seq.call(null,coll))));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__43593 = arguments.length;
switch (G__43593) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46047 = arguments.length;
var i__6921__auto___46048 = (0);
while(true){
if((i__6921__auto___46048 < len__6920__auto___46047)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46048]));

var G__46049 = (i__6921__auto___46048 + (1));
i__6921__auto___46048 = G__46049;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__6950__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return cljs.core.apply.call(null,goog.object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function (seq43592){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq43592));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return goog.object.getKeys(obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__46050 = (i__$1 + (1));
var G__46051 = (j__$1 + (1));
var G__46052 = (len__$1 - (1));
i__$1 = G__46050;
j__$1 = G__46051;
len__$1 = G__46052;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__46053 = (i__$1 - (1));
var G__46054 = (j__$1 - (1));
var G__46055 = (len__$1 - (1));
i__$1 = G__46053;
j__$1 = G__46054;
len__$1 = G__46055;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__5598__auto__ = (s == null);
if(or__5598__auto__){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISeqable,s));
if(or__5598__auto____$1){
return or__5598__auto____$1;
} else {
return ((cljs.core.array_QMARK_.call(null,s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__5598__auto__ = cljs.core.fn_QMARK_.call(null,f);
if(or__5598__auto__){
return or__5598__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((!(isNaN(n)))) && ((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))));
});
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_.call(null,x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long)));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_.call(null,x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not.call(null,x.isNegative())) && (cljs.core.not.call(null,x.isZero())));
} else {
if((x instanceof goog.math.Long)){
return ((cljs.core.not.call(null,x.isNegative())) && (cljs.core.not.call(null,x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_.call(null,x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof goog.math.Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_.call(null,x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not.call(null,x.isNegative());
} else {
if((x instanceof goog.math.Long)){
return cljs.core.not.call(null,x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.call(null,coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_.call(null,coll)){
return cljs.core._find.call(null,coll,k);
} else {
if((((!((coll == null)))) && (cljs.core.associative_QMARK_.call(null,coll)) && (cljs.core.contains_QMARK_.call(null,coll,k)))){
return (new cljs.core.MapEntry(k,cljs.core.get.call(null,coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__43608 = arguments.length;
switch (G__43608) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46066 = arguments.length;
var i__6921__auto___46067 = (0);
while(true){
if((i__6921__auto___46067 < len__6920__auto___46066)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46067]));

var G__46068 = (i__6921__auto___46067 + (1));
i__6921__auto___46067 = G__46068;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.call(null,x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if((!(cljs.core._EQ_.call(null,x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first.call(null,xs);
var etc = cljs.core.next.call(null,xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_.call(null,s,x__$1)){
return false;
} else {
var G__46070 = cljs.core.conj.call(null,s,x__$1);
var G__46071 = etc;
s = G__46070;
xs = G__46071;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq43605){
var G__43606 = cljs.core.first.call(null,seq43605);
var seq43605__$1 = cljs.core.next.call(null,seq43605);
var G__43607 = cljs.core.first.call(null,seq43605__$1);
var seq43605__$2 = cljs.core.next.call(null,seq43605__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43606,G__43607,seq43605__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IComparable,x))){
return cljs.core._compare.call(null,x,y);
} else {
if(((((typeof x === 'string') || (cljs.core.array_QMARK_.call(null,x)) || (x === true) || (x === false))) && ((cljs.core.type.call(null,x) === cljs.core.type.call(null,y))))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__43611 = arguments.length;
switch (G__43611) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count.call(null,xs);
var yl = cljs.core.count.call(null,ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.call(null,xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare.call(null,cljs.core.nth.call(null,xs,n),cljs.core.nth.call(null,ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__46077 = xs;
var G__46078 = ys;
var G__46079 = len;
var G__46080 = (n + (1));
xs = G__46077;
ys = G__46078;
len = G__46079;
n = G__46080;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.call(null,f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = f.call(null,x,y);
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_(f.call(null,y,x))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__43613 = arguments.length;
switch (G__43613) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.call(null,cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq.call(null,coll)){
var a = cljs.core.to_array.call(null,coll);
goog.array.stableSort(a,cljs.core.fn__GT_comparator.call(null,comp));

return cljs.core.seq.call(null,a);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__43615 = arguments.length;
switch (G__43615) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.call(null,keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.call(null,(function (x,y){
return cljs.core.fn__GT_comparator.call(null,comp).call(null,keyfn.call(null,x),keyfn.call(null,y));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__43617 = arguments.length;
switch (G__43617) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__5718__auto__ = cljs.core.seq.call(null,coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reduce.call(null,f,cljs.core.first.call(null,s),cljs.core.next.call(null,s));
} else {
return f.call(null);
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq.call(null,coll);
while(true){
if(coll__$1){
var nval = f.call(null,val__$1,cljs.core.first.call(null,coll__$1));
if(cljs.core.reduced_QMARK_.call(null,nval)){
return cljs.core.deref.call(null,nval);
} else {
var G__46088 = nval;
var G__46089 = cljs.core.next.call(null,coll__$1);
val__$1 = G__46088;
coll__$1 = G__46089;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array.call(null,coll);
goog.array.shuffle(a);

return cljs.core.vec.call(null,a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__43619 = arguments.length;
switch (G__43619) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
var iter = cljs.core._iterator.call(null,coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = f.call(null,acc,iter.next());
if(cljs.core.reduced_QMARK_.call(null,nacc)){
return cljs.core.deref.call(null,nacc);
} else {
var G__46091 = nacc;
acc = G__46091;
continue;
}
} else {
return acc;
}
break;
}
} else {
return f.call(null);
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,init){
var iter = cljs.core._iterator.call(null,coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = f.call(null,acc,iter.next());
if(cljs.core.reduced_QMARK_.call(null,nacc)){
return cljs.core.deref.call(null,nacc);
} else {
var G__46094 = nacc;
acc = G__46094;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__43621 = arguments.length;
switch (G__43621) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return cljs.core._reduce.call(null,coll,f);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return cljs.core.array_reduce.call(null,coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.call(null,coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IReduce,coll)){
return cljs.core._reduce.call(null,coll,f);
} else {
if(cljs.core.iterable_QMARK_.call(null,coll)){
return cljs.core.iter_reduce.call(null,coll,f);
} else {
return cljs.core.seq_reduce.call(null,f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return cljs.core._reduce.call(null,coll,f,val);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return cljs.core.array_reduce.call(null,coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.call(null,coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IReduce,coll)){
return cljs.core._reduce.call(null,coll,f,val);
} else {
if(cljs.core.iterable_QMARK_.call(null,coll)){
return cljs.core.iter_reduce.call(null,coll,f,val);
} else {
return cljs.core.seq_reduce.call(null,f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((!((coll == null)))){
return cljs.core._kv_reduce.call(null,coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__43625 = arguments.length;
switch (G__43625) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.call(null,f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__46100 = null;
var G__46100__0 = (function (){
return f.call(null);
});
var G__46100__1 = (function (x){
return cf.call(null,x);
});
var G__46100__2 = (function (x,y){
return f.call(null,x,y);
});
G__46100 = function(x,y){
switch(arguments.length){
case 0:
return G__46100__0.call(this);
case 1:
return G__46100__1.call(this,x);
case 2:
return G__46100__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46100.cljs$core$IFn$_invoke$arity$0 = G__46100__0;
G__46100.cljs$core$IFn$_invoke$arity$1 = G__46100__1;
G__46100.cljs$core$IFn$_invoke$arity$2 = G__46100__2;
return G__46100;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__43627 = arguments.length;
switch (G__43627) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.call(null,xform,f,f.call(null),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = xform.call(null,f);
var ret = cljs.core.reduce.call(null,f__$1,init,coll);
return f__$1.call(null,ret);
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__43632 = arguments.length;
switch (G__43632) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46107 = arguments.length;
var i__6921__auto___46108 = (0);
while(true){
if((i__6921__auto___46108 < len__6920__auto___46107)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46108]));

var G__46109 = (i__6921__auto___46108 + (1));
i__6921__auto___46108 = G__46109;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function (seq43629){
var G__43630 = cljs.core.first.call(null,seq43629);
var seq43629__$1 = cljs.core.next.call(null,seq43629);
var G__43631 = cljs.core.first.call(null,seq43629__$1);
var seq43629__$2 = cljs.core.next.call(null,seq43629__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43630,G__43631,seq43629__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__43637 = arguments.length;
switch (G__43637) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46111 = arguments.length;
var i__6921__auto___46112 = (0);
while(true){
if((i__6921__auto___46112 < len__6920__auto___46111)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46112]));

var G__46113 = (i__6921__auto___46112 + (1));
i__6921__auto___46112 = G__46113;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function (seq43634){
var G__43635 = cljs.core.first.call(null,seq43634);
var seq43634__$1 = cljs.core.next.call(null,seq43634);
var G__43636 = cljs.core.first.call(null,seq43634__$1);
var seq43634__$2 = cljs.core.next.call(null,seq43634__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43635,G__43636,seq43634__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__43642 = arguments.length;
switch (G__43642) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46115 = arguments.length;
var i__6921__auto___46116 = (0);
while(true){
if((i__6921__auto___46116 < len__6920__auto___46115)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46116]));

var G__46117 = (i__6921__auto___46116 + (1));
i__6921__auto___46116 = G__46117;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function (seq43639){
var G__43640 = cljs.core.first.call(null,seq43639);
var seq43639__$1 = cljs.core.next.call(null,seq43639);
var G__43641 = cljs.core.first.call(null,seq43639__$1);
var seq43639__$2 = cljs.core.next.call(null,seq43639__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43640,G__43641,seq43639__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__43647 = arguments.length;
switch (G__43647) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46119 = arguments.length;
var i__6921__auto___46120 = (0);
while(true){
if((i__6921__auto___46120 < len__6920__auto___46119)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46120]));

var G__46121 = (i__6921__auto___46120 + (1));
i__6921__auto___46120 = G__46121;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function (seq43644){
var G__43645 = cljs.core.first.call(null,seq43644);
var seq43644__$1 = cljs.core.next.call(null,seq43644);
var G__43646 = cljs.core.first.call(null,seq43644__$1);
var seq43644__$2 = cljs.core.next.call(null,seq43644__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43645,G__43646,seq43644__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__43652 = arguments.length;
switch (G__43652) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46123 = arguments.length;
var i__6921__auto___46124 = (0);
while(true){
if((i__6921__auto___46124 < len__6920__auto___46123)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46124]));

var G__46126 = (i__6921__auto___46124 + (1));
i__6921__auto___46124 = G__46126;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next.call(null,more)){
var G__46127 = y;
var G__46128 = cljs.core.first.call(null,more);
var G__46129 = cljs.core.next.call(null,more);
x = G__46127;
y = G__46128;
more = G__46129;
continue;
} else {
return (y < cljs.core.first.call(null,more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function (seq43649){
var G__43650 = cljs.core.first.call(null,seq43649);
var seq43649__$1 = cljs.core.next.call(null,seq43649);
var G__43651 = cljs.core.first.call(null,seq43649__$1);
var seq43649__$2 = cljs.core.next.call(null,seq43649__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43650,G__43651,seq43649__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__43657 = arguments.length;
switch (G__43657) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46132 = arguments.length;
var i__6921__auto___46133 = (0);
while(true){
if((i__6921__auto___46133 < len__6920__auto___46132)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46133]));

var G__46134 = (i__6921__auto___46133 + (1));
i__6921__auto___46133 = G__46134;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next.call(null,more)){
var G__46135 = y;
var G__46136 = cljs.core.first.call(null,more);
var G__46137 = cljs.core.next.call(null,more);
x = G__46135;
y = G__46136;
more = G__46137;
continue;
} else {
return (y <= cljs.core.first.call(null,more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq43654){
var G__43655 = cljs.core.first.call(null,seq43654);
var seq43654__$1 = cljs.core.next.call(null,seq43654);
var G__43656 = cljs.core.first.call(null,seq43654__$1);
var seq43654__$2 = cljs.core.next.call(null,seq43654__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43655,G__43656,seq43654__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__43662 = arguments.length;
switch (G__43662) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46140 = arguments.length;
var i__6921__auto___46141 = (0);
while(true){
if((i__6921__auto___46141 < len__6920__auto___46140)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46141]));

var G__46142 = (i__6921__auto___46141 + (1));
i__6921__auto___46141 = G__46142;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next.call(null,more)){
var G__46149 = y;
var G__46150 = cljs.core.first.call(null,more);
var G__46151 = cljs.core.next.call(null,more);
x = G__46149;
y = G__46150;
more = G__46151;
continue;
} else {
return (y > cljs.core.first.call(null,more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function (seq43659){
var G__43660 = cljs.core.first.call(null,seq43659);
var seq43659__$1 = cljs.core.next.call(null,seq43659);
var G__43661 = cljs.core.first.call(null,seq43659__$1);
var seq43659__$2 = cljs.core.next.call(null,seq43659__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43660,G__43661,seq43659__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__43667 = arguments.length;
switch (G__43667) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46153 = arguments.length;
var i__6921__auto___46154 = (0);
while(true){
if((i__6921__auto___46154 < len__6920__auto___46153)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46154]));

var G__46155 = (i__6921__auto___46154 + (1));
i__6921__auto___46154 = G__46155;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next.call(null,more)){
var G__46156 = y;
var G__46157 = cljs.core.first.call(null,more);
var G__46158 = cljs.core.next.call(null,more);
x = G__46156;
y = G__46157;
more = G__46158;
continue;
} else {
return (y >= cljs.core.first.call(null,more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq43664){
var G__43665 = cljs.core.first.call(null,seq43664);
var seq43664__$1 = cljs.core.next.call(null,seq43664);
var G__43666 = cljs.core.first.call(null,seq43664__$1);
var seq43664__$2 = cljs.core.next.call(null,seq43664__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43665,G__43666,seq43664__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__43672 = arguments.length;
switch (G__43672) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46160 = arguments.length;
var i__6921__auto___46161 = (0);
while(true){
if((i__6921__auto___46161 < len__6920__auto___46160)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46161]));

var G__46162 = (i__6921__auto___46161 + (1));
i__6921__auto___46161 = G__46162;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__5956__auto__ = x;
var y__5957__auto__ = y;
return ((x__5956__auto__ > y__5957__auto__) ? x__5956__auto__ : y__5957__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.max,(function (){var x__5956__auto__ = x;
var y__5957__auto__ = y;
return ((x__5956__auto__ > y__5957__auto__) ? x__5956__auto__ : y__5957__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function (seq43669){
var G__43670 = cljs.core.first.call(null,seq43669);
var seq43669__$1 = cljs.core.next.call(null,seq43669);
var G__43671 = cljs.core.first.call(null,seq43669__$1);
var seq43669__$2 = cljs.core.next.call(null,seq43669__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43670,G__43671,seq43669__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__43677 = arguments.length;
switch (G__43677) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46164 = arguments.length;
var i__6921__auto___46165 = (0);
while(true){
if((i__6921__auto___46165 < len__6920__auto___46164)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46165]));

var G__46170 = (i__6921__auto___46165 + (1));
i__6921__auto___46165 = G__46170;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__5963__auto__ = x;
var y__5964__auto__ = y;
return ((x__5963__auto__ < y__5964__auto__) ? x__5963__auto__ : y__5964__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.min,(function (){var x__5963__auto__ = x;
var y__5964__auto__ = y;
return ((x__5963__auto__ < y__5964__auto__) ? x__5963__auto__ : y__5964__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function (seq43674){
var G__43675 = cljs.core.first.call(null,seq43674);
var seq43674__$1 = cljs.core.next.call(null,seq43674);
var G__43676 = cljs.core.first.call(null,seq43674__$1);
var seq43674__$2 = cljs.core.next.call(null,seq43674__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43675,G__43676,seq43674__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__43682 = arguments.length;
switch (G__43682) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46172 = arguments.length;
var i__6921__auto___46173 = (0);
while(true){
if((i__6921__auto___46173 < len__6920__auto___46172)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46173]));

var G__46174 = (i__6921__auto___46173 + (1));
i__6921__auto___46173 = G__46174;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq43679){
var G__43680 = cljs.core.first.call(null,seq43679);
var seq43679__$1 = cljs.core.next.call(null,seq43679);
var G__43681 = cljs.core.first.call(null,seq43679__$1);
var seq43679__$2 = cljs.core.next.call(null,seq43679__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43680,G__43681,seq43679__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__43687 = arguments.length;
switch (G__43687) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46179 = arguments.length;
var i__6921__auto___46180 = (0);
while(true){
if((i__6921__auto___46180 < len__6920__auto___46179)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46180]));

var G__46181 = (i__6921__auto___46180 + (1));
i__6921__auto___46180 = G__46181;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq43684){
var G__43685 = cljs.core.first.call(null,seq43684);
var seq43684__$1 = cljs.core.next.call(null,seq43684);
var G__43686 = cljs.core.first.call(null,seq43684__$1);
var seq43684__$2 = cljs.core.next.call(null,seq43684__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43685,G__43686,seq43684__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__43692 = arguments.length;
switch (G__43692) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46186 = arguments.length;
var i__6921__auto___46187 = (0);
while(true){
if((i__6921__auto___46187 < len__6920__auto___46186)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46187]));

var G__46188 = (i__6921__auto___46187 + (1));
i__6921__auto___46187 = G__46188;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq43689){
var G__43690 = cljs.core.first.call(null,seq43689);
var seq43689__$1 = cljs.core.next.call(null,seq43689);
var G__43691 = cljs.core.first.call(null,seq43689__$1);
var seq43689__$2 = cljs.core.next.call(null,seq43689__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43690,G__43691,seq43689__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__43697 = arguments.length;
switch (G__43697) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46190 = arguments.length;
var i__6921__auto___46191 = (0);
while(true){
if((i__6921__auto___46191 < len__6920__auto___46190)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46191]));

var G__46192 = (i__6921__auto___46191 + (1));
i__6921__auto___46191 = G__46192;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq43694){
var G__43695 = cljs.core.first.call(null,seq43694);
var seq43694__$1 = cljs.core.next.call(null,seq43694);
var G__43696 = cljs.core.first.call(null,seq43694__$1);
var seq43694__$2 = cljs.core.next.call(null,seq43694__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43695,G__43696,seq43694__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__43702 = arguments.length;
switch (G__43702) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46194 = arguments.length;
var i__6921__auto___46195 = (0);
while(true){
if((i__6921__auto___46195 < len__6920__auto___46194)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46195]));

var G__46196 = (i__6921__auto___46195 + (1));
i__6921__auto___46195 = G__46196;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq43699){
var G__43700 = cljs.core.first.call(null,seq43699);
var seq43699__$1 = cljs.core.next.call(null,seq43699);
var G__43701 = cljs.core.first.call(null,seq43699__$1);
var seq43699__$2 = cljs.core.next.call(null,seq43699__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43700,G__43701,seq43699__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod.call(null,x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__43707 = arguments.length;
switch (G__43707) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46198 = arguments.length;
var i__6921__auto___46199 = (0);
while(true){
if((i__6921__auto___46199 < len__6920__auto___46198)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46199]));

var G__46200 = (i__6921__auto___46199 + (1));
i__6921__auto___46199 = G__46200;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq43704){
var G__43705 = cljs.core.first.call(null,seq43704);
var seq43704__$1 = cljs.core.next.call(null,seq43704);
var G__43706 = cljs.core.first.call(null,seq43704__$1);
var seq43704__$2 = cljs.core.next.call(null,seq43704__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43705,G__43706,seq43704__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__43712 = arguments.length;
switch (G__43712) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46202 = arguments.length;
var i__6921__auto___46203 = (0);
while(true){
if((i__6921__auto___46203 < len__6920__auto___46202)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46203]));

var G__46204 = (i__6921__auto___46203 + (1));
i__6921__auto___46203 = G__46204;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq43709){
var G__43710 = cljs.core.first.call(null,seq43709);
var seq43709__$1 = cljs.core.next.call(null,seq43709);
var G__43711 = cljs.core.first.call(null,seq43709__$1);
var seq43709__$2 = cljs.core.next.call(null,seq43709__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43710,G__43711,seq43709__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix.call(null,x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix.call(null,x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix.call(null,x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix.call(null,((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot.call(null,n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__43717 = arguments.length;
switch (G__43717) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46210 = arguments.length;
var i__6921__auto___46211 = (0);
while(true){
if((i__6921__auto___46211 < len__6920__auto___46210)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46211]));

var G__46212 = (i__6921__auto___46211 + (1));
i__6921__auto___46211 = G__46212;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function (seq43714){
var G__43715 = cljs.core.first.call(null,seq43714);
var seq43714__$1 = cljs.core.next.call(null,seq43714);
var G__43716 = cljs.core.first.call(null,seq43714__$1);
var seq43714__$2 = cljs.core.next.call(null,seq43714__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43715,G__43716,seq43714__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__43722 = arguments.length;
switch (G__43722) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46216 = arguments.length;
var i__6921__auto___46217 = (0);
while(true){
if((i__6921__auto___46217 < len__6920__auto___46216)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46217]));

var G__46219 = (i__6921__auto___46217 + (1));
i__6921__auto___46217 = G__46219;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function (seq43719){
var G__43720 = cljs.core.first.call(null,seq43719);
var seq43719__$1 = cljs.core.next.call(null,seq43719);
var G__43721 = cljs.core.first.call(null,seq43719__$1);
var seq43719__$2 = cljs.core.next.call(null,seq43719__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43720,G__43721,seq43719__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__43727 = arguments.length;
switch (G__43727) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46221 = arguments.length;
var i__6921__auto___46222 = (0);
while(true){
if((i__6921__auto___46222 < len__6920__auto___46221)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46222]));

var G__46223 = (i__6921__auto___46222 + (1));
i__6921__auto___46222 = G__46223;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function (seq43724){
var G__43725 = cljs.core.first.call(null,seq43724);
var seq43724__$1 = cljs.core.next.call(null,seq43724);
var G__43726 = cljs.core.first.call(null,seq43724__$1);
var seq43724__$2 = cljs.core.next.call(null,seq43724__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43725,G__43726,seq43724__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__43732 = arguments.length;
switch (G__43732) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46225 = arguments.length;
var i__6921__auto___46226 = (0);
while(true){
if((i__6921__auto___46226 < len__6920__auto___46225)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46226]));

var G__46229 = (i__6921__auto___46226 + (1));
i__6921__auto___46226 = G__46229;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.call(null,cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq43729){
var G__43730 = cljs.core.first.call(null,seq43729);
var seq43729__$1 = cljs.core.next.call(null,seq43729);
var G__43731 = cljs.core.first.call(null,seq43729__$1);
var seq43729__$2 = cljs.core.next.call(null,seq43729__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43730,G__43731,seq43729__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__43737 = arguments.length;
switch (G__43737) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46255 = arguments.length;
var i__6921__auto___46256 = (0);
while(true){
if((i__6921__auto___46256 < len__6920__auto___46255)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46256]));

var G__46257 = (i__6921__auto___46256 + (1));
i__6921__auto___46256 = G__46257;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv.call(null,x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next.call(null,more)){
var G__46260 = y;
var G__46261 = cljs.core.first.call(null,more);
var G__46262 = cljs.core.next.call(null,more);
x = G__46260;
y = G__46261;
more = G__46262;
continue;
} else {
return (y === cljs.core.first.call(null,more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq43734){
var G__43735 = cljs.core.first.call(null,seq43734);
var seq43734__$1 = cljs.core.next.call(null,seq43734);
var G__43736 = cljs.core.first.call(null,seq43734__$1);
var seq43734__$2 = cljs.core.next.call(null,seq43734__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43735,G__43736,seq43734__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq.call(null,coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__46265 = (n__$1 - (1));
var G__46266 = cljs.core.next.call(null,xs);
n__$1 = G__46265;
xs = G__46266;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__43741 = arguments.length;
switch (G__43741) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46270 = arguments.length;
var i__6921__auto___46271 = (0);
while(true){
if((i__6921__auto___46271 < len__6920__auto___46270)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46271]));

var G__46272 = (i__6921__auto___46271 + (1));
i__6921__auto___46271 = G__46272;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6950__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__46275 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,more)));
var G__46276 = cljs.core.next.call(null,more);
sb = G__46275;
more = G__46276;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function (seq43739){
var G__43740 = cljs.core.first.call(null,seq43739);
var seq43739__$1 = cljs.core.next.call(null,seq43739);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43740,seq43739__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__43743 = arguments.length;
switch (G__43743) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$.call(null,((cljs.core.sequential_QMARK_.call(null,y))?((((cljs.core.counted_QMARK_.call(null,x)) && (cljs.core.counted_QMARK_.call(null,y)) && ((!((cljs.core.count.call(null,x) === cljs.core.count.call(null,y)))))))?false:(function (){var xs = cljs.core.seq.call(null,x);
var ys = cljs.core.seq.call(null,y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,xs),cljs.core.first.call(null,ys))){
var G__46282 = cljs.core.next.call(null,xs);
var G__46283 = cljs.core.next.call(null,ys);
xs = G__46282;
ys = G__46283;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq.call(null,coll)){
var res = cljs.core.hash.call(null,cljs.core.first.call(null,coll));
var s = cljs.core.next.call(null,coll);
while(true){
if((s == null)){
return res;
} else {
var G__46284 = cljs.core.hash_combine.call(null,res,cljs.core.hash.call(null,cljs.core.first.call(null,s)));
var G__46285 = cljs.core.next.call(null,s);
res = G__46284;
s = G__46285;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq.call(null,m);
while(true){
if(s){
var e = cljs.core.first.call(null,s);
var G__46286 = ((h + (cljs.core.hash.call(null,cljs.core.key.call(null,e)) ^ cljs.core.hash.call(null,cljs.core.val.call(null,e)))) % (4503599627370496));
var G__46287 = cljs.core.next.call(null,s);
h = G__46286;
s = G__46287;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq.call(null,s);
while(true){
if(s__$1){
var e = cljs.core.first.call(null,s__$1);
var G__46288 = ((h + cljs.core.hash.call(null,e)) % (4503599627370496));
var G__46289 = cljs.core.next.call(null,s__$1);
h = G__46288;
s__$1 = G__46289;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__43744_46290 = cljs.core.seq.call(null,fn_map);
var chunk__43745_46291 = null;
var count__43746_46292 = (0);
var i__43747_46293 = (0);
while(true){
if((i__43747_46293 < count__43746_46292)){
var vec__43754_46294 = cljs.core._nth.call(null,chunk__43745_46291,i__43747_46293);
var key_name_46295 = cljs.core.nth.call(null,vec__43754_46294,(0),null);
var f_46296 = cljs.core.nth.call(null,vec__43754_46294,(1),null);
var str_name_46297 = cljs.core.name.call(null,key_name_46295);
goog.object.set(obj,str_name_46297,f_46296);


var G__46298 = seq__43744_46290;
var G__46299 = chunk__43745_46291;
var G__46300 = count__43746_46292;
var G__46301 = (i__43747_46293 + (1));
seq__43744_46290 = G__46298;
chunk__43745_46291 = G__46299;
count__43746_46292 = G__46300;
i__43747_46293 = G__46301;
continue;
} else {
var temp__5720__auto___46302 = cljs.core.seq.call(null,seq__43744_46290);
if(temp__5720__auto___46302){
var seq__43744_46303__$1 = temp__5720__auto___46302;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43744_46303__$1)){
var c__6568__auto___46304 = cljs.core.chunk_first.call(null,seq__43744_46303__$1);
var G__46305 = cljs.core.chunk_rest.call(null,seq__43744_46303__$1);
var G__46306 = c__6568__auto___46304;
var G__46307 = cljs.core.count.call(null,c__6568__auto___46304);
var G__46308 = (0);
seq__43744_46290 = G__46305;
chunk__43745_46291 = G__46306;
count__43746_46292 = G__46307;
i__43747_46293 = G__46308;
continue;
} else {
var vec__43757_46309 = cljs.core.first.call(null,seq__43744_46303__$1);
var key_name_46310 = cljs.core.nth.call(null,vec__43757_46309,(0),null);
var f_46311 = cljs.core.nth.call(null,vec__43757_46309,(1),null);
var str_name_46312 = cljs.core.name.call(null,key_name_46310);
goog.object.set(obj,str_name_46312,f_46311);


var G__46313 = cljs.core.next.call(null,seq__43744_46303__$1);
var G__46314 = null;
var G__46315 = (0);
var G__46316 = (0);
seq__43744_46290 = G__46313;
chunk__43745_46291 = G__46314;
count__43746_46292 = G__46315;
i__43747_46293 = G__46316;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var G__46320 = null;
var G__46320__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__46320__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__46320 = function(x,start){
switch(arguments.length){
case 1:
return G__46320__1.call(this,x);
case 2:
return G__46320__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46320.cljs$core$IFn$_invoke$arity$1 = G__46320__1;
G__46320.cljs$core$IFn$_invoke$arity$2 = G__46320__2;
return G__46320;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var G__46321 = null;
var G__46321__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,self__.count);
});
var G__46321__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__46321 = function(x,start){
switch(arguments.length){
case 1:
return G__46321__1.call(this,x);
case 2:
return G__46321__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46321.cljs$core$IFn$_invoke$arity$1 = G__46321__1;
G__46321.cljs$core$IFn$_invoke$arity$2 = G__46321__2;
return G__46321;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest.call(null,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IList,x);
}
});
goog.object.set(cljs.core.List.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var G__46332 = null;
var G__46332__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__46332__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__46332 = function(x,start){
switch(arguments.length){
case 1:
return G__46332__1.call(this,x);
case 2:
return G__46332__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46332.cljs$core$IFn$_invoke$arity$1 = G__46332__1;
G__46332.cljs$core$IFn$_invoke$arity$2 = G__46332__2;
return G__46332;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__46333 = null;
var G__46333__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__46333__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__46333 = function(x,start){
switch(arguments.length){
case 1:
return G__46333__1.call(this,x);
case 2:
return G__46333__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46333.cljs$core$IFn$_invoke$arity$1 = G__46333__1;
G__46333.cljs$core$IFn$_invoke$arity$2 = G__46333__2;
return G__46333;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_.call(null,other)) || (cljs.core.sequential_QMARK_.call(null,other)))){
return (cljs.core.seq.call(null,other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
goog.object.set(cljs.core.EmptyList.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq.call(null,rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_.call(null,coll)){
var or__5598__auto__ = cljs.core.rseq.call(null,coll);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.call(null,cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__6930__auto__ = [];
var len__6920__auto___46337 = arguments.length;
var i__6921__auto___46338 = (0);
while(true){
if((i__6921__auto___46338 < len__6920__auto___46337)){
args__6930__auto__.push((arguments[i__6921__auto___46338]));

var G__46339 = (i__6921__auto___46338 + (1));
i__6921__auto___46338 = G__46339;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first.call(null,xs__$1));

var G__46341 = cljs.core._next.call(null,xs__$1);
xs__$1 = G__46341;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__46342 = (i - (1));
var G__46343 = cljs.core._conj.call(null,r,(arr[(i - (1))]));
i = G__46342;
r = G__46343;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function (seq43762){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq43762));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var G__46344 = null;
var G__46344__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__46344__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__46344 = function(x,start){
switch(arguments.length){
case 1:
return G__46344__1.call(this,x);
case 2:
return G__46344__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46344.cljs$core$IFn$_invoke$arity$1 = G__46344__1;
G__46344.cljs$core$IFn$_invoke$arity$2 = G__46344__2;
return G__46344;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__46345 = null;
var G__46345__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__46345__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__46345 = function(x,start){
switch(arguments.length){
case 1:
return G__46345__1.call(this,x);
case 2:
return G__46345__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46345.cljs$core$IFn$_invoke$arity$1 = G__46345__1;
G__46345.cljs$core$IFn$_invoke$arity$2 = G__46345__2;
return G__46345;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq.call(null,self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

goog.object.set(cljs.core.Cons.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq.call(null,coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol.call(null,k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_(((cljs.core.not.call(null,a.ns))?b.ns:false))){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not.call(null,b.ns)){
return (1);
} else {
var nsc = goog.array.defaultCompare(a.ns,b.ns);
if(((0) === nsc)){
return goog.array.defaultCompare(a.name,b.name);
} else {
return nsc;
}
}
} else {
return goog.array.defaultCompare(a.name,b.name);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var G__46354 = null;
var G__46354__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.call(null,coll,kw);
});
var G__46354__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.call(null,coll,kw,not_found);
});
G__46354 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__46354__2.call(this,self__,coll);
case 3:
return G__46354__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__46354.cljs$core$IFn$_invoke$arity$2 = G__46354__2;
G__46354.cljs$core$IFn$_invoke$arity$3 = G__46354__3;
return G__46354;
})()
);

(cljs.core.Keyword.prototype.apply = (function (self__,args43764){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args43764)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.call(null,coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.call(null,coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__6060__auto__ = self__._hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_keyword.call(null,this$__$1);
(self__._hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write.call(null,writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return cljs.core._namespace.call(null,x);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_.call(null,x)) && ((cljs.core.namespace.call(null,x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$.call(null,((cljs.core.ident_QMARK_.call(null,x))?(function (){var and__5583__auto__ = cljs.core.namespace.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
return true;
} else {
return and__5583__auto__;
}
})():false));
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace.call(null,x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$.call(null,(((x instanceof cljs.core.Symbol))?(function (){var and__5583__auto__ = cljs.core.namespace.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
return true;
} else {
return and__5583__auto__;
}
})():false));
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace.call(null,x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$.call(null,(((x instanceof cljs.core.Keyword))?(function (){var and__5583__auto__ = cljs.core.namespace.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
return true;
} else {
return and__5583__auto__;
}
})():false));
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__43767 = arguments.length;
switch (G__43767) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace.call(null,name),cljs.core.name.call(null,name),name.str,null));
} else {
if(cljs.core._EQ_.call(null,"/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name.call(null,ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name.call(null,ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name.call(null,name):(((name instanceof cljs.core.Symbol))?cljs.core.name.call(null,name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = self__.fn.call(null));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var G__46361 = null;
var G__46361__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__46361__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__46361 = function(x,start){
switch(arguments.length){
case 1:
return G__46361__1.call(this,x);
case 2:
return G__46361__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46361.cljs$core$IFn$_invoke$arity$1 = G__46361__1;
G__46361.cljs$core$IFn$_invoke$arity$2 = G__46361__2;
return G__46361;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__46362 = null;
var G__46362__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__46362__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__46362 = function(x,start){
switch(arguments.length){
case 1:
return G__46362__1.call(this,x);
case 2:
return G__46362__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46362.cljs$core$IFn$_invoke$arity$1 = G__46362__1;
G__46362.cljs$core$IFn$_invoke$arity$2 = G__46362__2;
return G__46362;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq.call(null,coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next.call(null,self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not.call(null,self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq.call(null,coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first.call(null,self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq.call(null,coll__$1);

if((!((self__.s == null)))){
return cljs.core.rest.call(null,self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__46366 = ls.sval();
ls = G__46366;
continue;
} else {
(self__.s = ls);

return cljs.core.seq.call(null,self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function (){
return cljs.core._seq.call(null,coll__$1);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

goog.object.set(cljs.core.LazySeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.call(null,self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.call(null,self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__43769 = arguments.length;
switch (G__43769) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__46387 = null;
var G__46387__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__46387__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__46387 = function(x,start){
switch(arguments.length){
case 1:
return G__46387__1.call(this,x);
case 2:
return G__46387__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46387.cljs$core$IFn$_invoke$arity$1 = G__46387__1;
G__46387.cljs$core$IFn$_invoke$arity$2 = G__46387__2;
return G__46387;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__46388 = null;
var G__46388__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__46388__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__46388 = function(x,start){
switch(arguments.length){
case 1:
return G__46388__1.call(this,x);
case 2:
return G__46388__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46388.cljs$core$IFn$_invoke$arity$1 = G__46388__1;
G__46388.cljs$core$IFn$_invoke$arity$2 = G__46388__2;
return G__46388;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count.call(null,self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first.call(null,self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq.call(null,self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.call(null,self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count.call(null,self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first.call(null,self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

goog.object.set(cljs.core.ChunkedCons.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count.call(null,chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first.call(null,s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest.call(null,s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return cljs.core._chunked_next.call(null,s);
} else {
return cljs.core.seq.call(null,cljs.core._chunked_rest.call(null,s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq.call(null,coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first.call(null,s));

var G__46393 = cljs.core.next.call(null,s);
s = G__46393;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count.call(null,coll)));
var i_46394 = (0);
var xs_46395 = cljs.core.seq.call(null,coll);
while(true){
if((xs_46395 == null)){
} else {
(ret[i_46394] = cljs.core.to_array.call(null,cljs.core.first.call(null,xs_46395)));

var G__46396 = (i_46394 + (1));
var G__46397 = cljs.core.next.call(null,xs_46395);
i_46394 = G__46396;
xs_46395 = G__46397;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__43772 = arguments.length;
switch (G__43772) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.call(null,size_or_seq,null);
} else {
return cljs.core.into_array.call(null,size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq)){
var s = cljs.core.seq.call(null,init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first.call(null,s__$1));

var G__46399 = (i + (1));
var G__46400 = cljs.core.next.call(null,s__$1);
i = G__46399;
s__$1 = G__46400;
continue;
} else {
return a;
}
break;
}
} else {
var n__6679__auto___46401 = size;
var i_46402 = (0);
while(true){
if((i_46402 < n__6679__auto___46401)){
(a[i_46402] = init_val_or_seq);

var G__46403 = (i_46402 + (1));
i_46402 = G__46403;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__43774 = arguments.length;
switch (G__43774) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.call(null,size_or_seq,null);
} else {
return cljs.core.into_array.call(null,size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq)){
var s = cljs.core.seq.call(null,init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first.call(null,s__$1));

var G__46405 = (i + (1));
var G__46406 = cljs.core.next.call(null,s__$1);
i = G__46405;
s__$1 = G__46406;
continue;
} else {
return a;
}
break;
}
} else {
var n__6679__auto___46407 = size;
var i_46408 = (0);
while(true){
if((i_46408 < n__6679__auto___46407)){
(a[i_46408] = init_val_or_seq);

var G__46409 = (i_46408 + (1));
i_46408 = G__46409;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__43776 = arguments.length;
switch (G__43776) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.call(null,size_or_seq,null);
} else {
return cljs.core.into_array.call(null,size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq)){
var s = cljs.core.seq.call(null,init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first.call(null,s__$1));

var G__46411 = (i + (1));
var G__46412 = cljs.core.next.call(null,s__$1);
i = G__46411;
s__$1 = G__46412;
continue;
} else {
return a;
}
break;
}
} else {
var n__6679__auto___46413 = size;
var i_46414 = (0);
while(true){
if((i_46414 < n__6679__auto___46413)){
(a[i_46414] = init_val_or_seq);

var G__46415 = (i_46414 + (1));
i_46414 = G__46415;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__43778 = arguments.length;
switch (G__43778) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.call(null,size_or_seq,null);
} else {
return cljs.core.into_array.call(null,size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq)){
var s = cljs.core.seq.call(null,init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first.call(null,s__$1));

var G__46417 = (i + (1));
var G__46418 = cljs.core.next.call(null,s__$1);
i = G__46417;
s__$1 = G__46418;
continue;
} else {
return a;
}
break;
}
} else {
var n__6679__auto___46419 = size;
var i_46420 = (0);
while(true){
if((i_46420 < n__6679__auto___46419)){
(a[i_46420] = init_val_or_seq);

var G__46421 = (i_46420 + (1));
i_46420 = G__46421;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_.call(null,coll)){
return cljs.core.count.call(null,coll);
} else {
var i = (0);
var s = cljs.core.seq.call(null,coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__46422 = (i + (1));
var G__46423 = cljs.core.next.call(null,s);
i = G__46422;
s = G__46423;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next.call(null,arglist);
if((n == null)){
return cljs.core.seq.call(null,cljs.core.first.call(null,arglist));
} else {
return cljs.core.cons.call(null,cljs.core.first.call(null,arglist),cljs.core.spread.call(null,n));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__43783 = arguments.length;
switch (G__43783) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46425 = arguments.length;
var i__6921__auto___46426 = (0);
while(true){
if((i__6921__auto___46426 < len__6920__auto___46425)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46426]));

var G__46427 = (i__6921__auto___46426 + (1));
i__6921__auto___46426 = G__46427;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq.call(null,x);
if(s){
if(cljs.core.chunked_seq_QMARK_.call(null,s)){
return cljs.core.chunk_cons.call(null,cljs.core.chunk_first.call(null,s),cljs.core.concat.call(null,cljs.core.chunk_rest.call(null,s),y));
} else {
return cljs.core.cons.call(null,cljs.core.first.call(null,s),cljs.core.concat.call(null,cljs.core.rest.call(null,s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq.call(null,xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_.call(null,xys__$1)){
return cljs.core.chunk_cons.call(null,cljs.core.chunk_first.call(null,xys__$1),cljs$core$cat.call(null,cljs.core.chunk_rest.call(null,xys__$1),zs__$1));
} else {
return cljs.core.cons.call(null,cljs.core.first.call(null,xys__$1),cljs$core$cat.call(null,cljs.core.rest.call(null,xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat.call(null,cljs.core.first.call(null,zs__$1),cljs.core.next.call(null,zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat.call(null,cljs.core.concat.call(null,x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function (seq43780){
var G__43781 = cljs.core.first.call(null,seq43780);
var seq43780__$1 = cljs.core.next.call(null,seq43780);
var G__43782 = cljs.core.first.call(null,seq43780__$1);
var seq43780__$2 = cljs.core.next.call(null,seq43780__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43781,G__43782,seq43780__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__43790 = arguments.length;
switch (G__43790) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46432 = arguments.length;
var i__6921__auto___46433 = (0);
while(true){
if((i__6921__auto___46433 < len__6920__auto___46432)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46433]));

var G__46434 = (i__6921__auto___46433 + (1));
i__6921__auto___46433 = G__46434;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__6950__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq.call(null,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons.call(null,a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,cljs.core.cons.call(null,c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,cljs.core.cons.call(null,c,cljs.core.cons.call(null,d,cljs.core.spread.call(null,more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq43785){
var G__43786 = cljs.core.first.call(null,seq43785);
var seq43785__$1 = cljs.core.next.call(null,seq43785);
var G__43787 = cljs.core.first.call(null,seq43785__$1);
var seq43785__$2 = cljs.core.next.call(null,seq43785__$1);
var G__43788 = cljs.core.first.call(null,seq43785__$2);
var seq43785__$3 = cljs.core.next.call(null,seq43785__$2);
var G__43789 = cljs.core.first.call(null,seq43785__$3);
var seq43785__$4 = cljs.core.next.call(null,seq43785__$3);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43786,G__43787,G__43788,G__43789,seq43785__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient.call(null,coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_.call(null,tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__43795 = arguments.length;
switch (G__43795) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46439 = arguments.length;
var i__6921__auto___46440 = (0);
while(true){
if((i__6921__auto___46440 < len__6920__auto___46439)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46440]));

var G__46441 = (i__6921__auto___46440 + (1));
i__6921__auto___46440 = G__46441;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_.call(null,tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_.call(null,tcoll,val);
if(cljs.core.truth_(vals)){
var G__46442 = ntcoll;
var G__46443 = cljs.core.first.call(null,vals);
var G__46444 = cljs.core.next.call(null,vals);
tcoll = G__46442;
val = G__46443;
vals = G__46444;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq43792){
var G__43793 = cljs.core.first.call(null,seq43792);
var seq43792__$1 = cljs.core.next.call(null,seq43792);
var G__43794 = cljs.core.first.call(null,seq43792__$1);
var seq43792__$2 = cljs.core.next.call(null,seq43792__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43793,G__43794,seq43792__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__43801 = arguments.length;
switch (G__43801) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46446 = arguments.length;
var i__6921__auto___46447 = (0);
while(true){
if((i__6921__auto___46447 < len__6920__auto___46446)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46447]));

var G__46448 = (i__6921__auto___46447 + (1));
i__6921__auto___46447 = G__46448;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_.call(null,tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_.call(null,tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__46449 = ntcoll;
var G__46450 = cljs.core.first.call(null,kvs);
var G__46451 = cljs.core.second.call(null,kvs);
var G__46452 = cljs.core.nnext.call(null,kvs);
tcoll = G__46449;
key = G__46450;
val = G__46451;
kvs = G__46452;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq43797){
var G__43798 = cljs.core.first.call(null,seq43797);
var seq43797__$1 = cljs.core.next.call(null,seq43797);
var G__43799 = cljs.core.first.call(null,seq43797__$1);
var seq43797__$2 = cljs.core.next.call(null,seq43797__$1);
var G__43800 = cljs.core.first.call(null,seq43797__$2);
var seq43797__$3 = cljs.core.next.call(null,seq43797__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43798,G__43799,G__43800,seq43797__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__43806 = arguments.length;
switch (G__43806) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46457 = arguments.length;
var i__6921__auto___46458 = (0);
while(true){
if((i__6921__auto___46458 < len__6920__auto___46457)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46458]));

var G__46459 = (i__6921__auto___46458 + (1));
i__6921__auto___46458 = G__46459;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_.call(null,tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_.call(null,tcoll,key);
if(cljs.core.truth_(ks)){
var G__46460 = ntcoll;
var G__46461 = cljs.core.first.call(null,ks);
var G__46462 = cljs.core.next.call(null,ks);
tcoll = G__46460;
key = G__46461;
ks = G__46462;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq43803){
var G__43804 = cljs.core.first.call(null,seq43803);
var seq43803__$1 = cljs.core.next.call(null,seq43803);
var G__43805 = cljs.core.first.call(null,seq43803__$1);
var seq43803__$2 = cljs.core.next.call(null,seq43803__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43804,G__43805,seq43803__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_.call(null,tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__43811 = arguments.length;
switch (G__43811) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46464 = arguments.length;
var i__6921__auto___46468 = (0);
while(true){
if((i__6921__auto___46468 < len__6920__auto___46464)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46468]));

var G__46469 = (i__6921__auto___46468 + (1));
i__6921__auto___46468 = G__46469;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_.call(null,tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_.call(null,tcoll,val);
if(cljs.core.truth_(vals)){
var G__46470 = ntcoll;
var G__46471 = cljs.core.first.call(null,vals);
var G__46472 = cljs.core.next.call(null,vals);
tcoll = G__46470;
val = G__46471;
vals = G__46472;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq43808){
var G__43809 = cljs.core.first.call(null,seq43808);
var seq43808__$1 = cljs.core.next.call(null,seq43808);
var G__43810 = cljs.core.first.call(null,seq43808__$1);
var seq43808__$2 = cljs.core.next.call(null,seq43808__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43809,G__43810,seq43808__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq.call(null,args);
if((argc === (0))){
return f.call(null);
} else {
var a6723 = cljs.core._first.call(null,args__$1);
var args__$2 = cljs.core._rest.call(null,args__$1);
if((argc === (1))){
return f.call(null,a6723);
} else {
var b6724 = cljs.core._first.call(null,args__$2);
var args__$3 = cljs.core._rest.call(null,args__$2);
if((argc === (2))){
return f.call(null,a6723,b6724);
} else {
var c6725 = cljs.core._first.call(null,args__$3);
var args__$4 = cljs.core._rest.call(null,args__$3);
if((argc === (3))){
return f.call(null,a6723,b6724,c6725);
} else {
var d6726 = cljs.core._first.call(null,args__$4);
var args__$5 = cljs.core._rest.call(null,args__$4);
if((argc === (4))){
return f.call(null,a6723,b6724,c6725,d6726);
} else {
var e6727 = cljs.core._first.call(null,args__$5);
var args__$6 = cljs.core._rest.call(null,args__$5);
if((argc === (5))){
return f.call(null,a6723,b6724,c6725,d6726,e6727);
} else {
var f6728 = cljs.core._first.call(null,args__$6);
var args__$7 = cljs.core._rest.call(null,args__$6);
if((argc === (6))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728);
} else {
var g6729 = cljs.core._first.call(null,args__$7);
var args__$8 = cljs.core._rest.call(null,args__$7);
if((argc === (7))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729);
} else {
var h6730 = cljs.core._first.call(null,args__$8);
var args__$9 = cljs.core._rest.call(null,args__$8);
if((argc === (8))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730);
} else {
var i6731 = cljs.core._first.call(null,args__$9);
var args__$10 = cljs.core._rest.call(null,args__$9);
if((argc === (9))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731);
} else {
var j6732 = cljs.core._first.call(null,args__$10);
var args__$11 = cljs.core._rest.call(null,args__$10);
if((argc === (10))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732);
} else {
var k6733 = cljs.core._first.call(null,args__$11);
var args__$12 = cljs.core._rest.call(null,args__$11);
if((argc === (11))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733);
} else {
var l6734 = cljs.core._first.call(null,args__$12);
var args__$13 = cljs.core._rest.call(null,args__$12);
if((argc === (12))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734);
} else {
var m6735 = cljs.core._first.call(null,args__$13);
var args__$14 = cljs.core._rest.call(null,args__$13);
if((argc === (13))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735);
} else {
var n6736 = cljs.core._first.call(null,args__$14);
var args__$15 = cljs.core._rest.call(null,args__$14);
if((argc === (14))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736);
} else {
var o6737 = cljs.core._first.call(null,args__$15);
var args__$16 = cljs.core._rest.call(null,args__$15);
if((argc === (15))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736,o6737);
} else {
var p6738 = cljs.core._first.call(null,args__$16);
var args__$17 = cljs.core._rest.call(null,args__$16);
if((argc === (16))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736,o6737,p6738);
} else {
var q6739 = cljs.core._first.call(null,args__$17);
var args__$18 = cljs.core._rest.call(null,args__$17);
if((argc === (17))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736,o6737,p6738,q6739);
} else {
var r6740 = cljs.core._first.call(null,args__$18);
var args__$19 = cljs.core._rest.call(null,args__$18);
if((argc === (18))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736,o6737,p6738,q6739,r6740);
} else {
var s6741 = cljs.core._first.call(null,args__$19);
var args__$20 = cljs.core._rest.call(null,args__$19);
if((argc === (19))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736,o6737,p6738,q6739,r6740,s6741);
} else {
var t6742 = cljs.core._first.call(null,args__$20);
var args__$21 = cljs.core._rest.call(null,args__$20);
if((argc === (20))){
return f.call(null,a6723,b6724,c6725,d6726,e6727,f6728,g6729,h6730,i6731,j6732,k6733,l6734,m6735,n6736,o6737,p6738,q6739,r6740,s6741,t6742);
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return cljs.core._next.call(null,coll);
} else {
return cljs.core.seq.call(null,cljs.core.rest.call(null,coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__43814 = arguments.length;
switch (G__43814) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.call(null,f,cljs.core._first.call(null,args),cljs.core.next_STAR_.call(null,args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function (f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.call(null,f,a0,cljs.core._first.call(null,args),cljs.core.next_STAR_.call(null,args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function (f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.call(null,f,a0,a1,cljs.core._first.call(null,args),cljs.core.next_STAR_.call(null,args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function (f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.call(null,f,a0,a1,a2,cljs.core._first.call(null,args),cljs.core.next_STAR_.call(null,args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function (f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first.call(null,args);
var next_4 = cljs.core.next.call(null,args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first.call(null,next_4);
var next_5 = cljs.core.next.call(null,next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first.call(null,next_5);
var next_6 = cljs.core.next.call(null,next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first.call(null,next_6);
var next_7 = cljs.core.next.call(null,next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first.call(null,next_7);
var next_8 = cljs.core.next.call(null,next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first.call(null,next_8);
var next_9 = cljs.core.next.call(null,next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first.call(null,next_9);
var next_10 = cljs.core.next.call(null,next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first.call(null,next_10);
var next_11 = cljs.core.next.call(null,next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first.call(null,next_11);
var next_12 = cljs.core.next.call(null,next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first.call(null,next_12);
var next_13 = cljs.core.next.call(null,next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first.call(null,next_13);
var next_14 = cljs.core.next.call(null,next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first.call(null,next_14);
var next_15 = cljs.core.next.call(null,next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first.call(null,next_15);
var next_16 = cljs.core.next.call(null,next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first.call(null,next_16);
var next_17 = cljs.core.next.call(null,next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first.call(null,next_17);
var next_18 = cljs.core.next.call(null,next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first.call(null,next_18);
var next_19 = cljs.core.next.call(null,next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__6751__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__6752__auto___46523 = next_19;
while(true){
if(s__6752__auto___46523){
arr__6751__auto__.push(cljs.core._first.call(null,s__6752__auto___46523));

var G__46524 = cljs.core.next.call(null,s__6752__auto___46523);
s__6752__auto___46523 = G__46524;
continue;
} else {
}
break;
}

return f.apply(f,arr__6751__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__43822 = arguments.length;
switch (G__43822) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46529 = arguments.length;
var i__6921__auto___46530 = (0);
while(true){
if((i__6921__auto___46530 < len__6920__auto___46529)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46530]));

var G__46531 = (i__6921__auto___46530 + (1));
i__6921__auto___46530 = G__46531;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__6950__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count.call(null,(fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to.call(null,f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.call(null,f,cljs.core.seq.call(null,args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.call(null,x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count.call(null,fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to.call(null,f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.call(null,f,x,cljs.core.seq.call(null,args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.call(null,x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count.call(null,(fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to.call(null,f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.call(null,f,x,y,cljs.core.seq.call(null,args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.call(null,x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count.call(null,(fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to.call(null,f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.call(null,f,x,y,z,cljs.core.seq.call(null,args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread.call(null,args);
var arglist = cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,cljs.core.cons.call(null,c,cljs.core.cons.call(null,d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count.call(null,(fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to.call(null,f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.call(null,f,a,b,c,d,cljs.core.spread.call(null,args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function (seq43816){
var G__43817 = cljs.core.first.call(null,seq43816);
var seq43816__$1 = cljs.core.next.call(null,seq43816);
var G__43818 = cljs.core.first.call(null,seq43816__$1);
var seq43816__$2 = cljs.core.next.call(null,seq43816__$1);
var G__43819 = cljs.core.first.call(null,seq43816__$2);
var seq43816__$3 = cljs.core.next.call(null,seq43816__$2);
var G__43820 = cljs.core.first.call(null,seq43816__$3);
var seq43816__$4 = cljs.core.next.call(null,seq43816__$3);
var G__43821 = cljs.core.first.call(null,seq43816__$4);
var seq43816__$5 = cljs.core.next.call(null,seq43816__$4);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43817,G__43818,G__43819,G__43820,G__43821,seq43816__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__43831 = arguments.length;
switch (G__43831) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46548 = arguments.length;
var i__6921__auto___46549 = (0);
while(true){
if((i__6921__auto___46549 < len__6920__auto___46548)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46549]));

var G__46550 = (i__6921__auto___46549 + (1));
i__6921__auto___46549 = G__46550;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__6950__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta.call(null,obj,f.call(null,cljs.core.meta.call(null,obj)));
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta.call(null,obj,f.call(null,cljs.core.meta.call(null,obj),a));
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta.call(null,obj,f.call(null,cljs.core.meta.call(null,obj),a,b));
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta.call(null,obj,f.call(null,cljs.core.meta.call(null,obj),a,b,c));
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta.call(null,obj,f.call(null,cljs.core.meta.call(null,obj),a,b,c,d));
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta.call(null,obj,cljs.core.apply.call(null,f,cljs.core.meta.call(null,obj),a,b,c,d,args));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function (seq43824){
var G__43825 = cljs.core.first.call(null,seq43824);
var seq43824__$1 = cljs.core.next.call(null,seq43824);
var G__43826 = cljs.core.first.call(null,seq43824__$1);
var seq43824__$2 = cljs.core.next.call(null,seq43824__$1);
var G__43827 = cljs.core.first.call(null,seq43824__$2);
var seq43824__$3 = cljs.core.next.call(null,seq43824__$2);
var G__43828 = cljs.core.first.call(null,seq43824__$3);
var seq43824__$4 = cljs.core.next.call(null,seq43824__$3);
var G__43829 = cljs.core.first.call(null,seq43824__$4);
var seq43824__$5 = cljs.core.next.call(null,seq43824__$4);
var G__43830 = cljs.core.first.call(null,seq43824__$5);
var seq43824__$6 = cljs.core.next.call(null,seq43824__$5);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43825,G__43826,G__43827,G__43828,G__43829,G__43830,seq43824__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__43836 = arguments.length;
switch (G__43836) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46561 = arguments.length;
var i__6921__auto___46562 = (0);
while(true){
if((i__6921__auto___46562 < len__6920__auto___46561)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46562]));

var G__46563 = (i__6921__auto___46562 + (1));
i__6921__auto___46562 = G__46563;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.call(null,x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not.call(null,cljs.core.apply.call(null,cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq43833){
var G__43834 = cljs.core.first.call(null,seq43833);
var seq43833__$1 = cljs.core.next.call(null,seq43833);
var G__43835 = cljs.core.first.call(null,seq43833__$1);
var seq43833__$2 = cljs.core.next.call(null,seq43833__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43834,G__43835,seq43833__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq.call(null,coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core43837 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core43837 = (function (meta43838){
this.meta43838 = meta43838;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core43837.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43839,meta43838__$1){
var self__ = this;
var _43839__$1 = this;
return (new cljs.core.t_cljs$core43837(meta43838__$1));
}));

(cljs.core.t_cljs$core43837.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43839){
var self__ = this;
var _43839__$1 = this;
return self__.meta43838;
}));

(cljs.core.t_cljs$core43837.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core43837.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core43837.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core43837.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta43838","meta43838",-1077798642,null)], null);
}));

(cljs.core.t_cljs$core43837.cljs$lang$type = true);

(cljs.core.t_cljs$core43837.cljs$lang$ctorStr = "cljs.core/t_cljs$core43837");

(cljs.core.t_cljs$core43837.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/t_cljs$core43837");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core43837.
 */
cljs.core.__GT_t_cljs$core43837 = (function cljs$core$nil_iter_$___GT_t_cljs$core43837(meta43838){
return (new cljs.core.t_cljs$core43837(meta43838));
});

}

return (new cljs.core.t_cljs$core43837(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq.call(null,self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next.call(null,self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first.call(null,self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_.call(null,coll)){
return cljs.core._iterator.call(null,coll);
} else {
if((coll == null)){
return cljs.core.nil_iter.call(null);
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter.call(null,coll);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return cljs.core.array_iter.call(null,coll);
} else {
if(cljs.core.seqable_QMARK_.call(null,coll)){
return cljs.core.seq_iter.call(null,coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function (o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function (){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vals","vals",-1886377036,null)], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function (o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function (){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function (o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function (){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq.call(null,self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first.call(null,iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__46579 = cljs.core.next.call(null,iters__$1);
iters__$1 = G__46579;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var nexts = [];
var n__6679__auto___46580 = self__.iters.length;
var i_46581 = (0);
while(true){
if((i_46581 < n__6679__auto___46580)){
(nexts[i_46581] = (self__.iters[i_46581]).next());

var G__46582 = (i_46581 + (1));
i_46581 = G__46582;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.call(null,nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iters","iters",719353031,null)], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function (){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__5583__auto__ = iter.hasNext();
if(cljs.core.truth_(and__5583__auto__)){
return (n < (32));
} else {
return and__5583__auto__;
}
})())){
(arr[n] = iter.next());

var G__46583 = (n + (1));
n = G__46583;
continue;
} else {
return cljs.core.chunk_cons.call(null,cljs.core.array_chunk.call(null,arr,(0),n),cljs.core.chunkIteratorSeq.call(null,iter));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function (){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.call(null,self__.xf,cljs.core.cons.call(null,null,self__.sourceIter.next())):self__.xf.call(null,null,self__.sourceIter.next()));
if(cljs.core.reduced_QMARK_.call(null,iter)){
self__.xf.call(null,null);

(self__.completed = true);
} else {
}

continue;
} else {
self__.xf.call(null,null);

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",1450238522,null)], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

goog.object.set(cljs.core.TransformerIterator.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = xform.call(null,(function() {
var G__46587 = null;
var G__46587__0 = (function (){
return null;
});
var G__46587__1 = (function (acc){
return acc;
});
var G__46587__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
G__46587 = function(acc,o){
switch(arguments.length){
case 0:
return G__46587__0.call(this);
case 1:
return G__46587__1.call(this,acc);
case 2:
return G__46587__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46587.cljs$core$IFn$_invoke$arity$0 = G__46587__0;
G__46587.cljs$core$IFn$_invoke$arity$1 = G__46587__1;
G__46587.cljs$core$IFn$_invoke$arity$2 = G__46587__2;
return G__46587;
})()
));

return iterator;
});
(cljs.core.TransformerIterator.create = (function (xform,source){
return cljs.core.transformer_iterator.call(null,xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function (xform,sources){
return cljs.core.transformer_iterator.call(null,xform,(new cljs.core.MultiIterator(cljs.core.to_array.call(null,sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__43844 = arguments.length;
switch (G__43844) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46589 = arguments.length;
var i__6921__auto___46590 = (0);
while(true){
if((i__6921__auto___46590 < len__6920__auto___46589)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46590]));

var G__46591 = (i__6921__auto___46590 + (1));
i__6921__auto___46590 = G__46591;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_.call(null,coll)){
return coll;
} else {
var or__5598__auto__ = cljs.core.seq.call(null,coll);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
var or__5598__auto__ = cljs.core.chunkIteratorSeq.call(null,cljs.core.TransformerIterator.create(xform,cljs.core.iter.call(null,coll)));
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
var or__5598__auto__ = cljs.core.chunkIteratorSeq.call(null,cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.call(null,cljs.core.iter,cljs.core.cons.call(null,coll,colls))));
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function (seq43841){
var G__43842 = cljs.core.first.call(null,seq43841);
var seq43841__$1 = cljs.core.next.call(null,seq43841);
var G__43843 = cljs.core.first.call(null,seq43841__$1);
var seq43841__$2 = cljs.core.next.call(null,seq43841__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43842,G__43843,seq43841__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq.call(null,coll) == null)){
return true;
} else {
if(cljs.core.truth_(pred.call(null,cljs.core.first.call(null,coll)))){
var G__46598 = pred;
var G__46599 = cljs.core.next.call(null,coll);
pred = G__46598;
coll = G__46599;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_.call(null,pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var or__5598__auto__ = pred.call(null,cljs.core.first.call(null,s));
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var G__46610 = pred;
var G__46611 = cljs.core.next.call(null,s);
pred = G__46610;
coll = G__46611;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not.call(null,cljs.core.some.call(null,pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_.call(null,n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_.call(null,n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__46612 = null;
var G__46612__0 = (function (){
return cljs.core.not.call(null,f.call(null));
});
var G__46612__1 = (function (x){
return cljs.core.not.call(null,f.call(null,x));
});
var G__46612__2 = (function (x,y){
return cljs.core.not.call(null,f.call(null,x,y));
});
var G__46612__3 = (function() { 
var G__46613__delegate = function (x,y,zs){
return cljs.core.not.call(null,cljs.core.apply.call(null,f,x,y,zs));
};
var G__46613 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__46626__i = 0, G__46626__a = new Array(arguments.length -  2);
while (G__46626__i < G__46626__a.length) {G__46626__a[G__46626__i] = arguments[G__46626__i + 2]; ++G__46626__i;}
  zs = new cljs.core.IndexedSeq(G__46626__a,0,null);
} 
return G__46613__delegate.call(this,x,y,zs);};
G__46613.cljs$lang$maxFixedArity = 2;
G__46613.cljs$lang$applyTo = (function (arglist__46627){
var x = cljs.core.first(arglist__46627);
arglist__46627 = cljs.core.next(arglist__46627);
var y = cljs.core.first(arglist__46627);
var zs = cljs.core.rest(arglist__46627);
return G__46613__delegate(x,y,zs);
});
G__46613.cljs$core$IFn$_invoke$arity$variadic = G__46613__delegate;
return G__46613;
})()
;
G__46612 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__46612__0.call(this);
case 1:
return G__46612__1.call(this,x);
case 2:
return G__46612__2.call(this,x,y);
default:
var G__46628 = null;
if (arguments.length > 2) {
var G__46629__i = 0, G__46629__a = new Array(arguments.length -  2);
while (G__46629__i < G__46629__a.length) {G__46629__a[G__46629__i] = arguments[G__46629__i + 2]; ++G__46629__i;}
G__46628 = new cljs.core.IndexedSeq(G__46629__a,0,null);
}
return G__46612__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__46628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46612.cljs$lang$maxFixedArity = 2;
G__46612.cljs$lang$applyTo = G__46612__3.cljs$lang$applyTo;
G__46612.cljs$core$IFn$_invoke$arity$0 = G__46612__0;
G__46612.cljs$core$IFn$_invoke$arity$1 = G__46612__1;
G__46612.cljs$core$IFn$_invoke$arity$2 = G__46612__2;
G__46612.cljs$core$IFn$_invoke$arity$variadic = G__46612__3.cljs$core$IFn$_invoke$arity$variadic;
return G__46612;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__46630__delegate = function (args){
return x;
};
var G__46630 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__46631__i = 0, G__46631__a = new Array(arguments.length -  0);
while (G__46631__i < G__46631__a.length) {G__46631__a[G__46631__i] = arguments[G__46631__i + 0]; ++G__46631__i;}
  args = new cljs.core.IndexedSeq(G__46631__a,0,null);
} 
return G__46630__delegate.call(this,args);};
G__46630.cljs$lang$maxFixedArity = 0;
G__46630.cljs$lang$applyTo = (function (arglist__46632){
var args = cljs.core.seq(arglist__46632);
return G__46630__delegate(args);
});
G__46630.cljs$core$IFn$_invoke$arity$variadic = G__46630__delegate;
return G__46630;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__43850 = arguments.length;
switch (G__43850) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46634 = arguments.length;
var i__6921__auto___46635 = (0);
while(true){
if((i__6921__auto___46635 < len__6920__auto___46634)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46635]));

var G__46636 = (i__6921__auto___46635 + (1));
i__6921__auto___46635 = G__46636;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__46637 = null;
var G__46637__0 = (function (){
return f.call(null,g.call(null));
});
var G__46637__1 = (function (x){
return f.call(null,g.call(null,x));
});
var G__46637__2 = (function (x,y){
return f.call(null,g.call(null,x,y));
});
var G__46637__3 = (function (x,y,z){
return f.call(null,g.call(null,x,y,z));
});
var G__46637__4 = (function() { 
var G__46638__delegate = function (x,y,z,args){
return f.call(null,cljs.core.apply.call(null,g,x,y,z,args));
};
var G__46638 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46639__i = 0, G__46639__a = new Array(arguments.length -  3);
while (G__46639__i < G__46639__a.length) {G__46639__a[G__46639__i] = arguments[G__46639__i + 3]; ++G__46639__i;}
  args = new cljs.core.IndexedSeq(G__46639__a,0,null);
} 
return G__46638__delegate.call(this,x,y,z,args);};
G__46638.cljs$lang$maxFixedArity = 3;
G__46638.cljs$lang$applyTo = (function (arglist__46640){
var x = cljs.core.first(arglist__46640);
arglist__46640 = cljs.core.next(arglist__46640);
var y = cljs.core.first(arglist__46640);
arglist__46640 = cljs.core.next(arglist__46640);
var z = cljs.core.first(arglist__46640);
var args = cljs.core.rest(arglist__46640);
return G__46638__delegate(x,y,z,args);
});
G__46638.cljs$core$IFn$_invoke$arity$variadic = G__46638__delegate;
return G__46638;
})()
;
G__46637 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__46637__0.call(this);
case 1:
return G__46637__1.call(this,x);
case 2:
return G__46637__2.call(this,x,y);
case 3:
return G__46637__3.call(this,x,y,z);
default:
var G__46641 = null;
if (arguments.length > 3) {
var G__46642__i = 0, G__46642__a = new Array(arguments.length -  3);
while (G__46642__i < G__46642__a.length) {G__46642__a[G__46642__i] = arguments[G__46642__i + 3]; ++G__46642__i;}
G__46641 = new cljs.core.IndexedSeq(G__46642__a,0,null);
}
return G__46637__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46637.cljs$lang$maxFixedArity = 3;
G__46637.cljs$lang$applyTo = G__46637__4.cljs$lang$applyTo;
G__46637.cljs$core$IFn$_invoke$arity$0 = G__46637__0;
G__46637.cljs$core$IFn$_invoke$arity$1 = G__46637__1;
G__46637.cljs$core$IFn$_invoke$arity$2 = G__46637__2;
G__46637.cljs$core$IFn$_invoke$arity$3 = G__46637__3;
G__46637.cljs$core$IFn$_invoke$arity$variadic = G__46637__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46637;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__46643 = null;
var G__46643__0 = (function (){
return f.call(null,g.call(null,h.call(null)));
});
var G__46643__1 = (function (x){
return f.call(null,g.call(null,h.call(null,x)));
});
var G__46643__2 = (function (x,y){
return f.call(null,g.call(null,h.call(null,x,y)));
});
var G__46643__3 = (function (x,y,z){
return f.call(null,g.call(null,h.call(null,x,y,z)));
});
var G__46643__4 = (function() { 
var G__46644__delegate = function (x,y,z,args){
return f.call(null,g.call(null,cljs.core.apply.call(null,h,x,y,z,args)));
};
var G__46644 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46648__i = 0, G__46648__a = new Array(arguments.length -  3);
while (G__46648__i < G__46648__a.length) {G__46648__a[G__46648__i] = arguments[G__46648__i + 3]; ++G__46648__i;}
  args = new cljs.core.IndexedSeq(G__46648__a,0,null);
} 
return G__46644__delegate.call(this,x,y,z,args);};
G__46644.cljs$lang$maxFixedArity = 3;
G__46644.cljs$lang$applyTo = (function (arglist__46649){
var x = cljs.core.first(arglist__46649);
arglist__46649 = cljs.core.next(arglist__46649);
var y = cljs.core.first(arglist__46649);
arglist__46649 = cljs.core.next(arglist__46649);
var z = cljs.core.first(arglist__46649);
var args = cljs.core.rest(arglist__46649);
return G__46644__delegate(x,y,z,args);
});
G__46644.cljs$core$IFn$_invoke$arity$variadic = G__46644__delegate;
return G__46644;
})()
;
G__46643 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__46643__0.call(this);
case 1:
return G__46643__1.call(this,x);
case 2:
return G__46643__2.call(this,x,y);
case 3:
return G__46643__3.call(this,x,y,z);
default:
var G__46650 = null;
if (arguments.length > 3) {
var G__46651__i = 0, G__46651__a = new Array(arguments.length -  3);
while (G__46651__i < G__46651__a.length) {G__46651__a[G__46651__i] = arguments[G__46651__i + 3]; ++G__46651__i;}
G__46650 = new cljs.core.IndexedSeq(G__46651__a,0,null);
}
return G__46643__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46643.cljs$lang$maxFixedArity = 3;
G__46643.cljs$lang$applyTo = G__46643__4.cljs$lang$applyTo;
G__46643.cljs$core$IFn$_invoke$arity$0 = G__46643__0;
G__46643.cljs$core$IFn$_invoke$arity$1 = G__46643__1;
G__46643.cljs$core$IFn$_invoke$arity$2 = G__46643__2;
G__46643.cljs$core$IFn$_invoke$arity$3 = G__46643__3;
G__46643.cljs$core$IFn$_invoke$arity$variadic = G__46643__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46643;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse.call(null,cljs.core.list_STAR_.call(null,f1,f2,f3,fs));
return (function() { 
var G__46652__delegate = function (args){
var ret = cljs.core.apply.call(null,cljs.core.first.call(null,fs__$1),args);
var fs__$2 = cljs.core.next.call(null,fs__$1);
while(true){
if(fs__$2){
var G__46653 = cljs.core.first.call(null,fs__$2).call(null,ret);
var G__46654 = cljs.core.next.call(null,fs__$2);
ret = G__46653;
fs__$2 = G__46654;
continue;
} else {
return ret;
}
break;
}
};
var G__46652 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__46655__i = 0, G__46655__a = new Array(arguments.length -  0);
while (G__46655__i < G__46655__a.length) {G__46655__a[G__46655__i] = arguments[G__46655__i + 0]; ++G__46655__i;}
  args = new cljs.core.IndexedSeq(G__46655__a,0,null);
} 
return G__46652__delegate.call(this,args);};
G__46652.cljs$lang$maxFixedArity = 0;
G__46652.cljs$lang$applyTo = (function (arglist__46656){
var args = cljs.core.seq(arglist__46656);
return G__46652__delegate(args);
});
G__46652.cljs$core$IFn$_invoke$arity$variadic = G__46652__delegate;
return G__46652;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function (seq43846){
var G__43847 = cljs.core.first.call(null,seq43846);
var seq43846__$1 = cljs.core.next.call(null,seq43846);
var G__43848 = cljs.core.first.call(null,seq43846__$1);
var seq43846__$2 = cljs.core.next.call(null,seq43846__$1);
var G__43849 = cljs.core.first.call(null,seq43846__$2);
var seq43846__$3 = cljs.core.next.call(null,seq43846__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43847,G__43848,G__43849,seq43846__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__43857 = arguments.length;
switch (G__43857) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46661 = arguments.length;
var i__6921__auto___46662 = (0);
while(true){
if((i__6921__auto___46662 < len__6920__auto___46661)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46662]));

var G__46663 = (i__6921__auto___46662 + (1));
i__6921__auto___46662 = G__46663;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__6950__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__46664 = null;
var G__46664__0 = (function (){
return f.call(null,arg1);
});
var G__46664__1 = (function (x){
return f.call(null,arg1,x);
});
var G__46664__2 = (function (x,y){
return f.call(null,arg1,x,y);
});
var G__46664__3 = (function (x,y,z){
return f.call(null,arg1,x,y,z);
});
var G__46664__4 = (function() { 
var G__46665__delegate = function (x,y,z,args){
return cljs.core.apply.call(null,f,arg1,x,y,z,args);
};
var G__46665 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46666__i = 0, G__46666__a = new Array(arguments.length -  3);
while (G__46666__i < G__46666__a.length) {G__46666__a[G__46666__i] = arguments[G__46666__i + 3]; ++G__46666__i;}
  args = new cljs.core.IndexedSeq(G__46666__a,0,null);
} 
return G__46665__delegate.call(this,x,y,z,args);};
G__46665.cljs$lang$maxFixedArity = 3;
G__46665.cljs$lang$applyTo = (function (arglist__46667){
var x = cljs.core.first(arglist__46667);
arglist__46667 = cljs.core.next(arglist__46667);
var y = cljs.core.first(arglist__46667);
arglist__46667 = cljs.core.next(arglist__46667);
var z = cljs.core.first(arglist__46667);
var args = cljs.core.rest(arglist__46667);
return G__46665__delegate(x,y,z,args);
});
G__46665.cljs$core$IFn$_invoke$arity$variadic = G__46665__delegate;
return G__46665;
})()
;
G__46664 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__46664__0.call(this);
case 1:
return G__46664__1.call(this,x);
case 2:
return G__46664__2.call(this,x,y);
case 3:
return G__46664__3.call(this,x,y,z);
default:
var G__46671 = null;
if (arguments.length > 3) {
var G__46672__i = 0, G__46672__a = new Array(arguments.length -  3);
while (G__46672__i < G__46672__a.length) {G__46672__a[G__46672__i] = arguments[G__46672__i + 3]; ++G__46672__i;}
G__46671 = new cljs.core.IndexedSeq(G__46672__a,0,null);
}
return G__46664__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46664.cljs$lang$maxFixedArity = 3;
G__46664.cljs$lang$applyTo = G__46664__4.cljs$lang$applyTo;
G__46664.cljs$core$IFn$_invoke$arity$0 = G__46664__0;
G__46664.cljs$core$IFn$_invoke$arity$1 = G__46664__1;
G__46664.cljs$core$IFn$_invoke$arity$2 = G__46664__2;
G__46664.cljs$core$IFn$_invoke$arity$3 = G__46664__3;
G__46664.cljs$core$IFn$_invoke$arity$variadic = G__46664__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46664;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__46673 = null;
var G__46673__0 = (function (){
return f.call(null,arg1,arg2);
});
var G__46673__1 = (function (x){
return f.call(null,arg1,arg2,x);
});
var G__46673__2 = (function (x,y){
return f.call(null,arg1,arg2,x,y);
});
var G__46673__3 = (function (x,y,z){
return f.call(null,arg1,arg2,x,y,z);
});
var G__46673__4 = (function() { 
var G__46674__delegate = function (x,y,z,args){
return cljs.core.apply.call(null,f,arg1,arg2,x,y,z,args);
};
var G__46674 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46675__i = 0, G__46675__a = new Array(arguments.length -  3);
while (G__46675__i < G__46675__a.length) {G__46675__a[G__46675__i] = arguments[G__46675__i + 3]; ++G__46675__i;}
  args = new cljs.core.IndexedSeq(G__46675__a,0,null);
} 
return G__46674__delegate.call(this,x,y,z,args);};
G__46674.cljs$lang$maxFixedArity = 3;
G__46674.cljs$lang$applyTo = (function (arglist__46679){
var x = cljs.core.first(arglist__46679);
arglist__46679 = cljs.core.next(arglist__46679);
var y = cljs.core.first(arglist__46679);
arglist__46679 = cljs.core.next(arglist__46679);
var z = cljs.core.first(arglist__46679);
var args = cljs.core.rest(arglist__46679);
return G__46674__delegate(x,y,z,args);
});
G__46674.cljs$core$IFn$_invoke$arity$variadic = G__46674__delegate;
return G__46674;
})()
;
G__46673 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__46673__0.call(this);
case 1:
return G__46673__1.call(this,x);
case 2:
return G__46673__2.call(this,x,y);
case 3:
return G__46673__3.call(this,x,y,z);
default:
var G__46680 = null;
if (arguments.length > 3) {
var G__46681__i = 0, G__46681__a = new Array(arguments.length -  3);
while (G__46681__i < G__46681__a.length) {G__46681__a[G__46681__i] = arguments[G__46681__i + 3]; ++G__46681__i;}
G__46680 = new cljs.core.IndexedSeq(G__46681__a,0,null);
}
return G__46673__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46673.cljs$lang$maxFixedArity = 3;
G__46673.cljs$lang$applyTo = G__46673__4.cljs$lang$applyTo;
G__46673.cljs$core$IFn$_invoke$arity$0 = G__46673__0;
G__46673.cljs$core$IFn$_invoke$arity$1 = G__46673__1;
G__46673.cljs$core$IFn$_invoke$arity$2 = G__46673__2;
G__46673.cljs$core$IFn$_invoke$arity$3 = G__46673__3;
G__46673.cljs$core$IFn$_invoke$arity$variadic = G__46673__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46673;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__46682 = null;
var G__46682__0 = (function (){
return f.call(null,arg1,arg2,arg3);
});
var G__46682__1 = (function (x){
return f.call(null,arg1,arg2,arg3,x);
});
var G__46682__2 = (function (x,y){
return f.call(null,arg1,arg2,arg3,x,y);
});
var G__46682__3 = (function (x,y,z){
return f.call(null,arg1,arg2,arg3,x,y,z);
});
var G__46682__4 = (function() { 
var G__46683__delegate = function (x,y,z,args){
return cljs.core.apply.call(null,f,arg1,arg2,arg3,x,y,z,args);
};
var G__46683 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46684__i = 0, G__46684__a = new Array(arguments.length -  3);
while (G__46684__i < G__46684__a.length) {G__46684__a[G__46684__i] = arguments[G__46684__i + 3]; ++G__46684__i;}
  args = new cljs.core.IndexedSeq(G__46684__a,0,null);
} 
return G__46683__delegate.call(this,x,y,z,args);};
G__46683.cljs$lang$maxFixedArity = 3;
G__46683.cljs$lang$applyTo = (function (arglist__46685){
var x = cljs.core.first(arglist__46685);
arglist__46685 = cljs.core.next(arglist__46685);
var y = cljs.core.first(arglist__46685);
arglist__46685 = cljs.core.next(arglist__46685);
var z = cljs.core.first(arglist__46685);
var args = cljs.core.rest(arglist__46685);
return G__46683__delegate(x,y,z,args);
});
G__46683.cljs$core$IFn$_invoke$arity$variadic = G__46683__delegate;
return G__46683;
})()
;
G__46682 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__46682__0.call(this);
case 1:
return G__46682__1.call(this,x);
case 2:
return G__46682__2.call(this,x,y);
case 3:
return G__46682__3.call(this,x,y,z);
default:
var G__46686 = null;
if (arguments.length > 3) {
var G__46687__i = 0, G__46687__a = new Array(arguments.length -  3);
while (G__46687__i < G__46687__a.length) {G__46687__a[G__46687__i] = arguments[G__46687__i + 3]; ++G__46687__i;}
G__46686 = new cljs.core.IndexedSeq(G__46687__a,0,null);
}
return G__46682__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46682.cljs$lang$maxFixedArity = 3;
G__46682.cljs$lang$applyTo = G__46682__4.cljs$lang$applyTo;
G__46682.cljs$core$IFn$_invoke$arity$0 = G__46682__0;
G__46682.cljs$core$IFn$_invoke$arity$1 = G__46682__1;
G__46682.cljs$core$IFn$_invoke$arity$2 = G__46682__2;
G__46682.cljs$core$IFn$_invoke$arity$3 = G__46682__3;
G__46682.cljs$core$IFn$_invoke$arity$variadic = G__46682__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46682;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__46688__delegate = function (args){
return cljs.core.apply.call(null,f,arg1,arg2,arg3,cljs.core.concat.call(null,more,args));
};
var G__46688 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__46689__i = 0, G__46689__a = new Array(arguments.length -  0);
while (G__46689__i < G__46689__a.length) {G__46689__a[G__46689__i] = arguments[G__46689__i + 0]; ++G__46689__i;}
  args = new cljs.core.IndexedSeq(G__46689__a,0,null);
} 
return G__46688__delegate.call(this,args);};
G__46688.cljs$lang$maxFixedArity = 0;
G__46688.cljs$lang$applyTo = (function (arglist__46690){
var args = cljs.core.seq(arglist__46690);
return G__46688__delegate(args);
});
G__46688.cljs$core$IFn$_invoke$arity$variadic = G__46688__delegate;
return G__46688;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function (seq43852){
var G__43853 = cljs.core.first.call(null,seq43852);
var seq43852__$1 = cljs.core.next.call(null,seq43852);
var G__43854 = cljs.core.first.call(null,seq43852__$1);
var seq43852__$2 = cljs.core.next.call(null,seq43852__$1);
var G__43855 = cljs.core.first.call(null,seq43852__$2);
var seq43852__$3 = cljs.core.next.call(null,seq43852__$2);
var G__43856 = cljs.core.first.call(null,seq43852__$3);
var seq43852__$4 = cljs.core.next.call(null,seq43852__$3);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43853,G__43854,G__43855,G__43856,seq43852__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__43859 = arguments.length;
switch (G__43859) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__46692 = null;
var G__46692__1 = (function (a){
return f.call(null,(((a == null))?x:a));
});
var G__46692__2 = (function (a,b){
return f.call(null,(((a == null))?x:a),b);
});
var G__46692__3 = (function (a,b,c){
return f.call(null,(((a == null))?x:a),b,c);
});
var G__46692__4 = (function() { 
var G__46696__delegate = function (a,b,c,ds){
return cljs.core.apply.call(null,f,(((a == null))?x:a),b,c,ds);
};
var G__46696 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__46697__i = 0, G__46697__a = new Array(arguments.length -  3);
while (G__46697__i < G__46697__a.length) {G__46697__a[G__46697__i] = arguments[G__46697__i + 3]; ++G__46697__i;}
  ds = new cljs.core.IndexedSeq(G__46697__a,0,null);
} 
return G__46696__delegate.call(this,a,b,c,ds);};
G__46696.cljs$lang$maxFixedArity = 3;
G__46696.cljs$lang$applyTo = (function (arglist__46698){
var a = cljs.core.first(arglist__46698);
arglist__46698 = cljs.core.next(arglist__46698);
var b = cljs.core.first(arglist__46698);
arglist__46698 = cljs.core.next(arglist__46698);
var c = cljs.core.first(arglist__46698);
var ds = cljs.core.rest(arglist__46698);
return G__46696__delegate(a,b,c,ds);
});
G__46696.cljs$core$IFn$_invoke$arity$variadic = G__46696__delegate;
return G__46696;
})()
;
G__46692 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__46692__1.call(this,a);
case 2:
return G__46692__2.call(this,a,b);
case 3:
return G__46692__3.call(this,a,b,c);
default:
var G__46699 = null;
if (arguments.length > 3) {
var G__46703__i = 0, G__46703__a = new Array(arguments.length -  3);
while (G__46703__i < G__46703__a.length) {G__46703__a[G__46703__i] = arguments[G__46703__i + 3]; ++G__46703__i;}
G__46699 = new cljs.core.IndexedSeq(G__46703__a,0,null);
}
return G__46692__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__46699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46692.cljs$lang$maxFixedArity = 3;
G__46692.cljs$lang$applyTo = G__46692__4.cljs$lang$applyTo;
G__46692.cljs$core$IFn$_invoke$arity$1 = G__46692__1;
G__46692.cljs$core$IFn$_invoke$arity$2 = G__46692__2;
G__46692.cljs$core$IFn$_invoke$arity$3 = G__46692__3;
G__46692.cljs$core$IFn$_invoke$arity$variadic = G__46692__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46692;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__46704 = null;
var G__46704__2 = (function (a,b){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b));
});
var G__46704__3 = (function (a,b,c){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b),c);
});
var G__46704__4 = (function() { 
var G__46705__delegate = function (a,b,c,ds){
return cljs.core.apply.call(null,f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__46705 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__46706__i = 0, G__46706__a = new Array(arguments.length -  3);
while (G__46706__i < G__46706__a.length) {G__46706__a[G__46706__i] = arguments[G__46706__i + 3]; ++G__46706__i;}
  ds = new cljs.core.IndexedSeq(G__46706__a,0,null);
} 
return G__46705__delegate.call(this,a,b,c,ds);};
G__46705.cljs$lang$maxFixedArity = 3;
G__46705.cljs$lang$applyTo = (function (arglist__46710){
var a = cljs.core.first(arglist__46710);
arglist__46710 = cljs.core.next(arglist__46710);
var b = cljs.core.first(arglist__46710);
arglist__46710 = cljs.core.next(arglist__46710);
var c = cljs.core.first(arglist__46710);
var ds = cljs.core.rest(arglist__46710);
return G__46705__delegate(a,b,c,ds);
});
G__46705.cljs$core$IFn$_invoke$arity$variadic = G__46705__delegate;
return G__46705;
})()
;
G__46704 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__46704__2.call(this,a,b);
case 3:
return G__46704__3.call(this,a,b,c);
default:
var G__46711 = null;
if (arguments.length > 3) {
var G__46712__i = 0, G__46712__a = new Array(arguments.length -  3);
while (G__46712__i < G__46712__a.length) {G__46712__a[G__46712__i] = arguments[G__46712__i + 3]; ++G__46712__i;}
G__46711 = new cljs.core.IndexedSeq(G__46712__a,0,null);
}
return G__46704__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__46711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46704.cljs$lang$maxFixedArity = 3;
G__46704.cljs$lang$applyTo = G__46704__4.cljs$lang$applyTo;
G__46704.cljs$core$IFn$_invoke$arity$2 = G__46704__2;
G__46704.cljs$core$IFn$_invoke$arity$3 = G__46704__3;
G__46704.cljs$core$IFn$_invoke$arity$variadic = G__46704__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46704;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__46713 = null;
var G__46713__2 = (function (a,b){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b));
});
var G__46713__3 = (function (a,b,c){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c));
});
var G__46713__4 = (function() { 
var G__46714__delegate = function (a,b,c,ds){
return cljs.core.apply.call(null,f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__46714 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__46715__i = 0, G__46715__a = new Array(arguments.length -  3);
while (G__46715__i < G__46715__a.length) {G__46715__a[G__46715__i] = arguments[G__46715__i + 3]; ++G__46715__i;}
  ds = new cljs.core.IndexedSeq(G__46715__a,0,null);
} 
return G__46714__delegate.call(this,a,b,c,ds);};
G__46714.cljs$lang$maxFixedArity = 3;
G__46714.cljs$lang$applyTo = (function (arglist__46716){
var a = cljs.core.first(arglist__46716);
arglist__46716 = cljs.core.next(arglist__46716);
var b = cljs.core.first(arglist__46716);
arglist__46716 = cljs.core.next(arglist__46716);
var c = cljs.core.first(arglist__46716);
var ds = cljs.core.rest(arglist__46716);
return G__46714__delegate(a,b,c,ds);
});
G__46714.cljs$core$IFn$_invoke$arity$variadic = G__46714__delegate;
return G__46714;
})()
;
G__46713 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__46713__2.call(this,a,b);
case 3:
return G__46713__3.call(this,a,b,c);
default:
var G__46717 = null;
if (arguments.length > 3) {
var G__46718__i = 0, G__46718__a = new Array(arguments.length -  3);
while (G__46718__i < G__46718__a.length) {G__46718__a[G__46718__i] = arguments[G__46718__i + 3]; ++G__46718__i;}
G__46717 = new cljs.core.IndexedSeq(G__46718__a,0,null);
}
return G__46713__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__46717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46713.cljs$lang$maxFixedArity = 3;
G__46713.cljs$lang$applyTo = G__46713__4.cljs$lang$applyTo;
G__46713.cljs$core$IFn$_invoke$arity$2 = G__46713__2;
G__46713.cljs$core$IFn$_invoke$arity$3 = G__46713__3;
G__46713.cljs$core$IFn$_invoke$arity$variadic = G__46713__4.cljs$core$IFn$_invoke$arity$variadic;
return G__46713;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__43861 = arguments.length;
switch (G__43861) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = cljs.core.volatile_BANG_.call(null,(-1));
return (function() {
var G__46720 = null;
var G__46720__0 = (function (){
return rf.call(null);
});
var G__46720__1 = (function (result){
return rf.call(null,result);
});
var G__46720__2 = (function (result,input){
return rf.call(null,result,f.call(null,cljs.core._vreset_BANG_.call(null,i,(cljs.core._deref.call(null,i) + (1))),input));
});
G__46720 = function(result,input){
switch(arguments.length){
case 0:
return G__46720__0.call(this);
case 1:
return G__46720__1.call(this,result);
case 2:
return G__46720__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46720.cljs$core$IFn$_invoke$arity$0 = G__46720__0;
G__46720.cljs$core$IFn$_invoke$arity$1 = G__46720__1;
G__46720.cljs$core$IFn$_invoke$arity$2 = G__46720__2;
return G__46720;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s)){
var c = cljs.core.chunk_first.call(null,s);
var size = cljs.core.count.call(null,c);
var b = cljs.core.chunk_buffer.call(null,size);
var n__6679__auto___46724 = size;
var i_46725 = (0);
while(true){
if((i_46725 < n__6679__auto___46724)){
cljs.core.chunk_append.call(null,b,f.call(null,(idx + i_46725),cljs.core._nth.call(null,c,i_46725)));

var G__46726 = (i_46725 + (1));
i_46725 = G__46726;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b),cljs$core$mapi.call(null,(idx + size),cljs.core.chunk_rest.call(null,s)));
} else {
return cljs.core.cons.call(null,f.call(null,idx,cljs.core.first.call(null,s)),cljs$core$mapi.call(null,(idx + (1)),cljs.core.rest.call(null,s)));
}
} else {
return null;
}
}),null,null));
});
return mapi.call(null,(0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__43863 = arguments.length;
switch (G__43863) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__46728 = null;
var G__46728__0 = (function (){
return rf.call(null);
});
var G__46728__1 = (function (result){
return rf.call(null,result);
});
var G__46728__2 = (function (result,input){
var v = f.call(null,input);
if((v == null)){
return result;
} else {
return rf.call(null,result,v);
}
});
G__46728 = function(result,input){
switch(arguments.length){
case 0:
return G__46728__0.call(this);
case 1:
return G__46728__1.call(this,result);
case 2:
return G__46728__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46728.cljs$core$IFn$_invoke$arity$0 = G__46728__0;
G__46728.cljs$core$IFn$_invoke$arity$1 = G__46728__1;
G__46728.cljs$core$IFn$_invoke$arity$2 = G__46728__2;
return G__46728;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s)){
var c = cljs.core.chunk_first.call(null,s);
var size = cljs.core.count.call(null,c);
var b = cljs.core.chunk_buffer.call(null,size);
var n__6679__auto___46731 = size;
var i_46732 = (0);
while(true){
if((i_46732 < n__6679__auto___46731)){
var x_46733 = f.call(null,cljs.core._nth.call(null,c,i_46732));
if((x_46733 == null)){
} else {
cljs.core.chunk_append.call(null,b,x_46733);
}

var G__46735 = (i_46732 + (1));
i_46732 = G__46735;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b),cljs.core.keep.call(null,f,cljs.core.chunk_rest.call(null,s)));
} else {
var x = f.call(null,cljs.core.first.call(null,s));
if((x == null)){
return cljs.core.keep.call(null,f,cljs.core.rest.call(null,s));
} else {
return cljs.core.cons.call(null,x,cljs.core.keep.call(null,f,cljs.core.rest.call(null,s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__43864 = cljs.core.seq.call(null,self__.watches);
var chunk__43865 = null;
var count__43866 = (0);
var i__43867 = (0);
while(true){
if((i__43867 < count__43866)){
var vec__43874 = cljs.core._nth.call(null,chunk__43865,i__43867);
var key = cljs.core.nth.call(null,vec__43874,(0),null);
var f = cljs.core.nth.call(null,vec__43874,(1),null);
f.call(null,key,this$__$1,oldval,newval);


var G__46736 = seq__43864;
var G__46737 = chunk__43865;
var G__46738 = count__43866;
var G__46739 = (i__43867 + (1));
seq__43864 = G__46736;
chunk__43865 = G__46737;
count__43866 = G__46738;
i__43867 = G__46739;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__43864);
if(temp__5720__auto__){
var seq__43864__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43864__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__43864__$1);
var G__46740 = cljs.core.chunk_rest.call(null,seq__43864__$1);
var G__46741 = c__6568__auto__;
var G__46742 = cljs.core.count.call(null,c__6568__auto__);
var G__46743 = (0);
seq__43864 = G__46740;
chunk__43865 = G__46741;
count__43866 = G__46742;
i__43867 = G__46743;
continue;
} else {
var vec__43877 = cljs.core.first.call(null,seq__43864__$1);
var key = cljs.core.nth.call(null,vec__43877,(0),null);
var f = cljs.core.nth.call(null,vec__43877,(1),null);
f.call(null,key,this$__$1,oldval,newval);


var G__46744 = cljs.core.next.call(null,seq__43864__$1);
var G__46745 = null;
var G__46746 = (0);
var G__46747 = (0);
seq__43864 = G__46744;
chunk__43865 = G__46745;
count__43866 = G__46746;
i__43867 = G__46747;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__43883 = arguments.length;
switch (G__43883) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46756 = arguments.length;
var i__6921__auto___46757 = (0);
while(true){
if((i__6921__auto___46757 < len__6920__auto___46756)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46757]));

var G__46758 = (i__6921__auto___46757 + (1));
i__6921__auto___46757 = G__46758;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6950__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__43884){
var map__43885 = p__43884;
var map__43885__$1 = (((((!((map__43885 == null))))?(((((map__43885.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43885.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43885):map__43885);
var meta = cljs.core.get.call(null,map__43885__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.call(null,map__43885__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function (seq43881){
var G__43882 = cljs.core.first.call(null,seq43881);
var seq43881__$1 = cljs.core.next.call(null,seq43881);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43882,seq43881__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_(validate.call(null,new_value))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
cljs.core._notify_watches.call(null,a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_.call(null,a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_(validate.call(null,new_value))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
cljs.core._notify_watches.call(null,a,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__43893 = arguments.length;
switch (G__43893) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46802 = arguments.length;
var i__6921__auto___46803 = (0);
while(true){
if((i__6921__auto___46803 < len__6920__auto___46802)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46803]));

var G__46804 = (i__6921__auto___46803 + (1));
i__6921__auto___46803 = G__46804;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__6950__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state));
} else {
return cljs.core._swap_BANG_.call(null,a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state,x));
} else {
return cljs.core._swap_BANG_.call(null,a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state,x,y));
} else {
return cljs.core._swap_BANG_.call(null,a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_.call(null,a,cljs.core.apply.call(null,f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.call(null,a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq43888){
var G__43889 = cljs.core.first.call(null,seq43888);
var seq43888__$1 = cljs.core.next.call(null,seq43888);
var G__43890 = cljs.core.first.call(null,seq43888__$1);
var seq43888__$2 = cljs.core.next.call(null,seq43888__$1);
var G__43891 = cljs.core.first.call(null,seq43888__$2);
var seq43888__$3 = cljs.core.next.call(null,seq43888__$2);
var G__43892 = cljs.core.first.call(null,seq43888__$3);
var seq43888__$4 = cljs.core.next.call(null,seq43888__$3);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43889,G__43890,G__43891,G__43892,seq43888__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__43900 = arguments.length;
switch (G__43900) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46806 = arguments.length;
var i__6921__auto___46807 = (0);
while(true){
if((i__6921__auto___46807 < len__6920__auto___46806)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46807]));

var G__46808 = (i__6921__auto___46807 + (1));
i__6921__auto___46807 = G__46808;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((4)),(0),null));
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__6950__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
return cljs.core.reset_vals_BANG_.call(null,a,f.call(null,a.state));
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
return cljs.core.reset_vals_BANG_.call(null,a,f.call(null,a.state,x));
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
return cljs.core.reset_vals_BANG_.call(null,a,f.call(null,a.state,x,y));
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
return cljs.core.reset_vals_BANG_.call(null,a,cljs.core.apply.call(null,f,a.state,x,y,more));
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function (seq43895){
var G__43896 = cljs.core.first.call(null,seq43895);
var seq43895__$1 = cljs.core.next.call(null,seq43895);
var G__43897 = cljs.core.first.call(null,seq43895__$1);
var seq43895__$2 = cljs.core.next.call(null,seq43895__$1);
var G__43898 = cljs.core.first.call(null,seq43895__$2);
var seq43895__$3 = cljs.core.next.call(null,seq43895__$2);
var G__43899 = cljs.core.first.call(null,seq43895__$3);
var seq43895__$4 = cljs.core.next.call(null,seq43895__$3);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43896,G__43897,G__43898,G__43899,seq43895__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.call(null,cljs.core._deref.call(null,a),oldval)){
cljs.core.reset_BANG_.call(null,a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not.call(null,val.call(null,cljs.core._deref.call(null,iref)))))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_.call(null,vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__43902 = arguments.length;
switch (G__43902) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_.call(null,(-1));
return (function() {
var G__46813 = null;
var G__46813__0 = (function (){
return rf.call(null);
});
var G__46813__1 = (function (result){
return rf.call(null,result);
});
var G__46813__2 = (function (result,input){
var i = cljs.core._vreset_BANG_.call(null,ia,(cljs.core._deref.call(null,ia) + (1)));
var v = f.call(null,i,input);
if((v == null)){
return result;
} else {
return rf.call(null,result,v);
}
});
G__46813 = function(result,input){
switch(arguments.length){
case 0:
return G__46813__0.call(this);
case 1:
return G__46813__1.call(this,result);
case 2:
return G__46813__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46813.cljs$core$IFn$_invoke$arity$0 = G__46813__0;
G__46813.cljs$core$IFn$_invoke$arity$1 = G__46813__1;
G__46813.cljs$core$IFn$_invoke$arity$2 = G__46813__2;
return G__46813;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s)){
var c = cljs.core.chunk_first.call(null,s);
var size = cljs.core.count.call(null,c);
var b = cljs.core.chunk_buffer.call(null,size);
var n__6679__auto___46814 = size;
var i_46815 = (0);
while(true){
if((i_46815 < n__6679__auto___46814)){
var x_46816 = f.call(null,(idx + i_46815),cljs.core._nth.call(null,c,i_46815));
if((x_46816 == null)){
} else {
cljs.core.chunk_append.call(null,b,x_46816);
}

var G__46817 = (i_46815 + (1));
i_46815 = G__46817;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b),cljs$core$keepi.call(null,(idx + size),cljs.core.chunk_rest.call(null,s)));
} else {
var x = f.call(null,idx,cljs.core.first.call(null,s));
if((x == null)){
return cljs$core$keepi.call(null,(idx + (1)),cljs.core.rest.call(null,s));
} else {
return cljs.core.cons.call(null,x,cljs$core$keepi.call(null,(idx + (1)),cljs.core.rest.call(null,s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi.call(null,(0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__43914 = arguments.length;
switch (G__43914) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46819 = arguments.length;
var i__6921__auto___46820 = (0);
while(true){
if((i__6921__auto___46820 < len__6920__auto___46819)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46820]));

var G__46821 = (i__6921__auto___46820 + (1));
i__6921__auto___46820 = G__46821;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$.call(null,p.call(null,x));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
return p.call(null,y);
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p.call(null,y);
if(cljs.core.truth_(and__5583__auto____$1)){
return p.call(null,z);
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__46822__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = cljs$core$ep1.call(null,x,y,z);
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core.every_QMARK_.call(null,p,args);
} else {
return and__5583__auto__;
}
})());
};
var G__46822 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46826__i = 0, G__46826__a = new Array(arguments.length -  3);
while (G__46826__i < G__46826__a.length) {G__46826__a[G__46826__i] = arguments[G__46826__i + 3]; ++G__46826__i;}
  args = new cljs.core.IndexedSeq(G__46826__a,0,null);
} 
return G__46822__delegate.call(this,x,y,z,args);};
G__46822.cljs$lang$maxFixedArity = 3;
G__46822.cljs$lang$applyTo = (function (arglist__46827){
var x = cljs.core.first(arglist__46827);
arglist__46827 = cljs.core.next(arglist__46827);
var y = cljs.core.first(arglist__46827);
arglist__46827 = cljs.core.next(arglist__46827);
var z = cljs.core.first(arglist__46827);
var args = cljs.core.rest(arglist__46827);
return G__46822__delegate(x,y,z,args);
});
G__46822.cljs$core$IFn$_invoke$arity$variadic = G__46822__delegate;
return G__46822;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__46834 = null;
if (arguments.length > 3) {
var G__46835__i = 0, G__46835__a = new Array(arguments.length -  3);
while (G__46835__i < G__46835__a.length) {G__46835__a[G__46835__i] = arguments[G__46835__i + 3]; ++G__46835__i;}
G__46834 = new cljs.core.IndexedSeq(G__46835__a,0,null);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p1.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
return p2.call(null,x);
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p1.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p1.call(null,y);
if(cljs.core.truth_(and__5583__auto____$1)){
var and__5583__auto____$2 = p2.call(null,x);
if(cljs.core.truth_(and__5583__auto____$2)){
return p2.call(null,y);
} else {
return and__5583__auto____$2;
}
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p1.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p1.call(null,y);
if(cljs.core.truth_(and__5583__auto____$1)){
var and__5583__auto____$2 = p1.call(null,z);
if(cljs.core.truth_(and__5583__auto____$2)){
var and__5583__auto____$3 = p2.call(null,x);
if(cljs.core.truth_(and__5583__auto____$3)){
var and__5583__auto____$4 = p2.call(null,y);
if(cljs.core.truth_(and__5583__auto____$4)){
return p2.call(null,z);
} else {
return and__5583__auto____$4;
}
} else {
return and__5583__auto____$3;
}
} else {
return and__5583__auto____$2;
}
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__46836__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = cljs$core$ep2.call(null,x,y,z);
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core.every_QMARK_.call(null,(function (p1__43903_SHARP_){
var and__5583__auto____$1 = p1.call(null,p1__43903_SHARP_);
if(cljs.core.truth_(and__5583__auto____$1)){
return p2.call(null,p1__43903_SHARP_);
} else {
return and__5583__auto____$1;
}
}),args);
} else {
return and__5583__auto__;
}
})());
};
var G__46836 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46837__i = 0, G__46837__a = new Array(arguments.length -  3);
while (G__46837__i < G__46837__a.length) {G__46837__a[G__46837__i] = arguments[G__46837__i + 3]; ++G__46837__i;}
  args = new cljs.core.IndexedSeq(G__46837__a,0,null);
} 
return G__46836__delegate.call(this,x,y,z,args);};
G__46836.cljs$lang$maxFixedArity = 3;
G__46836.cljs$lang$applyTo = (function (arglist__46838){
var x = cljs.core.first(arglist__46838);
arglist__46838 = cljs.core.next(arglist__46838);
var y = cljs.core.first(arglist__46838);
arglist__46838 = cljs.core.next(arglist__46838);
var z = cljs.core.first(arglist__46838);
var args = cljs.core.rest(arglist__46838);
return G__46836__delegate(x,y,z,args);
});
G__46836.cljs$core$IFn$_invoke$arity$variadic = G__46836__delegate;
return G__46836;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__46839 = null;
if (arguments.length > 3) {
var G__46840__i = 0, G__46840__a = new Array(arguments.length -  3);
while (G__46840__i < G__46840__a.length) {G__46840__a[G__46840__i] = arguments[G__46840__i + 3]; ++G__46840__i;}
G__46839 = new cljs.core.IndexedSeq(G__46840__a,0,null);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p1.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p2.call(null,x);
if(cljs.core.truth_(and__5583__auto____$1)){
return p3.call(null,x);
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p1.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p2.call(null,x);
if(cljs.core.truth_(and__5583__auto____$1)){
var and__5583__auto____$2 = p3.call(null,x);
if(cljs.core.truth_(and__5583__auto____$2)){
var and__5583__auto____$3 = p1.call(null,y);
if(cljs.core.truth_(and__5583__auto____$3)){
var and__5583__auto____$4 = p2.call(null,y);
if(cljs.core.truth_(and__5583__auto____$4)){
return p3.call(null,y);
} else {
return and__5583__auto____$4;
}
} else {
return and__5583__auto____$3;
}
} else {
return and__5583__auto____$2;
}
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = p1.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p2.call(null,x);
if(cljs.core.truth_(and__5583__auto____$1)){
var and__5583__auto____$2 = p3.call(null,x);
if(cljs.core.truth_(and__5583__auto____$2)){
var and__5583__auto____$3 = p1.call(null,y);
if(cljs.core.truth_(and__5583__auto____$3)){
var and__5583__auto____$4 = p2.call(null,y);
if(cljs.core.truth_(and__5583__auto____$4)){
var and__5583__auto____$5 = p3.call(null,y);
if(cljs.core.truth_(and__5583__auto____$5)){
var and__5583__auto____$6 = p1.call(null,z);
if(cljs.core.truth_(and__5583__auto____$6)){
var and__5583__auto____$7 = p2.call(null,z);
if(cljs.core.truth_(and__5583__auto____$7)){
return p3.call(null,z);
} else {
return and__5583__auto____$7;
}
} else {
return and__5583__auto____$6;
}
} else {
return and__5583__auto____$5;
}
} else {
return and__5583__auto____$4;
}
} else {
return and__5583__auto____$3;
}
} else {
return and__5583__auto____$2;
}
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__46841__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = cljs$core$ep3.call(null,x,y,z);
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core.every_QMARK_.call(null,(function (p1__43904_SHARP_){
var and__5583__auto____$1 = p1.call(null,p1__43904_SHARP_);
if(cljs.core.truth_(and__5583__auto____$1)){
var and__5583__auto____$2 = p2.call(null,p1__43904_SHARP_);
if(cljs.core.truth_(and__5583__auto____$2)){
return p3.call(null,p1__43904_SHARP_);
} else {
return and__5583__auto____$2;
}
} else {
return and__5583__auto____$1;
}
}),args);
} else {
return and__5583__auto__;
}
})());
};
var G__46841 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46842__i = 0, G__46842__a = new Array(arguments.length -  3);
while (G__46842__i < G__46842__a.length) {G__46842__a[G__46842__i] = arguments[G__46842__i + 3]; ++G__46842__i;}
  args = new cljs.core.IndexedSeq(G__46842__a,0,null);
} 
return G__46841__delegate.call(this,x,y,z,args);};
G__46841.cljs$lang$maxFixedArity = 3;
G__46841.cljs$lang$applyTo = (function (arglist__46843){
var x = cljs.core.first(arglist__46843);
arglist__46843 = cljs.core.next(arglist__46843);
var y = cljs.core.first(arglist__46843);
arglist__46843 = cljs.core.next(arglist__46843);
var z = cljs.core.first(arglist__46843);
var args = cljs.core.rest(arglist__46843);
return G__46841__delegate(x,y,z,args);
});
G__46841.cljs$core$IFn$_invoke$arity$variadic = G__46841__delegate;
return G__46841;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__46844 = null;
if (arguments.length > 3) {
var G__46845__i = 0, G__46845__a = new Array(arguments.length -  3);
while (G__46845__i < G__46845__a.length) {G__46845__a[G__46845__i] = arguments[G__46845__i + 3]; ++G__46845__i;}
G__46844 = new cljs.core.IndexedSeq(G__46845__a,0,null);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.call(null,p1,p2,p3,ps);
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_.call(null,(function (p1__43905_SHARP_){
return p1__43905_SHARP_.call(null,x);
}),ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_.call(null,(function (p1__43906_SHARP_){
var and__5583__auto__ = p1__43906_SHARP_.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
return p1__43906_SHARP_.call(null,y);
} else {
return and__5583__auto__;
}
}),ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_.call(null,(function (p1__43907_SHARP_){
var and__5583__auto__ = p1__43907_SHARP_.call(null,x);
if(cljs.core.truth_(and__5583__auto__)){
var and__5583__auto____$1 = p1__43907_SHARP_.call(null,y);
if(cljs.core.truth_(and__5583__auto____$1)){
return p1__43907_SHARP_.call(null,z);
} else {
return and__5583__auto____$1;
}
} else {
return and__5583__auto__;
}
}),ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__46852__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__5583__auto__ = cljs$core$epn.call(null,x,y,z);
if(cljs.core.truth_(and__5583__auto__)){
return cljs.core.every_QMARK_.call(null,(function (p1__43908_SHARP_){
return cljs.core.every_QMARK_.call(null,p1__43908_SHARP_,args);
}),ps__$1);
} else {
return and__5583__auto__;
}
})());
};
var G__46852 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46853__i = 0, G__46853__a = new Array(arguments.length -  3);
while (G__46853__i < G__46853__a.length) {G__46853__a[G__46853__i] = arguments[G__46853__i + 3]; ++G__46853__i;}
  args = new cljs.core.IndexedSeq(G__46853__a,0,null);
} 
return G__46852__delegate.call(this,x,y,z,args);};
G__46852.cljs$lang$maxFixedArity = 3;
G__46852.cljs$lang$applyTo = (function (arglist__46854){
var x = cljs.core.first(arglist__46854);
arglist__46854 = cljs.core.next(arglist__46854);
var y = cljs.core.first(arglist__46854);
arglist__46854 = cljs.core.next(arglist__46854);
var z = cljs.core.first(arglist__46854);
var args = cljs.core.rest(arglist__46854);
return G__46852__delegate(x,y,z,args);
});
G__46852.cljs$core$IFn$_invoke$arity$variadic = G__46852__delegate;
return G__46852;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__46855 = null;
if (arguments.length > 3) {
var G__46856__i = 0, G__46856__a = new Array(arguments.length -  3);
while (G__46856__i < G__46856__a.length) {G__46856__a[G__46856__i] = arguments[G__46856__i + 3]; ++G__46856__i;}
G__46855 = new cljs.core.IndexedSeq(G__46856__a,0,null);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function (seq43910){
var G__43911 = cljs.core.first.call(null,seq43910);
var seq43910__$1 = cljs.core.next.call(null,seq43910);
var G__43912 = cljs.core.first.call(null,seq43910__$1);
var seq43910__$2 = cljs.core.next.call(null,seq43910__$1);
var G__43913 = cljs.core.first.call(null,seq43910__$2);
var seq43910__$3 = cljs.core.next.call(null,seq43910__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43911,G__43912,G__43913,seq43910__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__43926 = arguments.length;
switch (G__43926) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46862 = arguments.length;
var i__6921__auto___46863 = (0);
while(true){
if((i__6921__auto___46863 < len__6920__auto___46862)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46863]));

var G__46864 = (i__6921__auto___46863 + (1));
i__6921__auto___46863 = G__46864;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return p.call(null,x);
});
var cljs$core$sp1__2 = (function (x,y){
var or__5598__auto__ = p.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return p.call(null,y);
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__5598__auto__ = p.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p.call(null,y);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
return p.call(null,z);
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__46869__delegate = function (x,y,z,args){
var or__5598__auto__ = cljs$core$sp1.call(null,x,y,z);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.some.call(null,p,args);
}
};
var G__46869 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46870__i = 0, G__46870__a = new Array(arguments.length -  3);
while (G__46870__i < G__46870__a.length) {G__46870__a[G__46870__i] = arguments[G__46870__i + 3]; ++G__46870__i;}
  args = new cljs.core.IndexedSeq(G__46870__a,0,null);
} 
return G__46869__delegate.call(this,x,y,z,args);};
G__46869.cljs$lang$maxFixedArity = 3;
G__46869.cljs$lang$applyTo = (function (arglist__46871){
var x = cljs.core.first(arglist__46871);
arglist__46871 = cljs.core.next(arglist__46871);
var y = cljs.core.first(arglist__46871);
arglist__46871 = cljs.core.next(arglist__46871);
var z = cljs.core.first(arglist__46871);
var args = cljs.core.rest(arglist__46871);
return G__46869__delegate(x,y,z,args);
});
G__46869.cljs$core$IFn$_invoke$arity$variadic = G__46869__delegate;
return G__46869;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__46872 = null;
if (arguments.length > 3) {
var G__46873__i = 0, G__46873__a = new Array(arguments.length -  3);
while (G__46873__i < G__46873__a.length) {G__46873__a[G__46873__i] = arguments[G__46873__i + 3]; ++G__46873__i;}
G__46872 = new cljs.core.IndexedSeq(G__46873__a,0,null);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__5598__auto__ = p1.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return p2.call(null,x);
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__5598__auto__ = p1.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p1.call(null,y);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
var or__5598__auto____$2 = p2.call(null,x);
if(cljs.core.truth_(or__5598__auto____$2)){
return or__5598__auto____$2;
} else {
return p2.call(null,y);
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__5598__auto__ = p1.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p1.call(null,y);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
var or__5598__auto____$2 = p1.call(null,z);
if(cljs.core.truth_(or__5598__auto____$2)){
return or__5598__auto____$2;
} else {
var or__5598__auto____$3 = p2.call(null,x);
if(cljs.core.truth_(or__5598__auto____$3)){
return or__5598__auto____$3;
} else {
var or__5598__auto____$4 = p2.call(null,y);
if(cljs.core.truth_(or__5598__auto____$4)){
return or__5598__auto____$4;
} else {
return p2.call(null,z);
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__46878__delegate = function (x,y,z,args){
var or__5598__auto__ = cljs$core$sp2.call(null,x,y,z);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.some.call(null,(function (p1__43915_SHARP_){
var or__5598__auto____$1 = p1.call(null,p1__43915_SHARP_);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
return p2.call(null,p1__43915_SHARP_);
}
}),args);
}
};
var G__46878 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46879__i = 0, G__46879__a = new Array(arguments.length -  3);
while (G__46879__i < G__46879__a.length) {G__46879__a[G__46879__i] = arguments[G__46879__i + 3]; ++G__46879__i;}
  args = new cljs.core.IndexedSeq(G__46879__a,0,null);
} 
return G__46878__delegate.call(this,x,y,z,args);};
G__46878.cljs$lang$maxFixedArity = 3;
G__46878.cljs$lang$applyTo = (function (arglist__46880){
var x = cljs.core.first(arglist__46880);
arglist__46880 = cljs.core.next(arglist__46880);
var y = cljs.core.first(arglist__46880);
arglist__46880 = cljs.core.next(arglist__46880);
var z = cljs.core.first(arglist__46880);
var args = cljs.core.rest(arglist__46880);
return G__46878__delegate(x,y,z,args);
});
G__46878.cljs$core$IFn$_invoke$arity$variadic = G__46878__delegate;
return G__46878;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__46881 = null;
if (arguments.length > 3) {
var G__46882__i = 0, G__46882__a = new Array(arguments.length -  3);
while (G__46882__i < G__46882__a.length) {G__46882__a[G__46882__i] = arguments[G__46882__i + 3]; ++G__46882__i;}
G__46881 = new cljs.core.IndexedSeq(G__46882__a,0,null);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__5598__auto__ = p1.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p2.call(null,x);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
return p3.call(null,x);
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__5598__auto__ = p1.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p2.call(null,x);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
var or__5598__auto____$2 = p3.call(null,x);
if(cljs.core.truth_(or__5598__auto____$2)){
return or__5598__auto____$2;
} else {
var or__5598__auto____$3 = p1.call(null,y);
if(cljs.core.truth_(or__5598__auto____$3)){
return or__5598__auto____$3;
} else {
var or__5598__auto____$4 = p2.call(null,y);
if(cljs.core.truth_(or__5598__auto____$4)){
return or__5598__auto____$4;
} else {
return p3.call(null,y);
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__5598__auto__ = p1.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p2.call(null,x);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
var or__5598__auto____$2 = p3.call(null,x);
if(cljs.core.truth_(or__5598__auto____$2)){
return or__5598__auto____$2;
} else {
var or__5598__auto____$3 = p1.call(null,y);
if(cljs.core.truth_(or__5598__auto____$3)){
return or__5598__auto____$3;
} else {
var or__5598__auto____$4 = p2.call(null,y);
if(cljs.core.truth_(or__5598__auto____$4)){
return or__5598__auto____$4;
} else {
var or__5598__auto____$5 = p3.call(null,y);
if(cljs.core.truth_(or__5598__auto____$5)){
return or__5598__auto____$5;
} else {
var or__5598__auto____$6 = p1.call(null,z);
if(cljs.core.truth_(or__5598__auto____$6)){
return or__5598__auto____$6;
} else {
var or__5598__auto____$7 = p2.call(null,z);
if(cljs.core.truth_(or__5598__auto____$7)){
return or__5598__auto____$7;
} else {
return p3.call(null,z);
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__46888__delegate = function (x,y,z,args){
var or__5598__auto__ = cljs$core$sp3.call(null,x,y,z);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.some.call(null,(function (p1__43916_SHARP_){
var or__5598__auto____$1 = p1.call(null,p1__43916_SHARP_);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
var or__5598__auto____$2 = p2.call(null,p1__43916_SHARP_);
if(cljs.core.truth_(or__5598__auto____$2)){
return or__5598__auto____$2;
} else {
return p3.call(null,p1__43916_SHARP_);
}
}
}),args);
}
};
var G__46888 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46889__i = 0, G__46889__a = new Array(arguments.length -  3);
while (G__46889__i < G__46889__a.length) {G__46889__a[G__46889__i] = arguments[G__46889__i + 3]; ++G__46889__i;}
  args = new cljs.core.IndexedSeq(G__46889__a,0,null);
} 
return G__46888__delegate.call(this,x,y,z,args);};
G__46888.cljs$lang$maxFixedArity = 3;
G__46888.cljs$lang$applyTo = (function (arglist__46890){
var x = cljs.core.first(arglist__46890);
arglist__46890 = cljs.core.next(arglist__46890);
var y = cljs.core.first(arglist__46890);
arglist__46890 = cljs.core.next(arglist__46890);
var z = cljs.core.first(arglist__46890);
var args = cljs.core.rest(arglist__46890);
return G__46888__delegate(x,y,z,args);
});
G__46888.cljs$core$IFn$_invoke$arity$variadic = G__46888__delegate;
return G__46888;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__46891 = null;
if (arguments.length > 3) {
var G__46892__i = 0, G__46892__a = new Array(arguments.length -  3);
while (G__46892__i < G__46892__a.length) {G__46892__a[G__46892__i] = arguments[G__46892__i + 3]; ++G__46892__i;}
G__46891 = new cljs.core.IndexedSeq(G__46892__a,0,null);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.call(null,p1,p2,p3,ps);
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some.call(null,(function (p1__43917_SHARP_){
return p1__43917_SHARP_.call(null,x);
}),ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some.call(null,(function (p1__43918_SHARP_){
var or__5598__auto__ = p1__43918_SHARP_.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return p1__43918_SHARP_.call(null,y);
}
}),ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some.call(null,(function (p1__43919_SHARP_){
var or__5598__auto__ = p1__43919_SHARP_.call(null,x);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = p1__43919_SHARP_.call(null,y);
if(cljs.core.truth_(or__5598__auto____$1)){
return or__5598__auto____$1;
} else {
return p1__43919_SHARP_.call(null,z);
}
}
}),ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__46897__delegate = function (x,y,z,args){
var or__5598__auto__ = cljs$core$spn.call(null,x,y,z);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.some.call(null,(function (p1__43920_SHARP_){
return cljs.core.some.call(null,p1__43920_SHARP_,args);
}),ps__$1);
}
};
var G__46897 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__46904__i = 0, G__46904__a = new Array(arguments.length -  3);
while (G__46904__i < G__46904__a.length) {G__46904__a[G__46904__i] = arguments[G__46904__i + 3]; ++G__46904__i;}
  args = new cljs.core.IndexedSeq(G__46904__a,0,null);
} 
return G__46897__delegate.call(this,x,y,z,args);};
G__46897.cljs$lang$maxFixedArity = 3;
G__46897.cljs$lang$applyTo = (function (arglist__46905){
var x = cljs.core.first(arglist__46905);
arglist__46905 = cljs.core.next(arglist__46905);
var y = cljs.core.first(arglist__46905);
arglist__46905 = cljs.core.next(arglist__46905);
var z = cljs.core.first(arglist__46905);
var args = cljs.core.rest(arglist__46905);
return G__46897__delegate(x,y,z,args);
});
G__46897.cljs$core$IFn$_invoke$arity$variadic = G__46897__delegate;
return G__46897;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__46912 = null;
if (arguments.length > 3) {
var G__46913__i = 0, G__46913__a = new Array(arguments.length -  3);
while (G__46913__i < G__46913__a.length) {G__46913__a[G__46913__i] = arguments[G__46913__i + 3]; ++G__46913__i;}
G__46912 = new cljs.core.IndexedSeq(G__46913__a,0,null);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__46912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function (seq43922){
var G__43923 = cljs.core.first.call(null,seq43922);
var seq43922__$1 = cljs.core.next.call(null,seq43922);
var G__43924 = cljs.core.first.call(null,seq43922__$1);
var seq43922__$2 = cljs.core.next.call(null,seq43922__$1);
var G__43925 = cljs.core.first.call(null,seq43922__$2);
var seq43922__$3 = cljs.core.next.call(null,seq43922__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43923,G__43924,G__43925,seq43922__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__43934 = arguments.length;
switch (G__43934) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___46918 = arguments.length;
var i__6921__auto___46928 = (0);
while(true){
if((i__6921__auto___46928 < len__6920__auto___46918)){
args_arr__6949__auto__.push((arguments[i__6921__auto___46928]));

var G__46929 = (i__6921__auto___46928 + (1));
i__6921__auto___46928 = G__46929;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__6950__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__46930 = null;
var G__46930__0 = (function (){
return rf.call(null);
});
var G__46930__1 = (function (result){
return rf.call(null,result);
});
var G__46930__2 = (function (result,input){
return rf.call(null,result,f.call(null,input));
});
var G__46930__3 = (function() { 
var G__46931__delegate = function (result,input,inputs){
return rf.call(null,result,cljs.core.apply.call(null,f,input,inputs));
};
var G__46931 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__46932__i = 0, G__46932__a = new Array(arguments.length -  2);
while (G__46932__i < G__46932__a.length) {G__46932__a[G__46932__i] = arguments[G__46932__i + 2]; ++G__46932__i;}
  inputs = new cljs.core.IndexedSeq(G__46932__a,0,null);
} 
return G__46931__delegate.call(this,result,input,inputs);};
G__46931.cljs$lang$maxFixedArity = 2;
G__46931.cljs$lang$applyTo = (function (arglist__46933){
var result = cljs.core.first(arglist__46933);
arglist__46933 = cljs.core.next(arglist__46933);
var input = cljs.core.first(arglist__46933);
var inputs = cljs.core.rest(arglist__46933);
return G__46931__delegate(result,input,inputs);
});
G__46931.cljs$core$IFn$_invoke$arity$variadic = G__46931__delegate;
return G__46931;
})()
;
G__46930 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__46930__0.call(this);
case 1:
return G__46930__1.call(this,result);
case 2:
return G__46930__2.call(this,result,input);
default:
var G__46934 = null;
if (arguments.length > 2) {
var G__46935__i = 0, G__46935__a = new Array(arguments.length -  2);
while (G__46935__i < G__46935__a.length) {G__46935__a[G__46935__i] = arguments[G__46935__i + 2]; ++G__46935__i;}
G__46934 = new cljs.core.IndexedSeq(G__46935__a,0,null);
}
return G__46930__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__46934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46930.cljs$lang$maxFixedArity = 2;
G__46930.cljs$lang$applyTo = G__46930__3.cljs$lang$applyTo;
G__46930.cljs$core$IFn$_invoke$arity$0 = G__46930__0;
G__46930.cljs$core$IFn$_invoke$arity$1 = G__46930__1;
G__46930.cljs$core$IFn$_invoke$arity$2 = G__46930__2;
G__46930.cljs$core$IFn$_invoke$arity$variadic = G__46930__3.cljs$core$IFn$_invoke$arity$variadic;
return G__46930;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s)){
var c = cljs.core.chunk_first.call(null,s);
var size = cljs.core.count.call(null,c);
var b = cljs.core.chunk_buffer.call(null,size);
var n__6679__auto___46936 = size;
var i_46937 = (0);
while(true){
if((i_46937 < n__6679__auto___46936)){
cljs.core.chunk_append.call(null,b,f.call(null,cljs.core._nth.call(null,c,i_46937)));

var G__46938 = (i_46937 + (1));
i_46937 = G__46938;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b),cljs.core.map.call(null,f,cljs.core.chunk_rest.call(null,s)));
} else {
return cljs.core.cons.call(null,f.call(null,cljs.core.first.call(null,s)),cljs.core.map.call(null,f,cljs.core.rest.call(null,s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq.call(null,c1);
var s2 = cljs.core.seq.call(null,c2);
if(((s1) && (s2))){
return cljs.core.cons.call(null,f.call(null,cljs.core.first.call(null,s1),cljs.core.first.call(null,s2)),cljs.core.map.call(null,f,cljs.core.rest.call(null,s1),cljs.core.rest.call(null,s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq.call(null,c1);
var s2 = cljs.core.seq.call(null,c2);
var s3 = cljs.core.seq.call(null,c3);
if(((s1) && (s2) && (s3))){
return cljs.core.cons.call(null,f.call(null,cljs.core.first.call(null,s1),cljs.core.first.call(null,s2),cljs.core.first.call(null,s3)),cljs.core.map.call(null,f,cljs.core.rest.call(null,s1),cljs.core.rest.call(null,s2),cljs.core.rest.call(null,s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.call(null,cljs.core.seq,cs);
if(cljs.core.every_QMARK_.call(null,cljs.core.identity,ss)){
return cljs.core.cons.call(null,cljs.core.map.call(null,cljs.core.first,ss),cljs$core$step.call(null,cljs.core.map.call(null,cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.call(null,(function (p1__43927_SHARP_){
return cljs.core.apply.call(null,f,p1__43927_SHARP_);
}),step.call(null,cljs.core.conj.call(null,colls,c3,c2,c1)));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function (seq43929){
var G__43930 = cljs.core.first.call(null,seq43929);
var seq43929__$1 = cljs.core.next.call(null,seq43929);
var G__43931 = cljs.core.first.call(null,seq43929__$1);
var seq43929__$2 = cljs.core.next.call(null,seq43929__$1);
var G__43932 = cljs.core.first.call(null,seq43929__$2);
var seq43929__$3 = cljs.core.next.call(null,seq43929__$2);
var G__43933 = cljs.core.first.call(null,seq43929__$3);
var seq43929__$4 = cljs.core.next.call(null,seq43929__$3);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43930,G__43931,G__43932,G__43933,seq43929__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__43936 = arguments.length;
switch (G__43936) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_.call(null,n);
return (function() {
var G__46943 = null;
var G__46943__0 = (function (){
return rf.call(null);
});
var G__46943__1 = (function (result){
return rf.call(null,result);
});
var G__46943__2 = (function (result,input){
var n__$1 = cljs.core.deref.call(null,na);
var nn = cljs.core._vreset_BANG_.call(null,na,(cljs.core._deref.call(null,na) - (1)));
var result__$1 = (((n__$1 > (0)))?rf.call(null,result,input):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced.call(null,result__$1);
} else {
return result__$1;
}
});
G__46943 = function(result,input){
switch(arguments.length){
case 0:
return G__46943__0.call(this);
case 1:
return G__46943__1.call(this,result);
case 2:
return G__46943__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46943.cljs$core$IFn$_invoke$arity$0 = G__46943__0;
G__46943.cljs$core$IFn$_invoke$arity$1 = G__46943__1;
G__46943.cljs$core$IFn$_invoke$arity$2 = G__46943__2;
return G__46943;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons.call(null,cljs.core.first.call(null,s),cljs.core.take.call(null,(n - (1)),cljs.core.rest.call(null,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__43938 = arguments.length;
switch (G__43938) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_.call(null,n);
return (function() {
var G__46955 = null;
var G__46955__0 = (function (){
return rf.call(null);
});
var G__46955__1 = (function (result){
return rf.call(null,result);
});
var G__46955__2 = (function (result,input){
var n__$1 = cljs.core.deref.call(null,na);
cljs.core._vreset_BANG_.call(null,na,(cljs.core._deref.call(null,na) - (1)));

if((n__$1 > (0))){
return result;
} else {
return rf.call(null,result,input);
}
});
G__46955 = function(result,input){
switch(arguments.length){
case 0:
return G__46955__0.call(this);
case 1:
return G__46955__1.call(this,result);
case 2:
return G__46955__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46955.cljs$core$IFn$_invoke$arity$0 = G__46955__0;
G__46955.cljs$core$IFn$_invoke$arity$1 = G__46955__1;
G__46955.cljs$core$IFn$_invoke$arity$2 = G__46955__2;
return G__46955;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq.call(null,coll__$1);
if((((n__$1 > (0))) && (s))){
var G__46956 = (n__$1 - (1));
var G__46957 = cljs.core.rest.call(null,s);
n__$1 = G__46956;
coll__$1 = G__46957;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step.call(null,n,coll);
}),null,null));
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__43940 = arguments.length;
switch (G__43940) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.call(null,(1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.call(null,(function (x,_){
return x;
}),s,cljs.core.drop.call(null,n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq.call(null,coll);
var lead = cljs.core.seq.call(null,cljs.core.drop.call(null,n,coll));
while(true){
if(lead){
var G__46965 = cljs.core.next.call(null,s);
var G__46966 = cljs.core.next.call(null,lead);
s = G__46965;
lead = G__46966;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__43942 = arguments.length;
switch (G__43942) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_.call(null,true);
return (function() {
var G__46968 = null;
var G__46968__0 = (function (){
return rf.call(null);
});
var G__46968__1 = (function (result){
return rf.call(null,result);
});
var G__46968__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref.call(null,da);
if(cljs.core.truth_((function (){var and__5583__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__5583__auto__)){
return pred.call(null,input);
} else {
return and__5583__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_.call(null,da,null);

return rf.call(null,result,input);
}
});
G__46968 = function(result,input){
switch(arguments.length){
case 0:
return G__46968__0.call(this);
case 1:
return G__46968__1.call(this,result);
case 2:
return G__46968__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46968.cljs$core$IFn$_invoke$arity$0 = G__46968__0;
G__46968.cljs$core$IFn$_invoke$arity$1 = G__46968__1;
G__46968.cljs$core$IFn$_invoke$arity$2 = G__46968__2;
return G__46968;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq.call(null,coll__$1);
if(cljs.core.truth_((function (){var and__5583__auto__ = s;
if(and__5583__auto__){
return pred__$1.call(null,cljs.core.first.call(null,s));
} else {
return and__5583__auto__;
}
})())){
var G__46969 = pred__$1;
var G__46970 = cljs.core.rest.call(null,s);
pred__$1 = G__46969;
coll__$1 = G__46970;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step.call(null,pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.Cycle.prototype.currentval = (function (){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5718__auto___46973 = cljs.core.next.call(null,self__.prev);
if(temp__5718__auto___46973){
var c_46974 = temp__5718__auto___46973;
(self__.current = c_46974);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest.call(null,coll__$1);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first.call(null,s);
while(true){
var s__$1 = (function (){var or__5598__auto__ = cljs.core.next.call(null,s);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = f.call(null,ret,cljs.core.first.call(null,s__$1));
if(cljs.core.reduced_QMARK_.call(null,ret__$1)){
return cljs.core.deref.call(null,ret__$1);
} else {
var G__46977 = s__$1;
var G__46978 = ret__$1;
s = G__46977;
ret = G__46978;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = f.call(null,ret,cljs.core.first.call(null,s));
if(cljs.core.reduced_QMARK_.call(null,ret__$1)){
return cljs.core.deref.call(null,ret__$1);
} else {
var G__46985 = (function (){var or__5598__auto__ = cljs.core.next.call(null,s);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return self__.all;
}
})();
var G__46986 = ret__$1;
s = G__46985;
ret = G__46986;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first.call(null,coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"all","all",-1762306027,null),new cljs.core.Symbol(null,"prev","prev",43462301,null),cljs.core.with_meta(new cljs.core.Symbol(null,"current","current",552492924,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5718__auto__ = cljs.core.seq.call(null,coll);
if(temp__5718__auto__){
var vals = temp__5718__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.call(null,n,coll),cljs.core.drop.call(null,n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Repeat.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.Repeat.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var G__46991 = null;
var G__46991__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__46991__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__46991 = function(x,start){
switch(arguments.length){
case 1:
return G__46991__1.call(this,x);
case 2:
return G__46991__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46991.cljs$core$IFn$_invoke$arity$1 = G__46991__1;
G__46991.cljs$core$IFn$_invoke$arity$2 = G__46991__2;
return G__46991;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var G__46993 = null;
var G__46993__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,self__.count);
});
var G__46993__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__46993 = function(x,start){
switch(arguments.length){
case 1:
return G__46993__1.call(this,x);
case 2:
return G__46993__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__46993.cljs$core$IFn$_invoke$arity$1 = G__46993__1;
G__46993.cljs$core$IFn$_invoke$arity$2 = G__46993__2;
return G__46993;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = f.call(null,self__.val,self__.val);
while(true){
if(cljs.core.reduced_QMARK_.call(null,ret)){
return cljs.core.deref.call(null,ret);
} else {
var G__46994 = f.call(null,ret,self__.val);
ret = G__46994;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = f.call(null,ret,self__.val);
if(cljs.core.reduced_QMARK_.call(null,ret__$1)){
return cljs.core.deref.call(null,ret__$1);
} else {
var G__46995 = (i + (1));
var G__46996 = ret__$1;
i = G__46995;
ret = G__46996;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = f.call(null,start,self__.val);
while(true){
if(cljs.core.reduced_QMARK_.call(null,ret)){
return cljs.core.deref.call(null,ret);
} else {
var G__47002 = f.call(null,ret,self__.val);
ret = G__47002;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = f.call(null,ret,self__.val);
if(cljs.core.reduced_QMARK_.call(null,ret__$1)){
return cljs.core.deref.call(null,ret__$1);
} else {
var G__47003 = (i + (1));
var G__47004 = ret__$1;
i = G__47003;
ret = G__47004;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.Repeat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__43944 = arguments.length;
switch (G__43944) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.call(null,n,cljs.core.repeat.call(null,x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__43946 = arguments.length;
switch (G__43946) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,f.call(null),cljs.core.repeatedly.call(null,f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.call(null,n,cljs.core.repeatedly.call(null,f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest.call(null,coll__$1);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,rf){
var self__ = this;
var coll__$1 = this;
var first = cljs.core._first.call(null,coll__$1);
var v = self__.f.call(null,first);
var ret = rf.call(null,first,v);
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_.call(null,ret)){
return cljs.core.deref.call(null,ret);
} else {
var v__$2 = self__.f.call(null,v__$1);
var G__47019 = rf.call(null,ret,v__$2);
var G__47020 = v__$2;
ret = G__47019;
v__$1 = G__47020;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = cljs.core._first.call(null,coll__$1);
var ret = rf.call(null,start,v);
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_.call(null,ret)){
return cljs.core.deref.call(null,ret);
} else {
var v__$2 = self__.f.call(null,v__$1);
var G__47021 = rf.call(null,ret,v__$2);
var G__47022 = v__$2;
ret = G__47021;
v__$1 = G__47022;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = self__.f.call(null,self__.prev_seed));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,cljs.core._first.call(null,coll__$1),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"prev-seed","prev-seed",2126381367,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seed","seed",1709144854,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next","next",1522830042,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__43951 = arguments.length;
switch (G__43951) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___47024 = arguments.length;
var i__6921__auto___47025 = (0);
while(true){
if((i__6921__auto___47025 < len__6920__auto___47024)){
args_arr__6949__auto__.push((arguments[i__6921__auto___47025]));

var G__47026 = (i__6921__auto___47025 + (1));
i__6921__auto___47025 = G__47026;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6950__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq.call(null,c1);
var s2 = cljs.core.seq.call(null,c2);
if(((s1) && (s2))){
return cljs.core.cons.call(null,cljs.core.first.call(null,s1),cljs.core.cons.call(null,cljs.core.first.call(null,s2),cljs.core.interleave.call(null,cljs.core.rest.call(null,s1),cljs.core.rest.call(null,s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.call(null,cljs.core.seq,cljs.core.conj.call(null,colls,c2,c1));
if(cljs.core.every_QMARK_.call(null,cljs.core.identity,ss)){
return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,ss),cljs.core.apply.call(null,cljs.core.interleave,cljs.core.map.call(null,cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function (seq43948){
var G__43949 = cljs.core.first.call(null,seq43948);
var seq43948__$1 = cljs.core.next.call(null,seq43948);
var G__43950 = cljs.core.first.call(null,seq43948__$1);
var seq43948__$2 = cljs.core.next.call(null,seq43948__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43949,G__43950,seq43948__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__43953 = arguments.length;
switch (G__43953) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_.call(null,false);
return (function() {
var G__47034 = null;
var G__47034__0 = (function (){
return rf.call(null);
});
var G__47034__1 = (function (result){
return rf.call(null,result);
});
var G__47034__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref.call(null,started))){
var sepr = rf.call(null,result,sep);
if(cljs.core.reduced_QMARK_.call(null,sepr)){
return sepr;
} else {
return rf.call(null,sepr,input);
}
} else {
cljs.core.vreset_BANG_.call(null,started,true);

return rf.call(null,result,input);
}
});
G__47034 = function(result,input){
switch(arguments.length){
case 0:
return G__47034__0.call(this);
case 1:
return G__47034__1.call(this,result);
case 2:
return G__47034__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47034.cljs$core$IFn$_invoke$arity$0 = G__47034__0;
G__47034.cljs$core$IFn$_invoke$arity$1 = G__47034__1;
G__47034.cljs$core$IFn$_invoke$arity$2 = G__47034__2;
return G__47034;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.call(null,(1),cljs.core.interleave.call(null,cljs.core.repeat.call(null,sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5718__auto__ = cljs.core.seq.call(null,coll);
if(temp__5718__auto__){
var coll__$1 = temp__5718__auto__;
return cljs.core.cons.call(null,cljs.core.first.call(null,coll__$1),cljs$core$flatten1_$_cat.call(null,cljs.core.rest.call(null,coll__$1),colls__$1));
} else {
if(cljs.core.seq.call(null,colls__$1)){
return cljs$core$flatten1_$_cat.call(null,cljs.core.first.call(null,colls__$1),cljs.core.rest.call(null,colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat.call(null,null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__43957 = arguments.length;
switch (G__43957) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___47038 = arguments.length;
var i__6921__auto___47039 = (0);
while(true){
if((i__6921__auto___47039 < len__6920__auto___47038)){
args_arr__6949__auto__.push((arguments[i__6921__auto___47039]));

var G__47040 = (i__6921__auto___47039 + (1));
i__6921__auto___47039 = G__47040;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6950__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.call(null,cljs.core.map.call(null,f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.apply.call(null,cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function (seq43955){
var G__43956 = cljs.core.first.call(null,seq43955);
var seq43955__$1 = cljs.core.next.call(null,seq43955);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43956,seq43955__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__43959 = arguments.length;
switch (G__43959) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__47042 = null;
var G__47042__0 = (function (){
return rf.call(null);
});
var G__47042__1 = (function (result){
return rf.call(null,result);
});
var G__47042__2 = (function (result,input){
if(cljs.core.truth_(pred.call(null,input))){
return rf.call(null,result,input);
} else {
return result;
}
});
G__47042 = function(result,input){
switch(arguments.length){
case 0:
return G__47042__0.call(this);
case 1:
return G__47042__1.call(this,result);
case 2:
return G__47042__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47042.cljs$core$IFn$_invoke$arity$0 = G__47042__0;
G__47042.cljs$core$IFn$_invoke$arity$1 = G__47042__1;
G__47042.cljs$core$IFn$_invoke$arity$2 = G__47042__2;
return G__47042;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s)){
var c = cljs.core.chunk_first.call(null,s);
var size = cljs.core.count.call(null,c);
var b = cljs.core.chunk_buffer.call(null,size);
var n__6679__auto___47043 = size;
var i_47044 = (0);
while(true){
if((i_47044 < n__6679__auto___47043)){
if(cljs.core.truth_(pred.call(null,cljs.core._nth.call(null,c,i_47044)))){
cljs.core.chunk_append.call(null,b,cljs.core._nth.call(null,c,i_47044));
} else {
}

var G__47051 = (i_47044 + (1));
i_47044 = G__47051;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b),cljs.core.filter.call(null,pred,cljs.core.chunk_rest.call(null,s)));
} else {
var f = cljs.core.first.call(null,s);
var r = cljs.core.rest.call(null,s);
if(cljs.core.truth_(pred.call(null,f))){
return cljs.core.cons.call(null,f,cljs.core.filter.call(null,pred,r));
} else {
return cljs.core.filter.call(null,pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__43961 = arguments.length;
switch (G__43961) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.call(null,cljs.core.complement.call(null,pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.call(null,cljs.core.complement.call(null,pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,node,(cljs.core.truth_(branch_QMARK_.call(null,node))?cljs.core.mapcat.call(null,cljs$core$tree_seq_$_walk,children.call(null,node)):null));
}),null,null));
});
return walk.call(null,root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.call(null,(function (p1__43962_SHARP_){
return (!(cljs.core.sequential_QMARK_.call(null,p1__43962_SHARP_)));
}),cljs.core.rest.call(null,cljs.core.tree_seq.call(null,cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__43964 = arguments.length;
switch (G__43964) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta.call(null,cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,cljs.core._conj_BANG_,cljs.core.transient$.call(null,to),from)),cljs.core.meta.call(null,to));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.call(null,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta.call(null,cljs.core.persistent_BANG_.call(null,cljs.core.transduce.call(null,xform,cljs.core.conj_BANG_,cljs.core.transient$.call(null,to),from)),cljs.core.meta.call(null,to));
} else {
return cljs.core.transduce.call(null,xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__43973 = arguments.length;
switch (G__43973) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___47069 = arguments.length;
var i__6921__auto___47070 = (0);
while(true){
if((i__6921__auto___47070 < len__6920__auto___47069)){
args_arr__6949__auto__.push((arguments[i__6921__auto___47070]));

var G__47071 = (i__6921__auto___47070 + (1));
i__6921__auto___47070 = G__47071;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__6950__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (v,o){
return cljs.core.conj_BANG_.call(null,v,f.call(null,o));
}),cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.apply.call(null,cljs.core.map,f,c1,c2,c3,colls));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function (seq43968){
var G__43969 = cljs.core.first.call(null,seq43968);
var seq43968__$1 = cljs.core.next.call(null,seq43968);
var G__43970 = cljs.core.first.call(null,seq43968__$1);
var seq43968__$2 = cljs.core.next.call(null,seq43968__$1);
var G__43971 = cljs.core.first.call(null,seq43968__$2);
var seq43968__$3 = cljs.core.next.call(null,seq43968__$2);
var G__43972 = cljs.core.first.call(null,seq43968__$3);
var seq43968__$4 = cljs.core.next.call(null,seq43968__$3);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43969,G__43970,G__43971,G__43972,seq43968__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (v,o){
if(cljs.core.truth_(pred.call(null,o))){
return cljs.core.conj_BANG_.call(null,v,o);
} else {
return v;
}
}),cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__43975 = arguments.length;
switch (G__43975) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.call(null,n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.call(null,n,s);
if((n === cljs.core.count.call(null,p))){
return cljs.core.cons.call(null,p,cljs.core.partition.call(null,n,step,cljs.core.drop.call(null,step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var p = cljs.core.take.call(null,n,s);
if((n === cljs.core.count.call(null,p))){
return cljs.core.cons.call(null,p,cljs.core.partition.call(null,n,step,pad,cljs.core.drop.call(null,step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.call(null,n,cljs.core.concat.call(null,p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__43977 = arguments.length;
switch (G__43977) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.reduce.call(null,cljs.core.get,m,ks);
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq.call(null,ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.call(null,m__$1,cljs.core.first.call(null,ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__47087 = sentinel;
var G__47088 = m__$2;
var G__47089 = cljs.core.next.call(null,ks__$1);
sentinel = G__47087;
m__$1 = G__47088;
ks__$1 = G__47089;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__43978,v){
var vec__43979 = p__43978;
var seq__43980 = cljs.core.seq.call(null,vec__43979);
var first__43981 = cljs.core.first.call(null,seq__43980);
var seq__43980__$1 = cljs.core.next.call(null,seq__43980);
var k = first__43981;
var ks = seq__43980__$1;
if(ks){
return cljs.core.assoc.call(null,m,k,cljs.core.assoc_in.call(null,cljs.core.get.call(null,m,k),ks,v));
} else {
return cljs.core.assoc.call(null,m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__43990 = arguments.length;
switch (G__43990) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___47091 = arguments.length;
var i__6921__auto___47092 = (0);
while(true){
if((i__6921__auto___47092 < len__6920__auto___47091)){
args_arr__6949__auto__.push((arguments[i__6921__auto___47092]));

var G__47093 = (i__6921__auto___47092 + (1));
i__6921__auto___47092 = G__47093;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__6950__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__43991,f){
var vec__43992 = p__43991;
var seq__43993 = cljs.core.seq.call(null,vec__43992);
var first__43994 = cljs.core.first.call(null,seq__43993);
var seq__43993__$1 = cljs.core.next.call(null,seq__43993);
var k = first__43994;
var ks = seq__43993__$1;
if(ks){
return cljs.core.assoc.call(null,m,k,cljs.core.update_in.call(null,cljs.core.get.call(null,m,k),ks,f));
} else {
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__43995,f,a){
var vec__43996 = p__43995;
var seq__43997 = cljs.core.seq.call(null,vec__43996);
var first__43998 = cljs.core.first.call(null,seq__43997);
var seq__43997__$1 = cljs.core.next.call(null,seq__43997);
var k = first__43998;
var ks = seq__43997__$1;
if(ks){
return cljs.core.assoc.call(null,m,k,cljs.core.update_in.call(null,cljs.core.get.call(null,m,k),ks,f,a));
} else {
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),a));
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__43999,f,a,b){
var vec__44000 = p__43999;
var seq__44001 = cljs.core.seq.call(null,vec__44000);
var first__44002 = cljs.core.first.call(null,seq__44001);
var seq__44001__$1 = cljs.core.next.call(null,seq__44001);
var k = first__44002;
var ks = seq__44001__$1;
if(ks){
return cljs.core.assoc.call(null,m,k,cljs.core.update_in.call(null,cljs.core.get.call(null,m,k),ks,f,a,b));
} else {
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),a,b));
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__44003,f,a,b,c){
var vec__44004 = p__44003;
var seq__44005 = cljs.core.seq.call(null,vec__44004);
var first__44006 = cljs.core.first.call(null,seq__44005);
var seq__44005__$1 = cljs.core.next.call(null,seq__44005);
var k = first__44006;
var ks = seq__44005__$1;
if(ks){
return cljs.core.assoc.call(null,m,k,cljs.core.update_in.call(null,cljs.core.get.call(null,m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),a,b,c));
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__44007,f,a,b,c,args){
var vec__44008 = p__44007;
var seq__44009 = cljs.core.seq.call(null,vec__44008);
var first__44010 = cljs.core.first.call(null,seq__44009);
var seq__44009__$1 = cljs.core.next.call(null,seq__44009);
var k = first__44010;
var ks = seq__44009__$1;
if(ks){
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,cljs.core.update_in,cljs.core.get.call(null,m,k),ks,f,a,b,c,args));
} else {
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),a,b,c,args));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function (seq43983){
var G__43984 = cljs.core.first.call(null,seq43983);
var seq43983__$1 = cljs.core.next.call(null,seq43983);
var G__43985 = cljs.core.first.call(null,seq43983__$1);
var seq43983__$2 = cljs.core.next.call(null,seq43983__$1);
var G__43986 = cljs.core.first.call(null,seq43983__$2);
var seq43983__$3 = cljs.core.next.call(null,seq43983__$2);
var G__43987 = cljs.core.first.call(null,seq43983__$3);
var seq43983__$4 = cljs.core.next.call(null,seq43983__$3);
var G__43988 = cljs.core.first.call(null,seq43983__$4);
var seq43983__$5 = cljs.core.next.call(null,seq43983__$4);
var G__43989 = cljs.core.first.call(null,seq43983__$5);
var seq43983__$6 = cljs.core.next.call(null,seq43983__$5);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43984,G__43985,G__43986,G__43987,G__43988,G__43989,seq43983__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__44019 = arguments.length;
switch (G__44019) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___47108 = arguments.length;
var i__6921__auto___47109 = (0);
while(true){
if((i__6921__auto___47109 < len__6920__auto___47108)){
args_arr__6949__auto__.push((arguments[i__6921__auto___47109]));

var G__47110 = (i__6921__auto___47109 + (1));
i__6921__auto___47109 = G__47110;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__6950__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x));
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x,y));
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x,y,z));
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x,y,z,more));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function (seq44012){
var G__44013 = cljs.core.first.call(null,seq44012);
var seq44012__$1 = cljs.core.next.call(null,seq44012);
var G__44014 = cljs.core.first.call(null,seq44012__$1);
var seq44012__$2 = cljs.core.next.call(null,seq44012__$1);
var G__44015 = cljs.core.first.call(null,seq44012__$2);
var seq44012__$3 = cljs.core.next.call(null,seq44012__$2);
var G__44016 = cljs.core.first.call(null,seq44012__$3);
var seq44012__$4 = cljs.core.next.call(null,seq44012__$3);
var G__44017 = cljs.core.first.call(null,seq44012__$4);
var seq44012__$5 = cljs.core.next.call(null,seq44012__$4);
var G__44018 = cljs.core.first.call(null,seq44012__$5);
var seq44012__$6 = cljs.core.next.call(null,seq44012__$5);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44013,G__44014,G__44015,G__44016,G__44017,G__44018,seq44012__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone.call(null,node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node.call(null,edit);
var _ = cljs.core.pv_aset.call(null,r,(0),embed);
var G__47124 = (ll - (5));
var G__47125 = r;
ll = G__47124;
ret = G__47125;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node.call(null,parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset.call(null,ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget.call(null,parent,subidx);
if((!((child == null)))){
var node_to_insert = cljs.core.push_tail.call(null,pv,(level - (5)),child,tailnode);
cljs.core.pv_aset.call(null,ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path.call(null,null,(level - (5)),tailnode);
cljs.core.pv_aset.call(null,ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__47126 = cljs.core.pv_aget.call(null,node,(0));
var G__47127 = (level - (5));
node = G__47126;
level = G__47127;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off.call(null,pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__47132 = cljs.core.pv_aget.call(null,node,((i >>> level) & (31)));
var G__47133 = (level - (5));
node = G__47132;
level = G__47133;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for.call(null,pv,i);
} else {
return cljs.core.vector_index_out_of_bounds.call(null,i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node.call(null,node);
if((level === (0))){
cljs.core.pv_aset.call(null,ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset.call(null,ret,subidx,cljs.core.do_assoc.call(null,pv,(level - (5)),cljs.core.pv_aget.call(null,node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs.core.pop_tail.call(null,pv,(level - (5)),cljs.core.pv_aget.call(null,node,subidx));
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node.call(null,node);
cljs.core.pv_aset.call(null,ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node.call(null,node);
cljs.core.pv_aset.call(null,ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for.call(null,self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count.call(null,v)))?cljs.core.unchecked_array_for.call(null,v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__44021 = arguments.length;
switch (G__44021) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function (pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.call(null,pv,f,cljs.core.nth.call(null,pv,start),(start + (1)),end);
} else {
return f.call(null);
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function (pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for.call(null,pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for.call(null,pv,i):arr);
var nacc = f.call(null,acc,(arr__$1[j]));
if(cljs.core.reduced_QMARK_.call(null,nacc)){
return cljs.core.deref.call(null,nacc);
} else {
var G__47149 = nacc;
var G__47150 = (i + (1));
var G__47151 = arr__$1;
acc = G__47149;
i = G__47150;
arr = G__47151;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);








/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for.call(null,coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__47154 = null;
var G__47154__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47154__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47154 = function(x,start){
switch(arguments.length){
case 1:
return G__47154__1.call(this,x);
case 2:
return G__47154__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47154.cljs$core$IFn$_invoke$arity$1 = G__47154__1;
G__47154.cljs$core$IFn$_invoke$arity$2 = G__47154__2;
return G__47154;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__47157 = null;
var G__47157__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47157__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47157 = function(x,start){
switch(arguments.length){
case 1:
return G__47157__1.call(this,x);
case 2:
return G__47157__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47157.cljs$core$IFn$_invoke$arity$1 = G__47157__1;
G__47157.cljs$core$IFn$_invoke$arity$2 = G__47157__2;
return G__47157;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.call(null,coll__$1,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for.call(null,v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = f.call(null,init__$2,(j + i),(arr[j]));
if(cljs.core.reduced_QMARK_.call(null,init__$3)){
return init__$3;
} else {
var G__47163 = (j + (1));
var G__47164 = init__$3;
j = G__47163;
init__$2 = G__47164;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return cljs.core.deref.call(null,init__$2);
} else {
var G__47165 = (i + len);
var G__47166 = init__$2;
i = G__47165;
init__$1 = G__47166;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for.call(null,coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for.call(null,coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off.call(null,coll__$1) <= n)){
var new_tail = cljs.core.aclone.call(null,self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc.call(null,coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj.call(null,coll__$1,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator.call(null,this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.call(null,coll__$1,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta.call(null,cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off.call(null,coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for.call(null,coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail.call(null,coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget.call(null,new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget.call(null,new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count.call(null,other))){
var me_iter = cljs.core._iterator.call(null,coll__$1);
var you_iter = cljs.core._iterator.call(null,other);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.call(null,x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root.call(null,self__.root),cljs.core.tv_editable_tail.call(null,self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.call(null,v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for.call(null,v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = f.call(null,init__$2,(arr[j]));
if(cljs.core.reduced_QMARK_.call(null,init__$3)){
return init__$3;
} else {
var G__47175 = (j + (1));
var G__47176 = init__$3;
j = G__47175;
init__$2 = G__47176;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return cljs.core.deref.call(null,init__$2);
} else {
var G__47177 = (i + len);
var G__47178 = init__$2;
i = G__47177;
init__$1 = G__47178;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n.call(null,coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_.call(null,k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.call(null,coll__$1,cljs.core.first_array_for_longvec.call(null,coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off.call(null,coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__6679__auto___47184 = len;
var i_47185 = (0);
while(true){
if((i_47185 < n__6679__auto___47184)){
(new_tail[i_47185] = (self__.tail[i_47185]));

var G__47186 = (i_47185 + (1));
i_47185 = G__47186;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node.call(null,null);
cljs.core.pv_aset.call(null,n_r,(0),self__.root);

cljs.core.pv_aset.call(null,n_r,(1),cljs.core.new_path.call(null,null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail.call(null,coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function() {
var G__47187 = null;
var G__47187__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._nth.call(null,coll,k);
});
var G__47187__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._nth.call(null,coll,k,not_found);
});
G__47187 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47187__2.call(this,self__,k);
case 3:
return G__47187__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47187.cljs$core$IFn$_invoke$arity$2 = G__47187__2;
G__47187.cljs$core$IFn$_invoke$arity$3 = G__47187__3;
return G__47187;
})()
);

(cljs.core.PersistentVector.prototype.apply = (function (self__,args44022){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44022)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._nth.call(null,coll,k);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._nth.call(null,coll,k,not_found);
}));

(cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone.call(null,xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = cljs.core._as_transient.call(null,v);
while(true){
if((i < l)){
var G__47208 = (i + (1));
var G__47209 = cljs.core.conj_BANG_.call(null,out,(xs__$1[i]));
i = G__47208;
out = G__47209;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,out);
}
break;
}
}
}));
goog.object.set(cljs.core.PersistentVector.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.truth_(cljs.core.map_entry_QMARK_.call(null,coll))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key.call(null,coll),cljs.core.val.call(null,coll)], null);
} else {
if(cljs.core.vector_QMARK_.call(null,coll)){
return cljs.core.with_meta.call(null,coll,null);
} else {
if(cljs.core.array_QMARK_.call(null,coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_.call(null,cljs.core.reduce.call(null,cljs.core._conj_BANG_,cljs.core._as_transient.call(null,cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__6930__auto__ = [];
var len__6920__auto___47214 = arguments.length;
var i__6921__auto___47215 = (0);
while(true){
if((i__6921__auto___47215 < len__6920__auto___47214)){
args__6930__auto__.push((arguments[i__6921__auto___47215]));

var G__47216 = (i__6921__auto___47215 + (1));
i__6921__auto___47215 = G__47216;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_.call(null,args.arr))));
} else {
return cljs.core.vec.call(null,args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function (seq44023){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44023));
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__47217 = null;
var G__47217__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47217__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47217 = function(x,start){
switch(arguments.length){
case 1:
return G__47217__1.call(this,x);
case 2:
return G__47217__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47217.cljs$core$IFn$_invoke$arity$1 = G__47217__1;
G__47217.cljs$core$IFn$_invoke$arity$2 = G__47217__2;
return G__47217;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__47221 = null;
var G__47221__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47221__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47221 = function(x,start){
switch(arguments.length){
case 1:
return G__47221__1.call(this,x);
case 2:
return G__47221__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47221.cljs$core$IFn$_invoke$arity$1 = G__47221__1;
G__47221.cljs$core$IFn$_invoke$arity$2 = G__47221__2;
return G__47221;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next.call(null,coll__$1);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.call(null,self__.vec,f,(self__.i + self__.off),cljs.core.count.call(null,self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.call(null,self__.vec,f,start,(self__.i + self__.off),cljs.core.count.call(null,self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest.call(null,coll__$1);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.call(null,self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count.call(null,self__.vec))){
return cljs.core.chunked_seq.call(null,self__.vec,cljs.core.unchecked_array_for.call(null,self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count.call(null,self__.vec))){
return cljs.core.chunked_seq.call(null,self__.vec,cljs.core.unchecked_array_for.call(null,self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

goog.object.set(cljs.core.ChunkedSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__44025 = arguments.length;
switch (G__44025) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for.call(null,vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.call(null,self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var G__47248 = null;
var G__47248__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47248__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start__$1);
});
G__47248 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__47248__1.call(this,x);
case 2:
return G__47248__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47248.cljs$core$IFn$_invoke$arity$1 = G__47248__1;
G__47248.cljs$core$IFn$_invoke$arity$2 = G__47248__2;
return G__47248;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__47249 = null;
var G__47249__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47249__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start__$1);
});
G__47249 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__47249__1.call(this,x);
case 2:
return G__47249__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47249.cljs$core$IFn$_invoke$arity$1 = G__47249__1;
G__47249.cljs$core$IFn$_invoke$arity$2 = G__47249__2;
return G__47249;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.call(null,coll__$1,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = f.call(null,init__$1,j,cljs.core._nth.call(null,self__.v,i));
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return cljs.core.deref.call(null,init__$2);
} else {
var G__47251 = (i + (1));
var G__47252 = (j + (1));
var G__47253 = init__$2;
i = G__47251;
j = G__47252;
init__$1 = G__47253;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds.call(null,n,(self__.end - self__.start));
} else {
return cljs.core._nth.call(null,self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.call(null,self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core._count.call(null,coll__$1)),"]"].join('')));
} else {
return cljs.core.build_subvec.call(null,self__.meta,cljs.core.assoc.call(null,self__.v,v_pos,val),self__.start,(function (){var x__5956__auto__ = self__.end;
var y__5957__auto__ = (v_pos + (1));
return ((x__5956__auto__ > y__5957__auto__) ? x__5956__auto__ : y__5957__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator.call(null,self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter.call(null,coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.call(null,self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec.call(null,self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.call(null,self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.call(null,coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.call(null,self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.call(null,coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n.call(null,coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons.call(null,cljs.core._nth.call(null,self__.v,i),(new cljs.core.LazySeq(null,(function (){
return cljs$core$subvec_seq.call(null,(i + (1)));
}),null,null)));
}
});
return subvec_seq.call(null,self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec.call(null,new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec.call(null,self__.meta,cljs.core._assoc_n.call(null,self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var G__47262 = null;
var G__47262__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._nth.call(null,coll,k);
});
var G__47262__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._nth.call(null,coll,k,not_found);
});
G__47262 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47262__2.call(this,self__,k);
case 3:
return G__47262__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47262.cljs$core$IFn$_invoke$arity$2 = G__47262__2;
G__47262.cljs$core$IFn$_invoke$arity$3 = G__47262__3;
return G__47262;
})()
);

(cljs.core.Subvec.prototype.apply = (function (self__,args44026){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44026)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._nth.call(null,coll,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._nth.call(null,coll,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

goog.object.set(cljs.core.Subvec.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__47267 = meta;
var G__47268 = v.v;
var G__47269 = (v.start + start);
var G__47270 = (v.start + end);
var G__47271 = __hash;
meta = G__47267;
v = G__47268;
start = G__47269;
end = G__47270;
__hash = G__47271;
continue;
} else {
if(cljs.core.vector_QMARK_.call(null,v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((end < start)) || ((end > cljs.core.count.call(null,v))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__44031 = arguments.length;
switch (G__44031) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.call(null,v,start,cljs.core.count.call(null,v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec.call(null,null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone.call(null,node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone.call(null,node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy.call(null,tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable.call(null,tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset.call(null,ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget.call(null,ret,subidx);
if((!((child == null)))){
return cljs.core.tv_push_tail.call(null,tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path.call(null,tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable.call(null,tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs.core.tv_pop_tail.call(null,tv,(level - (5)),cljs.core.pv_aget.call(null,node__$1,subidx));
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset.call(null,node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset.call(null,node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off.call(null,tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__47281 = cljs.core.tv_ensure_editable.call(null,root.edit,cljs.core.pv_aget.call(null,node,((i >>> level) & (31))));
var G__47282 = (level - (5));
node = G__47281;
level = G__47282;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off.call(null,tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path.call(null,self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail.call(null,tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off.call(null,tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy.call(null,self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_.call(null,tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off.call(null,tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable.call(null,self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset.call(null,node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset.call(null,node__$1,subidx,cljs$core$go.call(null,(level - (5)),cljs.core.pv_aget.call(null,node__$1,subidx)));

return node__$1;
}
}).call(null,self__.shift,self__.root);
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_.call(null,tcoll__$1,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for.call(null,tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail.call(null,tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget.call(null,new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable.call(null,self__.root.edit,cljs.core.pv_aget.call(null,new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for.call(null,coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return cljs.core._nth.call(null,coll__$1,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return cljs.core._nth.call(null,coll__$1,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var G__47304 = null;
var G__47304__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__47304__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__47304 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47304__2.call(this,self__,k);
case 3:
return G__47304__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47304.cljs$core$IFn$_invoke$arity$2 = G__47304__2;
G__47304.cljs$core$IFn$_invoke$arity$3 = G__47304__3;
return G__47304;
})()
);

(cljs.core.TransientVector.prototype.apply = (function (self__,args44034){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44034)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__5598__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq.call(null,self__.fseq)));
if(or__5598__auto__){
return or__5598__auto__;
} else {
if((!((self__.riter == null)))){
return self__.riter.hasNext();
} else {
return false;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first.call(null,self__.fseq);
(self__.fseq = cljs.core.next.call(null,self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__47314 = null;
var G__47314__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47314__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47314 = function(x,start){
switch(arguments.length){
case 1:
return G__47314__1.call(this,x);
case 2:
return G__47314__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47314.cljs$core$IFn$_invoke$arity$1 = G__47314__1;
G__47314.cljs$core$IFn$_invoke$arity$2 = G__47314__2;
return G__47314;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__47315 = null;
var G__47315__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47315__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47315 = function(x,start){
switch(arguments.length){
case 1:
return G__47315__1.call(this,x);
case 2:
return G__47315__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47315.cljs$core$IFn$_invoke$arity$1 = G__47315__1;
G__47315.cljs$core$IFn$_invoke$arity$2 = G__47315__2;
return G__47315;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next.call(null,self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first.call(null,self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core.next.call(null,self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty.call(null,coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

goog.object.set(cljs.core.PersistentQueueSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__47330 = null;
var G__47330__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47330__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47330 = function(x,start){
switch(arguments.length){
case 1:
return G__47330__1.call(this,x);
case 2:
return G__47330__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47330.cljs$core$IFn$_invoke$arity$1 = G__47330__1;
G__47330.cljs$core$IFn$_invoke$arity$2 = G__47330__2;
return G__47330;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__47331 = null;
var G__47331__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,self__.count.call(null,coll));
});
var G__47331__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47331 = function(x,start){
switch(arguments.length){
case 1:
return G__47331__1.call(this,x);
case 2:
return G__47331__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47331.cljs$core$IFn$_invoke$arity$1 = G__47331__1;
G__47331.cljs$core$IFn$_invoke$arity$2 = G__47331__2;
return G__47331;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator.call(null,self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first.call(null,self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5718__auto__ = cljs.core.next.call(null,self__.front);
if(temp__5718__auto__){
var f1 = temp__5718__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq.call(null,self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first.call(null,self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest.call(null,cljs.core.seq.call(null,coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq.call(null,self__.rear);
if(cljs.core.truth_((function (){var or__5598__auto__ = self__.front;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq.call(null,rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.call(null,(function (){var or__5598__auto__ = self__.rear;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.call(null,self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
goog.object.set(cljs.core.PersistentQueue.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$.call(null,((((cljs.core.map_QMARK_.call(null,y)) && ((!(cljs.core.record_QMARK_.call(null,y))))))?(((cljs.core.count.call(null,x) === cljs.core.count.call(null,y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IKVReduce,x)))?cljs.core.reduce_kv.call(null,(function (_,k,v){
if(cljs.core._EQ_.call(null,cljs.core.get.call(null,y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced.call(null,false);
}
}),true,x):cljs.core.every_QMARK_.call(null,(function (xkv){
return cljs.core._EQ_.call(null,cljs.core.get.call(null,y,cljs.core.first.call(null,xkv),cljs.core.never_equiv),cljs.core.second.call(null,xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__47341 = (i + incr);
i = G__47341;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash.call(null,a);
var b__$1 = cljs.core.hash.call(null,b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta.call(null,m);
var i = (0);
var out = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__47342 = (i + (1));
var G__47343 = cljs.core.assoc_BANG_.call(null,out,k__$1,goog.object.get(so,k__$1));
i = G__47342;
out = G__47343;
continue;
} else {
return cljs.core._with_meta.call(null,cljs.core.persistent_BANG_.call(null,cljs.core.assoc_BANG_.call(null,out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_47344 = (0);
while(true){
if((i_47344 < l)){
var k_47345 = (ks[i_47344]);
goog.object.set(new_obj,k_47345,goog.object.get(obj,k_47345));

var G__47346 = (i_47344 + (1));
i_47344 = G__47346;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array.call(null,(1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array.call(null,(1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq.call(null,keys__$1)){
var k = cljs.core.first.call(null,keys__$1);
var init__$2 = f.call(null,init__$1,k,(self__.strobj[k]));
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return cljs.core.deref.call(null,init__$2);
} else {
var G__47347 = cljs.core.rest.call(null,keys__$1);
var G__47348 = init__$2;
keys__$1 = G__47347;
init__$1 = G__47348;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_unordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map.call(null,coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$.call(null,cljs.core.into.call(null,cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array.call(null,(1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone.call(null,self__.keys);
var new_strobj = cljs.core.obj_clone.call(null,self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array.call(null,(1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map.call(null,coll__$1,k,v);
} else {
if((!((cljs.core.scan_array.call(null,(1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone.call(null,self__.strobj,self__.keys);
goog.object.set(new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone.call(null,self__.strobj,self__.keys);
var new_keys = cljs.core.aclone.call(null,self__.keys);
goog.object.set(new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map.call(null,coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((goog.isString(k)) && ((!((cljs.core.scan_array.call(null,(1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.call(null,(function (p1__44038_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__44038_SHARP_,(self__.strobj[p1__44038_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,coll__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var G__47362 = null;
var G__47362__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__47362__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__47362 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47362__2.call(this,self__,k);
case 3:
return G__47362__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47362.cljs$core$IFn$_invoke$arity$2 = G__47362__2;
G__47362.cljs$core$IFn$_invoke$arity$3 = G__47362__3;
return G__47362;
})()
);

(cljs.core.ObjMap.prototype.apply = (function (self__,args44039){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44039)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__5598__auto__ = (self__.i < self__.base_count);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.call(null,self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.call(null,self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__44042 = cljs.core.first.call(null,self__.s);
var k = cljs.core.nth.call(null,vec__44042,(0),null);
var v = cljs.core.nth.call(null,vec__44042,(1),null);
(self__.s = cljs.core.next.call(null,self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq.call(null,coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first.call(null,self__.s);
(self__.s = cljs.core.next.call(null,self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq.call(null,coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__47397 = (i + (2));
i = G__47397;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__47399 = (i + (2));
i = G__47399;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__47400 = (i + (2));
i = G__47400;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__47401 = (i + (2));
i = G__47401;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.call(null,k,(arr[i]))){
return i;
} else {
var G__47403 = (i + (2));
i = G__47403;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_.call(null,arr,k);
} else {
if(((goog.isString(k)) || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_.call(null,arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_.call(null,arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_.call(null,arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_.call(null,arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of.call(null,m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_47404 = (0);
while(true){
if((i_47404 < l)){
(narr[i_47404] = (arr[i_47404]));

var G__47405 = (i_47404 + (1));
i_47404 = G__47405;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv.call(null,m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__44046 = k;
switch (G__44046) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var G__47407 = null;
var G__47407__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47407__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47407 = function(x,start){
switch(arguments.length){
case 1:
return G__47407__1.call(this,x);
case 2:
return G__47407__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47407.cljs$core$IFn$_invoke$arity$1 = G__47407__1;
G__47407.cljs$core$IFn$_invoke$arity$2 = G__47407__2;
return G__47407;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var G__47408 = null;
var G__47408__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47408__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47408 = function(x,start){
switch(arguments.length){
case 1:
return G__47408__1.call(this,x);
case 2:
return G__47408__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47408.cljs$core$IFn$_invoke$arity$1 = G__47408__1;
G__47408.cljs$core$IFn$_invoke$arity$2 = G__47408__2;
return G__47408;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.call(null,node__$1,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.call(null,node__$1,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return cljs.core._assoc_n.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var G__47413 = null;
var G__47413__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return cljs.core._nth.call(null,node,k);
});
var G__47413__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return cljs.core._nth.call(null,node,k,not_found);
});
G__47413 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47413__2.call(this,self__,k);
case 3:
return G__47413__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47413.cljs$core$IFn$_invoke$arity$2 = G__47413__2;
G__47413.cljs$core$IFn$_invoke$arity$3 = G__47413__3;
return G__47413;
})()
);

(cljs.core.MapEntry.prototype.apply = (function (self__,args44045){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44045)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return cljs.core._nth.call(null,node,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return cljs.core._nth.call(null,node,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__47423 = null;
var G__47423__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47423__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47423 = function(x,start){
switch(arguments.length){
case 1:
return G__47423__1.call(this,x);
case 2:
return G__47423__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47423.cljs$core$IFn$_invoke$arity$1 = G__47423__1;
G__47423.cljs$core$IFn$_invoke$arity$2 = G__47423__2;
return G__47423;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__47425 = null;
var G__47425__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47425__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47425 = function(x,start){
switch(arguments.length){
case 1:
return G__47425__1.call(this,x);
case 2:
return G__47425__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47425.cljs$core$IFn$_invoke$arity$1 = G__47425__1;
G__47425.cljs$core$IFn$_invoke$arity$2 = G__47425__2;
return G__47425;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll.call(null,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

goog.object.set(cljs.core.PersistentArrayMapSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of.call(null,coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.keys.call(null,coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.vals.call(null,coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_.call(null,coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44049 = cljs.core.seq.call(null,coll);
var chunk__44050 = null;
var count__44051 = (0);
var i__44052 = (0);
while(true){
if((i__44052 < count__44051)){
var vec__44059 = cljs.core._nth.call(null,chunk__44050,i__44052);
var k = cljs.core.nth.call(null,vec__44059,(0),null);
var v = cljs.core.nth.call(null,vec__44059,(1),null);
f.call(null,v,k);


var G__47458 = seq__44049;
var G__47459 = chunk__44050;
var G__47460 = count__44051;
var G__47461 = (i__44052 + (1));
seq__44049 = G__47458;
chunk__44050 = G__47459;
count__44051 = G__47460;
i__44052 = G__47461;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__44049);
if(temp__5720__auto__){
var seq__44049__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44049__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__44049__$1);
var G__47465 = cljs.core.chunk_rest.call(null,seq__44049__$1);
var G__47466 = c__6568__auto__;
var G__47467 = cljs.core.count.call(null,c__6568__auto__);
var G__47468 = (0);
seq__44049 = G__47465;
chunk__44050 = G__47466;
count__44051 = G__47467;
i__44052 = G__47468;
continue;
} else {
var vec__44062 = cljs.core.first.call(null,seq__44049__$1);
var k = cljs.core.nth.call(null,vec__44062,(0),null);
var v = cljs.core.nth.call(null,vec__44062,(1),null);
f.call(null,v,k);


var G__47470 = cljs.core.next.call(null,seq__44049__$1);
var G__47471 = null;
var G__47472 = (0);
var G__47473 = (0);
seq__44049 = G__47470;
chunk__44050 = G__47471;
count__44051 = G__47472;
i__44052 = G__47473;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of.call(null,coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = f.call(null,init__$1,(self__.arr[i]),(self__.arr[(i + (1))]));
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return cljs.core.deref.call(null,init__$2);
} else {
var G__47475 = (i + (2));
var G__47476 = init__$2;
i = G__47475;
init__$1 = G__47476;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_unordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_.call(null,other)) && ((!(cljs.core.record_QMARK_.call(null,other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === cljs.core._count.call(null,other__$1))){
var i = (0);
while(true){
if((i < alen)){
var v = cljs.core._lookup.call(null,other__$1,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.call(null,(self__.arr[(i + (1))]),v)){
var G__47478 = (i + (2));
i = G__47478;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone.call(null,self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.call(null,coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.call(null,coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of.call(null,coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty.call(null,coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.call(null,k,(self__.arr[s]))){
var G__47481 = (s + (2));
var G__47482 = d;
s = G__47481;
d = G__47482;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__47489 = (s + (2));
var G__47490 = (d + (2));
s = G__47489;
d = G__47490;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of.call(null,coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv.call(null,coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta.call(null,cljs.core._assoc.call(null,cljs.core.into.call(null,cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__44067 = cljs.core.aclone.call(null,self__.arr);
(G__44067[(idx + (1))] = v);

return G__44067;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of.call(null,coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq.call(null,self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,coll__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq.call(null,entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first.call(null,es);
if(cljs.core.vector_QMARK_.call(null,e)){
var G__47502 = cljs.core._assoc.call(null,ret,cljs.core._nth.call(null,e,(0)),cljs.core._nth.call(null,e,(1)));
var G__47503 = cljs.core.next.call(null,es);
ret = G__47502;
es = G__47503;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__47505 = null;
var G__47505__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__47505__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__47505 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47505__2.call(this,self__,k);
case 3:
return G__47505__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47505.cljs$core$IFn$_invoke$arity$2 = G__47505__2;
G__47505.cljs$core$IFn$_invoke$arity$3 = G__47505__3;
return G__47505;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args44048){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44048)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone.call(null,arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_47514 = (0);
while(true){
if((i_47514 < arr__$1.length)){
var k_47516 = (arr__$1[i_47514]);
var v_47517 = (arr__$1[(i_47514 + (1))]);
var idx_47518 = cljs.core.array_index_of.call(null,ret,k_47516);
if((idx_47518 === (-1))){
ret.push(k_47516);

ret.push(v_47517);
} else {
}

var G__47522 = (i_47514 + (2));
i_47514 = G__47522;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function (arr){
var ret = [];
var i_47523 = (0);
while(true){
if((i_47523 < arr.length)){
var k_47524 = (arr[i_47523]);
var v_47525 = (arr[(i_47523 + (1))]);
var idx_47526 = cljs.core.array_index_of.call(null,ret,k_47524);
if((idx_47526 === (-1))){
var G__44068_47527 = ret;
G__44068_47527.push(k_47524);

G__44068_47527.push(v_47525);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_47524)].join('')));
}

var G__47528 = (i_47523 + (2));
i_47523 = G__47528;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function (arr){
var ret = [];
var i_47530 = (0);
while(true){
if((i_47530 < arr.length)){
var k_47531 = (arr[i_47530]);
var v_47532 = (arr[(i_47530 + (1))]);
var idx_47533 = cljs.core.array_index_of.call(null,ret,k_47531);
if((idx_47533 === (-1))){
var G__44069_47534 = ret;
G__44069_47534.push(k_47531);

G__44069_47534.push(v_47532);

} else {
(ret[(idx_47533 + (1))] = v_47532);
}

var G__47535 = (i_47530 + (2));
i_47530 = G__47535;
continue;
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(ret.length / (2)),ret,null));
}));
goog.object.set(cljs.core.PersistentArrayMap.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot.call(null,self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.call(null,tcoll__$1,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of.call(null,tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_.call(null,o)){
return cljs.core._assoc_BANG_.call(null,tcoll__$1,cljs.core.key.call(null,o),cljs.core.val.call(null,o));
} else {
if(cljs.core.vector_QMARK_.call(null,o)){
return cljs.core._assoc_BANG_.call(null,tcoll__$1,o.call(null,(0)),o.call(null,(1)));
} else {
var es = cljs.core.seq.call(null,o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5718__auto__ = cljs.core.first.call(null,es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__47538 = cljs.core.next.call(null,es);
var G__47539 = cljs.core._assoc_BANG_.call(null,tcoll__$2,cljs.core.key.call(null,e),cljs.core.val.call(null,e));
es = G__47538;
tcoll__$2 = G__47539;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot.call(null,self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of.call(null,tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.call(null,cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of.call(null,tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__44071_47546 = self__.arr;
G__44071_47546.pop();

G__44071_47546.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var G__47547 = null;
var G__47547__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return cljs.core._lookup.call(null,tcoll,key,null);
});
var G__47547__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return cljs.core._lookup.call(null,tcoll,key,not_found);
});
G__47547 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return G__47547__2.call(this,self__,key);
case 3:
return G__47547__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47547.cljs$core$IFn$_invoke$arity$2 = G__47547__2;
G__47547.cljs$core$IFn$_invoke$arity$3 = G__47547__3;
return G__47547;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function (self__,args44070){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44070)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return cljs.core._lookup.call(null,tcoll,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return cljs.core._lookup.call(null,tcoll,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__47555 = cljs.core.assoc_BANG_.call(null,out,(arr[i]),(arr[(i + (1))]));
var G__47556 = (i + (2));
out = G__47555;
i = G__47556;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_.call(null,key,other)){
return true;
} else {
return cljs.core._EQ_.call(null,key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__44073 = arguments.length;
switch (G__44073) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__44074 = cljs.core.aclone.call(null,arr);
(G__44074[i] = a);

return G__44074;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__44075 = cljs.core.aclone.call(null,arr);
(G__44075[i] = a);

(G__44075[j] = b);

return G__44075;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy.call(null,arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy.call(null,arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count.call(null,(bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__44077 = arguments.length;
switch (G__44077) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
return f.call(null,init__$1,k,(arr[(i + (1))]));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return init__$2;
} else {
var G__47580 = (i + (2));
var G__47581 = init__$2;
i = G__47580;
init__$1 = G__47581;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator.call(null,node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__5598__auto__ = (!((self__.next_entry == null)));
if(or__5598__auto__){
return or__5598__auto__;
} else {
var or__5598__auto____$1 = (!((self__.next_iter == null)));
if(or__5598__auto____$1){
return or__5598__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count.call(null,self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy.call(null,self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index.call(null,self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.call(null,inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test.call(null,key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy.call(null,earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.call(null,self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce.call(null,self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index.call(null,self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test.call(null,key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index.call(null,self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count.call(null,self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward.call(null,earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_47597 = (0);
var j_47598 = (0);
while(true){
if((i_47597 < (32))){
if((((self__.bitmap >>> i_47597) & (1)) === (0))){
var G__47599 = (i_47597 + (1));
var G__47600 = j_47598;
i_47597 = G__47599;
j_47598 = G__47600;
continue;
} else {
(nodes[i_47597] = (((!(((self__.arr[j_47598]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash.call(null,(self__.arr[j_47598])),(self__.arr[j_47598]),(self__.arr[(j_47598 + (1))]),added_leaf_QMARK_):(self__.arr[(j_47598 + (1))])));

var G__47602 = (i_47597 + (1));
var G__47603 = (j_47598 + (2));
i_47597 = G__47602;
j_47598 = G__47603;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy.call(null,self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy.call(null,self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.call(null,inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test.call(null,key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.call(null,inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.call(null,inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.call(null,edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index.call(null,self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count.call(null,self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_47616 = (0);
var j_47617 = (0);
while(true){
if((i_47616 < (32))){
if((((self__.bitmap >>> i_47616) & (1)) === (0))){
var G__47618 = (i_47616 + (1));
var G__47619 = j_47617;
i_47616 = G__47618;
j_47617 = G__47619;
continue;
} else {
(nodes[i_47616] = (((!(((self__.arr[j_47617]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash.call(null,(self__.arr[j_47617])),(self__.arr[j_47617]),(self__.arr[(j_47617 + (1))]),added_leaf_QMARK_):(self__.arr[(j_47617 + (1))])));

var G__47620 = (i_47616 + (1));
var G__47621 = (j_47617 + (2));
i_47616 = G__47620;
j_47617 = G__47621;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy.call(null,self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy.call(null,self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.call(null,self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test.call(null,key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.call(null,self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.call(null,self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.call(null,(shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index.call(null,self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test.call(null,key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index.call(null,self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.call(null,self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair.call(null,self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test.call(null,key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair.call(null,self__.arr,idx)));
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__47647 = (i + (1));
var G__47648 = (j + (2));
var G__47649 = (bitmap | ((1) << i));
i = G__47647;
j = G__47648;
bitmap = G__47649;
continue;
} else {
var G__47650 = (i + (1));
var G__47651 = j;
var G__47652 = bitmap;
i = G__47650;
j = G__47651;
bitmap = G__47652;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator.call(null,node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone.call(null,self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node.call(null,inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.call(null,inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.call(null,inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.call(null,self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return init__$2;
} else {
var G__47658 = (i + (1));
var G__47659 = init__$2;
i = G__47658;
init__$1 = G__47659;
continue;
}
} else {
var G__47660 = (i + (1));
var G__47661 = init__$1;
i = G__47660;
init__$1 = G__47661;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.call(null,inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.call(null,inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.call(null,self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.call(null,self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node.call(null,inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.call(null,self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.call(null,self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test.call(null,key,(arr[i]))){
return i;
} else {
var G__47664 = (i + (2));
i = G__47664;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy.call(null,self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index.call(null,self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.call(null,self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce.call(null,self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index.call(null,self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test.call(null,key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index.call(null,self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.call(null,inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy.call(null,self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.call(null,inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index.call(null,self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy.call(null,self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.call(null,(self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.call(null,self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index.call(null,self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test.call(null,key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index.call(null,self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair.call(null,self__.arr,cljs.core.quot.call(null,idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__44079 = arguments.length;
switch (G__44079) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash.call(null,key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash.call(null,key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__47676 = null;
var G__47676__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47676__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47676 = function(x,start){
switch(arguments.length){
case 1:
return G__47676__1.call(this,x);
case 2:
return G__47676__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47676.cljs$core$IFn$_invoke$arity$1 = G__47676__1;
G__47676.cljs$core$IFn$_invoke$arity$2 = G__47676__2;
return G__47676;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__47677 = null;
var G__47677__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47677__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47677 = function(x,start){
switch(arguments.length){
case 1:
return G__47677__1.call(this,x);
case 2:
return G__47677__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47677.cljs$core$IFn$_invoke$arity$1 = G__47677__1;
G__47677.cljs$core$IFn$_invoke$arity$2 = G__47677__2;
return G__47677;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.call(null,self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.call(null,self__.nodes,self__.i,cljs.core.next.call(null,self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first.call(null,self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.call(null,self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.call(null,self__.nodes,self__.i,cljs.core.next.call(null,self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

goog.object.set(cljs.core.NodeSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__44081 = arguments.length;
switch (G__44081) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.call(null,nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5718__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5718__auto__)){
var node = temp__5718__auto__;
var temp__5718__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var node_seq = temp__5718__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__47684 = (j + (2));
j = G__47684;
continue;
}
} else {
var G__47685 = (j + (2));
j = G__47685;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__47686 = null;
var G__47686__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47686__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47686 = function(x,start){
switch(arguments.length){
case 1:
return G__47686__1.call(this,x);
case 2:
return G__47686__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47686.cljs$core$IFn$_invoke$arity$1 = G__47686__1;
G__47686.cljs$core$IFn$_invoke$arity$2 = G__47686__2;
return G__47686;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__47687 = null;
var G__47687__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47687__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47687 = function(x,start){
switch(arguments.length){
case 1:
return G__47687__1.call(this,x);
case 2:
return G__47687__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47687.cljs$core$IFn$_invoke$arity$1 = G__47687__1;
G__47687.cljs$core$IFn$_invoke$arity$2 = G__47687__2;
return G__47687;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.call(null,self__.nodes,self__.i,cljs.core.next.call(null,self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first.call(null,self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.call(null,self__.nodes,self__.i,cljs.core.next.call(null,self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

goog.object.set(cljs.core.ArrayNodeSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__44083 = arguments.length;
switch (G__44083) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.call(null,nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5718__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5718__auto__)){
var nj = temp__5718__auto__;
var temp__5718__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5718__auto____$1)){
var ns = temp__5718__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__47689 = (j + (1));
j = G__47689;
continue;
}
} else {
var G__47690 = (j + (1));
j = G__47690;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash.call(null,k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.keys.call(null,coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.vals.call(null,coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_.call(null,coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44085 = cljs.core.seq.call(null,coll);
var chunk__44086 = null;
var count__44087 = (0);
var i__44088 = (0);
while(true){
if((i__44088 < count__44087)){
var vec__44095 = cljs.core._nth.call(null,chunk__44086,i__44088);
var k = cljs.core.nth.call(null,vec__44095,(0),null);
var v = cljs.core.nth.call(null,vec__44095,(1),null);
f.call(null,v,k);


var G__47701 = seq__44085;
var G__47702 = chunk__44086;
var G__47703 = count__44087;
var G__47704 = (i__44088 + (1));
seq__44085 = G__47701;
chunk__44086 = G__47702;
count__44087 = G__47703;
i__44088 = G__47704;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__44085);
if(temp__5720__auto__){
var seq__44085__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44085__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__44085__$1);
var G__47723 = cljs.core.chunk_rest.call(null,seq__44085__$1);
var G__47724 = c__6568__auto__;
var G__47725 = cljs.core.count.call(null,c__6568__auto__);
var G__47726 = (0);
seq__44085 = G__47723;
chunk__44086 = G__47724;
count__44087 = G__47725;
i__44088 = G__47726;
continue;
} else {
var vec__44098 = cljs.core.first.call(null,seq__44085__$1);
var k = cljs.core.nth.call(null,vec__44098,(0),null);
var v = cljs.core.nth.call(null,vec__44098,(1),null);
f.call(null,v,k);


var G__47727 = cljs.core.next.call(null,seq__44085__$1);
var G__47728 = null;
var G__47729 = (0);
var G__47730 = (0);
seq__44085 = G__47727;
chunk__44086 = G__47728;
count__44087 = G__47729;
i__44088 = G__47730;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash.call(null,k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?f.call(null,init,null,self__.nil_val):init);
if(cljs.core.reduced_QMARK_.call(null,init__$1)){
return cljs.core.deref.call(null,init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced.call(null,self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator.call(null,self__.root):cljs.core.nil_iter.call(null));
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_unordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map.call(null,coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash.call(null,k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash.call(null,k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash.call(null,k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons.call(null,(new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,coll__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq.call(null,entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first.call(null,es);
if(cljs.core.vector_QMARK_.call(null,e)){
var G__47745 = cljs.core._assoc.call(null,ret,cljs.core._nth.call(null,e,(0)),cljs.core._nth.call(null,e,(1)));
var G__47746 = cljs.core.next.call(null,es);
ret = G__47745;
es = G__47746;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var G__47747 = null;
var G__47747__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__47747__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__47747 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47747__2.call(this,self__,k);
case 3:
return G__47747__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47747.cljs$core$IFn$_invoke$arity$2 = G__47747__2;
G__47747.cljs$core$IFn$_invoke$arity$3 = G__47747__3;
return G__47747;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function (self__,args44084){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44084)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone.call(null,arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__47758 = (i + (2));
var G__47759 = cljs.core._assoc_BANG_.call(null,ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__47758;
ret = G__47759;
continue;
} else {
return cljs.core._persistent_BANG_.call(null,ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__47760 = (i + (1));
var G__47761 = cljs.core._assoc_BANG_.call(null,out,(ks[i]),(vs[i]));
i = G__47760;
out = G__47761;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function (arr){
var len = arr.length;
var ret = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
var i_47762 = (0);
while(true){
if((i_47762 < len)){
cljs.core._assoc_BANG_.call(null,ret,(arr[i_47762]),(arr[(i_47762 + (1))]));

if(cljs.core.not_EQ_.call(null,cljs.core._count.call(null,ret),((i_47762 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_47762]))].join('')));
} else {
var G__47763 = (i_47762 + (2));
i_47762 = G__47763;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_.call(null,ret);
}));
goog.object.set(cljs.core.PersistentHashMap.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_.call(null,o)){
return tcoll.assoc_BANG_(cljs.core.key.call(null,o),cljs.core.val.call(null,o));
} else {
if(cljs.core.vector_QMARK_.call(null,o)){
return tcoll.assoc_BANG_(o.call(null,(0)),o.call(null,(1)));
} else {
var es = cljs.core.seq.call(null,o);
var tcoll__$1 = tcoll;
while(true){
var temp__5718__auto__ = cljs.core.first.call(null,es);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
var G__47766 = cljs.core.next.call(null,es);
var G__47767 = tcoll__$1.assoc_BANG_(cljs.core.key.call(null,e),cljs.core.val.call(null,e));
es = G__47766;
tcoll__$1 = G__47767;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash.call(null,k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash.call(null,k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash.call(null,k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash.call(null,k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var G__47773 = null;
var G__47773__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return cljs.core._lookup.call(null,tcoll,key);
});
var G__47773__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return cljs.core._lookup.call(null,tcoll,key,not_found);
});
G__47773 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return G__47773__2.call(this,self__,key);
case 3:
return G__47773__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47773.cljs$core$IFn$_invoke$arity$2 = G__47773__2;
G__47773.cljs$core$IFn$_invoke$arity$3 = G__47773__3;
return G__47773;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function (self__,args44103){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44103)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return cljs.core._lookup.call(null,tcoll,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return cljs.core._lookup.call(null,tcoll,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__47780 = ((ascending_QMARK_)?t.left:t.right);
var G__47781 = cljs.core.conj.call(null,stack__$1,t);
t = G__47780;
stack__$1 = G__47781;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__47784 = null;
var G__47784__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47784__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47784 = function(x,start){
switch(arguments.length){
case 1:
return G__47784__1.call(this,x);
case 2:
return G__47784__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47784.cljs$core$IFn$_invoke$arity$1 = G__47784__1;
G__47784.cljs$core$IFn$_invoke$arity$2 = G__47784__2;
return G__47784;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__47785 = null;
var G__47785__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47785__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47785 = function(x,start){
switch(arguments.length){
case 1:
return G__47785__1.call(this,x);
case 2:
return G__47785__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47785.cljs$core$IFn$_invoke$arity$1 = G__47785__1;
G__47785.cljs$core$IFn$_invoke$arity$2 = G__47785__2;
return G__47785;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first.call(null,self__.stack);
var next_stack = cljs.core.tree_map_seq_push.call(null,((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next.call(null,self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count.call(null,cljs.core.next.call(null,coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek.call(null,self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first.call(null,self__.stack);
var next_stack = cljs.core.tree_map_seq_push.call(null,((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next.call(null,self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

goog.object.set(cljs.core.PersistentTreeMapSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push.call(null,tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right.call(null,key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right.call(null,right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left.call(null,key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left.call(null,left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?cljs.core.tree_map_kv_reduce.call(null,node.left,f,init):init);
if(cljs.core.reduced_QMARK_.call(null,init__$1)){
return init__$1;
} else {
var init__$2 = f.call(null,init__$1,node.key,node.val);
if(cljs.core.reduced_QMARK_.call(null,init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
return cljs.core.tree_map_kv_reduce.call(null,node.right,f,init__$2);
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__44105 = k;
switch (G__44105) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__47850 = null;
var G__47850__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47850__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47850 = function(x,start){
switch(arguments.length){
case 1:
return G__47850__1.call(this,x);
case 2:
return G__47850__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47850.cljs$core$IFn$_invoke$arity$1 = G__47850__1;
G__47850.cljs$core$IFn$_invoke$arity$2 = G__47850__2;
return G__47850;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var G__47857 = null;
var G__47857__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47857__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47857 = function(x,start){
switch(arguments.length){
case 1:
return G__47857__1.call(this,x);
case 2:
return G__47857__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47857.cljs$core$IFn$_invoke$arity$1 = G__47857__1;
G__47857.cljs$core$IFn$_invoke$arity$2 = G__47857__2;
return G__47857;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del.call(null,self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce.call(null,node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del.call(null,self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.call(null,node__$1,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.call(null,node__$1,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return cljs.core._assoc_n.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var G__47908 = null;
var G__47908__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return cljs.core._nth.call(null,node,k);
});
var G__47908__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return cljs.core._nth.call(null,node,k,not_found);
});
G__47908 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47908__2.call(this,self__,k);
case 3:
return G__47908__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47908.cljs$core$IFn$_invoke$arity$2 = G__47908__2;
G__47908.cljs$core$IFn$_invoke$arity$3 = G__47908__3;
return G__47908;
})()
);

(cljs.core.BlackNode.prototype.apply = (function (self__,args44104){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44104)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return cljs.core._nth.call(null,node,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return cljs.core._nth.call(null,node,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

goog.object.set(cljs.core.BlackNode.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__44107 = k;
switch (G__44107) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__47929 = null;
var G__47929__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__47929__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__47929 = function(x,start){
switch(arguments.length){
case 1:
return G__47929__1.call(this,x);
case 2:
return G__47929__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47929.cljs$core$IFn$_invoke$arity$1 = G__47929__1;
G__47929.cljs$core$IFn$_invoke$arity$2 = G__47929__2;
return G__47929;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var G__47930 = null;
var G__47930__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__47930__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__47930 = function(x,start){
switch(arguments.length){
case 1:
return G__47930__1.call(this,x);
case 2:
return G__47930__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47930.cljs$core$IFn$_invoke$arity$1 = G__47930__1;
G__47930.cljs$core$IFn$_invoke$arity$2 = G__47930__2;
return G__47930;
})()
);

(cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce.call(null,node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.call(null,node__$1,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.call(null,node__$1,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return cljs.core._assoc_n.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.call(null,node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var G__47957 = null;
var G__47957__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return cljs.core._nth.call(null,node,k);
});
var G__47957__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return cljs.core._nth.call(null,node,k,not_found);
});
G__47957 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47957__2.call(this,self__,k);
case 3:
return G__47957__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47957.cljs$core$IFn$_invoke$arity$2 = G__47957__2;
G__47957.cljs$core$IFn$_invoke$arity$3 = G__47957__3;
return G__47957;
})()
);

(cljs.core.RedNode.prototype.apply = (function (self__,args44106){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44106)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return cljs.core._nth.call(null,node,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return cljs.core._nth.call(null,node,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.RedNode.cljs$lang$type = true);

(cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode");

(cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/RedNode");
}));

/**
 * Positional factory function for cljs.core/RedNode.
 */
cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

goog.object.set(cljs.core.RedNode.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = comp.call(null,k,tree.key);
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs.core.tree_map_add.call(null,comp,tree.left,k,v,found);
if((!((ins == null)))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs.core.tree_map_add.call(null,comp,tree.right,k,v,found);
if((!((ins == null)))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs.core.tree_map_append.call(null,left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs.core.tree_map_append.call(null,left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs.core.tree_map_append.call(null,left,right.left),right.right,null));
} else {
var app = cljs.core.tree_map_append.call(null,left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del.call(null,left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if((!((tree == null)))){
var c = comp.call(null,k,tree.key);
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append.call(null,tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs.core.tree_map_remove.call(null,comp,tree.left,k,found);
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del.call(null,tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs.core.tree_map_remove.call(null,comp,tree.right,k,found);
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del.call(null,tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = comp.call(null,k,tk);
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs.core.tree_map_replace.call(null,comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs.core.tree_map_replace.call(null,comp,tree.right,k,v));

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
}));

(cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44109 = cljs.core.seq.call(null,coll);
var chunk__44110 = null;
var count__44111 = (0);
var i__44112 = (0);
while(true){
if((i__44112 < count__44111)){
var vec__44119 = cljs.core._nth.call(null,chunk__44110,i__44112);
var k = cljs.core.nth.call(null,vec__44119,(0),null);
var v = cljs.core.nth.call(null,vec__44119,(1),null);
f.call(null,v,k);


var G__47962 = seq__44109;
var G__47963 = chunk__44110;
var G__47964 = count__44111;
var G__47965 = (i__44112 + (1));
seq__44109 = G__47962;
chunk__44110 = G__47963;
count__44111 = G__47964;
i__44112 = G__47965;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__44109);
if(temp__5720__auto__){
var seq__44109__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44109__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__44109__$1);
var G__47966 = cljs.core.chunk_rest.call(null,seq__44109__$1);
var G__47967 = c__6568__auto__;
var G__47968 = cljs.core.count.call(null,c__6568__auto__);
var G__47969 = (0);
seq__44109 = G__47966;
chunk__44110 = G__47967;
count__44111 = G__47968;
i__44112 = G__47969;
continue;
} else {
var vec__44122 = cljs.core.first.call(null,seq__44109__$1);
var k = cljs.core.nth.call(null,vec__44122,(0),null);
var v = cljs.core.nth.call(null,vec__44122,(1),null);
f.call(null,v,k);


var G__47970 = cljs.core.next.call(null,seq__44109__$1);
var G__47971 = null;
var G__47972 = (0);
var G__47973 = (0);
seq__44109 = G__47970;
chunk__44110 = G__47971;
count__44111 = G__47972;
i__44112 = G__47973;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.keys.call(null,coll));
}));

(cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.vals.call(null,coll));
}));

(cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = self__.comp.call(null,k,t.key);
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__47974 = t.left;
t = G__47974;
continue;
} else {
var G__47975 = t.right;
t = G__47975;
continue;

}
}
} else {
return null;
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_.call(null,coll,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,k,null);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if((!((n == null)))){
return n.val;
} else {
return not_found;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((!((self__.tree == null)))){
return cljs.core.unreduced.call(null,cljs.core.tree_map_kv_reduce.call(null,self__.tree,f,init));
} else {
return init;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq.call(null,self__.tree,false,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_unordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map.call(null,coll__$1,other);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove.call(null,self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.call(null,found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add.call(null,self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.call(null,found,(0));
if(cljs.core._EQ_.call(null,v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace.call(null,self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((coll__$1.entry_at(k) == null)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq.call(null,self__.tree,true,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,new_meta,self__.__hash));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,coll__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq.call(null,entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first.call(null,es);
if(cljs.core.vector_QMARK_.call(null,e)){
var G__47985 = cljs.core._assoc.call(null,ret,cljs.core._nth.call(null,e,(0)),cljs.core._nth.call(null,e,(1)));
var G__47986 = cljs.core.next.call(null,es);
ret = G__47985;
es = G__47986;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__47987 = null;
var G__47987__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__47987__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__47987 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__47987__2.call(this,self__,k);
case 3:
return G__47987__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__47987.cljs$core$IFn$_invoke$arity$2 = G__47987__2;
G__47987.cljs$core$IFn$_invoke$arity$3 = G__47987__3;
return G__47987;
})()
);

(cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args44108){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44108)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq.call(null,self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = self__.comp.call(null,k,t.key);
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.call(null,stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__47992 = cljs.core.conj.call(null,stack,t);
var G__47993 = t.left;
stack = G__47992;
t = G__47993;
continue;
} else {
var G__47994 = stack;
var G__47995 = t.right;
stack = G__47994;
t = G__47995;
continue;
}
} else {
if((c > (0))){
var G__47996 = cljs.core.conj.call(null,stack,t);
var G__47997 = t.right;
stack = G__47996;
t = G__47997;
continue;
} else {
var G__47998 = stack;
var G__47999 = t.left;
stack = G__47998;
t = G__47999;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return cljs.core.key.call(null,entry);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
}));

(cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeMap.cljs$lang$type = true);

(cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap");

(cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentTreeMap");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMap.
 */
cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

(cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash)));
goog.object.set(cljs.core.PersistentTreeMap.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48000 = arguments.length;
var i__6921__auto___48001 = (0);
while(true){
if((i__6921__auto___48001 < len__6920__auto___48000)){
args__6930__auto__.push((arguments[i__6921__auto___48001]));

var G__48002 = (i__6921__auto___48001 + (1));
i__6921__auto___48001 = G__48002;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__48003 = cljs.core.nnext.call(null,in$);
var G__48004 = cljs.core.assoc_BANG_.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__48003;
out = G__48004;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,out);
}
break;
}
}));

(cljs.core.hash_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.hash_map.cljs$lang$applyTo = (function (seq44125){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44125));
}));

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48005 = arguments.length;
var i__6921__auto___48006 = (0);
while(true){
if((i__6921__auto___48006 < len__6920__auto___48005)){
args__6930__auto__.push((arguments[i__6921__auto___48006]));

var G__48007 = (i__6921__auto___48006 + (1));
i__6921__auto___48006 = G__48007;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = (((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0)))))?keyvals.arr:cljs.core.into_array.call(null,keyvals));
return cljs.core.PersistentArrayMap.createAsIfByAssoc(arr);
}));

(cljs.core.array_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.array_map.cljs$lang$applyTo = (function (seq44126){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44126));
}));

/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48014 = arguments.length;
var i__6921__auto___48015 = (0);
while(true){
if((i__6921__auto___48015 < len__6920__auto___48014)){
args__6930__auto__.push((arguments[i__6921__auto___48015]));

var G__48016 = (i__6921__auto___48015 + (1));
i__6921__auto___48015 = G__48016;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = ({});
var kvs = cljs.core.seq.call(null,keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first.call(null,kvs));

goog.object.set(obj,cljs.core.first.call(null,kvs),cljs.core.second.call(null,kvs));

var G__48017 = cljs.core.nnext.call(null,kvs);
kvs = G__48017;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
}));

(cljs.core.obj_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.obj_map.cljs$lang$applyTo = (function (seq44127){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44127));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48018 = arguments.length;
var i__6921__auto___48019 = (0);
while(true){
if((i__6921__auto___48019 < len__6920__auto___48018)){
args__6930__auto__.push((arguments[i__6921__auto___48019]));

var G__48020 = (i__6921__auto___48019 + (1));
i__6921__auto___48019 = G__48020;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__48024 = cljs.core.nnext.call(null,in$);
var G__48025 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__48024;
out = G__48025;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.sorted_map.cljs$lang$applyTo = (function (seq44130){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44130));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48027 = arguments.length;
var i__6921__auto___48028 = (0);
while(true){
if((i__6921__auto___48028 < len__6920__auto___48027)){
args__6930__auto__.push((arguments[i__6921__auto___48028]));

var G__48029 = (i__6921__auto___48028 + (1));
i__6921__auto___48028 = G__48029;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator.call(null,comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__48032 = cljs.core.nnext.call(null,in$);
var G__48033 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__48032;
out = G__48033;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq44131){
var G__44132 = cljs.core.first.call(null,seq44131);
var seq44131__$1 = cljs.core.next.call(null,seq44131);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44132,seq44131__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.KeySeq.prototype.indexOf = (function() {
var G__48042 = null;
var G__48042__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__48042__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__48042 = function(x,start){
switch(arguments.length){
case 1:
return G__48042__1.call(this,x);
case 2:
return G__48042__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48042.cljs$core$IFn$_invoke$arity$1 = G__48042__1;
G__48042.cljs$core$IFn$_invoke$arity$2 = G__48042__2;
return G__48042;
})()
);

(cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__48047 = null;
var G__48047__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__48047__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__48047 = function(x,start){
switch(arguments.length){
case 1:
return G__48047__1.call(this,x);
case 2:
return G__48047__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48047.cljs$core$IFn$_invoke$arity$1 = G__48047__1;
G__48047.cljs$core$IFn$_invoke$arity$2 = G__48047__2;
return G__48047;
})()
);

(cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq)))?cljs.core._next.call(null,self__.mseq):cljs.core.next.call(null,self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,null));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll.call(null,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = cljs.core._first.call(null,self__.mseq);
return cljs.core._key.call(null,me);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq)))?cljs.core._next.call(null,self__.mseq):cljs.core.next.call(null,self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.KeySeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.KeySeq(self__.mseq,new_meta));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.KeySeq.cljs$lang$type = true);

(cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq");

(cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/KeySeq");
}));

/**
 * Positional factory function for cljs.core/KeySeq.
 */
cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

goog.object.set(cljs.core.KeySeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Returns a sequence of the map's keys, in the same order as (seq map).
 */
cljs.core.keys = (function cljs$core$keys(map){
var temp__5720__auto__ = cljs.core.seq.call(null,map);
if(temp__5720__auto__){
var mseq = temp__5720__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key.call(null,map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.ValSeq.prototype.indexOf = (function() {
var G__48071 = null;
var G__48071__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__48071__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start);
});
G__48071 = function(x,start){
switch(arguments.length){
case 1:
return G__48071__1.call(this,x);
case 2:
return G__48071__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48071.cljs$core$IFn$_invoke$arity$1 = G__48071__1;
G__48071.cljs$core$IFn$_invoke$arity$2 = G__48071__2;
return G__48071;
})()
);

(cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__48073 = null;
var G__48073__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__48073__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start);
});
G__48073 = function(x,start){
switch(arguments.length){
case 1:
return G__48073__1.call(this,x);
case 2:
return G__48073__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48073.cljs$core$IFn$_invoke$arity$1 = G__48073__1;
G__48073.cljs$core$IFn$_invoke$arity$2 = G__48073__2;
return G__48073;
})()
);

(cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq)))?cljs.core._next.call(null,self__.mseq):cljs.core.next.call(null,self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,null));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll.call(null,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential.call(null,coll__$1,other);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.call(null,f,start,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = cljs.core._first.call(null,self__.mseq);
return cljs.core._val.call(null,me);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.INext,self__.mseq)))?cljs.core._next.call(null,self__.mseq):cljs.core.next.call(null,self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.ValSeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.ValSeq(self__.mseq,new_meta));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons.call(null,o,coll__$1);
}));

(cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
}));

(cljs.core.ValSeq.cljs$lang$type = true);

(cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq");

(cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ValSeq");
}));

/**
 * Positional factory function for cljs.core/ValSeq.
 */
cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

goog.object.set(cljs.core.ValSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Returns a sequence of the map's values, in the same order as (seq map).
 */
cljs.core.vals = (function cljs$core$vals(map){
var temp__5720__auto__ = cljs.core.seq.call(null,map);
if(temp__5720__auto__){
var mseq = temp__5720__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val.call(null,map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48085 = arguments.length;
var i__6921__auto___48086 = (0);
while(true){
if((i__6921__auto___48086 < len__6920__auto___48085)){
args__6930__auto__.push((arguments[i__6921__auto___48086]));

var G__48087 = (i__6921__auto___48086 + (1));
i__6921__auto___48086 = G__48087;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,maps))){
return cljs.core.reduce.call(null,(function (p1__44137_SHARP_,p2__44138_SHARP_){
return cljs.core.conj.call(null,(function (){var or__5598__auto__ = p1__44137_SHARP_;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__44138_SHARP_);
}),maps);
} else {
return null;
}
}));

(cljs.core.merge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.merge.cljs$lang$applyTo = (function (seq44139){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44139));
}));

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48089 = arguments.length;
var i__6921__auto___48090 = (0);
while(true){
if((i__6921__auto___48090 < len__6920__auto___48089)){
args__6930__auto__.push((arguments[i__6921__auto___48090]));

var G__48091 = (i__6921__auto___48090 + (1));
i__6921__auto___48090 = G__48091;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key.call(null,e);
var v = cljs.core.val.call(null,e);
if(cljs.core.contains_QMARK_.call(null,m,k)){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),v));
} else {
return cljs.core.assoc.call(null,m,k,v);
}
});
var merge2 = (function (m1,m2){
return cljs.core.reduce.call(null,merge_entry,(function (){var or__5598__auto__ = m1;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq.call(null,m2));
});
return cljs.core.reduce.call(null,merge2,maps);
} else {
return null;
}
}));

(cljs.core.merge_with.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.merge_with.cljs$lang$applyTo = (function (seq44140){
var G__44141 = cljs.core.first.call(null,seq44140);
var seq44140__$1 = cljs.core.next.call(null,seq44140);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44141,seq44140__$1);
}));

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq.call(null,keyseq);
while(true){
if(keys){
var key = cljs.core.first.call(null,keys);
var entry = cljs.core.get.call(null,map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__48093 = ((cljs.core.not_EQ_.call(null,entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.call(null,ret,key,entry):ret);
var G__48094 = cljs.core.next.call(null,keys);
ret = G__48093;
keys = G__48094;
continue;
} else {
return cljs.core._with_meta.call(null,ret,cljs.core.meta.call(null,map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
});
(cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
}));

(cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return self__.iter.next().key;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null);
}));

(cljs.core.HashSetIter.cljs$lang$type = true);

(cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter");

(cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/HashSetIter");
}));

/**
 * Positional factory function for cljs.core/HashSetIter.
 */
cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_.call(null,coll,k);
}));

(cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44145 = cljs.core.seq.call(null,coll);
var chunk__44146 = null;
var count__44147 = (0);
var i__44148 = (0);
while(true){
if((i__44148 < count__44147)){
var vec__44155 = cljs.core._nth.call(null,chunk__44146,i__44148);
var k = cljs.core.nth.call(null,vec__44155,(0),null);
var v = cljs.core.nth.call(null,vec__44155,(1),null);
f.call(null,v,k);


var G__48100 = seq__44145;
var G__48101 = chunk__44146;
var G__48102 = count__44147;
var G__48103 = (i__44148 + (1));
seq__44145 = G__48100;
chunk__44146 = G__48101;
count__44147 = G__48102;
i__44148 = G__48103;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__44145);
if(temp__5720__auto__){
var seq__44145__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44145__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__44145__$1);
var G__48104 = cljs.core.chunk_rest.call(null,seq__44145__$1);
var G__48105 = c__6568__auto__;
var G__48106 = cljs.core.count.call(null,c__6568__auto__);
var G__48107 = (0);
seq__44145 = G__48104;
chunk__44146 = G__48105;
count__44147 = G__48106;
i__44148 = G__48107;
continue;
} else {
var vec__44158 = cljs.core.first.call(null,seq__44145__$1);
var k = cljs.core.nth.call(null,vec__44158,(0),null);
var v = cljs.core.nth.call(null,vec__44158,(1),null);
f.call(null,v,k);


var G__48108 = cljs.core.next.call(null,seq__44145__$1);
var G__48109 = null;
var G__48110 = (0);
var G__48111 = (0);
seq__44145 = G__48108;
chunk__44146 = G__48109;
count__44147 = G__48110;
i__44148 = G__48111;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,v,null);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var temp__5718__auto__ = cljs.core._find.call(null,self__.hash_map,v);
if(cljs.core.truth_(temp__5718__auto__)){
var entry = temp__5718__auto__;
return cljs.core.key.call(null,entry);
} else {
return not_found;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator.call(null,self__.hash_map)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count.call(null,self__.hash_map);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_unordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(cljs.core.set_QMARK_.call(null,other)){
if((cljs.core.count.call(null,coll__$1) === cljs.core.count.call(null,other))){
try{return cljs.core.reduce_kv.call(null,(function (p1__44143_SHARP_,p2__44142_SHARP_){
var or__5598__auto__ = cljs.core.contains_QMARK_.call(null,other,p2__44142_SHARP_);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return cljs.core.reduced.call(null,false);
}
}),true,self__.hash_map);
}catch (e44163){if((e44163 instanceof Error)){
var ex = e44163;
return false;
} else {
throw e44163;

}
}} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient.call(null,self__.hash_map)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentHashSet.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc.call(null,self__.hash_map,v),null));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys.call(null,self__.hash_map);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashSet(new_meta,self__.hash_map,self__.__hash));
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.call(null,self__.hash_map,o,null),null));
}));

(cljs.core.PersistentHashSet.prototype.call = (function() {
var G__48114 = null;
var G__48114__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__48114__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__48114 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__48114__2.call(this,self__,k);
case 3:
return G__48114__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__48114.cljs$core$IFn$_invoke$arity$2 = G__48114__2;
G__48114.cljs$core$IFn$_invoke$arity$3 = G__48114__3;
return G__48114;
})()
);

(cljs.core.PersistentHashSet.prototype.apply = (function (self__,args44144){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44144)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentHashSet.cljs$lang$type = true);

(cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet");

(cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentHashSet");
}));

/**
 * Positional factory function for cljs.core/PersistentHashSet.
 */
cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

(cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone.call(null,items));
var i = (0);
var out = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__48117 = (i + (1));
var G__48118 = cljs.core._assoc_BANG_.call(null,out,(items[i]),null);
i = G__48117;
out = G__48118;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_.call(null,out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$.call(null,cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__48119 = (i + (1));
var G__48120 = cljs.core._conj_BANG_.call(null,out,(items[i]));
i = G__48119;
out = G__48120;
continue;
} else {
return cljs.core._persistent_BANG_.call(null,out);
}
break;
}
}
}));
(cljs.core.PersistentHashSet.createWithCheck = (function (items){
var len = items.length;
var t = cljs.core._as_transient.call(null,cljs.core.PersistentHashSet.EMPTY);
var n__6679__auto___48121 = len;
var i_48122 = (0);
while(true){
if((i_48122 < n__6679__auto___48121)){
cljs.core._conj_BANG_.call(null,t,(items[i_48122]));

if(cljs.core._EQ_.call(null,cljs.core.count.call(null,t),(i_48122 + (1)))){
} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((items[i_48122]))].join('')));
}

var G__48123 = (i_48122 + (1));
i_48122 = G__48123;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_.call(null,t);
}));
(cljs.core.PersistentHashSet.createAsIfByAssoc = (function (items){
var len = items.length;
var t = cljs.core._as_transient.call(null,cljs.core.PersistentHashSet.EMPTY);
var n__6679__auto___48125 = len;
var i_48126 = (0);
while(true){
if((i_48126 < n__6679__auto___48125)){
cljs.core._conj_BANG_.call(null,t,(items[i_48126]));

var G__48127 = (i_48126 + (1));
i_48126 = G__48127;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_.call(null,t);
}));
goog.object.set(cljs.core.PersistentHashSet.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
});
(cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
(self__.transient_map = cljs.core.assoc_BANG_.call(null,self__.transient_map,o,null));

return tcoll__$1;
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_.call(null,self__.transient_map),null));
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
(self__.transient_map = cljs.core.dissoc_BANG_.call(null,self__.transient_map,v));

return tcoll__$1;
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count.call(null,self__.transient_map);
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.call(null,tcoll__$1,v,null);
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.call(null,self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
}));

(cljs.core.TransientHashSet.prototype.call = (function() {
var G__48128 = null;
var G__48128__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.call(null,self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__48128__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.call(null,self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__48128 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__48128__2.call(this,self__,k);
case 3:
return G__48128__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__48128.cljs$core$IFn$_invoke$arity$2 = G__48128__2;
G__48128.cljs$core$IFn$_invoke$arity$3 = G__48128__3;
return G__48128;
})()
);

(cljs.core.TransientHashSet.prototype.apply = (function (self__,args44164){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44164)));
}));

(cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.call(null,self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
}));

(cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.call(null,self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
}));

(cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"transient-map","transient-map",351764893,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.TransientHashSet.cljs$lang$type = true);

(cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet");

(cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/TransientHashSet");
}));

/**
 * Positional factory function for cljs.core/TransientHashSet.
 */
cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator.call(null,cljs.core.seq.call(null,coll));
}));

(cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_.call(null,coll,k);
}));

(cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__44168 = cljs.core.seq.call(null,coll);
var chunk__44169 = null;
var count__44170 = (0);
var i__44171 = (0);
while(true){
if((i__44171 < count__44170)){
var vec__44178 = cljs.core._nth.call(null,chunk__44169,i__44171);
var k = cljs.core.nth.call(null,vec__44178,(0),null);
var v = cljs.core.nth.call(null,vec__44178,(1),null);
f.call(null,v,k);


var G__48135 = seq__44168;
var G__48136 = chunk__44169;
var G__48137 = count__44170;
var G__48138 = (i__44171 + (1));
seq__44168 = G__48135;
chunk__44169 = G__48136;
count__44170 = G__48137;
i__44171 = G__48138;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__44168);
if(temp__5720__auto__){
var seq__44168__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44168__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__44168__$1);
var G__48139 = cljs.core.chunk_rest.call(null,seq__44168__$1);
var G__48140 = c__6568__auto__;
var G__48141 = cljs.core.count.call(null,c__6568__auto__);
var G__48142 = (0);
seq__44168 = G__48139;
chunk__44169 = G__48140;
count__44170 = G__48141;
i__44171 = G__48142;
continue;
} else {
var vec__44181 = cljs.core.first.call(null,seq__44168__$1);
var k = cljs.core.nth.call(null,vec__44181,(0),null);
var v = cljs.core.nth.call(null,vec__44181,(1),null);
f.call(null,v,k);


var G__48143 = cljs.core.next.call(null,seq__44168__$1);
var G__48144 = null;
var G__48145 = (0);
var G__48146 = (0);
seq__44168 = G__48143;
chunk__44169 = G__48144;
count__44170 = G__48145;
i__44171 = G__48146;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.call(null,coll__$1,v,null);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if((!((n == null)))){
return n.key;
} else {
return not_found;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count.call(null,self__.tree_map);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count.call(null,self__.tree_map) > (0))){
return cljs.core.map.call(null,cljs.core.key,cljs.core.rseq.call(null,self__.tree_map));
} else {
return null;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_unordered_coll.call(null,coll__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(cljs.core.set_QMARK_.call(null,other)){
if((cljs.core.count.call(null,coll__$1) === cljs.core.count.call(null,other))){
try{return cljs.core.reduce_kv.call(null,(function (p1__44166_SHARP_,p2__44165_SHARP_){
var or__5598__auto__ = cljs.core.contains_QMARK_.call(null,other,p2__44165_SHARP_);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return cljs.core.reduced.call(null,false);
}
}),true,self__.tree_map);
}catch (e44186){if((e44186 instanceof Error)){
var ex = e44186;
return false;
} else {
throw e44186;

}
}} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty.call(null,self__.tree_map),(0)));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.call(null,self__.tree_map,v),null));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys.call(null,self__.tree_map);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeSet(new_meta,self__.tree_map,self__.__hash));
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.call(null,self__.tree_map,o,null),null));
}));

(cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__48147 = null;
var G__48147__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k);
});
var G__48147__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return cljs.core._lookup.call(null,coll,k,not_found);
});
G__48147 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__48147__2.call(this,self__,k);
case 3:
return G__48147__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__48147.cljs$core$IFn$_invoke$arity$2 = G__48147__2;
G__48147.cljs$core$IFn$_invoke$arity$3 = G__48147__3;
return G__48147;
})()
);

(cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args44167){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args44167)));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return cljs.core._lookup.call(null,coll,k,not_found);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.call(null,cljs.core.key,cljs.core._sorted_seq.call(null,self__.tree_map,ascending_QMARK_));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.call(null,cljs.core.key,cljs.core._sorted_seq_from.call(null,self__.tree_map,k,ascending_QMARK_));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator.call(null,self__.tree_map);
}));

(cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"tree-map","tree-map",1373073049,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.PersistentTreeSet.cljs$lang$type = true);

(cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet");

(cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/PersistentTreeSet");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeSet.
 */
cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

(cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash)));
goog.object.set(cljs.core.PersistentTreeSet.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__6672__auto__ = arr;
var l__6673__auto__ = a__6672__auto__.length;
var i = (0);
var res = cljs.core._as_transient.call(null,cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < l__6673__auto__)){
var G__48148 = (i + (1));
var G__48149 = cljs.core._conj_BANG_.call(null,res,(arr[i]));
i = G__48148;
res = G__48149;
continue;
} else {
return res;
}
break;
}
})();
return cljs.core._persistent_BANG_.call(null,ret);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
if(cljs.core.set_QMARK_.call(null,coll)){
return cljs.core.with_meta.call(null,coll,null);
} else {
var in$ = cljs.core.seq.call(null,coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if((((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0))))){
return cljs.core.PersistentHashSet.createAsIfByAssoc(in$.arr);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient.call(null,cljs.core.PersistentHashSet.EMPTY);
while(true){
if((!((in$__$1 == null)))){
var G__48155 = cljs.core.next.call(null,in$__$1);
var G__48156 = cljs.core._conj_BANG_.call(null,out,cljs.core._first.call(null,in$__$1));
in$__$1 = G__48155;
out = G__48156;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,out);
}
break;
}

}
}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var G__44189 = arguments.length;
switch (G__44189) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___48158 = arguments.length;
var i__6921__auto___48159 = (0);
while(true){
if((i__6921__auto___48159 < len__6920__auto___48158)){
args_arr__6949__auto__.push((arguments[i__6921__auto___48159]));

var G__48160 = (i__6921__auto___48159 + (1));
i__6921__auto___48159 = G__48160;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((0)),(0),null));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__6950__auto__);

}
});

(cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
}));

(cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set.call(null,keys);
}));

/** @this {Function} */
(cljs.core.hash_set.cljs$lang$applyTo = (function (seq44188){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44188));
}));

(cljs.core.hash_set.cljs$lang$maxFixedArity = (0));

/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48165 = arguments.length;
var i__6921__auto___48166 = (0);
while(true){
if((i__6921__auto___48166 < len__6920__auto___48165)){
args__6930__auto__.push((arguments[i__6921__auto___48166]));

var G__48167 = (i__6921__auto___48166 + (1));
i__6921__auto___48166 = G__48167;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.call(null,cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
}));

(cljs.core.sorted_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.sorted_set.cljs$lang$applyTo = (function (seq44190){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44190));
}));

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__6930__auto__ = [];
var len__6920__auto___48168 = arguments.length;
var i__6921__auto___48169 = (0);
while(true){
if((i__6921__auto___48169 < len__6920__auto___48168)){
args__6930__auto__.push((arguments[i__6921__auto___48169]));

var G__48178 = (i__6921__auto___48169 + (1));
i__6921__auto___48169 = G__48178;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.call(null,cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by.call(null,comparator),(0))),keys);
}));

(cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq44191){
var G__44192 = cljs.core.first.call(null,seq44191);
var seq44191__$1 = cljs.core.next.call(null,seq44191);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44192,seq44191__$1);
}));

/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var G__44196 = arguments.length;
switch (G__44196) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.call(null,(function (p1__44193_SHARP_){
var temp__5718__auto__ = cljs.core.find.call(null,smap,p1__44193_SHARP_);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
return cljs.core.val.call(null,e);
} else {
return p1__44193_SHARP_;
}
}));
}));

(cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_.call(null,coll)){
var n = cljs.core.count.call(null,coll);
return cljs.core.reduce.call(null,(function (v,i){
var temp__5718__auto__ = cljs.core.find.call(null,smap,cljs.core.nth.call(null,v,i));
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
return cljs.core.assoc.call(null,v,i,cljs.core.second.call(null,e));
} else {
return v;
}
}),coll,cljs.core.take.call(null,n,cljs.core.iterate.call(null,cljs.core.inc,(0))));
} else {
return cljs.core.map.call(null,(function (p1__44194_SHARP_){
var temp__5718__auto__ = cljs.core.find.call(null,smap,p1__44194_SHARP_);
if(cljs.core.truth_(temp__5718__auto__)){
var e = temp__5718__auto__;
return cljs.core.second.call(null,e);
} else {
return p1__44194_SHARP_;
}
}),coll);
}
}));

(cljs.core.replace.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var G__44198 = arguments.length;
switch (G__44198) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return (function() {
var G__48194 = null;
var G__48194__0 = (function (){
return rf.call(null);
});
var G__48194__1 = (function (result){
return rf.call(null,result);
});
var G__48194__2 = (function (result,input){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,seen),input)){
return result;
} else {
cljs.core._vreset_BANG_.call(null,seen,cljs.core.conj.call(null,cljs.core._deref.call(null,seen),input));

return rf.call(null,result,input);
}
});
G__48194 = function(result,input){
switch(arguments.length){
case 0:
return G__48194__0.call(this);
case 1:
return G__48194__1.call(this,result);
case 2:
return G__48194__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48194.cljs$core$IFn$_invoke$arity$0 = G__48194__0;
G__48194.cljs$core$IFn$_invoke$arity$1 = G__48194__1;
G__48194.cljs$core$IFn$_invoke$arity$2 = G__48194__2;
return G__48194;
})()
});
}));

(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__44199,seen__$1){
while(true){
var vec__44200 = p__44199;
var f = cljs.core.nth.call(null,vec__44200,(0),null);
var xs__$1 = vec__44200;
var temp__5720__auto__ = cljs.core.seq.call(null,xs__$1);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.contains_QMARK_.call(null,seen__$1,f)){
var G__48201 = cljs.core.rest.call(null,s);
var G__48202 = seen__$1;
p__44199 = G__48201;
seen__$1 = G__48202;
continue;
} else {
return cljs.core.cons.call(null,f,cljs$core$step.call(null,cljs.core.rest.call(null,s),cljs.core.conj.call(null,seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step.call(null,coll,cljs.core.PersistentHashSet.EMPTY);
}));

(cljs.core.distinct.cljs$lang$maxFixedArity = 1);

/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next.call(null,s__$1)){
var G__48207 = cljs.core.conj.call(null,ret,cljs.core.first.call(null,s__$1));
var G__48208 = cljs.core.next.call(null,s__$1);
ret = G__48207;
s__$1 = G__48208;
continue;
} else {
return cljs.core.seq.call(null,ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return cljs.core._name.call(null,x);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error(["Doesn't support name: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq.call(null,keys);
var vs = cljs.core.seq.call(null,vals);
while(true){
if(((ks) && (vs))){
var G__48211 = cljs.core.assoc_BANG_.call(null,map,cljs.core.first.call(null,ks),cljs.core.first.call(null,vs));
var G__48212 = cljs.core.next.call(null,ks);
var G__48213 = cljs.core.next.call(null,vs);
map = G__48211;
ks = G__48212;
vs = G__48213;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 * 
 *   If there are multiple such xs, the last one is returned.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var G__44211 = arguments.length;
switch (G__44211) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___48221 = arguments.length;
var i__6921__auto___48222 = (0);
while(true){
if((i__6921__auto___48222 < len__6920__auto___48221)){
args_arr__6949__auto__.push((arguments[i__6921__auto___48222]));

var G__48223 = (i__6921__auto___48222 + (1));
i__6921__auto___48222 = G__48223;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
}));

(cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if((k.call(null,x) > k.call(null,y))){
return x;
} else {
return y;
}
}));

(cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.call(null,(function (p1__44204_SHARP_,p2__44205_SHARP_){
return cljs.core.max_key.call(null,k,p1__44204_SHARP_,p2__44205_SHARP_);
}),cljs.core.max_key.call(null,k,x,y),more);
}));

/** @this {Function} */
(cljs.core.max_key.cljs$lang$applyTo = (function (seq44207){
var G__44208 = cljs.core.first.call(null,seq44207);
var seq44207__$1 = cljs.core.next.call(null,seq44207);
var G__44209 = cljs.core.first.call(null,seq44207__$1);
var seq44207__$2 = cljs.core.next.call(null,seq44207__$1);
var G__44210 = cljs.core.first.call(null,seq44207__$2);
var seq44207__$3 = cljs.core.next.call(null,seq44207__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44208,G__44209,G__44210,seq44207__$3);
}));

(cljs.core.max_key.cljs$lang$maxFixedArity = (3));

/**
 * Returns the x for which (k x), a number, is least.
 * 
 *   If there are multiple such xs, the last one is returned.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var G__44219 = arguments.length;
switch (G__44219) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___48234 = arguments.length;
var i__6921__auto___48235 = (0);
while(true){
if((i__6921__auto___48235 < len__6920__auto___48234)){
args_arr__6949__auto__.push((arguments[i__6921__auto___48235]));

var G__48236 = (i__6921__auto___48235 + (1));
i__6921__auto___48235 = G__48236;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
}));

(cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if((k.call(null,x) < k.call(null,y))){
return x;
} else {
return y;
}
}));

(cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.call(null,(function (p1__44212_SHARP_,p2__44213_SHARP_){
return cljs.core.min_key.call(null,k,p1__44212_SHARP_,p2__44213_SHARP_);
}),cljs.core.min_key.call(null,k,x,y),more);
}));

/** @this {Function} */
(cljs.core.min_key.cljs$lang$applyTo = (function (seq44215){
var G__44216 = cljs.core.first.call(null,seq44215);
var seq44215__$1 = cljs.core.next.call(null,seq44215);
var G__44217 = cljs.core.first.call(null,seq44215__$1);
var seq44215__$2 = cljs.core.next.call(null,seq44215__$1);
var G__44218 = cljs.core.first.call(null,seq44215__$2);
var seq44215__$3 = cljs.core.next.call(null,seq44215__$2);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44216,G__44217,G__44218,seq44215__$3);
}));

(cljs.core.min_key.cljs$lang$maxFixedArity = (3));


/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
});
(cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
}));

(cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
}));

(cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return (self__.arr = []);
}));

(cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
}));

(cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
}));

(cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.ArrayList.cljs$lang$type = true);

(cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList");

(cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/ArrayList");
}));

/**
 * Positional factory function for cljs.core/ArrayList.
 */
cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var G__44221 = arguments.length;
switch (G__44221) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list.call(null);
return (function() {
var G__48255 = null;
var G__48255__0 = (function (){
return rf.call(null);
});
var G__48255__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec.call(null,a.toArray());
a.clear();

return cljs.core.unreduced.call(null,rf.call(null,result,v));
})());
return rf.call(null,result__$1);
});
var G__48255__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec.call(null,a.toArray());
a.clear();

return rf.call(null,result,v);
} else {
return result;
}
});
G__48255 = function(result,input){
switch(arguments.length){
case 0:
return G__48255__0.call(this);
case 1:
return G__48255__1.call(this,result);
case 2:
return G__48255__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48255.cljs$core$IFn$_invoke$arity$0 = G__48255__0;
G__48255.cljs$core$IFn$_invoke$arity$1 = G__48255__1;
G__48255.cljs$core$IFn$_invoke$arity$2 = G__48255__2;
return G__48255;
})()
});
}));

(cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.call(null,n,n,coll);
}));

(cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons.call(null,cljs.core.take.call(null,n,s),cljs.core.partition_all.call(null,n,step,cljs.core.drop.call(null,step,s)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition_all.cljs$lang$maxFixedArity = 3);

/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var G__44223 = arguments.length;
switch (G__44223) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__48276 = null;
var G__48276__0 = (function (){
return rf.call(null);
});
var G__48276__1 = (function (result){
return rf.call(null,result);
});
var G__48276__2 = (function (result,input){
if(cljs.core.truth_(pred.call(null,input))){
return rf.call(null,result,input);
} else {
return cljs.core.reduced.call(null,result);
}
});
G__48276 = function(result,input){
switch(arguments.length){
case 0:
return G__48276__0.call(this);
case 1:
return G__48276__1.call(this,result);
case 2:
return G__48276__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48276.cljs$core$IFn$_invoke$arity$0 = G__48276__0;
G__48276.cljs$core$IFn$_invoke$arity$1 = G__48276__1;
G__48276.cljs$core$IFn$_invoke$arity$2 = G__48276__2;
return G__48276;
})()
});
}));

(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
if(cljs.core.truth_(pred.call(null,cljs.core.first.call(null,s)))){
return cljs.core.cons.call(null,cljs.core.first.call(null,s),cljs.core.take_while.call(null,pred,cljs.core.rest.call(null,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take_while.cljs$lang$maxFixedArity = 2);

cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator.call(null,sc);
return test.call(null,comp.call(null,cljs.core._entry_key.call(null,sc,e),key),(0));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var G__44225 = arguments.length;
switch (G__44225) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn.call(null,sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core._GT_,cljs.core._GT__EQ_]).call(null,test))){
var temp__5720__auto__ = cljs.core._sorted_seq_from.call(null,sc,key,true);
if(cljs.core.truth_(temp__5720__auto__)){
var vec__44226 = temp__5720__auto__;
var e = cljs.core.nth.call(null,vec__44226,(0),null);
var s = vec__44226;
if(cljs.core.truth_(include.call(null,e))){
return s;
} else {
return cljs.core.next.call(null,s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.call(null,include,cljs.core._sorted_seq.call(null,sc,true));
}
}));

(cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__5720__auto__ = cljs.core._sorted_seq_from.call(null,sc,start_key,true);
if(cljs.core.truth_(temp__5720__auto__)){
var vec__44229 = temp__5720__auto__;
var e = cljs.core.nth.call(null,vec__44229,(0),null);
var s = vec__44229;
return cljs.core.take_while.call(null,cljs.core.mk_bound_fn.call(null,sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn.call(null,sc,start_test,start_key).call(null,e))?s:cljs.core.next.call(null,s)));
} else {
return null;
}
}));

(cljs.core.subseq.cljs$lang$maxFixedArity = 5);

/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a reverse seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(var_args){
var G__44233 = arguments.length;
switch (G__44233) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn.call(null,sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core._LT_,cljs.core._LT__EQ_]).call(null,test))){
var temp__5720__auto__ = cljs.core._sorted_seq_from.call(null,sc,key,false);
if(cljs.core.truth_(temp__5720__auto__)){
var vec__44234 = temp__5720__auto__;
var e = cljs.core.nth.call(null,vec__44234,(0),null);
var s = vec__44234;
if(cljs.core.truth_(include.call(null,e))){
return s;
} else {
return cljs.core.next.call(null,s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.call(null,include,cljs.core._sorted_seq.call(null,sc,false));
}
}));

(cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__5720__auto__ = cljs.core._sorted_seq_from.call(null,sc,end_key,false);
if(cljs.core.truth_(temp__5720__auto__)){
var vec__44237 = temp__5720__auto__;
var e = cljs.core.nth.call(null,vec__44237,(0),null);
var s = vec__44237;
return cljs.core.take_while.call(null,cljs.core.mk_bound_fn.call(null,sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn.call(null,sc,end_test,end_key).call(null,e))?s:cljs.core.next.call(null,s)));
} else {
return null;
}
}));

(cljs.core.rsubseq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.IChunk}
*/
cljs.core.RangeChunk = (function (start,step,count){
this.start = start;
this.step = step;
this.count = count;
this.cljs$lang$protocol_mask$partition0$ = 82;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RangeChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.RangeChunk.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.start;
}));

(cljs.core.RangeChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.start + (i * self__.step));
}));

(cljs.core.RangeChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < self__.count)))){
return (self__.start + (i * self__.step));
} else {
return not_found;
}
}));

(cljs.core.RangeChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RangeChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count <= (1))){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.RangeChunk((self__.start + self__.step),self__.step,(self__.count - (1))));
}
}));

(cljs.core.RangeChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"step","step",-1365547645,null),new cljs.core.Symbol(null,"count","count",-514511684,null)], null);
}));

(cljs.core.RangeChunk.cljs$lang$type = true);

(cljs.core.RangeChunk.cljs$lang$ctorStr = "cljs.core/RangeChunk");

(cljs.core.RangeChunk.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/RangeChunk");
}));

/**
 * Positional factory function for cljs.core/RangeChunk.
 */
cljs.core.__GT_RangeChunk = (function cljs$core$__GT_RangeChunk(start,step,count){
return (new cljs.core.RangeChunk(start,step,count));
});


/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
});
(cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
}));

(cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
(self__.i = (self__.i + self__.step));

return ret;
}));

(cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null);
}));

(cljs.core.RangeIterator.cljs$lang$type = true);

(cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator");

(cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/RangeIterator");
}));

/**
 * Positional factory function for cljs.core/RangeIterator.
 */
cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Range = (function (meta,start,end,step,chunk,chunk_next,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.chunk = chunk;
this.chunk_next = chunk_next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 140800;
});
(cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_.call(null,coll);
}));

(cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return cljs.core._equiv.call(null,this$,other);
}));

(cljs.core.Range.prototype.indexOf = (function() {
var G__48324 = null;
var G__48324__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,(0));
});
var G__48324__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.call(null,coll,x,start__$1);
});
G__48324 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__48324__1.call(this,x);
case 2:
return G__48324__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48324.cljs$core$IFn$_invoke$arity$1 = G__48324__1;
G__48324.cljs$core$IFn$_invoke$arity$2 = G__48324__2;
return G__48324;
})()
);

(cljs.core.Range.prototype.lastIndexOf = (function() {
var G__48327 = null;
var G__48327__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,cljs.core.count.call(null,coll));
});
var G__48327__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.call(null,coll,x,start__$1);
});
G__48327 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__48327__1.call(this,x);
case 2:
return G__48327__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48327.cljs$core$IFn$_invoke$arity$1 = G__48327__1;
G__48327.cljs$core$IFn$_invoke$arity$2 = G__48327__2;
return G__48327;
})()
);

(cljs.core.Range.prototype.forceChunk = (function (){
var self__ = this;
var coll = this;
if((self__.chunk == null)){
var count = cljs.core._count.call(null,coll);
if((count > (32))){
(self__.chunk_next = (new cljs.core.Range(null,(self__.start + (self__.step * (32))),self__.end,self__.step,null,null,null)));

return (self__.chunk = (new cljs.core.RangeChunk(self__.start,self__.step,(32))));
} else {
return (self__.chunk = (new cljs.core.RangeChunk(self__.start,self__.step,count)));
}
} else {
return null;
}
}));

(cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if(((((0) <= n)) && ((n < cljs.core._count.call(null,rng__$1))))){
return (self__.start + (n * self__.step));
} else {
if(((((0) <= n)) && ((self__.start > self__.end)) && ((self__.step === (0))))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
}));

(cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if(((((0) <= n)) && ((n < cljs.core._count.call(null,rng__$1))))){
return (self__.start + (n * self__.step));
} else {
if(((((0) <= n)) && ((self__.start > self__.end)) && ((self__.step === (0))))){
return self__.start;
} else {
return not_found;
}
}
}));

(cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
}));

(cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
}));

(cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.chunk,self__.chunk_next,self__.__hash));
}));

(cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(null,(self__.start + self__.step),self__.end,self__.step,null,null,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(null,(self__.start + self__.step),self__.end,self__.step,null,null,null));
} else {
return null;
}
}
}));

(cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return Math.ceil(((self__.end - self__.start) / self__.step));
}));

(cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = cljs.core.hash_ordered_coll.call(null,rng__$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential.call(null,rng__$1,other);
}));

(cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.call(null,rng__$1,f);
}));

(cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = f.call(null,ret,i);
if(cljs.core.reduced_QMARK_.call(null,ret__$1)){
return cljs.core.deref.call(null,ret__$1);
} else {
var G__48355 = (i + self__.step);
var G__48356 = ret__$1;
i = G__48355;
ret = G__48356;
continue;
}
} else {
return ret;
}
break;
}
}));

(cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.start;
}));

(cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var s = cljs.core._next.call(null,rng__$1);
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
}));

(cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return rng__$1;
}));

(cljs.core.Range.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
rng__$1.forceChunk();

return self__.chunk;
}));

(cljs.core.Range.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
rng__$1.forceChunk();

if((self__.chunk_next == null)){
return cljs.core.List.EMPTY;
} else {
return self__.chunk_next;
}
}));

(cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,new_meta){
var self__ = this;
var rng__$1 = this;
if((new_meta === self__.meta)){
return rng__$1;
} else {
return (new cljs.core.Range(new_meta,self__.start,self__.end,self__.step,self__.chunk,self__.chunk_next,self__.__hash));
}
}));

(cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons.call(null,o,rng__$1);
}));

(cljs.core.Range.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.seq.call(null,cljs.core._chunked_rest.call(null,rng__$1));
}));

(cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null),cljs.core.with_meta(new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"chunk-next","chunk-next",-547810434,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(cljs.core.Range.cljs$lang$type = true);

(cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range");

(cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"cljs.core/Range");
}));

/**
 * Positional factory function for cljs.core/Range.
 */
cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,chunk,chunk_next,__hash){
return (new cljs.core.Range(meta,start,end,step,chunk,chunk_next,__hash));
});

goog.object.set(cljs.core.Range.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__6781__auto__ = this;
return cljs.core.es6_iterator.call(null,this__6781__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(var_args){
var G__44241 = arguments.length;
switch (G__44241) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.call(null,(0),Number.MAX_VALUE,(1));
}));

(cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.call(null,(0),end,(1));
}));

(cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.call(null,start,end,(1));
}));

(cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
if((step > (0))){
if((end <= start)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.Range(null,start,end,step,null,null,null));
}
} else {
if((step < (0))){
if((end >= start)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.Range(null,start,end,step,null,null,null));
}
} else {
if((end === start)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.repeat.call(null,start);
}

}
}
}));

(cljs.core.range.cljs$lang$maxFixedArity = 3);

/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(var_args){
var G__44243 = arguments.length;
switch (G__44243) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var ia = cljs.core.volatile_BANG_.call(null,(-1));
return (function() {
var G__48398 = null;
var G__48398__0 = (function (){
return rf.call(null);
});
var G__48398__1 = (function (result){
return rf.call(null,result);
});
var G__48398__2 = (function (result,input){
var i = cljs.core._vreset_BANG_.call(null,ia,(cljs.core._deref.call(null,ia) + (1)));
if((cljs.core.rem.call(null,i,n) === (0))){
return rf.call(null,result,input);
} else {
return result;
}
});
G__48398 = function(result,input){
switch(arguments.length){
case 0:
return G__48398__0.call(this);
case 1:
return G__48398__1.call(this,result);
case 2:
return G__48398__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48398.cljs$core$IFn$_invoke$arity$0 = G__48398__0;
G__48398.cljs$core$IFn$_invoke$arity$1 = G__48398__1;
G__48398.cljs$core$IFn$_invoke$arity$2 = G__48398__2;
return G__48398;
})()
});
}));

(cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.cons.call(null,cljs.core.first.call(null,s),cljs.core.take_nth.call(null,n,cljs.core.drop.call(null,n,s)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.take_nth.cljs$lang$maxFixedArity = 2);

/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.call(null,pred,coll),cljs.core.drop_while.call(null,pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(var_args){
var G__44246 = arguments.length;
switch (G__44246) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list.call(null);
var pa = cljs.core.volatile_BANG_.call(null,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return (function() {
var G__48412 = null;
var G__48412__0 = (function (){
return rf.call(null);
});
var G__48412__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec.call(null,a.toArray());
a.clear();

return cljs.core.unreduced.call(null,rf.call(null,result,v));
})());
return rf.call(null,result__$1);
});
var G__48412__2 = (function (result,input){
var pval = cljs.core.deref.call(null,pa);
var val = f.call(null,input);
cljs.core.vreset_BANG_.call(null,pa,val);

if(((cljs.core.keyword_identical_QMARK_.call(null,pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.call(null,val,pval)))){
a.add(input);

return result;
} else {
var v = cljs.core.vec.call(null,a.toArray());
a.clear();

var ret = rf.call(null,result,v);
if(cljs.core.reduced_QMARK_.call(null,ret)){
} else {
a.add(input);
}

return ret;
}
});
G__48412 = function(result,input){
switch(arguments.length){
case 0:
return G__48412__0.call(this);
case 1:
return G__48412__1.call(this,result);
case 2:
return G__48412__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48412.cljs$core$IFn$_invoke$arity$0 = G__48412__0;
G__48412.cljs$core$IFn$_invoke$arity$1 = G__48412__1;
G__48412.cljs$core$IFn$_invoke$arity$2 = G__48412__2;
return G__48412;
})()
});
}));

(cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
var fst = cljs.core.first.call(null,s);
var fv = f.call(null,fst);
var run = cljs.core.cons.call(null,fst,cljs.core.take_while.call(null,(function (p1__44244_SHARP_){
return cljs.core._EQ_.call(null,fv,f.call(null,p1__44244_SHARP_));
}),cljs.core.next.call(null,s)));
return cljs.core.cons.call(null,run,cljs.core.partition_by.call(null,f,(new cljs.core.LazySeq(null,(function (){
return cljs.core.drop.call(null,cljs.core.count.call(null,run),s);
}),null,null))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition_by.cljs$lang$maxFixedArity = 2);

/**
 * Returns a map from distinct items in coll to the number of times
 *   they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (counts,x){
return cljs.core.assoc_BANG_.call(null,counts,x,(cljs.core.get.call(null,counts,x,(0)) + (1)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 *   per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(var_args){
var G__44248 = arguments.length;
switch (G__44248) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5718__auto__ = cljs.core.seq.call(null,coll);
if(temp__5718__auto__){
var s = temp__5718__auto__;
return cljs.core.reductions.call(null,f,cljs.core.first.call(null,s),cljs.core.rest.call(null,s));
} else {
return (new cljs.core.List(null,f.call(null),null,(1),null));
}
}),null,null));
}));

(cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
if(cljs.core.reduced_QMARK_.call(null,init)){
return (new cljs.core.List(null,cljs.core.deref.call(null,init),null,(1),null));
} else {
return cljs.core.cons.call(null,init,(new cljs.core.LazySeq(null,(function (){
var temp__5720__auto__ = cljs.core.seq.call(null,coll);
if(temp__5720__auto__){
var s = temp__5720__auto__;
return cljs.core.reductions.call(null,f,f.call(null,init,cljs.core.first.call(null,s)),cljs.core.rest.call(null,s));
} else {
return null;
}
}),null,null)));
}
}));

(cljs.core.reductions.cljs$lang$maxFixedArity = 3);

/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 *   of those fns.  The returned fn takes a variable number of args, and
 *   returns a vector containing the result of applying each fn to the
 *   args (left-to-right).
 *   ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(var_args){
var G__44264 = arguments.length;
switch (G__44264) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__6949__auto__ = [];
var len__6920__auto___48438 = arguments.length;
var i__6921__auto___48440 = (0);
while(true){
if((i__6921__auto___48440 < len__6920__auto___48438)){
args_arr__6949__auto__.push((arguments[i__6921__auto___48440]));

var G__48443 = (i__6921__auto___48440 + (1));
i__6921__auto___48440 = G__48443;
continue;
} else {
}
break;
}

var argseq__6950__auto__ = (new cljs.core.IndexedSeq(args_arr__6949__auto__.slice((3)),(0),null));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__6950__auto__);

}
});

(cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__48448 = null;
var G__48448__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null)],null));
});
var G__48448__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x)],null));
});
var G__48448__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x,y)],null));
});
var G__48448__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x,y,z)],null));
});
var G__48448__4 = (function() { 
var G__48449__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.call(null,f,x,y,z,args)],null));
};
var G__48449 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__48452__i = 0, G__48452__a = new Array(arguments.length -  3);
while (G__48452__i < G__48452__a.length) {G__48452__a[G__48452__i] = arguments[G__48452__i + 3]; ++G__48452__i;}
  args = new cljs.core.IndexedSeq(G__48452__a,0,null);
} 
return G__48449__delegate.call(this,x,y,z,args);};
G__48449.cljs$lang$maxFixedArity = 3;
G__48449.cljs$lang$applyTo = (function (arglist__48453){
var x = cljs.core.first(arglist__48453);
arglist__48453 = cljs.core.next(arglist__48453);
var y = cljs.core.first(arglist__48453);
arglist__48453 = cljs.core.next(arglist__48453);
var z = cljs.core.first(arglist__48453);
var args = cljs.core.rest(arglist__48453);
return G__48449__delegate(x,y,z,args);
});
G__48449.cljs$core$IFn$_invoke$arity$variadic = G__48449__delegate;
return G__48449;
})()
;
G__48448 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__48448__0.call(this);
case 1:
return G__48448__1.call(this,x);
case 2:
return G__48448__2.call(this,x,y);
case 3:
return G__48448__3.call(this,x,y,z);
default:
var G__48454 = null;
if (arguments.length > 3) {
var G__48455__i = 0, G__48455__a = new Array(arguments.length -  3);
while (G__48455__i < G__48455__a.length) {G__48455__a[G__48455__i] = arguments[G__48455__i + 3]; ++G__48455__i;}
G__48454 = new cljs.core.IndexedSeq(G__48455__a,0,null);
}
return G__48448__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__48454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48448.cljs$lang$maxFixedArity = 3;
G__48448.cljs$lang$applyTo = G__48448__4.cljs$lang$applyTo;
G__48448.cljs$core$IFn$_invoke$arity$0 = G__48448__0;
G__48448.cljs$core$IFn$_invoke$arity$1 = G__48448__1;
G__48448.cljs$core$IFn$_invoke$arity$2 = G__48448__2;
G__48448.cljs$core$IFn$_invoke$arity$3 = G__48448__3;
G__48448.cljs$core$IFn$_invoke$arity$variadic = G__48448__4.cljs$core$IFn$_invoke$arity$variadic;
return G__48448;
})()
}));

(cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__48456 = null;
var G__48456__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null),g.call(null)],null));
});
var G__48456__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x),g.call(null,x)],null));
});
var G__48456__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x,y),g.call(null,x,y)],null));
});
var G__48456__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x,y,z),g.call(null,x,y,z)],null));
});
var G__48456__4 = (function() { 
var G__48470__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.call(null,f,x,y,z,args),cljs.core.apply.call(null,g,x,y,z,args)],null));
};
var G__48470 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__48473__i = 0, G__48473__a = new Array(arguments.length -  3);
while (G__48473__i < G__48473__a.length) {G__48473__a[G__48473__i] = arguments[G__48473__i + 3]; ++G__48473__i;}
  args = new cljs.core.IndexedSeq(G__48473__a,0,null);
} 
return G__48470__delegate.call(this,x,y,z,args);};
G__48470.cljs$lang$maxFixedArity = 3;
G__48470.cljs$lang$applyTo = (function (arglist__48474){
var x = cljs.core.first(arglist__48474);
arglist__48474 = cljs.core.next(arglist__48474);
var y = cljs.core.first(arglist__48474);
arglist__48474 = cljs.core.next(arglist__48474);
var z = cljs.core.first(arglist__48474);
var args = cljs.core.rest(arglist__48474);
return G__48470__delegate(x,y,z,args);
});
G__48470.cljs$core$IFn$_invoke$arity$variadic = G__48470__delegate;
return G__48470;
})()
;
G__48456 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__48456__0.call(this);
case 1:
return G__48456__1.call(this,x);
case 2:
return G__48456__2.call(this,x,y);
case 3:
return G__48456__3.call(this,x,y,z);
default:
var G__48481 = null;
if (arguments.length > 3) {
var G__48482__i = 0, G__48482__a = new Array(arguments.length -  3);
while (G__48482__i < G__48482__a.length) {G__48482__a[G__48482__i] = arguments[G__48482__i + 3]; ++G__48482__i;}
G__48481 = new cljs.core.IndexedSeq(G__48482__a,0,null);
}
return G__48456__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__48481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48456.cljs$lang$maxFixedArity = 3;
G__48456.cljs$lang$applyTo = G__48456__4.cljs$lang$applyTo;
G__48456.cljs$core$IFn$_invoke$arity$0 = G__48456__0;
G__48456.cljs$core$IFn$_invoke$arity$1 = G__48456__1;
G__48456.cljs$core$IFn$_invoke$arity$2 = G__48456__2;
G__48456.cljs$core$IFn$_invoke$arity$3 = G__48456__3;
G__48456.cljs$core$IFn$_invoke$arity$variadic = G__48456__4.cljs$core$IFn$_invoke$arity$variadic;
return G__48456;
})()
}));

(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__48483 = null;
var G__48483__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null),g.call(null),h.call(null)],null));
});
var G__48483__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x),g.call(null,x),h.call(null,x)],null));
});
var G__48483__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x,y),g.call(null,x,y),h.call(null,x,y)],null));
});
var G__48483__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[f.call(null,x,y,z),g.call(null,x,y,z),h.call(null,x,y,z)],null));
});
var G__48483__4 = (function() { 
var G__48485__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.call(null,f,x,y,z,args),cljs.core.apply.call(null,g,x,y,z,args),cljs.core.apply.call(null,h,x,y,z,args)],null));
};
var G__48485 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__48486__i = 0, G__48486__a = new Array(arguments.length -  3);
while (G__48486__i < G__48486__a.length) {G__48486__a[G__48486__i] = arguments[G__48486__i + 3]; ++G__48486__i;}
  args = new cljs.core.IndexedSeq(G__48486__a,0,null);
} 
return G__48485__delegate.call(this,x,y,z,args);};
G__48485.cljs$lang$maxFixedArity = 3;
G__48485.cljs$lang$applyTo = (function (arglist__48487){
var x = cljs.core.first(arglist__48487);
arglist__48487 = cljs.core.next(arglist__48487);
var y = cljs.core.first(arglist__48487);
arglist__48487 = cljs.core.next(arglist__48487);
var z = cljs.core.first(arglist__48487);
var args = cljs.core.rest(arglist__48487);
return G__48485__delegate(x,y,z,args);
});
G__48485.cljs$core$IFn$_invoke$arity$variadic = G__48485__delegate;
return G__48485;
})()
;
G__48483 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__48483__0.call(this);
case 1:
return G__48483__1.call(this,x);
case 2:
return G__48483__2.call(this,x,y);
case 3:
return G__48483__3.call(this,x,y,z);
default:
var G__48495 = null;
if (arguments.length > 3) {
var G__48496__i = 0, G__48496__a = new Array(arguments.length -  3);
while (G__48496__i < G__48496__a.length) {G__48496__a[G__48496__i] = arguments[G__48496__i + 3]; ++G__48496__i;}
G__48495 = new cljs.core.IndexedSeq(G__48496__a,0,null);
}
return G__48483__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__48495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__48483.cljs$lang$maxFixedArity = 3;
G__48483.cljs$lang$applyTo = G__48483__4.cljs$lang$applyTo;
G__48483.cljs$core$IFn$_invoke$arity$0 = G__48483__0;
G__48483.cljs$core$IFn$_invoke$arity$1 = G__48483__1;
G__48483.cljs$core$IFn$_invoke$arity$2 = G__48483__2;
G__48483.cljs$core$IFn$_invoke$arity$3 = G__48483__3;
G__48483.cljs$core$IFn$_invoke$arity$variadic = G__48483__4.cljs$core$IFn$_invoke$arity$variadic;
return G__48483;
})()
}));

(cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.call(null,f,g,h,fs);
return (function() {
var G__48497 = null;
var G__48497__0 = (function (){
return cljs.core.reduce.call(null,(function (p1__44249_SHARP_,p2__44250_SHARP_){
return cljs.core.conj.call(null,p1__44249_SHARP_,p2__44250_SHARP_.call(null));
}),cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__48497__1 = (function (x){
return cljs.core.reduce.call(null,(function (p1__44251_SHARP_,p2__44252_SHARP_){
return cljs.core.conj.call(null,p1__44251_SHARP_,p2__44252_SHARP_.call(null,x));
}),cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__48497__2 = (function (x,y){
return cljs.core.reduce.call(null,(function (p1__44253_SHARP_,p2__44254_SHARP_){
return cljs.core.conj.call(null,p1__44253_SHARP_,p2__44254_SHARP_.call(null,x,y));
}),cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__48497__3 = (function (x,y,z){
return cljs.core.reduce.call(null,(function (p1__44255_SHARP_,p2__44256_SHARP_){
return cljs.core.conj.call(null,p1__44255_SHARP_,p2__44256_SHARP_.call(null,x,y,z));
}),cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__48497__4 = (function() { 
var G__48504__delegate = function (x,y,z,args){
return cljs.core.reduce.call(null,(function (p1__44257_SHARP_,p2__44258_SHARP_){
return cljs.core.conj.call(null,p1__44257_SHARP_,cljs.core.apply.call(null,p2__44258_SHARP_,x,y,z,args));
}),cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__48504 = function (x,y,z,var_args){
var args = null;
if (arguments.len