(ns ch.codesmith.blocks.postgres
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.jdbc :as cbjdbc]))

(defmulti postgres (fn [_ config] (::cb/type config)))

(def config-defaults
  {:reWriteBatchedInserts true})

(defmethod postgres :external
  [_ config]
  {::cb/instance (cbjdbc/init (merge config-defaults config))
   ::cb/halt     cbjdbc/halt!})


