(ns ch.codesmith.blocks.postgres.dev
  (:require [ch.codesmith.blocks :as cb]
            [ch.codesmith.blocks.jdbc :as cbjdbc]
            [ch.codesmith.blocks.postgres :as cbp])
  (:import (com.zaxxer.hikari HikariDataSource)
           (io.zonky.test.db.postgres.embedded EmbeddedPostgres)))

(def postgres cbp/postgres)

(defmethod cbp/postgres :embedded-dev
  [_ {:keys [port] :as config}]
  {::cb/instance         (let [builder                             (EmbeddedPostgres/builder)
                               builder                             (if port (.setPort builder port) builder)
                               ^EmbeddedPostgres embedded-postgres (.start builder)
                               jdbc-url                            (.getJdbcUrl embedded-postgres "postgres" "postgres")
                               config                              (update config :datasource
                                                                           #(assoc %
                                                                              :jdbcUrl jdbc-url
                                                                              :password "postgres"))
                               ^HikariDataSource ds                (cbjdbc/init config)]
                           {:datasource        ds
                            :embedded-postgres embedded-postgres})
   ::cb/resolve-instance :datasource
   ::cb/halt             (fn [_ {:keys [^HikariDataSource datasource ^EmbeddedPostgres embedded-postgres]}]
                           (.close datasource)
                           (.close embedded-postgres))})


