/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.velocity;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tiles.request.AbstractViewRequest;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.DispatchRequest;
import org.apache.tiles.request.servlet.ExternalWriterHttpServletResponse;
import org.apache.tiles.request.servlet.ServletUtil;
import org.apache.tiles.request.velocity.VelocityScopeMap;
import org.apache.velocity.context.Context;

public class VelocityRequest
extends AbstractViewRequest {
    private final List<String> scopes;
    private final Context ctx;
    private Writer writer;
    private Map<String, Object> pageScope;

    public static VelocityRequest createVelocityRequest(ApplicationContext applicationContext, HttpServletRequest request, HttpServletResponse response, Context velocityContext, Writer writer) {
        org.apache.tiles.request.servlet.ServletRequest servletRequest = new org.apache.tiles.request.servlet.ServletRequest(applicationContext, request, response);
        VelocityRequest velocityRequest = new VelocityRequest(servletRequest, velocityContext, writer);
        return velocityRequest;
    }

    public VelocityRequest(DispatchRequest enclosedRequest, Context ctx, Writer writer) {
        super(enclosedRequest);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.addAll(enclosedRequest.getAvailableScopes());
        scopes.add("page");
        this.scopes = Collections.unmodifiableList(scopes);
        this.ctx = ctx;
        this.writer = writer;
    }

    @Override
    public List<String> getAvailableScopes() {
        return this.scopes;
    }

    @Override
    protected void doInclude(String path) throws IOException {
        org.apache.tiles.request.servlet.ServletRequest servletRequest = ServletUtil.getServletRequest(this);
        HttpServletRequest request = servletRequest.getRequest();
        HttpServletResponse response = servletRequest.getResponse();
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            throw new IOException("No request dispatcher returned for path '" + path + "'");
        }
        PrintWriter printWriter = this.getPrintWriter();
        try {
            rd.include((ServletRequest)request, (ServletResponse)new ExternalWriterHttpServletResponse(response, printWriter));
        }
        catch (ServletException ex) {
            throw ServletUtil.wrapServletException(ex, "ServletException including path '" + path + "'.");
        }
    }

    @Override
    public PrintWriter getPrintWriter() {
        if (this.writer == null) {
            throw new IllegalStateException("A writer-less Tiles request has been created, cannot return a PrintWriter");
        }
        if (this.writer instanceof PrintWriter) {
            return (PrintWriter)this.writer;
        }
        return new PrintWriter(this.writer);
    }

    @Override
    public Writer getWriter() {
        if (this.writer == null) {
            throw new IllegalStateException("A writer-less Tiles request has been created, cannot return a PrintWriter");
        }
        return this.writer;
    }

    public Map<String, Object> getPageScope() {
        if (this.pageScope == null) {
            this.pageScope = new VelocityScopeMap(this.ctx);
        }
        return this.pageScope;
    }

    @Override
    public Map<String, Object> getContext(String scope) {
        return "page".equals(scope) ? this.getPageScope() : super.getContext(scope);
    }
}

