/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.schema.Schema;

public class UnextractedMessage
extends Expression {
    private final String meaning;
    private final String comment;
    private final boolean hidden;
    private final Expression content;

    public UnextractedMessage(Node fromNode, Schema schema, String meaning, String comment, boolean hidden, Expression content) {
        super(fromNode, schema);
        this.meaning = meaning;
        this.comment = comment;
        this.hidden = hidden;
        this.content = Preconditions.checkNotNull(content);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitUnextractedMessage(this);
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Expression getContent() {
        return this.content;
    }

    public UnextractedMessage withContent(Expression newContent) {
        return newContent.equals(this.content) ? this : new UnextractedMessage(this, this.getSchema(), this.meaning, this.comment, this.hidden, newContent);
    }

    public UnextractedMessage withContentAndSchema(Expression newContent, Schema newSchema) {
        return newContent.equals(this.content) && Objects.equal(newSchema, this.getSchema()) ? this : new UnextractedMessage(this, newSchema, this.meaning, this.comment, this.hidden, newContent);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof UnextractedMessage && this.equals((UnextractedMessage)that);
    }

    public boolean equals(UnextractedMessage that) {
        return this.equalsExpression(that) && Objects.equal(this.getMeaning(), that.getMeaning()) && Objects.equal(this.getComment(), that.getComment()) && Objects.equal(this.isHidden(), that.isHidden()) && Objects.equal(this.getContent(), that.getContent());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getMeaning(), this.getComment(), this.isHidden(), this.getContent());
    }
}

