/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.grouping;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.grouping.Load;

public class LoadMapping {
    private static final Load NOT_CONNECTED = new Load(false, 1.0, 1.0);
    private final AtomicReference<Map<Integer, Load>> local = new AtomicReference(new HashMap());
    private final AtomicReference<Map<Integer, Load>> remote = new AtomicReference(new HashMap());

    public void setLocal(Map<Integer, Double> local) {
        HashMap<Integer, Load> newLocal = new HashMap<Integer, Load>();
        if (local != null) {
            for (Map.Entry<Integer, Double> entry : local.entrySet()) {
                newLocal.put(entry.getKey(), new Load(true, entry.getValue(), 0.0));
            }
        }
        this.local.set(newLocal);
    }

    public void setRemote(Map<Integer, Load> remote) {
        if (remote != null) {
            this.remote.set(new HashMap<Integer, Load>(remote));
        } else {
            this.remote.set(new HashMap());
        }
    }

    public Load getLoad(int task) {
        Load ret = this.local.get().get(task);
        if (ret == null) {
            ret = this.remote.get().get(task);
        }
        if (ret == null) {
            ret = NOT_CONNECTED;
        }
        return ret;
    }

    public double get(int task) {
        return this.getLoad(task).getLoad();
    }
}

