/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.topology.ComponentConfigurationDeclarer;
import org.apache.storm.topology.ResourceDeclarer;

public abstract class BaseConfigurationDeclarer<T extends ComponentConfigurationDeclarer>
implements ComponentConfigurationDeclarer<T> {
    @Override
    public T addConfiguration(String config, Object value) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(config, value);
        return this.addConfigurations(configMap);
    }

    @Override
    public T setDebug(boolean debug2) {
        return this.addConfiguration("topology.debug", debug2);
    }

    @Override
    public T setMaxTaskParallelism(Number val) {
        if (val != null) {
            val = val.intValue();
        }
        return this.addConfiguration("topology.max.task.parallelism", val);
    }

    @Override
    public T setMaxSpoutPending(Number val) {
        if (val != null) {
            val = val.intValue();
        }
        return this.addConfiguration("topology.max.spout.pending", val);
    }

    @Override
    public T setNumTasks(Number val) {
        if (val != null) {
            val = val.intValue();
        }
        return this.addConfiguration("topology.tasks", val);
    }

    @Override
    public T setMemoryLoad(Number onHeap) {
        if (onHeap != null) {
            onHeap = onHeap.doubleValue();
            this.addResource("topology.component.resources.onheap.memory.mb", onHeap);
            return this.addConfiguration("topology.component.resources.onheap.memory.mb", onHeap);
        }
        return (T)this;
    }

    @Override
    public T setMemoryLoad(Number onHeap, Number offHeap) {
        ResourceDeclarer<T> ret = this;
        ret = this.setMemoryLoad(onHeap);
        if (offHeap != null) {
            offHeap = offHeap.doubleValue();
            this.addResource("topology.component.resources.offheap.memory.mb", offHeap);
            ret = this.addConfiguration("topology.component.resources.offheap.memory.mb", offHeap);
        }
        return (T)ret;
    }

    @Override
    public T setCPULoad(Number amount) {
        if (amount != null) {
            this.addResource("topology.component.cpu.pcore.percent", amount);
            return this.addConfiguration("topology.component.cpu.pcore.percent", amount);
        }
        return (T)this;
    }

    @Override
    public T addResource(String resourceName, Number resourceValue) {
        Map resourcesMap = (Map)this.getComponentConfiguration().computeIfAbsent("topology.component.resources.map", x -> new HashMap());
        resourcesMap.put(resourceName, resourceValue.doubleValue());
        return (T)this;
    }

    @Override
    public T addResources(Map<String, Double> resources) {
        if (resources != null) {
            Map currentResources = (Map)this.getComponentConfiguration().computeIfAbsent("topology.component.resources.map", k -> new HashMap());
            currentResources.putAll(resources);
        }
        return (T)this;
    }
}

