/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.config.ConfigException;

class ShareConsumerConfig
extends ConsumerConfig {
    private static final List<String> SHARE_GROUP_UNSUPPORTED_CONFIGS = List.of("auto.offset.reset", "enable.auto.commit", "group.instance.id", "isolation.level", "partition.assignment.strategy", "interceptor.classes", "session.timeout.ms", "heartbeat.interval.ms", "group.protocol", "group.remote.assignor");

    ShareConsumerConfig(Properties props) {
        super(props);
    }

    ShareConsumerConfig(Map<String, Object> props) {
        super(props);
    }

    protected ShareConsumerConfig(Map<?, ?> props, boolean doLog) {
        super(props, doLog);
    }

    @Override
    protected Map<String, Object> preProcessParsedConfig(Map<String, Object> parsedValues) {
        this.checkUnsupportedConfigsPreProcess(parsedValues);
        return parsedValues;
    }

    private void checkUnsupportedConfigsPreProcess(Map<String, Object> parsedValues) {
        ArrayList invalidConfigs = new ArrayList();
        SHARE_GROUP_UNSUPPORTED_CONFIGS.forEach(configName -> {
            if (parsedValues.containsKey(configName)) {
                invalidConfigs.add(configName);
            }
        });
        if (!invalidConfigs.isEmpty()) {
            throw new ConfigException(String.join((CharSequence)", ", invalidConfigs) + " cannot be set when using a share group.");
        }
    }

    @Override
    protected void checkUnsupportedConfigsPostProcess() {
    }
}

