/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.ide.impl.vlt.VltRepository;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryFactory;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceRanking;

@Component(service={RepositoryFactory.class})
@ServiceRanking(value=1000)
public class VltRepositoryFactory
implements RepositoryFactory {
    private final Logger logger;
    private Map<String, VltRepository> repositoryMap = new HashMap<String, VltRepository>();

    @Activate
    public VltRepositoryFactory(@Reference Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(RepositoryInfo repositoryInfo, boolean acceptsDisconnectedRepository) throws RepositoryException {
        String key = this.getKey(repositoryInfo);
        Map<String, VltRepository> map = this.repositoryMap;
        synchronized (map) {
            VltRepository repo = this.repositoryMap.get(key);
            if (repo == null) {
                return null;
            }
            if (!repo.isDisconnected() || acceptsDisconnectedRepository) {
                return repo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository connectRepository(RepositoryInfo repositoryInfo) throws RepositoryException {
        String key = this.getKey(repositoryInfo);
        Map<String, VltRepository> map = this.repositoryMap;
        synchronized (map) {
            VltRepository repo = this.repositoryMap.get(key);
            if (repo != null && !repo.isDisconnected()) {
                return repo;
            }
            repo = new VltRepository(repositoryInfo, this.logger);
            repo.connect();
            this.repositoryMap.put(key, repo);
            return repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectRepository(RepositoryInfo repositoryInfo) {
        String key = this.getKey(repositoryInfo);
        Map<String, VltRepository> map = this.repositoryMap;
        synchronized (map) {
            VltRepository r = this.repositoryMap.get(key);
            if (r != null) {
                r.disconnected();
            }
        }
    }

    private String getKey(RepositoryInfo repositoryInfo) {
        return repositoryInfo.getUsername() + ":" + repositoryInfo.getPassword() + "@" + String.valueOf(repositoryInfo.getUrl());
    }
}

