/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.WraparoundApplicator;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;

public final class WraparoundAxesFinder {
    public final CoordinateReferenceSystem preferredCRS;
    public final MathTransform preferredToSpecified;

    public WraparoundAxesFinder(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            ProjectedCRS p = (ProjectedCRS)crs;
            crs = p.getBaseCRS();
            this.preferredToSpecified = p.getConversionFromBase().getMathTransform();
        } else {
            this.preferredToSpecified = MathTransforms.identity(CRS.getDimensionOrZero(crs));
        }
        this.preferredCRS = crs;
    }

    public double[] periods() {
        double[] periods = null;
        CoordinateSystem cs = this.preferredCRS.getCoordinateSystem();
        int i = cs.getDimension();
        while (--i >= 0) {
            double period = WraparoundApplicator.range(cs, i);
            if (!(period > 0.0)) continue;
            if (periods == null) {
                periods = new double[i + 1];
            }
            periods[i] = period;
        }
        return periods;
    }
}

