/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mailbox.cassandra.DeleteMessageListener;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.server.core.Envelope;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageVault;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DeletedMessageVaultDeletionCallback
implements DeleteMessageListener.DeletionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedMessageVaultDeletionCallback.class);
    private final DeletedMessageVault deletedMessageVault;
    private final BlobStore blobStore;
    private final Clock clock;

    @Inject
    public DeletedMessageVaultDeletionCallback(DeletedMessageVault deletedMessageVault, BlobStore blobStore, Clock clock) {
        this.deletedMessageVault = deletedMessageVault;
        this.blobStore = blobStore;
        this.clock = clock;
    }

    public Mono<Void> forMessage(DeleteMessageListener.DeletedMessageCopyCommand copyCommand) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), copyCommand.getHeaderId(), BlobStore.StoragePolicy.LOW_COST)).flatMap(bytes -> {
            Optional<Message> mimeMessage = this.parseMessage(new ByteArrayInputStream((byte[])bytes), copyCommand.getMessageId());
            DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId(copyCommand.getMessageId())).originMailboxes(new MailboxId[]{copyCommand.getMailboxId()})).user(copyCommand.getOwner())).deliveryDate(ZonedDateTime.ofInstant(copyCommand.getInternalDate().toInstant(), ZoneOffset.UTC))).deletionDate(ZonedDateTime.ofInstant(this.clock.instant(), ZoneOffset.UTC))).sender(this.retrieveSender(mimeMessage))).recipients(this.retrieveRecipients(mimeMessage))).hasAttachment(copyCommand.hasAttachments())).size(copyCommand.getSize())).subject(mimeMessage.map(Message::getSubject)).build();
            return Mono.from((Publisher)this.blobStore.readReactive(this.blobStore.getDefaultBucketName(), copyCommand.getBodyId(), BlobStore.StoragePolicy.LOW_COST)).map(bodyStream -> new SequenceInputStream(new ByteArrayInputStream((byte[])bytes), (InputStream)bodyStream)).flatMap(bodyStream -> Mono.from((Publisher)this.deletedMessageVault.append(deletedMessage, (InputStream)bodyStream)));
        });
    }

    private Optional<Message> parseMessage(InputStream inputStream, MessageId messageId) {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        try {
            return Optional.ofNullable(messageBuilder.parseMessage(inputStream));
        }
        catch (MimeIOException e) {
            LOGGER.warn("Can not parse the message {}", (Object)messageId, (Object)e);
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MaybeSender retrieveSender(Optional<Message> mimeMessage) {
        return mimeMessage.map(Message::getSender).map(Mailbox::getAddress).map(MaybeSender::getMailSender).orElse(MaybeSender.nullSender());
    }

    private Set<MailAddress> retrieveRecipients(Optional<Message> maybeMessage) {
        return maybeMessage.map(message -> Envelope.fromMime4JMessage((Message)message, (Envelope.ValidationPolicy)Envelope.ValidationPolicy.IGNORE)).map(Envelope::getRecipients).orElse((Set)ImmutableSet.of());
    }
}

