/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.transport.ReceiverContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import java.net.URI;

public class PropagatingReceiverTracingObservationHandler<T extends ReceiverContext>
implements TracingObservationHandler<T> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(PropagatingReceiverTracingObservationHandler.class);
    private final Tracer tracer;
    private final Propagator propagator;

    public PropagatingReceiverTracingObservationHandler(Tracer tracer, Propagator propagator) {
        this.tracer = tracer;
        this.propagator = propagator;
    }

    public void onStart(T context) {
        Span.Builder extractedSpan = this.propagator.extract(context.getCarrier(), (carrier, key) -> context.getGetter().get(carrier, key));
        extractedSpan.kind(Span.Kind.valueOf(context.getKind().name()));
        if (context.getRemoteServiceName() != null) {
            extractedSpan.remoteServiceName(context.getRemoteServiceName());
        }
        if (context.getRemoteServiceAddress() != null) {
            try {
                URI uri = URI.create(context.getRemoteServiceAddress());
                extractedSpan = extractedSpan.remoteIpAndPort(uri.getHost(), uri.getPort());
            }
            catch (Exception ex) {
                log.warn("Exception [{}], occurred while trying to parse the uri [{}] to host and port.", (Object)ex, (Object)context.getRemoteServiceAddress());
            }
        }
        this.getTracingContext(context).setSpan(this.customizeExtractedSpan(context, extractedSpan).start());
    }

    public Span.Builder customizeExtractedSpan(T context, Span.Builder builder) {
        return builder;
    }

    @Override
    public void onError(T context) {
        if (context.getError() != null) {
            this.getRequiredSpan(context).error(context.getError());
        }
    }

    public void onStop(T context) {
        Span span = this.getRequiredSpan(context);
        this.tagSpan(context, span);
        this.customizeReceiverSpan(context, span);
        span.name(context.getContextualName() != null ? context.getContextualName() : context.getName());
        this.endSpan(context, span);
    }

    public void customizeReceiverSpan(T context, Span span) {
    }

    @Override
    public boolean supportsContext(Observation.Context context) {
        return context instanceof ReceiverContext;
    }

    @Override
    public Tracer getTracer() {
        return this.tracer;
    }
}

