/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.UserEntityValidator;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class MemoryUsersRepositoryModule
extends AbstractModule {
    public void configure() {
        this.bind(UsersRepository.class).to(MemoryUsersRepository.class);
    }

    @Provides
    @Singleton
    public MemoryUsersRepository providesUsersRepository(DomainList domainList, UserEntityValidator validator) {
        MemoryUsersRepository usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
        usersRepository.setValidator(validator);
        return usersRepository;
    }

    @ProvidesIntoSet
    InitializationOperation configureUsersRepository(ConfigurationProvider configurationProvider, MemoryUsersRepository usersRepository) {
        return InitilizationOperationBuilder.forClass(MemoryUsersRepository.class).init(() -> usersRepository.configure(configurationProvider.getConfiguration("usersrepository")));
    }
}

