/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class FiltersDeleteUserDataTaskStep
implements DeleteUserDataTaskStep {
    private final FilteringManagement filteringManagement;

    @Inject
    public FiltersDeleteUserDataTaskStep(FilteringManagement filteringManagement) {
        this.filteringManagement = filteringManagement;
    }

    public DeleteUserDataTaskStep.StepName name() {
        return new DeleteUserDataTaskStep.StepName("FiltersDeleteUserDataTaskStep ");
    }

    public int priority() {
        return 5;
    }

    public Publisher<Void> deleteUserData(Username username) {
        return Mono.from(this.filteringManagement.clearRulesForUser(username)).then();
    }
}

