/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class IsMarkedAsSpam
extends GenericMatcher {
    private static final String YES = "yes";
    public static final String STATUS_MAIL_PACKAGE_DEFAULT = "org.apache.james.spamassassin.status";
    private String spamStatusHeader = "org.apache.james.spamassassin.status";

    public String getMatcherInfo() {
        return "Has " + this.spamStatusHeader + " per recipient header with a Yes value";
    }

    public void init() throws MessagingException {
        this.spamStatusHeader = Optional.ofNullable(this.getCondition()).filter(s -> !s.isEmpty()).orElse(STATUS_MAIL_PACKAGE_DEFAULT);
    }

    public Collection<MailAddress> match(Mail mail) {
        return (Collection)mail.getRecipients().stream().filter(recipient -> this.isMarkedAsSpam(mail, (MailAddress)recipient)).collect(ImmutableList.toImmutableList());
    }

    public boolean isMarkedAsSpam(Mail mail, MailAddress recipient) {
        return mail.getPerRecipientSpecificHeaders().getHeadersForRecipient(recipient).stream().filter(header -> header.getName().equals(this.spamStatusHeader)).anyMatch(header -> header.getValue().toLowerCase(Locale.US).startsWith(YES));
    }
}

