/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import jakarta.inject.Inject;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.cassandra.UrlsDao;

public class CassandraMailRepositoryUrlStore
implements MailRepositoryUrlStore {
    private final UrlsDao urlsDao;

    @Inject
    public CassandraMailRepositoryUrlStore(UrlsDao urlsDao) {
        this.urlsDao = urlsDao;
    }

    public void add(MailRepositoryUrl url) {
        this.urlsDao.addUrl(url).block();
    }

    public Stream<MailRepositoryUrl> listDistinct() {
        return this.urlsDao.retrieveUsedUrls().toStream();
    }

    public boolean contains(MailRepositoryUrl url) {
        return ((Optional)this.urlsDao.retrieve(url).block()).isPresent();
    }
}

