/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.james.imap.message.response.FetchResponse;

final class PartialFetchBodyElement
implements FetchResponse.BodyElement {
    private final FetchResponse.BodyElement delegate;
    private final long firstOctet;
    private final Optional<Long> numberOfOctets;
    private final String name;

    public PartialFetchBodyElement(FetchResponse.BodyElement delegate, long firstOctet, Optional<Long> numberOfOctets) {
        this.delegate = delegate;
        this.firstOctet = firstOctet;
        this.numberOfOctets = numberOfOctets;
        this.name = delegate.getName() + "<" + firstOctet + ">";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long size() throws IOException {
        long size = this.delegate.size();
        if (this.firstOctet > size) {
            return 0L;
        }
        return this.numberOfOctets.map(requestedSize -> Math.min(requestedSize, size - this.firstOctet)).orElse(size - this.firstOctet);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new LimitingInputStream(this.delegate.getInputStream(), this.firstOctet, this.size());
    }

    private static final class LimitingInputStream
    extends FilterInputStream {
        private long pos = 0L;
        private final long length;
        private long offset;

        public LimitingInputStream(InputStream in, long offset, long length) {
            super(in);
            this.length = length;
            this.offset = offset;
        }

        private void checkOffset() throws IOException {
            if (this.offset > -1L) {
                try {
                    this.offset -= this.in.skip(this.offset);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (this.offset > 0L) {
                    this.in.read();
                    --this.offset;
                }
                this.offset = -1L;
            }
        }

        @Override
        public int read() throws IOException {
            this.checkOffset();
            if (this.pos >= this.length) {
                return -1;
            }
            ++this.pos;
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkOffset();
            if (this.pos >= this.length) {
                return -1;
            }
            int readLimit = this.pos + (long)len >= this.length ? (int)this.length - (int)this.pos : len;
            int i = super.read(b, off, readLimit);
            this.pos += (long)i;
            return i;
        }

        @Override
        public long skip(long n) throws IOException {
            throw new IOException("Not implemented");
        }

        @Override
        public int available() throws IOException {
            this.checkOffset();
            if (this.pos >= this.length) {
                return 0;
            }
            int i = this.in.available();
            if (i == -1) {
                return 0;
            }
            if ((long)i >= this.length) {
                return (int)this.length - (int)this.pos;
            }
            return i;
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("mark not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

