/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.auth;

import com.datastax.oss.driver.api.core.auth.PlainTextAuthProviderBase;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ProgrammaticPlainTextAuthProvider
extends PlainTextAuthProviderBase {
    private volatile char[] username;
    private volatile char[] password;
    private volatile char[] authorizationId;

    public ProgrammaticPlainTextAuthProvider(@NonNull String username, @NonNull String password) {
        this(username, password, "");
    }

    public ProgrammaticPlainTextAuthProvider(@NonNull String username, @NonNull String password, @NonNull String authorizationId) {
        super("");
        this.username = Strings.requireNotEmpty(username, "username").toCharArray();
        this.password = Strings.requireNotEmpty(password, "password").toCharArray();
        this.authorizationId = Objects.requireNonNull(authorizationId, "authorizationId cannot be null").toCharArray();
    }

    public void setUsername(@NonNull String username) {
        this.username = Strings.requireNotEmpty(username, "username").toCharArray();
    }

    public void setPassword(@NonNull String password) {
        this.password = Strings.requireNotEmpty(password, "password").toCharArray();
    }

    public void setAuthorizationId(@NonNull String authorizationId) {
        this.authorizationId = Objects.requireNonNull(authorizationId, "authorizationId cannot be null").toCharArray();
    }

    @Override
    @NonNull
    protected PlainTextAuthProviderBase.Credentials getCredentials(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) {
        return new PlainTextAuthProviderBase.Credentials((char[])this.username.clone(), (char[])this.password.clone(), (char[])this.authorizationId.clone());
    }
}

